/*
 * Decompiled with CFR 0.152.
 */
package com.farminghelper.speaax.ItemsAndLocations;

import com.farminghelper.speaax.FarmingHelperConfig;
import com.farminghelper.speaax.FarmingHelperPlugin;
import com.farminghelper.speaax.ItemRequirement;
import com.farminghelper.speaax.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;

public class HerbRunItemAndLocation {
    private FarmingHelperConfig config;
    private Client client;
    private FarmingHelperPlugin plugin;
    public Location ardougneLocation;
    public Location catherbyLocation;
    public Location faladorLocation;
    public Location farmingGuildLocation;
    public Location harmonyLocation;
    public Location kourendLocation;
    public Location morytaniaLocation;
    public Location trollStrongholdLocation;
    public Location weissLocation;
    public List<Location> locations = new ArrayList<Location>();

    public HerbRunItemAndLocation() {
    }

    public HerbRunItemAndLocation(FarmingHelperConfig config, Client client, FarmingHelperPlugin plugin) {
        this.config = config;
        this.client = client;
        this.plugin = plugin;
    }

    public Map<Integer, Integer> getHerbItems() {
        return this.getAllItemRequirements(this.locations);
    }

    public List<ItemRequirement> getHouseTeleportItemRequirements() {
        FarmingHelperConfig.OptionEnumHouseTele selectedOption = this.config.enumConfigHouseTele();
        ArrayList<ItemRequirement> itemRequirements = new ArrayList<ItemRequirement>();
        switch (selectedOption) {
            case Law_air_earth_runes: {
                itemRequirements.add(new ItemRequirement(556, 1));
                itemRequirements.add(new ItemRequirement(557, 1));
                itemRequirements.add(new ItemRequirement(563, 1));
                break;
            }
            case Teleport_To_House: {
                itemRequirements.add(new ItemRequirement(8013, 1));
                break;
            }
            case Construction_cape: {
                itemRequirements.add(new ItemRequirement(9789, 1));
                break;
            }
            case Construction_cape_t: {
                itemRequirements.add(new ItemRequirement(9790, 1));
                break;
            }
            case Max_cape: {
                itemRequirements.add(new ItemRequirement(13280, 1));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + selectedOption);
            }
        }
        return itemRequirements;
    }

    public Map<Integer, Integer> getAllItemRequirements(List<Location> locations) {
        HashMap<Integer, Integer> allRequirements = new HashMap<Integer, Integer>();
        this.setupHerbLocations();
        for (Location location : locations) {
            if (!this.plugin.getHerbLocationEnabled(location.getName())) continue;
            allRequirements.merge(5291, 1, Integer::sum);
            if (this.selectedCompostID() != -1 && this.selectedCompostID() != 22997) {
                allRequirements.merge(this.selectedCompostID(), 1, Integer::sum);
            }
            Location.Teleport teleport = location.getSelectedTeleport();
            Map<Integer, Integer> locationRequirements = teleport.getItemRequirements();
            for (Map.Entry<Integer, Integer> entry : locationRequirements.entrySet()) {
                int itemId = entry.getKey();
                int quantity = entry.getValue();
                if (itemId == 9789 || itemId == 9790 || itemId == 13280) {
                    allRequirements.merge(itemId, quantity, (oldValue, newValue) -> Math.min(1, oldValue + newValue));
                    continue;
                }
                allRequirements.merge(itemId, quantity, Integer::sum);
            }
            if (!location.getFarmLimps().booleanValue() || !this.config.generalLimpwurt()) continue;
            allRequirements.merge(5100, 1, Integer::sum);
            if (this.selectedCompostID() == -1 || this.selectedCompostID() == 22997) continue;
            allRequirements.merge(this.selectedCompostID(), 1, Integer::sum);
        }
        allRequirements.merge(5343, 1, Integer::sum);
        allRequirements.merge(952, 1, Integer::sum);
        if (this.selectedCompostID() == 22997) {
            allRequirements.merge(22997, 1, Integer::sum);
        }
        allRequirements.merge(7409, 1, Integer::sum);
        if (this.config.generalRake()) {
            allRequirements.merge(5341, 1, Integer::sum);
        }
        return allRequirements;
    }

    public Integer selectedCompostID() {
        FarmingHelperConfig.OptionEnumCompost selectedCompost = this.config.enumConfigCompost();
        switch (selectedCompost) {
            case Compost: {
                return 6032;
            }
            case Supercompost: {
                return 6034;
            }
            case Ultracompost: {
                return 21483;
            }
            case Bottomless: {
                return 22997;
            }
        }
        return -1;
    }

    public void setupHerbLocations() {
        this.locations.clear();
        WorldPoint ardougneHerbPatchPoint = new WorldPoint(2670, 3374, 0);
        this.ardougneLocation = new Location(FarmingHelperConfig::enumOptionEnumArdougneTeleport, this.config, "Ardougne", true);
        List<ItemRequirement> ardougneTeleportItem = Arrays.asList(new ItemRequirement(563, 2), new ItemRequirement(555, 2));
        Location location = this.ardougneLocation;
        Objects.requireNonNull(location);
        Location.Teleport ardougneTeleport = location.new Location.Teleport("Ardougne_teleport", Location.TeleportCategory.SPELLBOOK, "Teleport to Ardougne with standard spellbook, and run north.", 0, "null", 218, 38, 10547, ardougneHerbPatchPoint, ardougneTeleportItem);
        List<ItemRequirement> ardougneTeleTabItem = Arrays.asList(new ItemRequirement(8011, 1));
        Location location2 = this.ardougneLocation;
        Objects.requireNonNull(location2);
        Location.Teleport ardougneTeleTab = location2.new Location.Teleport("Ardougne_Tele_Tab", Location.TeleportCategory.ITEM, "Teleport to Ardougne with Ardougne tele tab, and run north.", 8011, "null", 0, 0, 10547, ardougneHerbPatchPoint, ardougneTeleTabItem);
        List<ItemRequirement> ardougneArdyCloak2Item = Arrays.asList(new ItemRequirement(13122, 1));
        Location location3 = this.ardougneLocation;
        Objects.requireNonNull(location3);
        Location.Teleport ardougneArdyCloak2 = location3.new Location.Teleport("Ardy_Cloak_2", Location.TeleportCategory.ITEM, "Teleport to Ardougne with Ardougne cloak.", 13122, "Farm Teleport", 0, 0, 10548, ardougneHerbPatchPoint, ardougneArdyCloak2Item);
        List<ItemRequirement> ardougneArdyCloak3Item = Arrays.asList(new ItemRequirement(13123, 1));
        Location location4 = this.ardougneLocation;
        Objects.requireNonNull(location4);
        Location.Teleport ardougneArdyCloak3 = location4.new Location.Teleport("Ardy_Cloak_3", Location.TeleportCategory.ITEM, "Teleport to Ardougne with Ardougne cloak.", 13123, "Farm Teleport", 0, 0, 10548, ardougneHerbPatchPoint, ardougneArdyCloak3Item);
        List<ItemRequirement> ardougneArdyCloak4Item = Arrays.asList(new ItemRequirement(13124, 1));
        Location location5 = this.ardougneLocation;
        Objects.requireNonNull(location5);
        Location.Teleport ardougneArdyCloak4 = location5.new Location.Teleport("Ardy_Cloak_4", Location.TeleportCategory.ITEM, "Teleport to Ardougne with Ardougne cloak.", 13124, "Farm Teleport", 0, 0, 10548, ardougneHerbPatchPoint, ardougneArdyCloak4Item);
        List<ItemRequirement> ardougneSkillsNecklaceItem = Arrays.asList(new ItemRequirement(11111, 1));
        Location location6 = this.ardougneLocation;
        Objects.requireNonNull(location6);
        Location.Teleport ardougneSkillsNecklace = location6.new Location.Teleport("Skills_Necklace", Location.TeleportCategory.ITEM, "Teleport to Fishing guild with Skills necklace, and run east.", 11111, "null", 0, 0, 10292, ardougneHerbPatchPoint, ardougneSkillsNecklaceItem);
        this.ardougneLocation.addTeleportOption(ardougneTeleport);
        this.ardougneLocation.addTeleportOption(ardougneTeleTab);
        this.ardougneLocation.addTeleportOption(ardougneArdyCloak2);
        this.ardougneLocation.addTeleportOption(ardougneArdyCloak3);
        this.ardougneLocation.addTeleportOption(ardougneArdyCloak4);
        this.ardougneLocation.addTeleportOption(ardougneSkillsNecklace);
        this.locations.add(this.ardougneLocation);
        WorldPoint catherbyHerbPatchPoint = new WorldPoint(2813, 3463, 0);
        this.catherbyLocation = new Location(FarmingHelperConfig::enumOptionEnumCatherbyTeleport, this.config, "Catherby", true);
        List<ItemRequirement> catherbyPortalNexusItems = this.getHouseTeleportItemRequirements();
        Location location7 = this.catherbyLocation;
        Objects.requireNonNull(location7);
        Location.Teleport catherbyPortalNexus = location7.new Location.Teleport("Portal_nexus", Location.TeleportCategory.PORTAL_NEXUS, "Teleport to Catherby with Portal nexus.", 0, "null", 17, 13, 11061, catherbyHerbPatchPoint, catherbyPortalNexusItems);
        List<ItemRequirement> catherbyCamelotTeleportItems = Arrays.asList(new ItemRequirement(556, 5), new ItemRequirement(563, 1));
        Location location8 = this.catherbyLocation;
        Objects.requireNonNull(location8);
        Location.Teleport catherbyCamelotTeleport = location8.new Location.Teleport("Camelot_Teleport", Location.TeleportCategory.SPELLBOOK, "Teleport to Camelot using the standard spellbook, and run east.(If you have configured the teleport to seers you need to right click and teleport to Camelot)", 0, "null", 218, 32, 11062, catherbyHerbPatchPoint, catherbyCamelotTeleportItems);
        List<ItemRequirement> catherbyCamelotTeleTabItems = Arrays.asList(new ItemRequirement(8010, 1));
        Location location9 = this.catherbyLocation;
        Objects.requireNonNull(location9);
        Location.Teleport catherbyCamelotTeleTab = location9.new Location.Teleport("Camelot_Tele_Tab", Location.TeleportCategory.ITEM, "Teleport to Camelot using a Camelot tele tab, and run east.(If you have configured the teleport to seers you need to right click and teleport to Camelot)", 8010, "null", 0, 0, 11062, catherbyHerbPatchPoint, catherbyCamelotTeleTabItems);
        List<ItemRequirement> catherbyTeleTabItems = Arrays.asList(new ItemRequirement(24961, 1));
        Location location10 = this.catherbyLocation;
        Objects.requireNonNull(location10);
        Location.Teleport catherbyTeleTab = location10.new Location.Teleport("Catherby_Tele_Tab", Location.TeleportCategory.ITEM, "Teleport to Catherby using Catherby teleport tab.", 24961, "null", 0, 0, 11061, catherbyHerbPatchPoint, catherbyTeleTabItems);
        this.catherbyLocation.addTeleportOption(catherbyPortalNexus);
        this.catherbyLocation.addTeleportOption(catherbyCamelotTeleport);
        this.catherbyLocation.addTeleportOption(catherbyCamelotTeleTab);
        this.catherbyLocation.addTeleportOption(catherbyTeleTab);
        this.locations.add(this.catherbyLocation);
        WorldPoint faladorHerbPatchPoint = new WorldPoint(3058, 3307, 0);
        this.faladorLocation = new Location(FarmingHelperConfig::enumOptionEnumFaladorTeleport, this.config, "Falador", true);
        List<ItemRequirement> faladorExplorersRing2Item = Arrays.asList(new ItemRequirement(13126, 1));
        Location location11 = this.faladorLocation;
        Objects.requireNonNull(location11);
        Location.Teleport faladorExplorersRing2 = location11.new Location.Teleport("Explorers_ring_2", Location.TeleportCategory.ITEM, "Teleport to Falador with Explorers ring.", 13126, "Teleport", 0, 0, 12083, faladorHerbPatchPoint, faladorExplorersRing2Item);
        List<ItemRequirement> faladorExplorersRing3Item = Arrays.asList(new ItemRequirement(13127, 1));
        Location location12 = this.faladorLocation;
        Objects.requireNonNull(location12);
        Location.Teleport faladorExplorersRing3 = location12.new Location.Teleport("Explorers_ring_3", Location.TeleportCategory.ITEM, "Teleport to Falador with Explorers ring.", 13127, "Teleport", 0, 0, 12083, faladorHerbPatchPoint, faladorExplorersRing3Item);
        List<ItemRequirement> faladorExplorersRing4Item = Arrays.asList(new ItemRequirement(13128, 1));
        Location location13 = this.faladorLocation;
        Objects.requireNonNull(location13);
        Location.Teleport faladorExplorersRing4 = location13.new Location.Teleport("Explorers_ring_4", Location.TeleportCategory.ITEM, "Teleport to Falador with Explorers ring.", 13128, "Teleport", 0, 0, 12083, faladorHerbPatchPoint, faladorExplorersRing4Item);
        List<ItemRequirement> faladorTeleportItem = Arrays.asList(new ItemRequirement(556, 3), new ItemRequirement(563, 1), new ItemRequirement(555, 1));
        Location location14 = this.faladorLocation;
        Objects.requireNonNull(location14);
        Location.Teleport faladorTeleport = location14.new Location.Teleport("Falador_Teleport", Location.TeleportCategory.SPELLBOOK, "Teleport to Falador with standard spellbook, and run south-east.", 0, "null", 218, 27, 11828, faladorHerbPatchPoint, faladorTeleportItem);
        List<ItemRequirement> faladorTeleTabItem = Arrays.asList(new ItemRequirement(8009, 1));
        Location location15 = this.faladorLocation;
        Objects.requireNonNull(location15);
        Location.Teleport faladorTeleTab = location15.new Location.Teleport("Falador_Tele_Tab", Location.TeleportCategory.ITEM, "Teleport to Falador with Falador Tele Tab, and run south-east.", 8009, "null", 0, 0, 11828, faladorHerbPatchPoint, faladorTeleTabItem);
        List<ItemRequirement> faladorDraynorManorTeleTabItem = Arrays.asList(new ItemRequirement(19615, 1));
        Location location16 = this.faladorLocation;
        Objects.requireNonNull(location16);
        Location.Teleport faladorDraynorManorTeleTab = location16.new Location.Teleport("Draynor_Tele_Tab", Location.TeleportCategory.ITEM, "Teleport to Draynor Manor with Draynor Manor Tele Tab, and run south-west.", 19615, "null", 0, 0, 12340, faladorHerbPatchPoint, faladorDraynorManorTeleTabItem);
        this.faladorLocation.addTeleportOption(faladorExplorersRing2);
        this.faladorLocation.addTeleportOption(faladorExplorersRing3);
        this.faladorLocation.addTeleportOption(faladorExplorersRing4);
        this.faladorLocation.addTeleportOption(faladorTeleport);
        this.faladorLocation.addTeleportOption(faladorTeleTab);
        this.faladorLocation.addTeleportOption(faladorDraynorManorTeleTab);
        this.locations.add(this.faladorLocation);
        WorldPoint farmingGuildHerbPatchPoint = new WorldPoint(1238, 3726, 0);
        this.farmingGuildLocation = new Location(FarmingHelperConfig::enumOptionEnumFarmingGuildTeleport, this.config, "Farming Guild", true);
        List<ItemRequirement> farmingGuildJewelleryBoxItems = this.getHouseTeleportItemRequirements();
        Location location17 = this.farmingGuildLocation;
        Objects.requireNonNull(location17);
        Location.Teleport farmingGuildJewelleryBox = location17.new Location.Teleport("Jewellery_box", Location.TeleportCategory.JEWELLERY_BOX, "Teleport to Farming guild with Jewellery box.", 29155, "null", 0, 0, 4922, farmingGuildHerbPatchPoint, farmingGuildJewelleryBoxItems);
        List<ItemRequirement> farmingGuildSkillsNecklaceItems = Arrays.asList(new ItemRequirement(11111, 1));
        Location location18 = this.farmingGuildLocation;
        Objects.requireNonNull(location18);
        Location.Teleport farmingGuildSkillsNecklace = location18.new Location.Teleport("Skills_Necklace", Location.TeleportCategory.ITEM, "Teleport to Farming guild using Skills necklace.", 11111, "null", 0, 0, 4922, farmingGuildHerbPatchPoint, farmingGuildSkillsNecklaceItems);
        this.farmingGuildLocation.addTeleportOption(farmingGuildJewelleryBox);
        this.farmingGuildLocation.addTeleportOption(farmingGuildSkillsNecklace);
        this.locations.add(this.farmingGuildLocation);
        WorldPoint harmonyHerbPatchPoint = new WorldPoint(3789, 2837, 0);
        this.harmonyLocation = new Location(FarmingHelperConfig::enumOptionEnumHarmonyTeleport, this.config, "Harmony Island", false);
        List<ItemRequirement> harmonyPortalNexusItems = this.getHouseTeleportItemRequirements();
        Location location19 = this.harmonyLocation;
        Objects.requireNonNull(location19);
        Location.Teleport harmonyPortalNexus = location19.new Location.Teleport("Portal_Nexus", Location.TeleportCategory.PORTAL_NEXUS, "Teleport to Harmony with Portal Nexus.", 0, "null", 17, 13, 15148, harmonyHerbPatchPoint, harmonyPortalNexusItems);
        this.harmonyLocation.addTeleportOption(harmonyPortalNexus);
        this.locations.add(this.harmonyLocation);
        List<ItemRequirement> harmonyTeleTabItems = Arrays.asList(new ItemRequirement(19625, 1));
        Location location20 = this.harmonyLocation;
        Objects.requireNonNull(location20);
        Location.Teleport harmonyTeleTab = location20.new Location.Teleport("Harmony_Tele_Tab", Location.TeleportCategory.ITEM, "Teleport to Harmony with Harmony Tele Tab.", 19625, "null", 0, 0, 15148, harmonyHerbPatchPoint, harmonyTeleTabItems);
        this.harmonyLocation.addTeleportOption(harmonyPortalNexus);
        this.harmonyLocation.addTeleportOption(harmonyTeleTab);
        this.locations.add(this.harmonyLocation);
        WorldPoint kourendHerbPatchPoint = new WorldPoint(1738, 3550, 0);
        this.kourendLocation = new Location(FarmingHelperConfig::enumOptionEnumKourendTeleport, this.config, "Kourend", true);
        List<ItemRequirement> kourendXericsTalismanItems = Arrays.asList(new ItemRequirement(13393, 1));
        Location location21 = this.kourendLocation;
        Objects.requireNonNull(location21);
        Location.Teleport kourendXericsTalisman = location21.new Location.Teleport("Xerics_Talisman", Location.TeleportCategory.ITEM, "Teleport to Kourend with Xeric's Talisman.", 13393, "Rub", 187, 3, 6967, kourendHerbPatchPoint, kourendXericsTalismanItems);
        List<ItemRequirement> kourendMountedXericsItems = this.getHouseTeleportItemRequirements();
        Location location22 = this.kourendLocation;
        Objects.requireNonNull(location22);
        Location.Teleport kourendMountedXerics = location22.new Location.Teleport("Mounted_Xerics", Location.TeleportCategory.MOUNTED_XERICS, "Teleport to Kourend with Xeric's Talisman in PoH.", 0, "null", 187, 3, 6967, kourendHerbPatchPoint, kourendMountedXericsItems);
        this.kourendLocation.addTeleportOption(kourendXericsTalisman);
        this.kourendLocation.addTeleportOption(kourendMountedXerics);
        this.locations.add(this.kourendLocation);
        WorldPoint morytaniaHerbPatchPoint = new WorldPoint(3601, 3525, 0);
        this.morytaniaLocation = new Location(FarmingHelperConfig::enumOptionEnumMorytaniaTeleport, this.config, "Morytania", true);
        List<ItemRequirement> morytaniaEctophialItems = Arrays.asList(new ItemRequirement(4251, 1));
        Location location23 = this.morytaniaLocation;
        Objects.requireNonNull(location23);
        Location.Teleport morytaniaEctophial = location23.new Location.Teleport("Ectophial", Location.TeleportCategory.ITEM, "Teleport to Morytania with Ectophial.", 4251, "null", 0, 0, 14647, morytaniaHerbPatchPoint, morytaniaEctophialItems);
        this.morytaniaLocation.addTeleportOption(morytaniaEctophial);
        this.locations.add(this.morytaniaLocation);
        WorldPoint trollStrongholhHerbPatchPoint = new WorldPoint(2824, 3696, 0);
        this.trollStrongholdLocation = new Location(FarmingHelperConfig::enumOptionEnumTrollStrongholdTeleport, this.config, "Troll Stronghold", false);
        List<ItemRequirement> tsStonyBasaltItems = Arrays.asList(new ItemRequirement(22601, 1));
        Location location24 = this.trollStrongholdLocation;
        Objects.requireNonNull(location24);
        Location.Teleport tsStonyBasalt = location24.new Location.Teleport("Stony_Basalt", Location.TeleportCategory.ITEM, "Teleport to Troll Stronghold with Stony Basalt.", 22601, "null", 0, 0, 11321, trollStrongholhHerbPatchPoint, tsStonyBasaltItems);
        List<ItemRequirement> tsPortalNexusItems = this.getHouseTeleportItemRequirements();
        Location location25 = this.trollStrongholdLocation;
        Objects.requireNonNull(location25);
        Location.Teleport tsPortalNexus = location25.new Location.Teleport("Portal_Nexus", Location.TeleportCategory.PORTAL_NEXUS, "Teleport to Troll Stronghold with Portal Nexus.", 0, "null", 17, 13, 11321, trollStrongholhHerbPatchPoint, tsPortalNexusItems);
        this.trollStrongholdLocation.addTeleportOption(tsStonyBasalt);
        this.trollStrongholdLocation.addTeleportOption(tsPortalNexus);
        this.locations.add(this.trollStrongholdLocation);
        WorldPoint weissHerbPatchPoint = new WorldPoint(2847, 3931, 0);
        this.weissLocation = new Location(FarmingHelperConfig::enumOptionEnumWeissTeleport, this.config, "Weiss", false);
        List<ItemRequirement> weissIcyBasaltItems = Arrays.asList(new ItemRequirement(22599, 1));
        Location location26 = this.weissLocation;
        Objects.requireNonNull(location26);
        Location.Teleport weissIcyBasalt = location26.new Location.Teleport("Icy_Basalt", Location.TeleportCategory.ITEM, "Teleport to Weiss with Icy Basalt.", 22599, "null", 0, 0, 11325, weissHerbPatchPoint, weissIcyBasaltItems);
        List<ItemRequirement> weissPortalNexusItems = this.getHouseTeleportItemRequirements();
        Location location27 = this.weissLocation;
        Objects.requireNonNull(location27);
        Location.Teleport weissPortalNexus = location27.new Location.Teleport("Portal_Nexus", Location.TeleportCategory.PORTAL_NEXUS, "Teleport to Weiss with Portal Nexus.", 0, "null", 17, 13, 11325, weissHerbPatchPoint, weissPortalNexusItems);
        this.weissLocation.addTeleportOption(weissIcyBasalt);
        this.weissLocation.addTeleportOption(weissPortalNexus);
        this.locations.add(this.weissLocation);
    }
}

