/*
 * Decompiled with CFR 0.152.
 */
package com.farminghelper.speaax.ItemsAndLocations;

import com.farminghelper.speaax.FarmingHelperConfig;
import com.farminghelper.speaax.FarmingHelperPlugin;
import com.farminghelper.speaax.ItemRequirement;
import com.farminghelper.speaax.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;

public class FruitTreeRunItemAndLocation {
    private FarmingHelperConfig config;
    private Client client;
    private FarmingHelperPlugin plugin;
    public Location brimhavenFruitTreeLocation;
    public Location catherbyFruitTreeLocation;
    public Location farmingGuildFruitTreeLocation;
    public Location gnomeStrongholdFruitTreeLocation;
    public Location lletyaFruitTreeLocation;
    public Location treeGnomeVillageFruitTreeLocation;
    public List<Location> locations = new ArrayList<Location>();

    public FruitTreeRunItemAndLocation() {
    }

    public FruitTreeRunItemAndLocation(FarmingHelperConfig config, Client client, FarmingHelperPlugin plugin) {
        this.config = config;
        this.client = client;
        this.plugin = plugin;
    }

    public Map<Integer, Integer> getFruitTreeItems() {
        return this.getAllItemRequirements(this.locations);
    }

    public List<ItemRequirement> getHouseTeleportItemRequirements() {
        FarmingHelperConfig.OptionEnumHouseTele selectedOption = this.config.enumConfigHouseTele();
        ArrayList<ItemRequirement> itemRequirements = new ArrayList<ItemRequirement>();
        switch (selectedOption) {
            case Law_air_earth_runes: {
                itemRequirements.add(new ItemRequirement(556, 1));
                itemRequirements.add(new ItemRequirement(557, 1));
                itemRequirements.add(new ItemRequirement(563, 1));
                break;
            }
            case Teleport_To_House: {
                itemRequirements.add(new ItemRequirement(8013, 1));
                break;
            }
            case Construction_cape: {
                itemRequirements.add(new ItemRequirement(9789, 1));
                break;
            }
            case Construction_cape_t: {
                itemRequirements.add(new ItemRequirement(9790, 1));
                break;
            }
            case Max_cape: {
                itemRequirements.add(new ItemRequirement(13280, 1));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + selectedOption);
            }
        }
        return itemRequirements;
    }

    public Map<Integer, Integer> getAllItemRequirements(List<Location> locations) {
        HashMap<Integer, Integer> allRequirements = new HashMap<Integer, Integer>();
        this.setupFruitTreeLocations();
        for (Location location : locations) {
            if (!this.plugin.getFruitTreeLocationEnabled(location.getName())) continue;
            allRequirements.merge(5496, 1, Integer::sum);
            allRequirements.merge(995, 200, Integer::sum);
            Location.Teleport teleport = location.getSelectedTeleport();
            Map<Integer, Integer> locationRequirements = teleport.getItemRequirements();
            for (Map.Entry<Integer, Integer> entry : locationRequirements.entrySet()) {
                int itemId = entry.getKey();
                int quantity = entry.getValue();
                if (itemId == 9789 || itemId == 9790 || itemId == 13280 || itemId == 19564) {
                    allRequirements.merge(itemId, quantity, (oldValue, newValue) -> Math.min(1, oldValue + newValue));
                    continue;
                }
                allRequirements.merge(itemId, quantity, Integer::sum);
            }
        }
        allRequirements.merge(952, 1, Integer::sum);
        allRequirements.merge(22997, 1, Integer::sum);
        allRequirements.merge(7409, 1, Integer::sum);
        if (this.config.generalRake()) {
            allRequirements.merge(5341, 1, Integer::sum);
        }
        return allRequirements;
    }

    public void setupFruitTreeLocations() {
        this.locations.clear();
        this.brimhavenFruitTreeLocation = new Location(FarmingHelperConfig::enumFruitTreeBrimhavenTeleport, this.config, "Brimhaven", false);
        List<ItemRequirement> brimhavenFruitTreeTeleportItems = Arrays.asList(new ItemRequirement(995, 30), new ItemRequirement(563, 2), new ItemRequirement(555, 2));
        WorldPoint brimhavenFruitTreePatchPoint = new WorldPoint(2764, 3212, 0);
        Location location = this.brimhavenFruitTreeLocation;
        Objects.requireNonNull(location);
        Location.Teleport brimhavenFruitTreeTeleport = location.new Location.Teleport("Ardougne_teleport", Location.TeleportCategory.SPELLBOOK, "Teleport to Ardougne with Spellbook and run to Brimhaven.", 0, "null", 218, 38, 10547, brimhavenFruitTreePatchPoint, brimhavenFruitTreeTeleportItems);
        this.brimhavenFruitTreeLocation.addTeleportOption(brimhavenFruitTreeTeleport);
        this.locations.add(this.brimhavenFruitTreeLocation);
        this.catherbyFruitTreeLocation = new Location(FarmingHelperConfig::enumFruitTreeCatherbyTeleport, this.config, "Catherby", false);
        List<ItemRequirement> catherbyFruitTreeTeleportItems = this.getHouseTeleportItemRequirements();
        WorldPoint cathebyFruitTreePatchPoint = new WorldPoint(2860, 3433, 0);
        Location location2 = this.catherbyFruitTreeLocation;
        Objects.requireNonNull(location2);
        Location.Teleport catherbyFruitTreeTeleport = location2.new Location.Teleport("Portal_nexus", Location.TeleportCategory.PORTAL_NEXUS, "Teleport to Catherby with Portal nexus.", 0, "null", 17, 13, 11061, cathebyFruitTreePatchPoint, catherbyFruitTreeTeleportItems);
        this.catherbyFruitTreeLocation.addTeleportOption(catherbyFruitTreeTeleport);
        this.locations.add(this.catherbyFruitTreeLocation);
        this.farmingGuildFruitTreeLocation = new Location(FarmingHelperConfig::enumFruitTreeFarmingGuildTeleport, this.config, "Farming Guild", false);
        List<ItemRequirement> farmingGuildFruitTreeTeleportItems = this.getHouseTeleportItemRequirements();
        WorldPoint farmingGuildFruitTreePatchPoint = new WorldPoint(1243, 3759, 0);
        Location location3 = this.farmingGuildFruitTreeLocation;
        Objects.requireNonNull(location3);
        Location.Teleport farmingGuildFruitTreeTeleport = location3.new Location.Teleport("Jewellery_box", Location.TeleportCategory.JEWELLERY_BOX, "Teleport to Farming Guild with Jewellery box.", 0, "null", 17, 13, 4922, farmingGuildFruitTreePatchPoint, farmingGuildFruitTreeTeleportItems);
        this.farmingGuildFruitTreeLocation.addTeleportOption(farmingGuildFruitTreeTeleport);
        this.locations.add(this.farmingGuildFruitTreeLocation);
        this.gnomeStrongholdFruitTreeLocation = new Location(FarmingHelperConfig::enumFruitTreeGnomeStrongholdTeleport, this.config, "Gnome Stronghold", false);
        List<ItemRequirement> gnomeStrongholdFruitTreeTeleportItems = Arrays.asList(new ItemRequirement(19564, 1));
        WorldPoint gnomeStrongholdFruitTreePatchPoint = new WorldPoint(2475, 3446, 0);
        Location location4 = this.gnomeStrongholdFruitTreeLocation;
        Objects.requireNonNull(location4);
        Location.Teleport gnomeStrongholdFruitTreeTeleport = location4.new Location.Teleport("Royal_seed_pod", Location.TeleportCategory.ITEM, "Teleport to Gnome Stronghold with Royal seed pod.", 19564, "null", 0, 0, 9782, gnomeStrongholdFruitTreePatchPoint, gnomeStrongholdFruitTreeTeleportItems);
        this.gnomeStrongholdFruitTreeLocation.addTeleportOption(gnomeStrongholdFruitTreeTeleport);
        this.locations.add(this.gnomeStrongholdFruitTreeLocation);
        this.lletyaFruitTreeLocation = new Location(FarmingHelperConfig::enumFruitTreeLletyaTeleport, this.config, "Lletya", false);
        List<ItemRequirement> lletyaFruitTreeTeleportItems = Arrays.asList(new ItemRequirement(6102, 1));
        WorldPoint lletyaFruitTreePatchPoint = new WorldPoint(2346, 3162, 0);
        Location location5 = this.lletyaFruitTreeLocation;
        Objects.requireNonNull(location5);
        Location.Teleport lletyaFruitTreeTeleport = location5.new Location.Teleport("Teleport_crystal", Location.TeleportCategory.ITEM, "Teleport to Lletya with Teleport crystal.", 6102, "null", 0, 0, 9265, lletyaFruitTreePatchPoint, lletyaFruitTreeTeleportItems);
        this.lletyaFruitTreeLocation.addTeleportOption(lletyaFruitTreeTeleport);
        this.locations.add(this.lletyaFruitTreeLocation);
        this.treeGnomeVillageFruitTreeLocation = new Location(FarmingHelperConfig::enumFruitTreeTreeGnomeVillageTeleport, this.config, "Tree Gnome Village", false);
        List<ItemRequirement> treeGnomeVillageFruitTreeTeleportItems = Arrays.asList(new ItemRequirement(19564, 1));
        WorldPoint treeGnomeVillageFruitTreePatchPoint = new WorldPoint(2490, 3180, 0);
        Location location6 = this.treeGnomeVillageFruitTreeLocation;
        Objects.requireNonNull(location6);
        Location.Teleport treeGnomeVillageFruitTreeTeleport = location6.new Location.Teleport("Royal_seed_pod", Location.TeleportCategory.ITEM, "Teleport to Tree Gnome Village with Royal seed pod and use Spirit tree to Tree Gnome Village.", 19564, "null", 0, 0, 9782, treeGnomeVillageFruitTreePatchPoint, treeGnomeVillageFruitTreeTeleportItems);
        this.treeGnomeVillageFruitTreeLocation.addTeleportOption(treeGnomeVillageFruitTreeTeleport);
        this.locations.add(this.treeGnomeVillageFruitTreeLocation);
    }
}

