/*
 * Decompiled with CFR 0.152.
 */
package com.farminghelper.speaax;

import java.util.Arrays;
import java.util.List;
import net.runelite.api.Client;

public class FlowerPatchChecker {
    private static final List<Integer> harvestable = Arrays.asList(32);
    private static final List<Integer> growing = Arrays.asList(28, 29, 30, 31);
    private static final List<Integer> dead = Arrays.asList(221, 222, 223, 224);
    private static final List<Integer> weeds = Arrays.asList(0, 1, 2);

    public static PlantState checkFlowerPatch(Client client, int varbitIndex) {
        int varbitValue = client.getVarbitValue(varbitIndex);
        if (harvestable.contains(varbitValue)) {
            return PlantState.HARVESTABLE;
        }
        if (growing.contains(varbitValue)) {
            return PlantState.GROWING;
        }
        if (dead.contains(varbitValue)) {
            return PlantState.DEAD;
        }
        if (weeds.contains(varbitValue)) {
            return PlantState.WEEDS;
        }
        if (varbitValue == 3) {
            return PlantState.PLANT;
        }
        return PlantState.UNKNOWN;
    }

    public static enum PlantState {
        HARVESTABLE,
        GROWING,
        DEAD,
        WEEDS,
        PLANT,
        UNKNOWN;

    }
}

