/*
 * Decompiled with CFR 0.152.
 */
package com.farminghelper.speaax;

import com.farminghelper.speaax.AreaCheck;
import com.farminghelper.speaax.FarmingHelperConfig;
import com.farminghelper.speaax.FarmingHelperOverlay;
import com.farminghelper.speaax.FarmingHelperOverlayInfoBox;
import com.farminghelper.speaax.FarmingHelperPlugin;
import com.farminghelper.speaax.FlowerPatchChecker;
import com.farminghelper.speaax.FruitTreePatchChecker;
import com.farminghelper.speaax.HerbPatchChecker;
import com.farminghelper.speaax.InventoryTabChecker;
import com.farminghelper.speaax.Location;
import com.farminghelper.speaax.TreePatchChecker;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.util.ColorUtil;

public class FarmingTeleportOverlay
extends Overlay {
    private final Client client;
    private final FarmingHelperPlugin plugin;
    private boolean clicked = false;
    @Inject
    private FarmingHelperConfig config;
    @Inject
    private FarmingHelperOverlay farmingHelperOverlay;
    @Inject
    private FarmingTeleportOverlay farmingTeleportOverlay;
    @Inject
    private FarmingHelperOverlayInfoBox farmingHelperOverlayInfoBox;
    @Inject
    private AreaCheck areaCheck;
    private final PanelComponent panelComponent = new PanelComponent();
    public boolean patchCleared = false;
    private Color leftClickColorWithAlpha;
    private Color rightClickColorWithAlpha;
    private Color highlightUseItemWithAlpha;
    public Map<String, Boolean> herbConfigMap = new HashMap<String, Boolean>();
    private int previousRegionId;
    public int inventoryTabValue = 0;
    private int currentHerbCase = 1;
    public Boolean herbPatchDone = false;
    public static boolean flowerPatchDone = false;
    public Boolean treePatchDone = false;
    public Boolean patchComposted = false;
    public Boolean fruitTreePatchDone = false;
    public static int currentTeleportCase = 1;
    public boolean isAtDestination = false;
    public static boolean farmLimps = false;
    public static int subCase = 1;
    public static boolean startSubCases = false;
    public static int herbRunIndex = 0;
    public Boolean herbRun = false;
    public Boolean treeRun = false;
    public Boolean fruitTreeRun = false;

    public void updateColors() {
        this.leftClickColorWithAlpha = new Color(this.config.highlightLeftClickColor().getRed(), this.config.highlightLeftClickColor().getGreen(), this.config.highlightLeftClickColor().getBlue(), this.config.highlightAlpha());
        this.rightClickColorWithAlpha = new Color(this.config.highlightRightClickColor().getRed(), this.config.highlightRightClickColor().getGreen(), this.config.highlightRightClickColor().getBlue(), this.config.highlightAlpha());
        this.highlightUseItemWithAlpha = new Color(this.config.highlightUseItemColor().getRed(), this.config.highlightUseItemColor().getGreen(), this.config.highlightUseItemColor().getBlue(), this.config.highlightAlpha());
    }

    public boolean isItComposted(String message) {
        String regexCompost1 = "You treat the (herb patch|flower patch|tree patch|fruit tree patch) with (compost|supercompost|ultracompost)\\.";
        String regexCompost2 = "This (herb patch|flower patch|tree patch|fruit tree patch) has already been treated with (compost|supercompost|ultracompost)\\.";
        String combinedRegex = regexCompost1 + "|" + regexCompost2;
        Pattern patternCompost = Pattern.compile(combinedRegex);
        Matcher matcherCompost = patternCompost.matcher(this.plugin.getLastMessage());
        return matcherCompost.matches();
    }

    @Inject
    public FarmingTeleportOverlay(FarmingHelperPlugin plugin, Client client, AreaCheck areaCheck) {
        this.areaCheck = areaCheck;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.plugin = plugin;
        this.client = client;
    }

    public Overlay interfaceOverlay(final int groupId, final int childId) {
        return new Overlay(){

            public Dimension render(Graphics2D graphics) {
                Widget widget;
                Client client = FarmingTeleportOverlay.this.plugin.getClient();
                if (client != null && (widget = client.getWidget(groupId, childId)) != null) {
                    Rectangle bounds = widget.getBounds();
                    graphics.setColor(FarmingTeleportOverlay.this.leftClickColorWithAlpha);
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.65f);
                    graphics.setComposite(alphaComposite);
                    graphics.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                    graphics.setComposite(AlphaComposite.SrcOver);
                }
                return null;
            }
        };
    }

    public int getChildIndexPN(String searchText) {
        Widget parentWidget = this.client.getWidget(17, 12);
        if (parentWidget == null) {
            return -1;
        }
        Widget[] children = parentWidget.getChildren();
        if (children == null) {
            return -1;
        }
        for (int index = 0; index < children.length; ++index) {
            String textAfterColon;
            int colonIndex;
            Widget child = children[index];
            String text = child.getText();
            if (text == null || (colonIndex = text.indexOf(58)) == -1 || colonIndex + 1 >= text.length() || !(textAfterColon = text.substring(colonIndex + 1).trim()).equals(searchText)) continue;
            return index;
        }
        return -1;
    }

    public void highlightDynamicComponent(Graphics2D graphics, Widget widget, int dynamicChildIndex, Color color) {
        Widget dynamicChild;
        Widget[] dynamicChildren;
        if (widget != null && (dynamicChildren = widget.getDynamicChildren()) != null && dynamicChildIndex >= 0 && dynamicChildIndex < dynamicChildren.length && (dynamicChild = dynamicChildren[dynamicChildIndex]) != null) {
            Rectangle bounds = dynamicChild.getBounds();
            graphics.setColor(color);
            graphics.fill(bounds);
        }
    }

    public void itemHighlight(Graphics2D graphics, int itemID, Color color) {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inventory != null) {
            Item[] items = inventory.getItems();
            Widget inventoryWidget = this.client.getWidget(WidgetInfo.INVENTORY);
            for (int i = 0; i < items.length; ++i) {
                Item item = items[i];
                if (item.getId() != itemID) continue;
                Widget itemWidget = inventoryWidget.getChild(i);
                Rectangle bounds = itemWidget.getBounds();
                graphics.setColor(color);
                graphics.draw(bounds);
                graphics.fill(bounds);
            }
        }
    }

    private List<GameObject> findGameObjectsByID(int objectID) {
        ArrayList<GameObject> gameObjects = new ArrayList<GameObject>();
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Tile tile = this.client.getScene().getTiles()[this.client.getPlane()][x][y];
                if (tile == null) continue;
                for (GameObject gameObject : tile.getGameObjects()) {
                    if (gameObject == null || gameObject.getId() != objectID) continue;
                    gameObjects.add(gameObject);
                }
            }
        }
        return gameObjects;
    }

    private void drawGameObjectClickbox(Graphics2D graphics, GameObject gameObject, Color color) {
        Shape objectClickbox = gameObject.getClickbox();
        if (objectClickbox != null) {
            graphics.setColor(color);
            graphics.draw(objectClickbox);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() / 5));
            graphics.fill(objectClickbox);
        }
    }

    public Overlay gameObjectOverlay(final int objectId, final Color color) {
        return new Overlay(){

            public Dimension render(Graphics2D graphics) {
                Client client = FarmingTeleportOverlay.this.plugin.getClient();
                if (client != null) {
                    List<GameObject> gameObjects = FarmingTeleportOverlay.this.findGameObjectsByID(objectId);
                    for (GameObject gameObject : gameObjects) {
                        FarmingTeleportOverlay.this.drawGameObjectClickbox(graphics, gameObject, color);
                    }
                }
                return null;
            }
        };
    }

    public List<DecorativeObject> findDecorativeObjectsByID(int objectId) {
        Client client = this.plugin.getClient();
        ArrayList<DecorativeObject> foundDecorativeObjects = new ArrayList<DecorativeObject>();
        if (client != null) {
            Tile[][][] tiles = client.getScene().getTiles();
            for (int plane = 0; plane < tiles.length; ++plane) {
                for (int x = 0; x < tiles[plane].length; ++x) {
                    for (int y = 0; y < tiles[plane][x].length; ++y) {
                        DecorativeObject decorativeObject;
                        Tile tile = tiles[plane][x][y];
                        if (tile == null || (decorativeObject = tile.getDecorativeObject()) == null || decorativeObject.getId() != objectId) continue;
                        foundDecorativeObjects.add(decorativeObject);
                    }
                }
            }
        }
        return foundDecorativeObjects;
    }

    public Overlay decorativeObjectOverlay(final int objectId, final Color color) {
        return new Overlay(){

            public Dimension render(Graphics2D graphics) {
                Client client = FarmingTeleportOverlay.this.plugin.getClient();
                if (client != null) {
                    List<DecorativeObject> decorativeObjects = FarmingTeleportOverlay.this.findDecorativeObjectsByID(objectId);
                    for (DecorativeObject decorativeObject : decorativeObjects) {
                        FarmingTeleportOverlay.this.drawDecorativeObjectClickbox(graphics, decorativeObject, color);
                    }
                }
                return null;
            }
        };
    }

    public void drawDecorativeObjectClickbox(Graphics2D graphics, DecorativeObject decorativeObject, Color color) {
        Shape clickbox = decorativeObject.getClickbox();
        if (clickbox != null) {
            graphics.setColor(color);
            graphics.draw(clickbox);
            graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 50));
            graphics.fill(clickbox);
        }
    }

    public void highlightRightClickOption(Graphics2D graphics, String option) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        for (int i = 0; i < menuEntries.length; ++i) {
            MenuEntry entry = menuEntries[i];
            String optionText = entry.getOption();
            if (!optionText.equalsIgnoreCase(option)) continue;
            String highlightedText = ColorUtil.prependColorTag((String)(">>> " + optionText), (Color)this.leftClickColorWithAlpha);
            entry.setOption(highlightedText);
            this.client.setMenuEntries(menuEntries);
            break;
        }
    }

    public void highlightNpc(Graphics2D graphics, String npcName, Color color) {
        List npcs = this.client.getNpcs();
        if (npcs != null) {
            for (NPC npc : npcs) {
                Polygon tilePolygon;
                if (npc == null || npc.getName() == null || !npc.getName().equals(npcName) || (tilePolygon = npc.getCanvasTilePoly()) == null) continue;
                graphics.setColor(color);
                graphics.draw(tilePolygon);
                graphics.fill(tilePolygon);
            }
        }
    }

    private boolean isInterfaceOpen(int groupId, int childId) {
        Widget widget = this.client.getWidget(groupId, childId);
        return widget != null && !widget.isHidden();
    }

    private void printWidgetText(int groupId, int childId) {
        Widget widget = this.client.getWidget(groupId, childId);
        if (widget != null) {
            String text = widget.getText();
            System.out.println("Widget text: " + text);
        } else {
            System.out.println("Widget not found for groupId: " + groupId + " and childId: " + childId);
        }
    }

    public void highlightHerbPatches(Graphics2D graphics, Color color) {
        List<Integer> herbPatchIds = this.farmingHelperOverlay.getHerbPatchIds();
        for (Integer patchId : herbPatchIds) {
            this.gameObjectOverlay(patchId, color).render(graphics);
        }
    }

    public void highlightFlowerPatches(Graphics2D graphics, Color color) {
        List<Integer> flowerPatchIds = this.farmingHelperOverlay.getFlowerPatchIds();
        for (Integer patchId : flowerPatchIds) {
            this.gameObjectOverlay(patchId, color).render(graphics);
        }
    }

    public void highlightTreePatches(Graphics2D graphics, Color color) {
        List<Integer> treePatchIds = this.farmingHelperOverlay.getTreePatchIds();
        for (Integer patchId : treePatchIds) {
            this.gameObjectOverlay(patchId, color).render(graphics);
        }
    }

    public void highlightFruitTreePatches(Graphics2D graphics, Color color) {
        List<Integer> fruitTreePatchIds = this.farmingHelperOverlay.getFruitTreePatchIds();
        for (Integer patchId : fruitTreePatchIds) {
            this.gameObjectOverlay(patchId, color).render(graphics);
        }
    }

    public void highlightHerbSeeds(Graphics2D graphics, Color color) {
        List<Integer> herbSeedIds = this.farmingHelperOverlay.getHerbSeedIds();
        for (Integer seedId : herbSeedIds) {
            this.itemHighlight(graphics, seedId, color);
        }
    }

    public void highlightTreeSapling(Graphics2D graphics, Color color) {
        List<Integer> treeSaplingIds = this.farmingHelperOverlay.getTreeSaplingIds();
        for (Integer seedId : treeSaplingIds) {
            this.itemHighlight(graphics, seedId, color);
        }
    }

    public void highlightFruitTreeSapling(Graphics2D graphics, Color color) {
        List<Integer> fruitTreeSaplingIds = this.farmingHelperOverlay.getFruitTreeSaplingIds();
        for (Integer seedId : fruitTreeSaplingIds) {
            this.itemHighlight(graphics, seedId, color);
        }
    }

    public void highlightTeleportCrystal(Graphics2D graphics, Color color) {
        List<Integer> teleportCrystalIds = this.farmingHelperOverlay.getTeleportCrystalIdsIds();
        for (Integer seedId : teleportCrystalIds) {
            this.itemHighlight(graphics, seedId, color);
        }
    }

    public void highlightSkillsNecklace(Graphics2D graphics, Color color) {
        List<Integer> skillsNecklaceIds = this.farmingHelperOverlay.getSkillsNecklaceIdsIds();
        for (Integer seedId : skillsNecklaceIds) {
            this.itemHighlight(graphics, seedId, color);
        }
    }

    public Integer selectedCompostID() {
        FarmingHelperConfig.OptionEnumCompost selectedCompost = this.config.enumConfigCompost();
        switch (selectedCompost) {
            case Compost: {
                return 6032;
            }
            case Supercompost: {
                return 6034;
            }
            case Ultracompost: {
                return 21483;
            }
            case Bottomless: {
                return 22997;
            }
        }
        return -1;
    }

    private boolean isItemInInventory(int itemId) {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        Item[] items = inventory == null || inventory.getItems() == null ? new Item[]{} : inventory.getItems();
        for (Item item : items) {
            if (item.getId() != itemId) continue;
            return true;
        }
        return false;
    }

    public void withdrawCompost(Graphics2D graphics) {
        this.plugin.addTextToInfoBox("Withdraw compost from Tool Leprechaun");
        if (!this.isInterfaceOpen(125, 0)) {
            this.highlightNpc(graphics, "Tool Leprechaun", this.leftClickColorWithAlpha);
        } else if (this.selectedCompostID() == 6032) {
            this.interfaceOverlay(125, 17).render(graphics);
        } else if (this.selectedCompostID() == 6034) {
            this.interfaceOverlay(125, 18).render(graphics);
        } else if (this.selectedCompostID() == 21483) {
            this.interfaceOverlay(125, 19).render(graphics);
        } else if (this.selectedCompostID() == 22997) {
            this.interfaceOverlay(125, 15).render(graphics);
        }
    }

    public void herbSteps(Graphics2D graphics, Location.Teleport teleport) {
        int currentRegionId = this.client.getLocalPlayer().getWorldLocation().getRegionID();
        HerbPatchChecker.PlantState plantState = currentRegionId == 4922 ? HerbPatchChecker.checkHerbPatch(this.client, 4775) : (currentRegionId == 15148 ? HerbPatchChecker.checkHerbPatch(this.client, 4772) : (currentRegionId == 11321 || currentRegionId == 11325 ? HerbPatchChecker.checkHerbPatch(this.client, 4771) : HerbPatchChecker.checkHerbPatch(this.client, 4774)));
        if (!this.areaCheck.isPlayerWithinArea(teleport.getPoint(), 15)) {
            this.highlightHerbPatches(graphics, this.leftClickColorWithAlpha);
        } else {
            switch (plantState) {
                case HARVESTABLE: {
                    this.plugin.addTextToInfoBox("Harvest Herbs.");
                    this.highlightHerbPatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case PLANT: {
                    this.plugin.addTextToInfoBox("Use Herb seed on patch.");
                    this.highlightHerbPatches(graphics, this.highlightUseItemWithAlpha);
                    this.highlightHerbSeeds(graphics, this.highlightUseItemWithAlpha);
                    break;
                }
                case DEAD: {
                    this.plugin.addTextToInfoBox("Clear the dead herb patch.");
                    this.highlightHerbPatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case DISEASED: {
                    this.plugin.addTextToInfoBox("Use Plant cure on herb patch. Buy at GE or in farming guild/catherby, and store at Tool Leprechaun for easy access.");
                    this.highlightHerbPatches(graphics, this.leftClickColorWithAlpha);
                    this.itemHighlight(graphics, 6036, this.highlightUseItemWithAlpha);
                    break;
                }
                case WEEDS: {
                    this.plugin.addTextToInfoBox("Rake the herb patch.");
                    this.highlightHerbPatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case GROWING: {
                    this.plugin.addTextToInfoBox("Use Compost on patch.");
                    if (this.isItemInInventory(this.selectedCompostID())) {
                        this.highlightHerbPatches(graphics, this.highlightUseItemWithAlpha);
                        this.itemHighlight(graphics, this.selectedCompostID(), this.highlightUseItemWithAlpha);
                    } else {
                        this.withdrawCompost(graphics);
                    }
                    if (!this.isItComposted(this.plugin.getLastMessage())) break;
                    this.currentHerbCase = 1;
                    this.herbPatchDone = true;
                    break;
                }
                case UNKNOWN: {
                    this.plugin.addTextToInfoBox("UNKNOWN state: Try to do something with the herb patch to change its state.");
                }
            }
        }
    }

    public void flowerSteps(Graphics2D graphics) {
        if (farmLimps) {
            int currentRegionId = this.client.getLocalPlayer().getWorldLocation().getRegionID();
            FlowerPatchChecker.PlantState plantState = currentRegionId == 4922 ? FlowerPatchChecker.checkFlowerPatch(this.client, 7906) : FlowerPatchChecker.checkFlowerPatch(this.client, 4773);
            switch (plantState) {
                case HARVESTABLE: {
                    this.plugin.addTextToInfoBox("Harvest Limwurt root.");
                    this.highlightFlowerPatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case WEEDS: {
                    this.plugin.addTextToInfoBox("Rake the flower patch.");
                    this.highlightFlowerPatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case DEAD: {
                    this.plugin.addTextToInfoBox("Clear the dead flower patch.");
                    this.highlightFlowerPatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case PLANT: {
                    this.plugin.addTextToInfoBox("Use Limwurt seed on the patch.");
                    this.highlightFlowerPatches(graphics, this.highlightUseItemWithAlpha);
                    this.itemHighlight(graphics, 5100, this.highlightUseItemWithAlpha);
                    break;
                }
                case GROWING: {
                    this.plugin.addTextToInfoBox("Use Compost on patch.");
                    if (this.isItemInInventory(this.selectedCompostID())) {
                        this.highlightFlowerPatches(graphics, this.highlightUseItemWithAlpha);
                        this.itemHighlight(graphics, this.selectedCompostID(), this.highlightUseItemWithAlpha);
                    } else {
                        this.withdrawCompost(graphics);
                    }
                    if (!this.isItComposted(this.plugin.getLastMessage())) break;
                    this.currentHerbCase = 1;
                    flowerPatchDone = true;
                }
            }
        } else {
            flowerPatchDone = true;
        }
    }

    public void treeSteps(Graphics2D graphics, Location.Teleport teleport) {
        int currentRegionId = this.client.getLocalPlayer().getWorldLocation().getRegionID();
        TreePatchChecker.PlantState plantState = currentRegionId == 4922 ? TreePatchChecker.checkTreePatch(this.client, 7905) : TreePatchChecker.checkTreePatch(this.client, 4771);
        if (!this.areaCheck.isPlayerWithinArea(teleport.getPoint(), 15)) {
            this.highlightTreePatches(graphics, this.leftClickColorWithAlpha);
        } else {
            switch (plantState) {
                case HEALTHY: {
                    this.plugin.addTextToInfoBox("Check tree health.");
                    this.highlightTreePatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case WEEDS: {
                    this.plugin.addTextToInfoBox("Rake the tree patch.");
                    this.highlightTreePatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case DEAD: {
                    this.plugin.addTextToInfoBox("Clear the dead tree patch.");
                    this.highlightTreePatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case PLANT: {
                    this.plugin.addTextToInfoBox("Use Sapling on the patch.");
                    this.highlightTreePatches(graphics, this.highlightUseItemWithAlpha);
                    this.highlightTreeSapling(graphics, this.highlightUseItemWithAlpha);
                    break;
                }
                case DISEASED: {
                    this.plugin.addTextToInfoBox("Prune the tree patch patch.");
                    this.highlightTreePatches(graphics, this.highlightUseItemWithAlpha);
                    break;
                }
                case REMOVE: {
                    this.plugin.addTextToInfoBox("Pay to remove tree, or cut it down and clear the patch.");
                    if (!this.isInterfaceOpen(219, 1)) {
                        this.highlightNpc(graphics, "Heskel", this.leftClickColorWithAlpha);
                        this.highlightNpc(graphics, "Rosie", this.leftClickColorWithAlpha);
                        this.highlightNpc(graphics, "Prissy Scilla", this.leftClickColorWithAlpha);
                        this.highlightNpc(graphics, "Fayeth", this.leftClickColorWithAlpha);
                        this.highlightNpc(graphics, "Alain", this.leftClickColorWithAlpha);
                        this.highlightNpc(graphics, "Treznor", this.leftClickColorWithAlpha);
                        break;
                    }
                    Widget widget = this.client.getWidget(219, 1);
                    this.highlightDynamicComponent(graphics, widget, 1, this.leftClickColorWithAlpha);
                    break;
                }
                case UNKNOWN: {
                    this.plugin.addTextToInfoBox("UNKNOWN state: Try to do something with the tree patch to change its state.");
                    break;
                }
                case GROWING: {
                    this.plugin.addTextToInfoBox("Use Compost on patch.");
                    if (this.isItemInInventory(this.selectedCompostID())) {
                        this.highlightTreePatches(graphics, this.highlightUseItemWithAlpha);
                        this.itemHighlight(graphics, this.selectedCompostID(), this.highlightUseItemWithAlpha);
                    } else {
                        this.withdrawCompost(graphics);
                    }
                    if (!this.isItComposted(this.plugin.getLastMessage())) break;
                    this.currentHerbCase = 1;
                    this.treePatchDone = true;
                }
            }
        }
    }

    public void fruitTreeSteps(Graphics2D graphics, Location.Teleport teleport) {
        int currentRegionId = this.client.getLocalPlayer().getWorldLocation().getRegionID();
        FruitTreePatchChecker.PlantState plantState = currentRegionId == 4922 ? FruitTreePatchChecker.checkFruitTreePatch(this.client, 7909) : (currentRegionId == 9782 || currentRegionId == 9781 ? FruitTreePatchChecker.checkFruitTreePatch(this.client, 4772) : FruitTreePatchChecker.checkFruitTreePatch(this.client, 4771));
        if (!this.areaCheck.isPlayerWithinArea(teleport.getPoint(), 15)) {
            this.highlightFruitTreePatches(graphics, this.leftClickColorWithAlpha);
        } else {
            switch (plantState) {
                case HEALTHY: {
                    this.plugin.addTextToInfoBox("Check Fruit tree health.");
                    this.highlightFruitTreePatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case WEEDS: {
                    this.plugin.addTextToInfoBox("Rake the fruit tree patch.");
                    this.highlightFruitTreePatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case DEAD: {
                    this.plugin.addTextToInfoBox("Clear the dead fruit tree patch.");
                    this.highlightFruitTreePatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case PLANT: {
                    this.plugin.addTextToInfoBox("Use Sapling on the patch.");
                    this.highlightFruitTreePatches(graphics, this.highlightUseItemWithAlpha);
                    this.highlightFruitTreeSapling(graphics, this.highlightUseItemWithAlpha);
                    break;
                }
                case DISEASED: {
                    this.plugin.addTextToInfoBox("Prune the fruit tree patch.");
                    this.highlightFruitTreePatches(graphics, this.leftClickColorWithAlpha);
                    break;
                }
                case REMOVE: {
                    this.plugin.addTextToInfoBox("Pay to remove fruit tree, or cut it down and clear the patch.");
                    if (!this.isInterfaceOpen(219, 1)) {
                        this.highlightNpc(graphics, "Garth", this.leftClickColorWithAlpha);
                        this.highlightNpc(graphics, "Ellena", this.leftClickColorWithAlpha);
                        this.highlightNpc(graphics, "Nikkie", this.leftClickColorWithAlpha);
                        this.highlightNpc(graphics, "Bolongo", this.leftClickColorWithAlpha);
                        this.highlightNpc(graphics, "Liliwen", this.leftClickColorWithAlpha);
                        this.highlightNpc(graphics, "Gileth", this.leftClickColorWithAlpha);
                        break;
                    }
                    Widget widget = this.client.getWidget(219, 1);
                    this.highlightDynamicComponent(graphics, widget, 1, this.leftClickColorWithAlpha);
                    break;
                }
                case UNKNOWN: {
                    this.plugin.addTextToInfoBox("UNKNOWN state: Try to do something with the tree patch to change its state.");
                    break;
                }
                case GROWING: {
                    this.plugin.addTextToInfoBox("Use Compost on patch.");
                    if (this.isItemInInventory(this.selectedCompostID())) {
                        this.highlightFruitTreePatches(graphics, this.highlightUseItemWithAlpha);
                        this.itemHighlight(graphics, this.selectedCompostID(), this.highlightUseItemWithAlpha);
                    } else {
                        this.withdrawCompost(graphics);
                    }
                    if (!this.isItComposted(this.plugin.getLastMessage())) break;
                    this.currentHerbCase = 1;
                    this.fruitTreePatchDone = true;
                }
            }
        }
    }

    private List<Integer> getGameObjectIdsByName(String name) {
        ArrayList<Integer> foundObjectIds = new ArrayList<Integer>();
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Tile tile = tiles[this.client.getPlane()][x][y];
                if (tile == null) continue;
                for (GameObject gameObject : tile.getGameObjects()) {
                    ObjectComposition objectComposition;
                    if (gameObject == null || (objectComposition = this.client.getObjectDefinition(gameObject.getId())) == null || !objectComposition.getName().equals(name)) continue;
                    foundObjectIds.add(gameObject.getId());
                }
            }
        }
        return foundObjectIds;
    }

    public void inHouseCheck() {
        if (this.getGameObjectIdsByName("Portal").contains(4525)) {
            currentTeleportCase = 2;
        }
    }

    public void gettingToHouse(Graphics2D graphics) {
        FarmingHelperConfig.OptionEnumHouseTele teleportOption = this.config.enumConfigHouseTele();
        switch (teleportOption) {
            case Law_air_earth_runes: {
                InventoryTabChecker.TabState tabState = InventoryTabChecker.checkTab(this.client, 171);
                switch (tabState) {
                    case INVENTORY: 
                    case REST: {
                        this.interfaceOverlay(161, 64).render(graphics);
                        break;
                    }
                    case SPELLBOOK: {
                        this.interfaceOverlay(218, 29).render(graphics);
                        this.inHouseCheck();
                    }
                }
            }
            case Teleport_To_House: {
                this.inHouseCheck();
                this.itemHighlight(graphics, 8013, this.leftClickColorWithAlpha);
                break;
            }
            case Construction_cape: {
                this.inHouseCheck();
                this.itemHighlight(graphics, 9789, this.rightClickColorWithAlpha);
                break;
            }
            case Construction_cape_t: {
                this.inHouseCheck();
                this.itemHighlight(graphics, 9790, this.rightClickColorWithAlpha);
                break;
            }
            case Max_cape: {
                this.inHouseCheck();
                this.itemHighlight(graphics, 13280, this.rightClickColorWithAlpha);
            }
        }
    }

    public void gettingToLocation(Graphics2D graphics, Location location) {
        this.updateColors();
        Location.Teleport teleport = location.getSelectedTeleport();
        Boolean locationEnabledBool = false;
        if (this.plugin.getFarmingTeleportOverlay().herbRun.booleanValue()) {
            locationEnabledBool = this.plugin.getHerbLocationEnabled(location.getName());
        }
        if (this.plugin.getFarmingTeleportOverlay().treeRun.booleanValue()) {
            locationEnabledBool = this.plugin.getTreeLocationEnabled(location.getName());
        }
        if (this.plugin.getFarmingTeleportOverlay().fruitTreeRun.booleanValue()) {
            locationEnabledBool = this.plugin.getFruitTreeLocationEnabled(location.getName());
        }
        if (locationEnabledBool.booleanValue()) {
            if (!this.isAtDestination) {
                int currentRegionId = this.client.getLocalPlayer().getWorldLocation().getRegionID();
                this.plugin.addTextToInfoBox(teleport.getDescription());
                block0 : switch (teleport.getCategory()) {
                    case ITEM: {
                        if (teleport.getInterfaceGroupId() != 0) {
                            if (!this.isInterfaceOpen(teleport.getInterfaceGroupId(), teleport.getInterfaceChildId())) {
                                this.itemHighlight(graphics, teleport.getId(), this.rightClickColorWithAlpha);
                                if (!teleport.getRightClickOption().equals("null")) {
                                    this.highlightRightClickOption(graphics, teleport.getRightClickOption());
                                }
                            } else {
                                Widget widget = this.client.getWidget(teleport.getInterfaceGroupId(), teleport.getInterfaceChildId());
                                this.highlightDynamicComponent(graphics, widget, 1, this.leftClickColorWithAlpha);
                            }
                            if (currentRegionId != teleport.getRegionId()) break;
                            currentTeleportCase = 1;
                            this.isAtDestination = true;
                            startSubCases = true;
                            if (!location.getFarmLimps().booleanValue()) break;
                            farmLimps = true;
                            break;
                        }
                        if (!teleport.getRightClickOption().equals("null")) {
                            this.itemHighlight(graphics, teleport.getId(), this.rightClickColorWithAlpha);
                            this.highlightRightClickOption(graphics, teleport.getRightClickOption());
                        } else {
                            if (teleport.getId() == 6102) {
                                this.highlightTeleportCrystal(graphics, this.leftClickColorWithAlpha);
                            }
                            if (teleport.getId() == 11111) {
                                Widget widget;
                                String index = location.getName();
                                if (Objects.equals(index, "Ardougne")) {
                                    this.highlightSkillsNecklace(graphics, this.leftClickColorWithAlpha);
                                    this.highlightRightClickOption(graphics, "Rub");
                                    widget = this.client.getWidget(187, 3);
                                    this.highlightDynamicComponent(graphics, widget, 0, this.leftClickColorWithAlpha);
                                }
                                if (Objects.equals(index, "Farming Guild")) {
                                    this.highlightSkillsNecklace(graphics, this.leftClickColorWithAlpha);
                                    this.highlightRightClickOption(graphics, "Rub");
                                    widget = this.client.getWidget(187, 3);
                                    this.highlightDynamicComponent(graphics, widget, 5, this.leftClickColorWithAlpha);
                                }
                            } else {
                                this.itemHighlight(graphics, teleport.getId(), this.leftClickColorWithAlpha);
                            }
                        }
                        if (currentRegionId != teleport.getRegionId()) break;
                        currentTeleportCase = 1;
                        this.isAtDestination = true;
                        startSubCases = true;
                        if (!location.getFarmLimps().booleanValue()) break;
                        farmLimps = true;
                        break;
                    }
                    case PORTAL_NEXUS: {
                        switch (currentTeleportCase) {
                            case 1: {
                                this.gettingToHouse(graphics);
                                break block0;
                            }
                            case 2: {
                                if (!this.isInterfaceOpen(17, 0)) {
                                    List<Integer> portalNexusIds = this.getGameObjectIdsByName("Portal Nexus");
                                    for (Integer objectId : portalNexusIds) {
                                        this.gameObjectOverlay(objectId, this.leftClickColorWithAlpha).render(graphics);
                                    }
                                } else {
                                    int index = this.getChildIndexPN(location.getName());
                                    Widget widget = this.client.getWidget(17, 13);
                                    this.highlightDynamicComponent(graphics, widget, index, this.leftClickColorWithAlpha);
                                }
                                if (currentRegionId != teleport.getRegionId()) break;
                                currentTeleportCase = 1;
                                this.isAtDestination = true;
                                startSubCases = true;
                                if (!location.getFarmLimps().booleanValue()) break;
                                farmLimps = true;
                            }
                        }
                        break;
                    }
                    case JEWELLERY_BOX: {
                        switch (currentTeleportCase) {
                            case 1: {
                                this.gettingToHouse(graphics);
                                break block0;
                            }
                            case 2: {
                                List<Integer> jewelleryBoxIds = Arrays.asList(29154, 29155, 29156);
                                if (!this.isInterfaceOpen(590, 0)) {
                                    for (int id : jewelleryBoxIds) {
                                        this.gameObjectOverlay(id, this.leftClickColorWithAlpha).render(graphics);
                                    }
                                    this.gameObjectOverlay(teleport.getId(), this.leftClickColorWithAlpha).render(graphics);
                                } else {
                                    Widget widget = this.client.getWidget(590, 5);
                                    this.highlightDynamicComponent(graphics, widget, 10, this.leftClickColorWithAlpha);
                                }
                                if (currentRegionId != teleport.getRegionId()) break;
                                currentTeleportCase = 1;
                                this.isAtDestination = true;
                                startSubCases = true;
                                if (!location.getFarmLimps().booleanValue()) break;
                                farmLimps = true;
                            }
                        }
                        break;
                    }
                    case MOUNTED_XERICS: {
                        switch (currentTeleportCase) {
                            case 1: {
                                this.gettingToHouse(graphics);
                                break;
                            }
                            case 2: {
                                List<Integer> xericsTalismanIds = Arrays.asList(33411, 33412, 33413, 33414, 33415);
                                if (!this.isInterfaceOpen(teleport.getInterfaceGroupId(), teleport.getInterfaceChildId())) {
                                    for (int id : xericsTalismanIds) {
                                        Overlay decorativeObjectHighlight = this.decorativeObjectOverlay(id, this.leftClickColorWithAlpha);
                                        decorativeObjectHighlight.render(graphics);
                                    }
                                    break;
                                }
                                Widget widget = this.client.getWidget(teleport.getInterfaceGroupId(), teleport.getInterfaceChildId());
                                this.highlightDynamicComponent(graphics, widget, 1, this.leftClickColorWithAlpha);
                                if (currentRegionId != teleport.getRegionId()) break;
                                currentTeleportCase = 1;
                                this.isAtDestination = true;
                                startSubCases = true;
                                if (!location.getFarmLimps().booleanValue()) break;
                                farmLimps = true;
                            }
                        }
                    }
                    case SPELLBOOK: {
                        InventoryTabChecker.TabState tabState = InventoryTabChecker.checkTab(this.client, 171);
                        switch (tabState) {
                            case REST: {
                                if (currentRegionId == teleport.getRegionId()) {
                                    currentTeleportCase = 1;
                                    this.isAtDestination = true;
                                    startSubCases = true;
                                }
                            }
                            case INVENTORY: {
                                this.interfaceOverlay(161, 64).render(graphics);
                                if (currentRegionId != teleport.getRegionId()) break;
                                currentTeleportCase = 1;
                                this.isAtDestination = true;
                                startSubCases = true;
                                break block0;
                            }
                            case SPELLBOOK: {
                                this.interfaceOverlay(teleport.getInterfaceGroupId(), teleport.getInterfaceChildId()).render(graphics);
                                if (currentRegionId != teleport.getRegionId()) break;
                                currentTeleportCase = 1;
                                this.isAtDestination = true;
                                startSubCases = true;
                            }
                        }
                        break;
                    }
                }
            } else {
                this.farming(graphics, teleport);
            }
        } else {
            ++herbRunIndex;
        }
    }

    public void farming(Graphics2D graphics, Location.Teleport teleport) {
        if (startSubCases) {
            if (this.herbRun.booleanValue()) {
                if (subCase == 1) {
                    this.herbSteps(graphics, teleport);
                    if (this.herbPatchDone.booleanValue()) {
                        subCase = 2;
                        this.herbPatchDone = false;
                        this.patchComposted = false;
                    }
                } else if (subCase == 2) {
                    if (this.config.generalLimpwurt()) {
                        this.flowerSteps(graphics);
                        if (flowerPatchDone) {
                            subCase = 1;
                            startSubCases = false;
                            this.isAtDestination = false;
                            ++herbRunIndex;
                            farmLimps = false;
                            flowerPatchDone = false;
                            this.patchComposted = false;
                        }
                    } else {
                        subCase = 1;
                        startSubCases = false;
                        this.isAtDestination = false;
                        ++herbRunIndex;
                        farmLimps = false;
                        flowerPatchDone = false;
                        this.patchComposted = false;
                    }
                }
            }
            if (this.treeRun.booleanValue()) {
                this.treeSteps(graphics, teleport);
                if (this.treePatchDone.booleanValue()) {
                    startSubCases = false;
                    this.isAtDestination = false;
                    ++herbRunIndex;
                    this.patchComposted = false;
                    this.treePatchDone = false;
                }
            }
            if (this.fruitTreeRun.booleanValue()) {
                this.fruitTreeSteps(graphics, teleport);
                if (this.fruitTreePatchDone.booleanValue()) {
                    startSubCases = false;
                    this.isAtDestination = false;
                    ++herbRunIndex;
                    this.patchComposted = false;
                    this.fruitTreePatchDone = false;
                }
            }
        }
    }

    public void RemoveOverlay() {
        this.plugin.overlayManager.remove((Overlay)this.farmingHelperOverlay);
        this.plugin.overlayManager.remove((Overlay)this.farmingTeleportOverlay);
        this.plugin.overlayManager.remove((Overlay)this.farmingHelperOverlayInfoBox);
        this.plugin.setOverlayActive(false);
        this.plugin.setTeleportOverlayActive(false);
        herbRunIndex = 0;
        currentTeleportCase = 1;
        subCase = 1;
        startSubCases = false;
        this.isAtDestination = false;
        farmLimps = false;
        flowerPatchDone = false;
        this.plugin.setItemsCollected(false);
        this.plugin.getFarmingTeleportOverlay().herbRun = false;
        this.plugin.getFarmingTeleportOverlay().treeRun = false;
        this.plugin.getFarmingTeleportOverlay().fruitTreeRun = false;
        this.fruitTreeRun = false;
        this.herbRun = false;
        this.treeRun = false;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.isTeleportOverlayActive()) {
            Client client = this.plugin.getClient();
            if (this.herbRun.booleanValue()) {
                switch (herbRunIndex) {
                    case 0: {
                        this.gettingToLocation(graphics, this.plugin.getArdougneLocation());
                        break;
                    }
                    case 1: {
                        this.gettingToLocation(graphics, this.plugin.getCatherbyLocation());
                        break;
                    }
                    case 2: {
                        this.gettingToLocation(graphics, this.plugin.getFaladorLocation());
                        break;
                    }
                    case 3: {
                        this.gettingToLocation(graphics, this.plugin.getFarmingGuildLocation());
                        break;
                    }
                    case 4: {
                        this.gettingToLocation(graphics, this.plugin.getHarmonyLocation());
                        break;
                    }
                    case 5: {
                        this.gettingToLocation(graphics, this.plugin.getKourendLocation());
                        break;
                    }
                    case 6: {
                        this.gettingToLocation(graphics, this.plugin.getMorytaniaLocation());
                        break;
                    }
                    case 7: {
                        this.gettingToLocation(graphics, this.plugin.getTrollStrongholdLocation());
                        break;
                    }
                    case 8: {
                        this.gettingToLocation(graphics, this.plugin.getWeissLocation());
                        break;
                    }
                    case 9: {
                        this.RemoveOverlay();
                    }
                    default: {
                        this.RemoveOverlay();
                        break;
                    }
                }
            } else if (this.treeRun.booleanValue()) {
                switch (herbRunIndex) {
                    case 0: {
                        this.gettingToLocation(graphics, this.plugin.getFaladorTreeLocation());
                        break;
                    }
                    case 1: {
                        this.gettingToLocation(graphics, this.plugin.getFarmingGuildTreeLocation());
                        break;
                    }
                    case 2: {
                        this.gettingToLocation(graphics, this.plugin.getGnomeStrongholdTreeLocation());
                        break;
                    }
                    case 3: {
                        this.gettingToLocation(graphics, this.plugin.getLumbridgeTreeLocation());
                        break;
                    }
                    case 4: {
                        this.gettingToLocation(graphics, this.plugin.getTaverleyTreeLocation());
                        break;
                    }
                    case 5: {
                        this.gettingToLocation(graphics, this.plugin.getVarrockTreeLocation());
                        break;
                    }
                    case 6: {
                        this.RemoveOverlay();
                    }
                    default: {
                        this.RemoveOverlay();
                        break;
                    }
                }
            } else if (this.fruitTreeRun.booleanValue()) {
                switch (herbRunIndex) {
                    case 0: {
                        this.gettingToLocation(graphics, this.plugin.getBrimhavenFruitTreeLocation());
                        break;
                    }
                    case 1: {
                        this.gettingToLocation(graphics, this.plugin.getCatherbyFruitTreeLocation());
                        break;
                    }
                    case 2: {
                        this.gettingToLocation(graphics, this.plugin.getFarmingGuildFruitTreeLocation());
                        break;
                    }
                    case 3: {
                        this.gettingToLocation(graphics, this.plugin.getGnomeStrongholdFruitTreeLocation());
                        break;
                    }
                    case 4: {
                        this.gettingToLocation(graphics, this.plugin.getLletyaFruitTreeLocation());
                        break;
                    }
                    case 5: {
                        this.gettingToLocation(graphics, this.plugin.getTreeGnomeVillageTreeLocation());
                        break;
                    }
                    case 6: {
                        this.RemoveOverlay();
                    }
                    default: {
                        this.RemoveOverlay();
                    }
                }
            }
        }
        return null;
    }
}

