/*
 * Decompiled with CFR 0.152.
 */
package com.farminghelper.speaax;

import com.farminghelper.speaax.FarmingHelperConfig;
import com.farminghelper.speaax.FarmingHelperOverlay;
import com.farminghelper.speaax.FarmingHelperOverlayInfoBox;
import com.farminghelper.speaax.FarmingHelperPanel;
import com.farminghelper.speaax.FarmingTeleportOverlay;
import com.farminghelper.speaax.ItemsAndLocations.FruitTreeRunItemAndLocation;
import com.farminghelper.speaax.ItemsAndLocations.HerbRunItemAndLocation;
import com.farminghelper.speaax.ItemsAndLocations.TreeRunItemAndLocation;
import com.farminghelper.speaax.Location;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Lazy Farming", description="Show item requirements and highlights for farming runs.")
public class FarmingHelperPlugin
extends Plugin {
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private HerbRunItemAndLocation herbRunItemAndLocation;
    private TreeRunItemAndLocation treeRunItemAndLocation;
    private FruitTreeRunItemAndLocation fruitTreeRunItemAndLocation;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Client client;
    private boolean isTeleportOverlayActive = false;
    @Inject
    private FarmingHelperOverlayInfoBox farmingHelperOverlayInfoBox;
    private String lastMessage = "";
    @Inject
    private EventBus eventBus;
    @Inject
    private ClientThread clientThread;
    @Inject
    private FarmingTeleportOverlay farmingTeleportOverlay;
    private int lastClickedGroupId;
    private int lastClickedChildId;
    private boolean clicked = false;
    private FarmingHelperPanel farmingHelperPanel;
    private FarmingHelperPanel panel;
    private NavigationButton navButton;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private FarmingHelperConfig config;
    @Inject
    public OverlayManager overlayManager;
    private boolean isOverlayActive = true;
    @Inject
    private FarmingHelperOverlay farmingHelperOverlay;
    private boolean itemsCollected = false;
    private int lastAnimationId = -1;
    private Map<Integer, Integer> herbItemsCache;
    private Map<Integer, Integer> treeItemsCache;
    private Map<Integer, Integer> fruitTreeItemsCache;

    public void runOnClientThread(Runnable task) {
        this.clientThread.invokeLater(task);
    }

    public Location getArdougneLocation() {
        return this.herbRunItemAndLocation.ardougneLocation;
    }

    public Location getCatherbyLocation() {
        return this.herbRunItemAndLocation.catherbyLocation;
    }

    public Location getFaladorLocation() {
        return this.herbRunItemAndLocation.faladorLocation;
    }

    public Location getFarmingGuildLocation() {
        return this.herbRunItemAndLocation.farmingGuildLocation;
    }

    public Location getHarmonyLocation() {
        return this.herbRunItemAndLocation.harmonyLocation;
    }

    public Location getKourendLocation() {
        return this.herbRunItemAndLocation.kourendLocation;
    }

    public Location getMorytaniaLocation() {
        return this.herbRunItemAndLocation.morytaniaLocation;
    }

    public Location getTrollStrongholdLocation() {
        return this.herbRunItemAndLocation.trollStrongholdLocation;
    }

    public Location getWeissLocation() {
        return this.herbRunItemAndLocation.weissLocation;
    }

    public Location getFaladorTreeLocation() {
        return this.treeRunItemAndLocation.faladorTreeLocation;
    }

    public Location getFarmingGuildTreeLocation() {
        return this.treeRunItemAndLocation.farmingGuildTreeLocation;
    }

    public Location getGnomeStrongholdTreeLocation() {
        return this.treeRunItemAndLocation.gnomeStrongholdTreeLocation;
    }

    public Location getLumbridgeTreeLocation() {
        return this.treeRunItemAndLocation.lumbridgeTreeLocation;
    }

    public Location getTaverleyTreeLocation() {
        return this.treeRunItemAndLocation.taverleyTreeLocation;
    }

    public Location getVarrockTreeLocation() {
        return this.treeRunItemAndLocation.varrockTreeLocation;
    }

    public Location getBrimhavenFruitTreeLocation() {
        return this.fruitTreeRunItemAndLocation.brimhavenFruitTreeLocation;
    }

    public Location getCatherbyFruitTreeLocation() {
        return this.fruitTreeRunItemAndLocation.catherbyFruitTreeLocation;
    }

    public Location getFarmingGuildFruitTreeLocation() {
        return this.fruitTreeRunItemAndLocation.farmingGuildFruitTreeLocation;
    }

    public Location getGnomeStrongholdFruitTreeLocation() {
        return this.fruitTreeRunItemAndLocation.gnomeStrongholdFruitTreeLocation;
    }

    public Location getLletyaFruitTreeLocation() {
        return this.fruitTreeRunItemAndLocation.lletyaFruitTreeLocation;
    }

    public Location getTreeGnomeVillageTreeLocation() {
        return this.fruitTreeRunItemAndLocation.treeGnomeVillageFruitTreeLocation;
    }

    public boolean isTeleportOverlayActive() {
        return this.isTeleportOverlayActive;
    }

    public void setTeleportOverlayActive(boolean isTeleportOverlayActive) {
        this.isTeleportOverlayActive = isTeleportOverlayActive;
    }

    public FarmingHelperOverlayInfoBox getFarmingHelperOverlayInfoBox() {
        return this.farmingHelperOverlayInfoBox;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE) {
            this.lastMessage = event.getMessage();
            System.out.println("Last game message updated: " + this.lastMessage);
        } else if (event.getType() == ChatMessageType.SPAM) {
            this.lastMessage = event.getMessage();
            System.out.println("Last spam message updated: " + this.lastMessage);
        }
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public boolean checkMessage(String targetMessage, String lastMessage) {
        return lastMessage.trim().equalsIgnoreCase(targetMessage.trim());
    }

    public FarmingTeleportOverlay getFarmingTeleportOverlay() {
        return this.farmingTeleportOverlay;
    }

    public boolean isClicked(int groupId, int childId) {
        return this.clicked && groupId == this.lastClickedGroupId && childId == this.lastClickedChildId;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        this.clientThread.invokeLater(() -> {
            int groupId = event.getWidgetId() >>> 16;
            int childId = event.getWidgetId() & 0xFFFF;
            this.clicked = true;
            this.lastClickedGroupId = groupId;
            this.lastClickedChildId = childId;
            System.out.printf("Clicked widget: groupId=%d, childId=%d%n", groupId, childId);
        });
    }

    public FarmingHelperOverlay getFarmingHelperOverlay() {
        return this.farmingHelperOverlay;
    }

    public boolean areItemsCollected() {
        return this.itemsCollected;
    }

    public void setItemsCollected(boolean itemsCollected) {
        this.itemsCollected = itemsCollected;
    }

    public Client getClient() {
        return this.client;
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (this.client.getGameState() != GameState.LOGGED_IN || event.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        int currentAnimationId = event.getActor().getAnimation();
        if (currentAnimationId != this.lastAnimationId) {
            System.out.println("Animation ID: " + currentAnimationId);
            this.lastAnimationId = currentAnimationId;
        }
    }

    public void updateHerbOverlay(Map<Integer, Integer> herbItems) {
        this.herbItemsCache = herbItems;
    }

    public void updateTreeOverlay(Map<Integer, Integer> treeItems) {
        this.treeItemsCache = treeItems;
    }

    public void updateFruitTreeOverlay(Map<Integer, Integer> fruitTreeItems) {
        this.fruitTreeItemsCache = fruitTreeItems;
    }

    @Provides
    FarmingHelperConfig getConfig(ConfigManager configManager) {
        return (FarmingHelperConfig)configManager.getConfig(FarmingHelperConfig.class);
    }

    public boolean isOverlayActive() {
        return this.isOverlayActive;
    }

    public void setOverlayActive(boolean overlayActive) {
        this.isOverlayActive = overlayActive;
    }

    public void addTextToInfoBox(String text) {
        this.farmingHelperOverlayInfoBox.setText(text);
    }

    public boolean getHerbLocationEnabled(String locationName) {
        switch (locationName) {
            case "Ardougne": {
                return this.config.ardougneHerb();
            }
            case "Catherby": {
                return this.config.catherbyHerb();
            }
            case "Falador": {
                return this.config.faladorHerb();
            }
            case "Farming Guild": {
                return this.config.farmingGuildHerb();
            }
            case "Harmony Island": {
                return this.config.harmonyHerb();
            }
            case "Kourend": {
                return this.config.kourendHerb();
            }
            case "Morytania": {
                return this.config.morytaniaHerb();
            }
            case "Troll Stronghold": {
                return this.config.trollStrongholdHerb();
            }
            case "Weiss": {
                return this.config.weissHerb();
            }
        }
        return false;
    }

    public boolean getTreeLocationEnabled(String locationName) {
        switch (locationName) {
            case "Falador": {
                return this.config.faladorTree();
            }
            case "Farming Guild": {
                return this.config.farmingGuildTree();
            }
            case "Gnome Stronghold": {
                return this.config.gnomeStrongholdTree();
            }
            case "Lumbridge": {
                return this.config.lumbridgeTree();
            }
            case "Taverley": {
                return this.config.taverleyTree();
            }
            case "Varrock": {
                return this.config.varrockTree();
            }
        }
        return false;
    }

    public boolean getFruitTreeLocationEnabled(String locationName) {
        switch (locationName) {
            case "Brimhaven": {
                return this.config.brimhavenFruitTree();
            }
            case "Catherby": {
                return this.config.catherbyFruitTree();
            }
            case "Farming Guild": {
                return this.config.farmingGuildFruitTree();
            }
            case "Gnome Stronghold": {
                return this.config.gnomeStrongholdFruitTree();
            }
            case "Lletya": {
                return this.config.lletyaFruitTree();
            }
            case "Tree Gnome Village": {
                return this.config.treeGnomeVillageFruitTree();
            }
        }
        return false;
    }

    protected void startUp() {
        this.herbRunItemAndLocation = new HerbRunItemAndLocation(this.config, this.client, this);
        this.treeRunItemAndLocation = new TreeRunItemAndLocation(this.config, this.client, this);
        this.fruitTreeRunItemAndLocation = new FruitTreeRunItemAndLocation(this.config, this.client, this);
        this.farmingHelperOverlay = new FarmingHelperOverlay(this.client, this, this.itemManager, this.herbRunItemAndLocation, this.treeRunItemAndLocation, this.fruitTreeRunItemAndLocation);
        this.panel = new FarmingHelperPanel(this, this.overlayManager, this.farmingTeleportOverlay, this.herbRunItemAndLocation, this.treeRunItemAndLocation, this.fruitTreeRunItemAndLocation);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/com/farminghelper/speaax/icon.png");
        this.navButton = NavigationButton.builder().tooltip("Lazy Farming ").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.overlayManager.add((Overlay)this.farmingHelperOverlay);
        this.overlayManager.add((Overlay)this.farmingTeleportOverlay);
        this.overlayManager.add((Overlay)this.farmingHelperOverlayInfoBox);
        this.isOverlayActive = false;
        this.eventBus.register((Object)this);
        this.herbRunItemAndLocation.setupHerbLocations();
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
        this.overlayManager.remove((Overlay)this.farmingHelperOverlay);
        this.overlayManager.remove((Overlay)this.farmingTeleportOverlay);
        this.overlayManager.remove((Overlay)this.farmingHelperOverlayInfoBox);
        this.eventBus.unregister((Object)this);
    }
}

