/*
 * Decompiled with CFR 0.152.
 */
package com.farminghelper.speaax;

import com.farminghelper.speaax.FarmingHelperOverlay;
import com.farminghelper.speaax.FarmingHelperPlugin;
import com.farminghelper.speaax.FarmingTeleportOverlay;
import com.farminghelper.speaax.ItemsAndLocations.FruitTreeRunItemAndLocation;
import com.farminghelper.speaax.ItemsAndLocations.HerbRunItemAndLocation;
import com.farminghelper.speaax.ItemsAndLocations.TreeRunItemAndLocation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

public class FarmingHelperPanel
extends PluginPanel {
    private final HerbRunItemAndLocation herbRunItemAndLocation;
    private final TreeRunItemAndLocation treeRunItemAndLocation;
    private final FruitTreeRunItemAndLocation fruitTreeRunItemAndLocation;
    private final FarmingHelperPlugin plugin;
    private final OverlayManager overlayManager;
    private final FarmingTeleportOverlay farmingTeleportOverlay;
    private JButton herbButton;
    private JButton treeButton;
    private JButton fruitTreeButton;
    private JLabel textLabel;

    public FarmingHelperPanel(final FarmingHelperPlugin plugin, OverlayManager overlayManager, FarmingTeleportOverlay farmingTeleportOverlay, final HerbRunItemAndLocation herbRunItemAndLocation, final TreeRunItemAndLocation treeRunItemAndLocation, final FruitTreeRunItemAndLocation fruitTreeRunItemAndLocation) {
        this.herbRunItemAndLocation = herbRunItemAndLocation;
        this.treeRunItemAndLocation = treeRunItemAndLocation;
        this.farmingTeleportOverlay = farmingTeleportOverlay;
        this.fruitTreeRunItemAndLocation = fruitTreeRunItemAndLocation;
        this.plugin = plugin;
        this.overlayManager = overlayManager;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(0, 2, 4, 2);
        c.gridx = 0;
        c.gridy = 0;
        this.herbButton = new JButton("Herb run");
        this.herbButton.setFocusable(false);
        this.herbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.runOnClientThread(() -> {
                    Map<Integer, Integer> herbItems = herbRunItemAndLocation.getHerbItems();
                    plugin.updateHerbOverlay(herbItems);
                    plugin.setOverlayActive(!plugin.isOverlayActive());
                    FarmingHelperPanel.this.onHerbButtonClicked();
                });
            }
        });
        this.add(this.herbButton, c);
        JLabel textLabel = new JLabel("Tree/Fruit Tree run is not recommended.");
        c.gridx = 0;
        c.gridy = 1;
        this.add(textLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        this.treeButton = new JButton("Tree run");
        this.treeButton.setFocusable(false);
        this.treeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.runOnClientThread(() -> {
                    Map<Integer, Integer> treeItems = treeRunItemAndLocation.getTreeItems();
                    plugin.updateTreeOverlay(treeItems);
                    plugin.setOverlayActive(!plugin.isOverlayActive());
                    FarmingHelperPanel.this.onTreeButtonClicked();
                });
            }
        });
        this.add(this.treeButton, c);
        c.gridx = 0;
        c.gridy = 3;
        this.fruitTreeButton = new JButton("Fruit Tree run");
        this.fruitTreeButton.setFocusable(false);
        this.fruitTreeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                plugin.runOnClientThread(() -> {
                    Map<Integer, Integer> fruitTreeItems = fruitTreeRunItemAndLocation.getFruitTreeItems();
                    plugin.updateFruitTreeOverlay(fruitTreeItems);
                    plugin.setOverlayActive(!plugin.isOverlayActive());
                    FarmingHelperPanel.this.onFruitTreeButtonClicked();
                });
            }
        });
        this.add(this.fruitTreeButton, c);
        JTextArea textAreaTip = new JTextArea("Tips: \n - Rune pouch and combination runes work. \n - If you don't have Bottomless compost bucket you should store compost @ Tool Leprechaun, the plugin checks if you have compost stored there.");
        textAreaTip.setWrapStyleWord(true);
        textAreaTip.setLineWrap(true);
        textAreaTip.setEditable(false);
        c.gridx = 0;
        c.gridy = 6;
        this.add(textAreaTip, c);
    }

    private void onHerbButtonClicked() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FarmingHelperOverlay overlay = FarmingHelperPanel.this.plugin.getFarmingHelperOverlay();
                if (!FarmingHelperPanel.this.plugin.isOverlayActive()) {
                    FarmingHelperPanel.this.farmingTeleportOverlay.RemoveOverlay();
                    System.out.println("Remove overlay from button");
                } else {
                    System.out.println("Add overlay from button");
                    FarmingHelperPanel.this.plugin.getFarmingTeleportOverlay().herbRun = true;
                    FarmingHelperPanel.this.overlayManager.add((Overlay)overlay);
                    FarmingHelperPanel.this.overlayManager.add((Overlay)FarmingHelperPanel.this.farmingTeleportOverlay);
                }
            }
        });
    }

    private void onTreeButtonClicked() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FarmingHelperOverlay overlay = FarmingHelperPanel.this.plugin.getFarmingHelperOverlay();
                if (!FarmingHelperPanel.this.plugin.isOverlayActive()) {
                    FarmingHelperPanel.this.farmingTeleportOverlay.RemoveOverlay();
                    System.out.println("Remove overlay from button");
                } else {
                    System.out.println("Add overlay from button");
                    FarmingHelperPanel.this.plugin.getFarmingTeleportOverlay().treeRun = true;
                    FarmingHelperPanel.this.overlayManager.add((Overlay)overlay);
                    FarmingHelperPanel.this.overlayManager.add((Overlay)FarmingHelperPanel.this.farmingTeleportOverlay);
                }
            }
        });
    }

    private void onFruitTreeButtonClicked() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FarmingHelperOverlay overlay = FarmingHelperPanel.this.plugin.getFarmingHelperOverlay();
                if (!FarmingHelperPanel.this.plugin.isOverlayActive()) {
                    FarmingHelperPanel.this.farmingTeleportOverlay.RemoveOverlay();
                    System.out.println("Remove overlay from button");
                } else {
                    System.out.println("Add overlay from button");
                    FarmingHelperPanel.this.plugin.getFarmingTeleportOverlay().fruitTreeRun = true;
                    FarmingHelperPanel.this.overlayManager.add((Overlay)overlay);
                    FarmingHelperPanel.this.overlayManager.add((Overlay)FarmingHelperPanel.this.farmingTeleportOverlay);
                }
            }
        });
    }
}

