/*
 * Decompiled with CFR 0.152.
 */
package com.farminghelper.speaax;

import com.farminghelper.speaax.FarmingHelperPlugin;
import com.farminghelper.speaax.ItemsAndLocations.FruitTreeRunItemAndLocation;
import com.farminghelper.speaax.ItemsAndLocations.HerbRunItemAndLocation;
import com.farminghelper.speaax.ItemsAndLocations.TreeRunItemAndLocation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.util.AsyncBufferedImage;

public class FarmingHelperOverlay
extends Overlay {
    private HerbRunItemAndLocation herbRunItemAndLocation;
    private TreeRunItemAndLocation treeRunItemAndLocation;
    private FruitTreeRunItemAndLocation fruitTreeRunItemAndLocation;
    private final Client client;
    private final FarmingHelperPlugin plugin;
    private final PanelComponent panelComponent = new PanelComponent();
    @Inject
    private ItemManager itemManager;
    public static final List<Integer> TELEPORT_CRYSTAL_IDS = Arrays.asList(6102, 6101, 6100, 6099, 13102);
    private static final int BASE_TELEPORT_CRYSTAL_ID = 6102;
    public static final List<Integer> SKILLS_NECKLACE_IDS = Arrays.asList(11111, 11109, 11107, 11105, 11970, 11968);
    private static final int BASE_SKILLS_NECKLACE_ID = 11111;
    public static final List<Integer> HERB_PATCH_IDS = Arrays.asList(33176, 27115, 8152, 8150, 8153, 18816, 8151, 9372, 33979);
    private static final List<Integer> HERB_SEED_IDS = Arrays.asList(5291, 5292, 5293, 5294, 5295, 5296, 5297, 5298, 5299, 5300, 5301, 5302, 5303, 5304);
    private static final int BASE_SEED_ID = 5291;
    private static final List<Integer> FLOWER_PATCH_IDS = Arrays.asList(27111, 7849, 7847, 7850, 7848, 33649);
    public static final List<Integer> TREE_PATCH_IDS = Arrays.asList(8389, 33732, 19147, 8391, 8388, 8390);
    private static final List<Integer> TREE_SAPLING_IDS = Arrays.asList(5370, 5371, 5372, 5373, 5374);
    private static final int BASE_SAPLING_ID = 5370;
    public static final List<Integer> FRUIT_TREE_PATCH_IDS = Arrays.asList(7964, 7965, 34007, 7962, 26579, 7963);
    private static final List<Integer> FRUIT_TREE_SAPLING_IDS = Arrays.asList(5496, 5497, 5498, 5499, 5500, 5501, 5502, 22866);
    private static final int BASE_FRUIT_SAPLING_ID = 5496;
    public static final List<Integer> RUNE_POUCH_ID = Arrays.asList(12791, 27281);
    public static final List<Integer> RUNE_POUCH_AMOUNT_VARBITS = Arrays.asList(1624, 1625, 1626, 14286);
    public static final List<Integer> RUNE_POUCH_RUNE_VARBITS = Arrays.asList(29, 1622, 1623, 14285);
    private static final Map<Integer, List<Integer>> COMBINATION_RUNE_SUBRUNES_MAP;
    public Map<Integer, Integer> itemsToCheck;

    public List<Integer> getTeleportCrystalIdsIds() {
        return TELEPORT_CRYSTAL_IDS;
    }

    private boolean isTeleportCrystal(int itemId) {
        return TELEPORT_CRYSTAL_IDS.contains(itemId);
    }

    public List<Integer> getSkillsNecklaceIdsIds() {
        return SKILLS_NECKLACE_IDS;
    }

    private boolean isSkillsNecklace(int itemId) {
        return SKILLS_NECKLACE_IDS.contains(itemId);
    }

    public List<Integer> getHerbPatchIds() {
        return HERB_PATCH_IDS;
    }

    public List<Integer> getHerbSeedIds() {
        return HERB_SEED_IDS;
    }

    private boolean isHerbSeed(int itemId) {
        return HERB_SEED_IDS.contains(itemId);
    }

    public List<Integer> getFlowerPatchIds() {
        return FLOWER_PATCH_IDS;
    }

    public List<Integer> getTreePatchIds() {
        return TREE_PATCH_IDS;
    }

    public List<Integer> getTreeSaplingIds() {
        return TREE_SAPLING_IDS;
    }

    private boolean isTreeSapling(int itemId) {
        return TREE_SAPLING_IDS.contains(itemId);
    }

    public List<Integer> getFruitTreePatchIds() {
        return FRUIT_TREE_PATCH_IDS;
    }

    public List<Integer> getFruitTreeSaplingIds() {
        return FRUIT_TREE_SAPLING_IDS;
    }

    private boolean isFruitTreeSapling(int itemId) {
        return FRUIT_TREE_SAPLING_IDS.contains(itemId);
    }

    private int getRuneItemIdFromVarbitValue(int varbitValue) {
        switch (varbitValue) {
            case 1: {
                return 556;
            }
            case 2: {
                return 555;
            }
            case 3: {
                return 557;
            }
            case 4: {
                return 554;
            }
            case 5: {
                return 558;
            }
            case 6: {
                return 562;
            }
            case 7: {
                return 560;
            }
            case 8: {
                return 565;
            }
            case 9: {
                return 564;
            }
            case 10: {
                return 561;
            }
            case 11: {
                return 563;
            }
            case 12: {
                return 559;
            }
            case 13: {
                return 566;
            }
            case 14: {
                return 9075;
            }
            case 15: {
                return 4695;
            }
            case 16: {
                return 4698;
            }
            case 17: {
                return 4696;
            }
            case 18: {
                return 4699;
            }
            case 19: {
                return 4694;
            }
            case 20: {
                return 4697;
            }
            case 21: {
                return 21880;
            }
        }
        return -1;
    }

    private Map<Integer, Integer> getRunePouchContentsVarbits() {
        HashMap<Integer, Integer> runePouchContents = new HashMap<Integer, Integer>();
        for (int i = 0; i < RUNE_POUCH_RUNE_VARBITS.size(); ++i) {
            int runeVarbitValue = this.client.getVarbitValue(RUNE_POUCH_RUNE_VARBITS.get(i).intValue());
            int runeAmount = this.client.getVarbitValue(RUNE_POUCH_AMOUNT_VARBITS.get(i).intValue());
            int runeId = this.getRuneItemIdFromVarbitValue(runeVarbitValue);
            if (runeId == -1 || runeAmount <= 0) continue;
            this.handleCombinationRunes(runeId, runeAmount, runePouchContents);
        }
        return runePouchContents;
    }

    @Inject
    public FarmingHelperOverlay(Client client, FarmingHelperPlugin plugin, ItemManager itemManager, HerbRunItemAndLocation herbRunItemAndLocation, TreeRunItemAndLocation treeRunItemAndLocation, FruitTreeRunItemAndLocation fruitTreeRunItemAndLocation) {
        this.client = client;
        this.plugin = plugin;
        this.itemManager = itemManager;
        this.herbRunItemAndLocation = herbRunItemAndLocation;
        this.treeRunItemAndLocation = treeRunItemAndLocation;
        this.fruitTreeRunItemAndLocation = fruitTreeRunItemAndLocation;
        this.setPosition(OverlayPosition.BOTTOM_RIGHT);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    private void handleCombinationRunes(int runeId, int runeAmount, Map<Integer, Integer> runePouchContents) {
        if (COMBINATION_RUNE_SUBRUNES_MAP.containsKey(runeId)) {
            List<Integer> subRunes = COMBINATION_RUNE_SUBRUNES_MAP.get(runeId);
            for (int subRune : subRunes) {
                runePouchContents.put(subRune, runePouchContents.getOrDefault(subRune, 0) + runeAmount);
            }
        } else {
            runePouchContents.put(runeId, runeAmount);
        }
    }

    public Integer checkToolLep(Integer item) {
        if (item == 6032) {
            return this.client.getVarbitValue(1442);
        }
        if (item == 6034) {
            return this.client.getVarbitValue(1443);
        }
        if (item == 21483) {
            return this.client.getVarbitValue(5732);
        }
        if (item == 22997 && this.client.getVarbitValue(7915) != 0) {
            return 1;
        }
        return 0;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.isOverlayActive() && !this.plugin.areItemsCollected()) {
            if (!this.plugin.isOverlayActive()) {
                return null;
            }
            this.plugin.addTextToInfoBox("Grab all the items needed");
            Map<Integer, Integer> itemsToCheck = null;
            if (this.plugin.getFarmingTeleportOverlay().herbRun.booleanValue()) {
                itemsToCheck = this.herbRunItemAndLocation.getHerbItems();
            }
            if (this.plugin.getFarmingTeleportOverlay().treeRun.booleanValue()) {
                itemsToCheck = this.treeRunItemAndLocation.getTreeItems();
            }
            if (this.plugin.getFarmingTeleportOverlay().fruitTreeRun.booleanValue()) {
                itemsToCheck = this.fruitTreeRunItemAndLocation.getFruitTreeItems();
            }
            if (itemsToCheck == null || itemsToCheck.isEmpty()) {
                return null;
            }
            ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
            Map<Integer, Integer> runePouchContents = this.getRunePouchContentsVarbits();
            Item[] items = inventory == null || inventory.getItems() == null ? new Item[]{} : inventory.getItems();
            int teleportCrystalCount = 0;
            for (Item item : items) {
                if (!this.isTeleportCrystal(item.getId())) continue;
                teleportCrystalCount += item.getQuantity();
                break;
            }
            int skillsNecklaceCount = 0;
            for (Item item : items) {
                if (!this.isSkillsNecklace(item.getId())) continue;
                skillsNecklaceCount += item.getQuantity();
                break;
            }
            int totalSeeds = 0;
            if (this.plugin.getFarmingTeleportOverlay().herbRun.booleanValue()) {
                for (Item item : items) {
                    if (!this.isHerbSeed(item.getId())) continue;
                    totalSeeds += item.getQuantity();
                }
            }
            if (this.plugin.getFarmingTeleportOverlay().treeRun.booleanValue()) {
                for (Item item : items) {
                    if (!this.isTreeSapling(item.getId())) continue;
                    totalSeeds += item.getQuantity();
                }
            }
            if (this.plugin.getFarmingTeleportOverlay().fruitTreeRun.booleanValue()) {
                for (Item item : items) {
                    if (!this.isFruitTreeSapling(item.getId())) continue;
                    totalSeeds += item.getQuantity();
                }
            }
            this.panelComponent.getChildren().clear();
            int yOffset = 0;
            ArrayList<AbstractMap.SimpleEntry<Integer, Integer>> missingItemsWithCounts = new ArrayList<AbstractMap.SimpleEntry<Integer, Integer>>();
            boolean allItemsCollected = true;
            for (Map.Entry<Integer, Integer> entry : itemsToCheck.entrySet()) {
                int toolLepCount;
                int n = entry.getKey();
                int count = entry.getValue();
                int inventoryCount = 0;
                if (this.plugin.getFarmingTeleportOverlay().herbRun.booleanValue()) {
                    if (n == 5291) {
                        inventoryCount = totalSeeds;
                    } else {
                        for (Item item : items) {
                            if (item == null || item.getId() != n) continue;
                            inventoryCount = item.getQuantity();
                            break;
                        }
                    }
                }
                if ((toolLepCount = this.checkToolLep(n).intValue()) > 0) {
                    inventoryCount += toolLepCount;
                }
                if (this.plugin.getFarmingTeleportOverlay().treeRun.booleanValue()) {
                    if (n == 5370) {
                        inventoryCount = totalSeeds;
                    } else {
                        for (Item item : items) {
                            if (item == null || item.getId() != n) continue;
                            inventoryCount = item.getQuantity();
                            break;
                        }
                    }
                }
                if (this.plugin.getFarmingTeleportOverlay().fruitTreeRun.booleanValue()) {
                    if (n == 5496) {
                        inventoryCount = totalSeeds;
                    } else {
                        for (Item item : items) {
                            if (item == null || item.getId() != n) continue;
                            inventoryCount = item.getQuantity();
                            break;
                        }
                    }
                }
                if (n == 6102) {
                    inventoryCount = teleportCrystalCount;
                } else {
                    for (Item item : items) {
                        if (item == null || item.getId() != n) continue;
                        inventoryCount = item.getQuantity();
                        break;
                    }
                }
                if (n == 11111) {
                    inventoryCount = skillsNecklaceCount;
                } else {
                    for (Item item : items) {
                        if (item == null || item.getId() != n) continue;
                        inventoryCount = item.getQuantity();
                        break;
                    }
                }
                for (Item item : items) {
                    if (item == null || item.getId() != n) continue;
                    inventoryCount = item.getQuantity();
                    break;
                }
                for (Item item : items) {
                    if (item == null || !RUNE_POUCH_ID.contains(item.getId()) || !runePouchContents.containsKey(n)) continue;
                    inventoryCount += runePouchContents.get(n).intValue();
                }
                for (Item item : items) {
                    if (item == null) continue;
                    int itemIdRune = item.getId();
                    int itemQuantity = item.getQuantity();
                    if (!COMBINATION_RUNE_SUBRUNES_MAP.containsKey(itemIdRune)) continue;
                    this.handleCombinationRunes(itemIdRune, itemQuantity, runePouchContents);
                }
                if (inventoryCount >= count) continue;
                allItemsCollected = false;
                int missingCount = count - inventoryCount;
                AsyncBufferedImage itemImage = this.itemManager.getImage(n);
                if (itemImage == null) continue;
                ImageComponent imageComponent = new ImageComponent((BufferedImage)itemImage);
                this.panelComponent.getChildren().add(imageComponent);
                missingItemsWithCounts.add(new AbstractMap.SimpleEntry<Integer, Integer>(n, missingCount));
                yOffset += itemImage.getHeight() + 2;
            }
            this.plugin.setTeleportOverlayActive(allItemsCollected);
            Dimension dimension = this.panelComponent.render(graphics);
            yOffset = 0;
            for (AbstractMap.SimpleEntry simpleEntry : missingItemsWithCounts) {
                int itemId = (Integer)simpleEntry.getKey();
                int missingCount = (Integer)simpleEntry.getValue();
                AsyncBufferedImage itemImage = this.itemManager.getImage(itemId);
                if (itemImage == null) continue;
                if (missingCount > 1) {
                    String countText = Integer.toString(missingCount);
                    int textX = 2;
                    int textY = yOffset + 15;
                    graphics.setColor(Color.WHITE);
                    graphics.drawString(countText, textX, textY);
                }
                yOffset += itemImage.getHeight() + 2;
            }
            if (missingItemsWithCounts.isEmpty()) {
                this.plugin.setItemsCollected(true);
            } else {
                this.plugin.setItemsCollected(false);
            }
            return dimension;
        }
        return null;
    }

    static {
        HashMap<Integer, List<Integer>> tempMap = new HashMap<Integer, List<Integer>>();
        tempMap.put(4696, Arrays.asList(556, 557));
        tempMap.put(4695, Arrays.asList(556, 555));
        tempMap.put(4698, Arrays.asList(555, 557));
        tempMap.put(4699, Arrays.asList(554, 557));
        tempMap.put(4694, Arrays.asList(554, 555));
        tempMap.put(4697, Arrays.asList(554, 556));
        COMBINATION_RUNE_SUBRUNES_MAP = Collections.unmodifiableMap(tempMap);
    }
}

