/*
 * Decompiled with CFR 0.152.
 */
package com.ingametimer;

import com.ingametimer.InGameTimerConfig;
import com.ingametimer.InGameTimerPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimerOverlay
extends OverlayPanel {
    private static final Logger log = LoggerFactory.getLogger(TimerOverlay.class);
    private final InGameTimerConfig config;
    private final InGameTimerPlugin plugin;
    private final LineComponent timeRemainingComponent;
    private long secondsElapsed;
    private long lastUpdate;
    private boolean loggedIn;
    private boolean timeUp;
    private boolean isPaused;
    public static OverlayMenuEntry PAUSE_ENTRY = new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, "Pause", "Timer");
    public static OverlayMenuEntry START_ENTRY = new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, "Start", "Timer");
    public static OverlayMenuEntry RESET_ENTRY = new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY, "Reset", "Timer");
    public static TitleComponent PAUSE_TITLE = TitleComponent.builder().color(Color.YELLOW).text("Timer Paused").build();
    public static TitleComponent START_TITLE = TitleComponent.builder().color(Color.GREEN).text("Timer Running").build();
    public static TitleComponent TIME_EXPIRED_TITLE = TitleComponent.builder().color(Color.RED).text("Time Expired").build();

    @Inject
    private TimerOverlay(InGameTimerConfig config, InGameTimerPlugin plugin) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.config = config;
        this.plugin = plugin;
        this.getMenuEntries().add(RESET_ENTRY);
        this.getMenuEntries().add(START_ENTRY);
        this.panelComponent.getChildren().add(PAUSE_TITLE);
        this.timeRemainingComponent = LineComponent.builder().left("Time Remaining:").right("").build();
        this.panelComponent.getChildren().add(this.timeRemainingComponent);
        this.secondsElapsed = this.getSecondsElapsed();
        this.lastUpdate = -1L;
        this.loggedIn = false;
        this.timeUp = false;
        this.isPaused = true;
        this.setClearChildren(false);
    }

    public Dimension render(Graphics2D graphics) {
        long timeRemaining;
        graphics.setFont(FontManager.getRunescapeFont());
        long now = Instant.now().getEpochSecond();
        if (this.loggedIn && !this.isPaused && now - this.lastUpdate >= 1L && !this.timeUp) {
            this.lastUpdate = now;
            ++this.secondsElapsed;
            if (this.secondsElapsed % 5L == 0L) {
                this.plugin.saveSecondsElapsed(this.secondsElapsed);
            }
        }
        if ((timeRemaining = (long)(this.config.countdown() * 60) - this.secondsElapsed) <= 0L && !this.timeUp) {
            this.timeUp();
        }
        Color timeColor = timeRemaining < 60L ? Color.RED : (timeRemaining < 300L ? Color.YELLOW : Color.WHITE);
        this.timeRemainingComponent.setRightColor(timeColor);
        this.timeRemainingComponent.setRight(TimerOverlay.formatTime(timeRemaining));
        return super.render(graphics);
    }

    public void reset() {
        this.secondsElapsed = 0L;
        this.timeUp = false;
        this.getMenuEntries().remove(START_ENTRY);
        this.getMenuEntries().remove(PAUSE_ENTRY);
        this.pauseTimer();
        this.timeRemainingComponent.setRight("");
    }

    public void pauseTimer() {
        this.isPaused = true;
        this.addOverlayEntry(START_ENTRY);
        this.updateOverlayTitle(PAUSE_TITLE);
    }

    public void resumeTimer() {
        if (this.timeUp) {
            this.reset();
        }
        this.isPaused = false;
        this.timeUp = false;
        this.lastUpdate = Instant.now().getEpochSecond();
        this.addOverlayEntry(PAUSE_ENTRY);
        this.updateOverlayTitle(START_TITLE);
    }

    private void timeUp() {
        this.addOverlayEntry(START_ENTRY);
        this.updateOverlayTitle(TIME_EXPIRED_TITLE);
        this.timeUp = true;
    }

    public void setLoggedIn(boolean isLoggedIn) {
        this.loggedIn = isLoggedIn;
    }

    private void updateOverlayTitle(TitleComponent title) {
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(title);
        this.panelComponent.getChildren().add(this.timeRemainingComponent);
    }

    private void addOverlayEntry(OverlayMenuEntry entry) {
        this.getMenuEntries().remove(PAUSE_ENTRY);
        this.getMenuEntries().remove(START_ENTRY);
        this.getMenuEntries().add(entry);
    }

    private long getSecondsElapsed() {
        String savedSeconds = this.plugin.getSavedSecondsElapsed();
        if (savedSeconds == null || savedSeconds.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(savedSeconds);
    }

    private static String formatTime(long remaining) {
        long hours = TimeUnit.SECONDS.toHours(remaining);
        long minutes = TimeUnit.SECONDS.toMinutes(remaining % 3600L);
        long seconds = remaining % 60L;
        if (remaining < 60L) {
            return String.format("%01ds", seconds);
        }
        if (remaining < 3600L) {
            return String.format("%2dm %02ds", minutes, seconds);
        }
        return String.format("%1dh %02dm", hours, minutes);
    }
}

