/*
 * Decompiled with CFR 0.152.
 */
package com.ingametimer;

import com.google.inject.Provides;
import com.ingametimer.InGameTimerConfig;
import com.ingametimer.TimerOverlay;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.OverlayMenuClicked;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="In Game Timer")
public class InGameTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InGameTimerPlugin.class);
    public static final String CONFIG_GROUP = "ingametimer";
    public static final String CONFIG_KEY_SECONDS_ELAPSED = "secondsElapsed";
    @Inject
    private Client client;
    @Inject
    private InGameTimerConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TimerOverlay timerOverlay;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.timerOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.timerOverlay);
    }

    public void saveSecondsElapsed(long secondsElapsed) {
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY_SECONDS_ELAPSED, (Object)secondsElapsed);
    }

    public String getSavedSecondsElapsed() {
        return this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY_SECONDS_ELAPSED);
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.timerOverlay.setLoggedIn(true);
        }
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.timerOverlay.setLoggedIn(false);
        }
    }

    @Subscribe
    public void onOverlayMenuClicked(OverlayMenuClicked event) {
        if (event.getEntry() == TimerOverlay.PAUSE_ENTRY) {
            this.timerOverlay.pauseTimer();
        }
        if (event.getEntry() == TimerOverlay.START_ENTRY) {
            this.timerOverlay.resumeTimer();
        }
        if (event.getEntry() == TimerOverlay.RESET_ENTRY) {
            this.timerOverlay.reset();
        }
    }

    @Provides
    InGameTimerConfig provideConfig(ConfigManager configManager) {
        return (InGameTimerConfig)configManager.getConfig(InGameTimerConfig.class);
    }
}

