/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.tithe;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tictac7x.tithe.TitheConfig;
import tictac7x.tithe.TitheOverlayInventory;
import tictac7x.tithe.TitheOverlayPatches;
import tictac7x.tithe.TitheOverlayPlants;
import tictac7x.tithe.TitheOverlayPoints;

@PluginDescriptor(name="Tithe Farm Improved", description="Improve overall experience for Tithe farm", tags={"tithe", "farm"}, conflicts={"Tithe Farm"})
public class TithePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TithePlugin.class);
    private String plugin_version = "v0.4";
    private String plugin_message = "<colHIGHLIGHT>Tithe Farm Improved " + this.plugin_version + ":<br><colHIGHLIGHT>* Updated points calculation based on new forumula";
    private static final int SEED_TABLE = 27430;
    private boolean in_tithe_farm = false;
    @Inject
    private TitheConfig config;
    @Inject
    private Client client;
    @Inject
    private ClientThread client_thread;
    @Inject
    private OverlayManager overlays;
    @Inject
    private ItemManager items;
    @Inject
    private ConfigManager configs;
    @Inject
    private ChatMessageManager chat_messages;
    private TitheOverlayPlants overlay_plants;
    private TitheOverlayPoints overlay_points;
    private TitheOverlayPatches overlay_patches;
    private TitheOverlayInventory overlay_inventory;

    @Provides
    TitheConfig provideConfig(ConfigManager configs) {
        return (TitheConfig)configs.getConfig(TitheConfig.class);
    }

    protected void startUp() {
        this.overlay_points = new TitheOverlayPoints(this, this.config, this.client);
        this.overlay_patches = new TitheOverlayPatches(this, this.config, this.client);
        this.overlay_plants = new TitheOverlayPlants(this, this.config);
        this.overlay_inventory = new TitheOverlayInventory(this, this.config);
        this.overlays.add((Overlay)this.overlay_points);
        this.overlays.add((Overlay)this.overlay_patches);
        this.overlays.add((Overlay)this.overlay_plants);
        this.overlays.add((Overlay)this.overlay_inventory);
        this.overlay_points.startUp();
    }

    protected void shutDown() {
        this.overlay_points.shutDown();
        this.overlays.remove((Overlay)this.overlay_points);
        this.overlays.remove((Overlay)this.overlay_patches);
        this.overlays.remove((Overlay)this.overlay_plants);
        this.overlays.remove((Overlay)this.overlay_inventory);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.overlay_plants.onGameObjectSpawned(event);
        if (event.getGameObject().getId() == 27430) {
            this.in_tithe_farm = true;
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        this.overlay_inventory.onItemContainerChanged(event);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.overlay_points.onVarbitChanged(event);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.overlay_plants.onGameTick();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        this.overlay_points.onWidgetLoaded(event);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.overlay_points.onConfigChanged(event);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN && !this.config.getVersion().equals(this.plugin_version)) {
            this.configs.setConfiguration("tictac7x-tithe", "version", this.plugin_version);
            this.chat_messages.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(this.plugin_message).build());
        }
        if (event.getGameState() == GameState.LOADING) {
            this.in_tithe_farm = false;
        }
    }

    public boolean inTitheFarm() {
        return this.in_tithe_farm;
    }

    public int fruitsInInventory() {
        return this.overlay_inventory.fruits_inventory;
    }
}

