/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.tithe;

import java.awt.Color;
import net.runelite.api.GameObject;
import net.runelite.api.TileObject;
import tictac7x.tithe.TitheConfig;

public class TithePlant {
    protected static final int TITHE_EMPTY_PATCH = 27383;
    protected static final int GOLOVANOVA_SEEDLING = 27384;
    protected static final int GOLOVANOVA_SEEDLING_WATERED = 27385;
    protected static final int GOLOVANOVA_SEEDLING_BLIGHTED = 27386;
    protected static final int GOLOVANOVA_PLANT_1 = 27387;
    protected static final int GOLOVANOVA_PLANT_1_WATERED = 27388;
    protected static final int GOLOVANOVA_PLANT_1_BLIGHTED = 27389;
    protected static final int GOLOVANOVA_PLANT_2 = 27390;
    protected static final int GOLOVANOVA_PLANT_2_WATERED = 27391;
    protected static final int GOLOVANOVA_PLANT_2_BLIGHTED = 27392;
    protected static final int GOLOVANOVA_GROWN = 27393;
    protected static final int GOLOVANOVA_GROWN_BLIGHTED = 27394;
    protected static final int BOLOGANO_SEEDLING = 27395;
    protected static final int BOLOGANO_SEEDLING_WATERED = 27396;
    protected static final int BOLOGANO_SEEDLING_BLIGHTED = 27397;
    protected static final int BOLOGANO_PLANT_1 = 27398;
    protected static final int BOLOGANO_PLANT_1_WATERED = 27399;
    protected static final int BOLOGANO_PLANT_1_BLIGHTED = 27400;
    protected static final int BOLOGANO_PLANT_2 = 27401;
    protected static final int BOLOGANO_PLANT_2_WATERED = 27402;
    protected static final int BOLOGANO_PLANT_2_BLIGHTED = 27403;
    protected static final int BOLOGANO_GROWN = 27404;
    protected static final int BOLOGANO_GROWN_BLIGHTED = 27405;
    protected static final int LOGAVANO_SEEDLING = 27406;
    protected static final int LOGAVANO_SEEDLING_WATERED = 27407;
    protected static final int LOGAVANO_SEEDLING_BLIGHTED = 27408;
    protected static final int LOGAVANO_PLANT_1 = 27409;
    protected static final int LOGAVANO_PLANT_1_WATERED = 27410;
    protected static final int LOGAVANO_PLANT_1_BLIGHTED = 27411;
    protected static final int LOGAVANO_PLANT_2 = 27412;
    protected static final int LOGAVANO_PLANT_2_WATERED = 27413;
    protected static final int LOGAVANO_PLANT_2_BLIGHTED = 27414;
    protected static final int LOGAVANO_GROWN = 27415;
    protected static final int LOGAVANO_GROWN_BLIGHTED = 27416;
    private final double DURATION_CYCLE_GAME_TICKS = 100.0;
    private final TitheConfig config;
    private GameObject game_object;
    public State state = State.SEEDLING_DRY;
    private int ticks = 0;

    public TithePlant(TitheConfig config, GameObject seedling) {
        this.config = config;
        this.game_object = seedling;
    }

    public GameObject getGameObject() {
        return this.game_object;
    }

    public void setGameObject(GameObject game_object) {
        if (!TithePlant.isPatch((TileObject)game_object)) {
            return;
        }
        this.game_object = game_object;
        switch (game_object.getId()) {
            case 27385: 
            case 27396: 
            case 27407: {
                this.state = State.SEEDLING_WATERED;
                return;
            }
            case 27387: 
            case 27398: 
            case 27409: {
                if (this.state != State.PLANT_1_DRY) {
                    this.ticks = 0;
                }
                this.state = State.PLANT_1_DRY;
                return;
            }
            case 27388: 
            case 27399: 
            case 27410: {
                this.state = State.PLANT_1_WATERED;
                return;
            }
            case 27390: 
            case 27401: 
            case 27412: {
                if (this.state != State.PLANT_2_DRY) {
                    this.ticks = 0;
                }
                this.state = State.PLANT_2_DRY;
                return;
            }
            case 27391: 
            case 27402: 
            case 27413: {
                this.state = State.PLANT_2_WATERED;
                return;
            }
            case 27393: 
            case 27404: 
            case 27415: {
                if (this.state != State.GROWN) {
                    this.ticks = 0;
                }
                this.state = State.GROWN;
                return;
            }
            case 27386: 
            case 27389: 
            case 27392: 
            case 27397: 
            case 27400: 
            case 27403: 
            case 27408: 
            case 27411: 
            case 27414: {
                if (this.state != State.BLIGHTED) {
                    this.ticks = 0;
                }
                this.state = State.BLIGHTED;
                return;
            }
        }
    }

    public void onGameTick() {
        ++this.ticks;
        if ((double)this.ticks != 100.0) {
            return;
        }
        this.ticks = 0;
        switch (this.state) {
            case SEEDLING_DRY: 
            case PLANT_1_DRY: 
            case PLANT_2_DRY: 
            case GROWN: {
                this.state = State.BLIGHTED;
                return;
            }
            case SEEDLING_WATERED: {
                this.state = State.PLANT_1_DRY;
                return;
            }
            case PLANT_1_WATERED: {
                this.state = State.PLANT_2_DRY;
                return;
            }
            case PLANT_2_WATERED: {
                this.state = State.GROWN;
                return;
            }
        }
    }

    public Color getCycleColor() {
        switch (this.state) {
            case SEEDLING_DRY: 
            case PLANT_1_DRY: 
            case PLANT_2_DRY: {
                return this.config.getPlantsDryColor();
            }
            case SEEDLING_WATERED: 
            case PLANT_1_WATERED: 
            case PLANT_2_WATERED: {
                return this.config.getPlantsWateredColor();
            }
            case GROWN: {
                return this.config.getPlantsGrownColor();
            }
            case BLIGHTED: {
                return this.config.getPlantsBlightedColor();
            }
        }
        return null;
    }

    public float getCycleProgress() {
        return -1.0f + (float)((double)this.ticks / 100.0);
    }

    public static boolean isSeedling(TileObject patch) {
        int id = patch.getId();
        return id == 27384 || id == 27395 || id == 27406;
    }

    public static boolean isDry(TileObject patch) {
        int id = patch.getId();
        return id == 27384 || id == 27387 || id == 27390 || id == 27395 || id == 27398 || id == 27401 || id == 27406 || id == 27409 || id == 27412;
    }

    public static boolean isWatered(TileObject patch) {
        int id = patch.getId();
        return id == 27385 || id == 27388 || id == 27391 || id == 27396 || id == 27399 || id == 27402 || id == 27407 || id == 27410 || id == 27413;
    }

    public static boolean isGrown(TileObject patch) {
        int id = patch.getId();
        return id == 27393 || id == 27404 || id == 27415;
    }

    public static boolean isBlighted(TileObject patch) {
        int id = patch.getId();
        return id == 27386 || id == 27389 || id == 27392 || id == 27394 || id == 27397 || id == 27400 || id == 27403 || id == 27405 || id == 27408 || id == 27411 || id == 27414 || id == 27416;
    }

    public static boolean isEmptyPatch(TileObject patch) {
        return patch.getId() == 27383;
    }

    public static boolean isPatch(TileObject patch) {
        return TithePlant.isDry(patch) || TithePlant.isWatered(patch) || TithePlant.isGrown(patch) || TithePlant.isBlighted(patch) || TithePlant.isEmptyPatch(patch);
    }

    public static enum State {
        SEEDLING_DRY,
        SEEDLING_WATERED,
        PLANT_1_DRY,
        PLANT_1_WATERED,
        PLANT_2_DRY,
        PLANT_2_WATERED,
        GROWN,
        BLIGHTED;

    }
}

