/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.tithe;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import tictac7x.tithe.TitheConfig;
import tictac7x.tithe.TithePlugin;

public class TitheOverlayPoints
extends OverlayPanel {
    private static final int TITHE_FARM_POINTS = 4893;
    private static final int TITHE_FARM_SACK = 4900;
    private final TithePlugin plugin;
    private final TitheConfig config;
    private final Client client;
    public int points_total = 0;
    public int fruits_sack = 0;

    public TitheOverlayPoints(TithePlugin plugin, TitheConfig config, Client client) {
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() != WidgetInfo.TITHE_FARM.getGroupId()) {
            return;
        }
        if (this.config.showCustomPoints()) {
            this.hideNativePoints();
        } else {
            this.showNativePoints();
        }
    }

    public void onConfigChanged(ConfigChanged event) {
        if (!(this.plugin.inTitheFarm() && event.getGroup().equals("tictac7x-tithe") && event.getKey().equals("points"))) {
            return;
        }
        this.checkWidget();
    }

    public void showNativePoints() {
        Widget widget_tithe = this.client.getWidget(WidgetInfo.TITHE_FARM);
        if (widget_tithe != null) {
            widget_tithe.setHidden(false);
        }
    }

    public void hideNativePoints() {
        Widget widget_tithe = this.client.getWidget(WidgetInfo.TITHE_FARM);
        if (widget_tithe != null) {
            widget_tithe.setHidden(true);
        }
    }

    public void startUp() {
        this.checkWidget();
    }

    public void shutDown() {
        this.showNativePoints();
    }

    private void checkWidget() {
        if (this.config.showCustomPoints()) {
            this.hideNativePoints();
        } else {
            this.showNativePoints();
        }
    }

    public void onVarbitChanged(VarbitChanged event) {
        switch (event.getVarbitId()) {
            case 4893: {
                this.points_total = event.getValue();
                return;
            }
            case 4900: {
                this.fruits_sack = event.getValue();
                return;
            }
        }
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.inTitheFarm() || !this.config.showCustomPoints()) {
            return null;
        }
        int fruits = this.plugin.fruitsInInventory();
        int points_earned = fruits / 3 + fruits / 100 * 2;
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(LineComponent.builder().left("Points:").leftColor(new Color(200, 200, 200)).right(this.points_total + (String)(points_earned > 0 ? " + " + points_earned : "")).rightColor(Color.green).build());
        return super.render(graphics);
    }
}

