/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.tithe;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.GameObject;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;
import tictac7x.tithe.TitheConfig;
import tictac7x.tithe.TithePlant;
import tictac7x.tithe.TithePlugin;

public class TitheOverlayPlants
extends OverlayPanel {
    private final TithePlugin plugin;
    private final TitheConfig config;
    public final Map<LocalPoint, TithePlant> plants = new HashMap<LocalPoint, TithePlant>();

    public TitheOverlayPlants(TithePlugin plugin, TitheConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
    }

    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (!this.plugin.inTitheFarm()) {
            return;
        }
        GameObject game_object = event.getGameObject();
        if (!TithePlant.isPatch((TileObject)game_object)) {
            return;
        }
        LocalPoint location_patch = game_object.getLocalLocation();
        if (game_object.getId() == 27383) {
            this.plants.remove(location_patch);
        } else if (this.plants.containsKey(location_patch)) {
            this.plants.get(location_patch).setGameObject(game_object);
        }
        if (TithePlant.isSeedling((TileObject)game_object)) {
            this.plants.put(location_patch, new TithePlant(this.config, game_object));
        }
    }

    public void onGameTick() {
        for (TithePlant plant : this.plants.values()) {
            plant.onGameTick();
        }
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.inTitheFarm()) {
            return null;
        }
        for (TithePlant plant : this.plants.values()) {
            this.renderPie(graphics, (TileObject)plant.getGameObject(), plant.getCycleColor(), plant.getCycleProgress());
        }
        return null;
    }

    private void renderPie(Graphics2D graphics, TileObject object, Color color, float progress) {
        if (color == null || color.getAlpha() == 0) {
            return;
        }
        try {
            ProgressPieComponent pie = new ProgressPieComponent();
            pie.setPosition(object.getCanvasLocation(0));
            pie.setProgress((double)(-progress));
            pie.setBorderColor(color.darker());
            pie.setFill(color);
            pie.render(graphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

