/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.tithe;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import tictac7x.tithe.TitheConfig;
import tictac7x.tithe.TithePlant;
import tictac7x.tithe.TithePlugin;

public class TitheOverlayPatches
extends OverlayPanel {
    private final Client client;
    private final TithePlugin plugin;
    private final TitheConfig config;

    public TitheOverlayPatches(TithePlugin plugin, TitheConfig config, Client client) {
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.inTitheFarm()) {
            MenuEntry[] menu_entries;
            for (MenuEntry menu_entry : menu_entries = this.client.getMenuEntries()) {
                TileObject object;
                MenuAction menu_option = menu_entry.getType();
                if (menu_option == MenuAction.CANCEL || menu_option == MenuAction.WALK || (object = this.findTileObject(this.client, menu_entry.getParam0(), menu_entry.getParam1(), menu_entry.getIdentifier())) == null || !TithePlant.isPatch(object)) continue;
                this.renderTile(graphics, object, this.config.getPatchesHighlightOnHoverColor());
                break;
            }
        }
        return null;
    }

    private TileObject findTileObject(Client client, int x, int y, int id) {
        try {
            Scene scene = client.getScene();
            Tile[][][] tiles = scene.getTiles();
            Tile tile = tiles[client.getPlane()][x][y];
            if (tile != null) {
                for (GameObject game_object : tile.getGameObjects()) {
                    if (game_object == null || game_object.getId() != id) continue;
                    return game_object;
                }
                WallObject wall_object = tile.getWallObject();
                if (wall_object != null && wall_object.getId() == id) {
                    return wall_object;
                }
                DecorativeObject decorative_object = tile.getDecorativeObject();
                if (decorative_object != null && decorative_object.getId() == id) {
                    return decorative_object;
                }
                GroundObject ground_object = tile.getGroundObject();
                if (ground_object != null && ground_object.getId() == id) {
                    return ground_object;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, TileObject object, Color color) {
        if (color == null || color.getAlpha() == 0) {
            return;
        }
        try {
            Polygon shape = object.getCanvasTilePoly();
            graphics.setColor(color.darker());
            graphics.setStroke(new BasicStroke(1.0f));
            graphics.draw(shape);
            graphics.setColor(color);
            graphics.fill(shape);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

