/*
 * Decompiled with CFR 0.152.
 */
package tictac7x.tithe;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="tictac7x-tithe")
public interface TitheConfig
extends Config {
    public static final String group = "tictac7x-tithe";
    public static final String version = "version";
    @ConfigSection(position=1, name="Farming patches", description="Highlight farming patches and show progress of plants")
    public static final String section_patches = "farming_patches";
    @ConfigSection(position=2, name="Inventory", description="Highlight items needed for the tithe farming in the inventory")
    public static final String section_inventory = "inventory";
    @ConfigSection(position=3, name="Points", description="Show custom information about tithe farm points")
    public static final String section_points = "points";
    public static final String points = "points";

    @ConfigItem(position=1, keyName="version", name="Version", description="Plugin version", hidden=true)
    default public String getVersion() {
        return "0";
    }

    @Alpha
    @ConfigItem(position=1, keyName="plants_dry", name="Dry plants", description="Highlight dry plants that need to be watered.", section="farming_patches")
    default public Color getPlantsDryColor() {
        return new Color(255, 180, 0, 100);
    }

    @Alpha
    @ConfigItem(position=2, keyName="plants_watered", name="Watered plants", description="Highlight watered plants", section="farming_patches")
    default public Color getPlantsWateredColor() {
        return new Color(60, 240, 255, 100);
    }

    @Alpha
    @ConfigItem(position=3, keyName="plants_grown", name="Grown plants", description="Highlight grown plants", section="farming_patches")
    default public Color getPlantsGrownColor() {
        return new Color(0, 255, 0, 100);
    }

    @Alpha
    @ConfigItem(position=4, keyName="plants_blighted", name="Blighted plants", description="Highlight blighted plants", section="farming_patches")
    default public Color getPlantsBlightedColor() {
        return new Color(200, 200, 200, 100);
    }

    @Alpha
    @ConfigItem(position=5, keyName="farm_patches_hover", name="Farm patches", description="Highlight farm patches on hover", section="farming_patches")
    default public Color getPatchesHighlightOnHoverColor() {
        return new Color(200, 200, 200, 60);
    }

    @Alpha
    @ConfigItem(position=1, keyName="seeds", name="Seeds", description="Highlight seeds", section="inventory")
    default public Color getHighlightSeedsColor() {
        return new Color(0, 255, 0, 80);
    }

    @Alpha
    @ConfigItem(position=1, keyName="watering_cans", name="Watering cans", description="Highlight watering cans", section="inventory")
    default public Color getHighlightWateringCanColor() {
        return new Color(60, 240, 255, 100);
    }

    @ConfigItem(position=1, keyName="points", name="Show custom points widget", description="Show total, earned points and harvested fruits.", section="points")
    default public boolean showCustomPoints() {
        return true;
    }
}

