/*
 * Decompiled with CFR 0.152.
 */
package com.creativetechguy;

import com.creativetechguy.CustomTextComponent;
import com.creativetechguy.TreeConfig;
import com.creativetechguy.TreeDespawnTimerConfig;
import com.creativetechguy.TreeDespawnTimerOverlay;
import com.creativetechguy.TreeState;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.coords.Angle;
import net.runelite.api.coords.Direction;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Tree Despawn Timer", description="Show an estimate of the remaining time until a tree is chopped down", configName="tree-despawn-timer")
public class TreeDespawnTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TreeDespawnTimerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private TreeDespawnTimerConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TreeDespawnTimerOverlay treeDespawnTimerOverlay;
    private int subTick = 0;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> subTickFuture;
    private final Pattern WOOD_CUT_PATTERN = Pattern.compile("You get (?:some|an)[\\w ]+(?:logs?|mushrooms)\\.");
    private final HashMap<WorldPoint, TreeState> treeAtLocation = new HashMap();
    protected HashSet<TreeState> uniqueTrees = new HashSet();
    private final HashMap<Player, TreeState> playerTreeChopping = new HashMap();
    private final HashMap<Player, Integer> newlySpawnedPlayers = new HashMap();
    private final HashMap<Player, WorldPoint> playerSpawnLocation = new HashMap();
    private final ArrayList<Runnable> deferTickQueue = new ArrayList();
    private final HashMap<Player, Integer> playerRecentlySpeced = new HashMap();
    private int nextGarbageCollect = 100;
    private int localPlayerRecentlyClimbedRedwood = 0;
    private int currentPlayerPlane = 0;
    private final int playerSpawnedTicksMax = 8;
    private final int playerSpecTicksMax = 8;

    @Provides
    TreeDespawnTimerConfig provideConfig(ConfigManager configManager) {
        return (TreeDespawnTimerConfig)configManager.getConfig(TreeDespawnTimerConfig.class);
    }

    protected void startUp() throws Exception {
        CustomTextComponent.updateFontSizes(this.config.uiSizeNormal(), this.config.uiSizePopular());
        this.overlayManager.add((Overlay)this.treeDespawnTimerOverlay);
        this.deferTickQueue.add(() -> this.client.getPlayers().forEach(player -> {
            this.onPlayerSpawned(new PlayerSpawned(player));
            this.handlePlayerChopping((Player)player);
        }));
        this.subTickFuture = this.executor.scheduleAtFixedRate(() -> this.subTick += 20, 0L, 20L, TimeUnit.MILLISECONDS);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.treeDespawnTimerOverlay);
        this.treeAtLocation.clear();
        this.uniqueTrees.clear();
        this.playerTreeChopping.clear();
        this.newlySpawnedPlayers.clear();
        this.playerSpawnLocation.clear();
        this.deferTickQueue.clear();
        this.subTickFuture.cancel(false);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("tree-despawn-timer")) {
            return;
        }
        if (event.getKey().equals("uiSizeNormal") || event.getKey().equals("uiSizePopular")) {
            CustomTextComponent.updateFontSizes(this.config.uiSizeNormal(), this.config.uiSizePopular());
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.HOPPING || event.getGameState() == GameState.LOGGING_IN) {
            this.treeAtLocation.clear();
            this.uniqueTrees.clear();
            this.playerTreeChopping.clear();
            this.newlySpawnedPlayers.clear();
            this.deferTickQueue.clear();
            this.localPlayerRecentlyClimbedRedwood = 8;
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.computePlayerPlaneChange();
        if (this.localPlayerRecentlyClimbedRedwood > 0) {
            --this.localPlayerRecentlyClimbedRedwood;
        }
        this.deferTickQueue.forEach(Runnable::run);
        this.deferTickQueue.clear();
        this.uniqueTrees.forEach(TreeState::tick);
        --this.nextGarbageCollect;
        if (this.nextGarbageCollect <= 0) {
            ArrayList<TreeState> toDelete = new ArrayList<TreeState>();
            this.nextGarbageCollect = 25;
            this.uniqueTrees.forEach(entry -> {
                if (entry.worldPoint.distanceTo(this.client.getLocalPlayer().getWorldLocation()) > 150 && !entry.shouldShowTimer() || entry.getTimeTicks() == 0 && entry.playersChopping.size() == 0) {
                    toDelete.add((TreeState)entry);
                }
            });
            toDelete.forEach(this::deleteTree);
        }
        this.newlySpawnedPlayers.entrySet().removeIf(p -> {
            p.setValue((Integer)p.getValue() - 1);
            if ((Integer)p.getValue() <= 0) {
                this.playerSpawnLocation.remove(p.getKey());
            }
            return (Integer)p.getValue() <= 0;
        });
        this.playerRecentlySpeced.entrySet().removeIf(p -> {
            p.setValue((Integer)p.getValue() - 1);
            return (Integer)p.getValue() <= 0;
        });
        this.subTick = 0;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        if (TreeConfig.isTree(gameObject)) {
            TreeState treeState = new TreeState(gameObject, this.client, this.config);
            if (this.treeAtLocation.containsKey(gameObject.getWorldLocation())) {
                return;
            }
            treeState.points.forEach(point -> this.treeAtLocation.put((WorldPoint)point, treeState));
            this.uniqueTrees.add(treeState);
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject gameObject = event.getGameObject();
        if (!TreeConfig.isTree(gameObject)) {
            return;
        }
        TreeState treeState = this.treeAtLocation.get(gameObject.getWorldLocation());
        if (treeState == null) {
            return;
        }
        this.deleteTree(treeState);
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor() instanceof Player) {
            Player player = (Player)event.getActor();
            this.deferTickQueue.add(() -> this.handlePlayerChopping(player));
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        this.deferTickQueue.add(() -> this.handlePlayerChopping(this.client.getLocalPlayer()));
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned event) {
        Player player = event.getPlayer();
        if (player.equals(this.client.getLocalPlayer())) {
            return;
        }
        this.newlySpawnedPlayers.put(player, 8);
        this.playerSpawnLocation.put(player, player.getWorldLocation());
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned event) {
        Player player = event.getPlayer();
        if (this.playerTreeChopping.containsKey(player)) {
            TreeState treeState = this.playerTreeChopping.get(player);
            if (treeState.treeName.equals(TreeConfig.REDWOOD.name())) {
                this.computePlayerPlaneChange();
            }
            if (!treeState.treeName.equals(TreeConfig.REDWOOD.name()) || this.hasLocalPlayerRecentlyClimbedRedwood()) {
                treeState.hasUnrenderedPlayersChopping = true;
            }
            treeState.playersChopping.remove(player);
            this.playerTreeChopping.remove(player);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        TreeState interactingTree;
        if (event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (this.WOOD_CUT_PATTERN.matcher(event.getMessage()).matches() && (interactingTree = this.playerTreeChopping.get(this.client.getLocalPlayer())) != null) {
            interactingTree.haveYouChoppedLog = true;
        }
    }

    void handlePlayerChopping(Player player) {
        if (this.hasMoved(player)) {
            this.newlySpawnedPlayers.remove(player);
            this.playerSpawnLocation.remove(player);
        }
        boolean isNewPlayer = this.newlySpawnedPlayers.containsKey(player);
        if (this.playerTreeChopping.containsKey(player)) {
            TreeState treeState = this.playerTreeChopping.get(player);
            treeState.playersChopping.remove(player);
            if (player.equals(this.client.getLocalPlayer())) {
                treeState.haveYouChoppedLog = false;
            }
            this.playerTreeChopping.remove(player);
        }
        if (this.isWoodcutting(player)) {
            TreeState interactingTree = this.findClosetFacingTree(player);
            if (interactingTree == null) {
                return;
            }
            if (isNewPlayer && !interactingTree.hasUnrenderedPlayersChopping && interactingTree.playersChopping.isEmpty()) {
                if (interactingTree.treeName.equals(TreeConfig.REDWOOD.name())) {
                    if (this.hasLocalPlayerRecentlyClimbedRedwood()) {
                        interactingTree.hideTree = true;
                    }
                } else {
                    interactingTree.hideTree = true;
                }
            }
            interactingTree.playersChopping.add(player);
            this.playerTreeChopping.put(player, interactingTree);
        }
    }

    void deleteTree(TreeState treeState) {
        treeState.playersChopping.forEach(this.playerTreeChopping::remove);
        treeState.points.forEach(this.treeAtLocation::remove);
        this.uniqueTrees.remove(treeState);
    }

    void computePlayerPlaneChange() {
        int newPlane = this.client.getLocalPlayer().getWorldLocation().getPlane();
        if (newPlane != this.currentPlayerPlane) {
            this.currentPlayerPlane = newPlane;
            this.localPlayerRecentlyClimbedRedwood = 8;
        }
    }

    boolean hasLocalPlayerRecentlyClimbedRedwood() {
        return this.localPlayerRecentlyClimbedRedwood > 0;
    }

    @Nullable
    TreeState findClosetFacingTree(Player player) {
        WorldPoint actorLocation = player.getWorldLocation();
        Direction direction = new Angle(player.getOrientation()).getNearestDirection();
        WorldPoint facingPoint = this.neighborPoint(actorLocation, direction);
        return this.treeAtLocation.get(facingPoint);
    }

    private WorldPoint neighborPoint(WorldPoint point, Direction direction) {
        switch (direction) {
            case NORTH: {
                return point.dy(1);
            }
            case SOUTH: {
                return point.dy(-1);
            }
            case EAST: {
                return point.dx(1);
            }
            case WEST: {
                return point.dx(-1);
            }
        }
        throw new IllegalStateException();
    }

    private boolean isWoodcutting(Player player) {
        if (this.playerRecentlySpeced.containsKey(player)) {
            return true;
        }
        switch (player.getAnimation()) {
            case 24: 
            case 867: 
            case 869: 
            case 871: 
            case 873: 
            case 875: 
            case 877: 
            case 879: 
            case 2117: 
            case 2846: 
            case 7264: 
            case 8303: 
            case 8324: 
            case 8778: 
            case 10064: 
            case 10065: 
            case 10066: 
            case 10067: 
            case 10068: 
            case 10069: 
            case 10070: 
            case 10071: 
            case 10072: 
            case 10074: {
                return true;
            }
            case 2876: {
                this.playerRecentlySpeced.put(player, 8);
                return true;
            }
        }
        return false;
    }

    private boolean hasMoved(Player player) {
        WorldPoint spawnLocation = this.playerSpawnLocation.get(player);
        if (spawnLocation == null) {
            return false;
        }
        return !player.getWorldLocation().equals((Object)spawnLocation);
    }

    public int getSubTick() {
        return this.subTick;
    }
}

