/*
 * Decompiled with CFR 0.152.
 */
package com.creativetechguy;

import com.creativetechguy.CustomTextComponent;
import com.creativetechguy.TimerTypes;
import com.creativetechguy.TreeDespawnTimerConfig;
import com.creativetechguy.TreeDespawnTimerPlugin;
import com.creativetechguy.TreeState;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;

public class TreeDespawnTimerOverlay
extends Overlay {
    private final TreeDespawnTimerPlugin plugin;
    private final TreeDespawnTimerConfig config;
    private final Client client;

    @Inject
    private TreeDespawnTimerOverlay(TreeDespawnTimerPlugin plugin, TreeDespawnTimerConfig config, Client client) {
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public Dimension render(Graphics2D graphics) {
        for (TreeState treeState : this.plugin.uniqueTrees) {
            boolean isPopularTree;
            LocalPoint centeredPoint;
            Point point;
            LocalPoint lp;
            if (!treeState.shouldShowTimer() || (lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)treeState.worldPoint)) == null || (point = Perspective.localToCanvas((Client)this.client, (LocalPoint)(centeredPoint = new LocalPoint(lp.getX() + treeState.centerOffset.getX(), lp.getY() + treeState.centerOffset.getY())), (int)this.client.getPlane())) == null) continue;
            boolean bl = isPopularTree = this.config.highlightPopularTrees() && treeState.playersChopping.size() >= 10 && treeState.canShowPopularIndicator();
            if (this.config.timerType() == TimerTypes.PIE) {
                ProgressPieComponent pie = new ProgressPieComponent();
                pie.setPosition(point);
                pie.setBorderColor(treeState.getTimerColor());
                pie.setDiameter(this.config.uiSizeNormal());
                if (isPopularTree) {
                    pie.setBorder(Color.BLACK, 2);
                    pie.setDiameter(this.config.uiSizePopular());
                }
                pie.setFill(treeState.getTimerColor());
                pie.setProgress((double)treeState.getTimePercent().floatValue());
                pie.render(graphics);
                continue;
            }
            if (this.config.timerType() == TimerTypes.TICKS) {
                String text = treeState.getTimeTicks().toString();
                CustomTextComponent textComponent = new CustomTextComponent(text, new java.awt.Point(point.getX(), point.getY()));
                if (isPopularTree) {
                    textComponent.setEmphasize(true);
                }
                textComponent.setColor(treeState.getTimerColor());
                textComponent.render(graphics);
                continue;
            }
            if (this.config.timerType() != TimerTypes.SECONDS) continue;
            Duration duration = Duration.ofSeconds(treeState.getTimeSeconds(this.plugin.getSubTick()).intValue());
            String text = String.format("%d:%02d", duration.toMinutesPart(), duration.toSecondsPart());
            CustomTextComponent textComponent = new CustomTextComponent(text, new java.awt.Point(point.getX(), point.getY()));
            if (isPopularTree) {
                textComponent.setEmphasize(true);
            }
            textComponent.setColor(treeState.getTimerColor());
            textComponent.render(graphics);
        }
        return null;
    }
}

