/*
 * Decompiled with CFR 0.152.
 */
package com.morefireworks;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.morefireworks.MoreFireworksConfig;
import java.util.Random;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="More Fireworks")
public class MoreFireworksPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MoreFireworksPlugin.class);
    @Inject
    private Client client;
    @Inject
    ItemManager itemManager;
    @Inject
    private MoreFireworksConfig config;
    Integer[] fireWorks = new Integer[]{199, 1388, 1389};
    private static final Set<Integer> LAST_MAN_STANDING_REGIONS = ImmutableSet.of((Object)13658, (Object)13659, (Object)13914, (Object)13915, (Object)13916);

    protected void startUp() throws Exception {
        log.info("Fireworks lit!");
    }

    protected void shutDown() throws Exception {
        log.info("Fireworks were duds!");
    }

    @Subscribe(priority=4.0f)
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (event.getOverheadText().toLowerCase().contains("gz") || event.getOverheadText().toLowerCase().contains("@@@") || event.getOverheadText().toLowerCase().contains(this.config.custom().toLowerCase())) {
            event.getActor().setGraphic(this.fireWorks[new Random().nextInt(this.fireWorks.length)].intValue());
            event.getActor().setSpotAnimFrame(0);
        }
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        for (ItemStack items : npcLootReceived.getItems()) {
            if (this.itemManager.getItemPrice(items.getId()) < this.config.loot() || this.config.loot() == 0) continue;
            this.client.getLocalPlayer().setGraphic(this.fireWorks[new Random().nextInt(this.fireWorks.length)].intValue());
            this.client.getLocalPlayer().setSpotAnimFrame(0);
        }
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        if (this.isPlayerWithinMapRegion(LAST_MAN_STANDING_REGIONS)) {
            return;
        }
        for (ItemStack items : playerLootReceived.getItems()) {
            if (this.itemManager.getItemPrice(items.getId()) < this.config.loot() || this.config.loot() == 0) continue;
            this.client.getLocalPlayer().setGraphic(this.fireWorks[new Random().nextInt(this.fireWorks.length)].intValue());
            this.client.getLocalPlayer().setSpotAnimFrame(0);
        }
    }

    private boolean isPlayerWithinMapRegion(Set<Integer> definedMapRegions) {
        int[] mapRegions;
        for (int region : mapRegions = this.client.getMapRegions()) {
            if (!definedMapRegions.contains(region)) continue;
            return true;
        }
        return false;
    }

    @Provides
    MoreFireworksConfig provideConfig(ConfigManager configManager) {
        return (MoreFireworksConfig)configManager.getConfig(MoreFireworksConfig.class);
    }
}

