/*
 * Decompiled with CFR 0.152.
 */
package com.skeldoor.cool2h;

import java.util.stream.IntStream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.kit.KitType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Cool 2h", description="Fix your posture and look cooler while using two-handed weapons")
public class Cool2hPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(Cool2hPlugin.class);
    @Inject
    private Client client;
    int[] rune2hItemId = new int[]{1307, 1309, 1311, 1313, 1315, 1317, 1319, 6609, 7158, 20155};
    int superCool2hAnimationIdIdle = 7053;
    int superCool2hAnimationIdIdleRotateLeft = 7044;
    int superCool2hAnimationIdIdleRotateRight = 7044;
    int superCool2hAnimationIdWalking = 7052;
    int superCool2hAnimationIdWalkingRotate180 = 7052;
    int superCool2hAnimationIdWalkingRotateLeft = 7048;
    int superCool2hAnimationIdWalkingRotateRight = 7047;
    int superCool2hAnimationIdRunning = 7043;

    @Subscribe(priority=-1000.0f)
    public void onBeforeRender(BeforeRender e) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        Player local = this.client.getLocalPlayer();
        if (local == null) {
            return;
        }
        PlayerComposition localComp = local.getPlayerComposition();
        if (localComp == null) {
            return;
        }
        int weaponId = localComp.getEquipmentId(KitType.WEAPON);
        if (IntStream.of(this.rune2hItemId).anyMatch(x -> x == weaponId)) {
            this.swapPlayerAnimation(local);
        }
    }

    private void swapPlayerAnimation(Player local) {
        local.setIdlePoseAnimation(this.superCool2hAnimationIdIdle);
        local.setIdleRotateLeft(this.superCool2hAnimationIdIdleRotateLeft);
        local.setIdleRotateRight(this.superCool2hAnimationIdIdleRotateRight);
        local.setWalkAnimation(this.superCool2hAnimationIdWalking);
        local.setWalkRotate180(this.superCool2hAnimationIdWalkingRotate180);
        local.setWalkRotateLeft(this.superCool2hAnimationIdWalkingRotateLeft);
        local.setWalkRotateRight(this.superCool2hAnimationIdWalkingRotateRight);
        local.setRunAnimation(this.superCool2hAnimationIdRunning);
    }
}

