/*
 * Decompiled with CFR 0.152.
 */
package com.tuna.toa;

import com.google.inject.Provides;
import com.tuna.toa.ToANpc;
import com.tuna.toa.ToAPointsConfig;
import com.tuna.toa.ToAPointsOverlay;
import com.tuna.toa.ToARegion;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Hitsplat;
import net.runelite.api.NPC;
import net.runelite.api.TileItem;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ToA Points Overlay")
public class ToAPointsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ToAPointsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ToAPointsOverlay overlay;
    @Inject
    private ToAPointsConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    public static double totalPoints = 5000.0;
    public static double roomPoints = 0.0;
    public static int invocationLevel = 0;
    public static int partySize = 0;
    boolean inRaid = false;
    private ToARegion currentRegion = null;

    public static int getInvocationLevel() {
        return invocationLevel;
    }

    @Provides
    ToAPointsConfig provideConfig(ConfigManager configManager) {
        return (ToAPointsConfig)configManager.getConfig(ToAPointsConfig.class);
    }

    public static double getTotalPoints() {
        return totalPoints;
    }

    public static double getRoomPoints() {
        return roomPoints;
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.reset();
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        Actor target = hitsplatApplied.getActor();
        Hitsplat hitsplat = hitsplatApplied.getHitsplat();
        if (!(hitsplat.isMine() || hitsplat.isOthers() || target.getName().equals("Kephri") || hitsplat.getHitsplatType() != 53 && hitsplat.getHitsplatType() != 55 && hitsplat.getHitsplatType() != 11)) {
            NPC npc = (NPC)target;
            List teamMembers = this.client.getPlayers();
            int averageHitSplat = hitsplat.getAmount() / teamMembers.size();
            roomPoints += (double)(averageHitSplat *= 2);
            if (hitsplat.getHitsplatType() == 11 && roomPoints >= 10000.0) {
                roomPoints = 10000.0;
            }
        } else if (hitsplat.isMine() && target != this.client.getLocalPlayer()) {
            NPC npc = (NPC)target;
            this.pointCalc(hitsplat, npc);
        }
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        LocalPoint lp = this.client.getLocalPlayer().getLocalLocation();
        int newRegionID = lp == null ? -1 : WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)lp).getRegionID();
        ToARegion newRegion = ToARegion.fromRegionID(newRegionID);
        if (newRegion != null && newRegion != ToARegion.TOA_LOBBY) {
            this.inRaid = true;
            this.overlayManager.add((Overlay)this.overlay);
            Widget invoWidget = this.client.getWidget(31522858);
            if (invoWidget != null) {
                String invoLevel = invoWidget.getText();
                invocationLevel = Integer.parseInt(invoLevel.replaceAll("[^0-9]", ""));
            }
        } else {
            this.inRaid = false;
            this.overlayManager.remove((Overlay)this.overlay);
        }
        if (newRegion != this.currentRegion && this.inRaid) {
            if (this.config.puzzlePointsAssumption()) {
                switch (newRegion) {
                    case BOSS_BABA: {
                        totalPoints += 450.0;
                        break;
                    }
                    case BOSS_KEPHRI: {
                        totalPoints += 300.0;
                    }
                }
            }
            if (this.config.mvpAssumption()) {
                this.mvpAssumption(this.currentRegion, newRegion);
            }
            this.currentRegion = newRegion;
            if (this.currentRegion != null) {
                totalPoints += roomPoints;
                roomPoints = 0.0;
                if (totalPoints > 64000.0) {
                    totalPoints = 64000.0;
                }
            }
        }
        this.currentRegion = newRegion;
    }

    public void mvpAssumption(ToARegion leftRegion, ToARegion enteredRegion) {
        if (leftRegion != null) {
            switch (leftRegion) {
                case PUZZLE_MONKEY: {
                    if (enteredRegion == ToARegion.BOSS_BABA) {
                        totalPoints += 300.0;
                    }
                }
                case PUZZLE_CRONDIS: {
                    if (enteredRegion == ToARegion.BOSS_ZEBAK) {
                        totalPoints += 300.0;
                    }
                }
                case PUZZLE_SCABARAS: {
                    if (enteredRegion == ToARegion.BOSS_KEPHRI) {
                        totalPoints += 300.0;
                    }
                }
                case PUZZLE_HET: {
                    if (enteredRegion == ToARegion.BOSS_AKKHA) {
                        totalPoints += 300.0;
                    }
                }
                case BOSS_WARDEN_FINAL: {
                    if (enteredRegion != ToARegion.CHEST_ROOM) break;
                    totalPoints += 300.0;
                }
            }
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        List teamMembers = this.client.getPlayers();
        if (item.getId() == 27221 && this.currentRegion == ToARegion.BOSS_BABA) {
            totalPoints += (double)(300 * teamMembers.size());
        } else if (item.getId() == 27223 && this.currentRegion == ToARegion.BOSS_AKKHA) {
            totalPoints += (double)(300 * teamMembers.size());
        } else if (item.getId() == 27219 && this.currentRegion == ToARegion.BOSS_ZEBAK) {
            totalPoints += (double)(300 * teamMembers.size());
        } else if (item.getId() == 27214 && this.currentRegion == ToARegion.BOSS_KEPHRI) {
            totalPoints += (double)(300 * teamMembers.size());
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        if (actorDeath.getActor() == this.client.getLocalPlayer()) {
            totalPoints += roomPoints;
            roomPoints = 0.0;
            double pointLoss = totalPoints * 20.0;
            if ((pointLoss /= 100.0) < 1000.0) {
                pointLoss = 1000.0;
            }
            totalPoints = totalPoints < 1000.0 ? 0.0 : (totalPoints -= pointLoss);
        }
    }

    public void pointCalc(Hitsplat hitsplat, NPC target) {
        double modHit = 0.0;
        double modifier = 0.0;
        int rawHit = hitsplat.getAmount();
        ToANpc currentTarget = ToANpc.fromNpcID(target.getId());
        if (currentTarget == null) {
            modifier = 1.0;
        } else {
            switch (currentTarget) {
                case BABOON_BRAWLER: 
                case BABOON_THROWER: 
                case BABOON_MAGE: 
                case BABOON_SHAMAN: 
                case BABOON_THRALL: 
                case BABOON_CURSED: 
                case BABOON_VOLATILE: {
                    modifier = 1.2;
                    break;
                }
                case BABA: 
                case WARDEN_TUMEKEN_RANGE: 
                case WARDEN_TUMEKEN_MAGE: 
                case WARDEN_ELIDINIS_MAGE: 
                case WARDEN_ELIDINIS_RANGE: {
                    modifier = 2.0;
                    break;
                }
                case BOULDER: {
                    modifier = 0.0;
                    break;
                }
                case HET_OBELISK: 
                case WARDEN_TUMEKEN_FINAL: 
                case WARDEN_ELIDINIS_FINAL: {
                    modifier = 2.5;
                    break;
                }
                case ZEBAK: 
                case ZEBAK_ENRAGED: 
                case WARDEN_OBELISK: {
                    modifier = 1.5;
                    break;
                }
                case SCARAB_ARCANE: 
                case SCARAB_SPITTING: 
                case SCARAB_SOLDIER: {
                    modifier = 0.5;
                    break;
                }
                case WARDEN_ELIDINIS_INACTIVE_P1: 
                case WARDEN_ELIDINIS_INACTIVE_P2: 
                case WARDEN_ELIDINIS_INACTIVE_P3: 
                case WARDEN_TUMEKEN_INACTIVE_P1: 
                case WARDEN_TUMEKEN_INACTIVE_P2: 
                case WARDEN_TUMEKEN_INACTIVE_P3: 
                case WARDEN_CORE_TUMEKEN: 
                case WARDEN_CORE_ELIDINIS: {
                    modifier = 0.0;
                    break;
                }
                default: {
                    modifier = 1.0;
                }
            }
        }
        modHit = (double)rawHit * modifier;
        roomPoints += modHit;
        if (roomPoints > 20000.0) {
            roomPoints = 20000.0;
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer() != null && !this.inRaid) {
            this.reset();
        }
    }

    public void reset() {
        roomPoints = 0.0;
        this.currentRegion = null;
        totalPoints = 5000.0;
        this.inRaid = false;
    }
}

