/*
 * Decompiled with CFR 0.152.
 */
package com.tuna.toa;

import com.tuna.toa.ToAPointsConfig;
import com.tuna.toa.ToAPointsPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class ToAPointsOverlay
extends OverlayPanel {
    private static final DecimalFormat POINTS_FORMAT = new DecimalFormat("#,###");
    private Client client;
    private ToAPointsPlugin plugin;
    private ToAPointsConfig config;
    private double uniqueChance;
    private double petChance;

    @Inject
    private ToAPointsOverlay(Client client, ToAPointsPlugin plugin, ToAPointsConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.setPriority(OverlayPriority.HIGH);
    }

    public Dimension render(Graphics2D graphics) {
        double totalPoints = ToAPointsPlugin.getTotalPoints();
        double roomPoints = ToAPointsPlugin.getRoomPoints();
        if (totalPoints >= 5000.0) {
            totalPoints -= 5000.0;
        }
        this.panelComponent.getChildren().add(TitleComponent.builder().text("ToA Point Tracker").build());
        this.panelComponent.getChildren().add(LineComponent.builder().left("Total:").right(POINTS_FORMAT.format(totalPoints)).build());
        if (this.config.roomPoints()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Room Points:").right(POINTS_FORMAT.format(roomPoints)).build());
        }
        if (this.config.raidsUniqueChance()) {
            int invocationLevel;
            if (totalPoints < 1500.0) {
                this.uniqueChance = 0.0;
                this.petChance = 0.0;
            }
            if ((invocationLevel = ToAPointsPlugin.getInvocationLevel()) > 550) {
                invocationLevel = 550;
            }
            int invocationMod = 0;
            int petInvocationMod = 0;
            if (invocationLevel < 150) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Unique:").right("Very low").build());
            } else {
                if (invocationLevel > 400) {
                    int invocOver = invocationLevel - 400;
                    int expertInvocationLevel = 400 + (invocOver /= 3);
                    invocationMod = expertInvocationLevel * 20;
                    petInvocationMod = expertInvocationLevel * 700;
                } else {
                    invocationMod = invocationLevel * 20;
                    petInvocationMod = invocationLevel * 700;
                }
                int perOnePercentChance = 10500 - invocationMod;
                double petOnePercentChance = 350000 - petInvocationMod;
                this.uniqueChance = (totalPoints += roomPoints) / (double)perOnePercentChance;
                this.petChance = totalPoints / petOnePercentChance;
                this.panelComponent.getChildren().add(LineComponent.builder().left("Unique:").right(String.valueOf((double)Math.round(this.uniqueChance * 100.0) / 100.0) + "%").build());
                if (this.config.petChance()) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left("Pet Chance:").right(String.valueOf((double)Math.round(this.petChance * 100.0) / 100.0) + "%").build());
                }
            }
        }
        return super.render(graphics);
    }
}

