/*
 * Decompiled with CFR 0.152.
 */
package com.imbuedheartnotifier;

import com.google.inject.Provides;
import com.imbuedheartnotifier.ImbuedHeartNotifierConfig;
import com.imbuedheartnotifier.ImbuedHeartNotifierOverlay;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Imbued Heart Notifier")
public class ImbuedHeartNotifierPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ImbuedHeartNotifierPlugin.class);
    public static final int SATURATED_HEART_ITEM_ID = 27641;
    private static final Pattern IMBUED_HEART_READY_MESSAGE = Pattern.compile("<col=.{6}>Your (saturated|imbued) heart has regained its magical power.</col>");
    private static final Pattern IMBUED_HEART_BUSY_MESSAGE = Pattern.compile("The heart is still drained of its power. Judging by how it feels, it will be ready in around (\\d) minutes\\.");
    private static final int invigorateDuration = 700;
    private static final int saturatedDuration = 500;
    @Inject
    private Client client;
    @Inject
    private ImbuedHeartNotifierConfig config;
    @Inject
    private ImbuedHeartNotifierOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Notifier notifier;
    private int invigorateTick;
    private int remainingDuration;

    protected void startUp() throws Exception {
        this.invigorateTick = -1;
        this.remainingDuration = 0;
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.invigorateTick = -1;
        this.remainingDuration = 0;
    }

    public boolean isHeartActive() {
        return this.invigorateTick > 0;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        Matcher heartBusy;
        String message = event.getMessage();
        Matcher heartReady = IMBUED_HEART_READY_MESSAGE.matcher(message);
        if (heartReady.find()) {
            this.invigorateTick = -1;
            this.remainingDuration = 0;
            this.notifyUser();
        }
        if ((heartBusy = IMBUED_HEART_BUSY_MESSAGE.matcher(message)).find()) {
            this.remainingDuration = (int)((double)(Integer.parseInt(heartBusy.group(1)) * 60) / 0.6);
            this.invigorateTick = this.client.getTickCount();
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuOption().contains("Invigorate")) {
            log.debug("Invigorate option clicked");
            this.invigorateTick = this.client.getTickCount();
            ItemContainer playerInventory = this.client.getItemContainer(InventoryID.INVENTORY);
            this.remainingDuration = playerInventory != null && playerInventory.contains(27641) ? 500 : 700;
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.invigorateTick > 0 && this.client.getTickCount() > this.invigorateTick + this.remainingDuration) {
            this.invigorateTick = -1;
            this.remainingDuration = 0;
            this.notifyUser();
        }
    }

    @Provides
    ImbuedHeartNotifierConfig provideConfig(ConfigManager configManager) {
        return (ImbuedHeartNotifierConfig)configManager.getConfig(ImbuedHeartNotifierConfig.class);
    }

    private void notifyUser() {
        ItemContainer playerInventory;
        if (this.config.enableNotifier() && (playerInventory = this.client.getItemContainer(InventoryID.INVENTORY)) != null && (playerInventory.contains(20724) || playerInventory.contains(27641))) {
            this.notifier.notify("Your imbued heart can be used again");
        }
    }
}

