/*
 * Decompiled with CFR 0.152.
 */
package com.imbuedheartnotifier;

import com.imbuedheartnotifier.ImbuedHeartNotifierConfig;
import com.imbuedheartnotifier.ImbuedHeartNotifierPlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;

public class ImbuedHeartNotifierOverlay
extends WidgetItemOverlay {
    private final ItemManager itemManager;
    private final ImbuedHeartNotifierPlugin plugin;
    private final ImbuedHeartNotifierConfig config;

    @Inject
    private ImbuedHeartNotifierOverlay(ItemManager itemManager, ImbuedHeartNotifierPlugin plugin, ImbuedHeartNotifierConfig config) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.showOnInventory();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        Color color;
        if (!(itemId != 20724 && itemId != 27641 || this.plugin.isHeartActive() || (color = this.config.getHighlightColor()) == null)) {
            Rectangle bounds = itemWidget.getCanvasBounds();
            if (this.config.outlineHeart()) {
                BufferedImage outline = this.itemManager.getItemOutline(itemId, itemWidget.getQuantity(), color);
                graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
            }
            if (this.config.fillHeart()) {
                Color fillColor = ColorUtil.colorWithAlpha((Color)color, (int)this.config.getFillHeartOpacity());
                BufferedImage image = ImageUtil.fillImage((BufferedImage)this.itemManager.getImage(itemId, itemWidget.getQuantity(), false), (Color)fillColor);
                graphics.drawImage((Image)image, (int)bounds.getX(), (int)bounds.getY(), null);
            }
        }
    }
}

