/*
 * Decompiled with CFR 0.152.
 */
package info.sigterm.plugins.deathindicator;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import info.sigterm.plugins.deathindicator.DeathIndicatorConfig;
import info.sigterm.plugins.deathindicator.DeathWorldMapPoint;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.InfoBoxMenuClicked;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ui.overlay.infobox.Timer;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Death Indicator", description="Show where you last died, and on what world", tags={"arrow", "hints", "world", "map", "overlay"})
public class DeathIndicatorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DeathIndicatorPlugin.class);
    private static final String DEATH_TIMER_CLEAR = "Clear";
    private static final Set<Integer> RESPAWN_REGIONS = ImmutableSet.of((Object)6457, (Object)12850, (Object)11828, (Object)12342, (Object)11062, (Object)13150, (Object[])new Integer[]{12894});
    @Inject
    private Client client;
    @Inject
    private DeathIndicatorConfig config;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    @Named(value="developerMode")
    boolean developerMode;
    private BufferedImage mapArrow;
    private Timer deathTimer;
    private WorldPoint lastDeath;
    private Instant lastDeathTime;
    private int lastDeathWorld;

    @Provides
    DeathIndicatorConfig deathIndicatorConfig(ConfigManager configManager) {
        return (DeathIndicatorConfig)configManager.getConfig(DeathIndicatorConfig.class);
    }

    protected void startUp() {
        if (!this.hasDied()) {
            return;
        }
        this.resetInfobox();
        if (this.client.getWorld() != this.config.deathWorld()) {
            return;
        }
        if (this.config.showDeathHintArrow() && !this.client.hasHintArrow()) {
            this.client.setHintArrow(new WorldPoint(this.config.deathLocationX(), this.config.deathLocationY(), this.config.deathLocationPlane()));
        }
        if (this.config.showDeathOnWorldMap()) {
            this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
            this.worldMapPointManager.add((WorldMapPoint)new DeathWorldMapPoint(new WorldPoint(this.config.deathLocationX(), this.config.deathLocationY(), this.config.deathLocationPlane()), this));
        }
    }

    protected void shutDown() {
        if (this.client.hasHintArrow()) {
            this.client.clearHintArrow();
        }
        if (this.deathTimer != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.deathTimer);
            this.deathTimer = null;
        }
        this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        if (this.client.isInInstancedRegion() || actorDeath.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        this.lastDeath = this.client.getLocalPlayer().getWorldLocation();
        this.lastDeathWorld = this.client.getWorld();
        this.lastDeathTime = Instant.now();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Tile[][][] tiles;
        Tile tile;
        if (this.lastDeath != null && !this.client.getLocalPlayer().getWorldLocation().equals((Object)this.lastDeath)) {
            if (!RESPAWN_REGIONS.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
                log.debug("Died, but did not respawn in a known respawn location: {}", (Object)this.client.getLocalPlayer().getWorldLocation().getRegionID());
                this.lastDeath = null;
                this.lastDeathTime = null;
                return;
            }
            log.debug("Died! Grave at {}", (Object)this.lastDeath);
            this.die(this.lastDeath, this.lastDeathTime, this.lastDeathWorld);
            this.lastDeath = null;
            this.lastDeathTime = null;
        }
        if (!this.hasDied() || this.client.getWorld() != this.config.deathWorld()) {
            return;
        }
        boolean reset = this.deathTimer != null && this.deathTimer.cull();
        WorldPoint deathPoint = new WorldPoint(this.config.deathLocationX(), this.config.deathLocationY(), this.config.deathLocationPlane());
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)deathPoint);
        if (localPoint != null && ((tile = (tiles = this.client.getScene().getTiles())[this.client.getPlane()][localPoint.getSceneX()][localPoint.getSceneY()]) == null || tile.getGroundItems() == null || tile.getGroundItems().isEmpty())) {
            reset = true;
        }
        if (reset) {
            this.reset();
            this.resetDeathConfig();
        }
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        if (this.developerMode && commandExecuted.getCommand().equals("die")) {
            this.die(this.client.getLocalPlayer().getWorldLocation(), Instant.now(), this.client.getWorld());
        }
    }

    private void die(WorldPoint location, Instant time, int world) {
        this.config.deathLocationX(location.getX());
        this.config.deathLocationY(location.getY());
        this.config.deathLocationPlane(location.getPlane());
        this.config.timeOfDeath(time);
        this.config.deathWorld(world);
        if (this.config.showDeathHintArrow()) {
            this.client.setHintArrow(location);
        }
        if (this.config.showDeathOnWorldMap()) {
            this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
            this.worldMapPointManager.add((WorldMapPoint)new DeathWorldMapPoint(location, this));
        }
        this.resetInfobox();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("deathIndicator")) {
            if (!this.config.showDeathHintArrow() && this.hasDied()) {
                this.client.clearHintArrow();
            }
            if (!this.config.showDeathInfoBox() && this.deathTimer != null) {
                this.infoBoxManager.removeInfoBox((InfoBox)this.deathTimer);
                this.deathTimer = null;
            }
            if (!this.config.showDeathOnWorldMap()) {
                this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
            }
            if (!this.hasDied()) {
                this.client.clearHintArrow();
                this.resetInfobox();
                this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (!this.hasDied()) {
            return;
        }
        if (event.getGameState() == GameState.LOGGED_IN) {
            if (this.client.getWorld() == this.config.deathWorld()) {
                WorldPoint deathPoint = new WorldPoint(this.config.deathLocationX(), this.config.deathLocationY(), this.config.deathLocationPlane());
                if (this.config.showDeathHintArrow()) {
                    this.client.setHintArrow(deathPoint);
                }
                if (this.config.showDeathOnWorldMap()) {
                    this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
                    this.worldMapPointManager.add((WorldMapPoint)new DeathWorldMapPoint(deathPoint, this));
                }
            } else {
                this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
            }
        }
    }

    @Subscribe
    public void onInfoBoxMenuClicked(InfoBoxMenuClicked infoBoxMenuClicked) {
        if (infoBoxMenuClicked.getInfoBox() == this.deathTimer) {
            this.reset();
        }
    }

    private boolean hasDied() {
        return this.config.timeOfDeath() != null;
    }

    private void reset() {
        this.client.clearHintArrow();
        if (this.deathTimer != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.deathTimer);
            this.deathTimer = null;
        }
        this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
    }

    private void resetDeathConfig() {
        this.config.deathLocationX(0);
        this.config.deathLocationY(0);
        this.config.deathLocationPlane(0);
        this.config.deathWorld(0);
        this.config.timeOfDeath(null);
    }

    private void resetInfobox() {
        if (this.deathTimer != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.deathTimer);
            this.deathTimer = null;
        }
        if (this.hasDied() && this.config.showDeathInfoBox()) {
            Instant now = Instant.now();
            Duration timeLeft = Duration.ofHours(1L).minus(Duration.between(this.config.timeOfDeath(), now));
            if (!timeLeft.isNegative() && !timeLeft.isZero()) {
                this.deathTimer = new Timer(timeLeft.getSeconds(), ChronoUnit.SECONDS, this.getBonesImage(), (Plugin)this);
                this.deathTimer.setTooltip("Died on world: " + this.config.deathWorld());
                this.deathTimer.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_INFOBOX, DEATH_TIMER_CLEAR, "Death Timer"));
                this.infoBoxManager.addInfoBox((InfoBox)this.deathTimer);
            }
        }
    }

    BufferedImage getMapArrow() {
        if (this.mapArrow != null) {
            return this.mapArrow;
        }
        this.mapArrow = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/util/clue_arrow.png");
        return this.mapArrow;
    }

    BufferedImage getBonesImage() {
        return this.itemManager.getImage(526);
    }
}

