/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.swap;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import eq.uirs.fashionscape.FashionscapeConfig;
import eq.uirs.fashionscape.FashionscapePlugin;
import eq.uirs.fashionscape.colors.ColorScorer;
import eq.uirs.fashionscape.data.BootsColor;
import eq.uirs.fashionscape.data.ClothingColor;
import eq.uirs.fashionscape.data.ColorType;
import eq.uirs.fashionscape.data.Colorable;
import eq.uirs.fashionscape.data.HairColor;
import eq.uirs.fashionscape.data.ItemInteractions;
import eq.uirs.fashionscape.data.SkinColor;
import eq.uirs.fashionscape.data.kit.JawIcon;
import eq.uirs.fashionscape.data.kit.JawKit;
import eq.uirs.fashionscape.data.kit.Kit;
import eq.uirs.fashionscape.swap.CompoundSwap;
import eq.uirs.fashionscape.swap.RandomizerIntelligence;
import eq.uirs.fashionscape.swap.SavedSwaps;
import eq.uirs.fashionscape.swap.SwapDiff;
import eq.uirs.fashionscape.swap.SwapDiffHistory;
import eq.uirs.fashionscape.swap.SwapMode;
import eq.uirs.fashionscape.swap.event.SwapEvent;
import eq.uirs.fashionscape.swap.event.SwapEventListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.game.ItemManager;
import net.runelite.http.api.item.ItemEquipmentStats;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SwapManager {
    private static final Logger log = LoggerFactory.getLogger(SwapManager.class);
    public static final Map<Integer, Kit> KIT_ID_TO_KIT = new HashMap<Integer, Kit>();
    public static final List<KitType> ALLOWS_NOTHING = ImmutableList.of((Object)KitType.HEAD, (Object)KitType.CAPE, (Object)KitType.AMULET, (Object)KitType.WEAPON, (Object)KitType.SHIELD);
    private static final Map<KitType, List<Kit>> KIT_TYPE_TO_KITS;
    private static final List<KitType> NEVER_ZERO_SLOTS_FEMALE;
    private static final List<KitType> NEVER_ZERO_SLOTS_MALE;
    private static final String KIT_SUFFIX = "_KIT";
    private static final String COLOR_SUFFIX = "_COLOR";
    private static final String ICON_KEY = "ICON";
    @Inject
    private FashionscapeConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ColorScorer colorScorer;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private SavedSwaps savedSwaps;
    private final SwapDiffHistory swapDiffHistory = new SwapDiffHistory(s -> this.restore((SwapDiff)s, true));
    private Boolean isFemale;
    private String lastKnownPlayerName = null;
    private SwapDiff hoverSwapDiff;
    private final Map<KitType, Integer> disabledSlots = new HashMap<KitType, Integer>();
    private Integer disabledAnimationId = null;

    public void startUp() {
        this.doPreRefreshCheck();
        this.refreshAllSwaps();
    }

    public void shutDown() {
        this.revertSwaps(true, true);
        this.savedSwaps.removeListeners();
        this.swapDiffHistory.removeListeners();
        this.hoverSwapDiff = null;
    }

    public void onPlayerChanged() {
        this.doPreRefreshCheck();
        this.savedSwaps.loadFromConfig();
        this.refreshAllSwaps();
    }

    public void addEventListener(SwapEventListener<? extends SwapEvent> listener) {
        this.savedSwaps.addEventListener(listener);
    }

    public void addUndoQueueChangeListener(Consumer<Integer> listener) {
        this.swapDiffHistory.addUndoQueueChangeListener(listener);
    }

    public void addRedoQueueChangeListener(Consumer<Integer> listener) {
        this.swapDiffHistory.addRedoQueueChangeListener(listener);
    }

    public boolean isSlotLocked(KitType slot) {
        return this.savedSwaps.isSlotLocked(slot);
    }

    public boolean isKitLocked(KitType slot) {
        return this.savedSwaps.isKitLocked(slot);
    }

    public boolean isItemLocked(KitType slot) {
        return this.savedSwaps.isItemLocked(slot);
    }

    public boolean isColorLocked(ColorType type) {
        return this.savedSwaps.isColorLocked(type);
    }

    public boolean isIconLocked() {
        return this.savedSwaps.isIconLocked();
    }

    public void toggleItemLocked(KitType slot) {
        this.savedSwaps.toggleItemLocked(slot);
    }

    public void toggleKitLocked(KitType slot) {
        this.savedSwaps.toggleKitLocked(slot);
    }

    public void toggleColorLocked(ColorType type) {
        this.savedSwaps.toggleColorLocked(type);
    }

    public void toggleIconLocked() {
        this.savedSwaps.toggleIconLocked();
    }

    public void refreshAllSwaps() {
        Map<KitType, Integer> savedEquipmentIds = this.savedSwaps.itemEntries().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + 512));
        Map<KitType, Integer> savedKitEquipIds = this.savedSwaps.kitEntries().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + 256));
        Map<KitType, Integer> hiddenEquipIds = this.savedSwaps.getHiddenSlots().stream().collect(Collectors.toMap(v -> v, v -> 0));
        savedEquipmentIds.putAll(savedKitEquipIds);
        savedEquipmentIds.putAll(hiddenEquipIds);
        for (CompoundSwap compoundSwap : CompoundSwap.fromMap(this.sanitize(savedEquipmentIds), this.savedSwaps.getSwappedIcon())) {
            this.swap(compoundSwap, SwapMode.PREVIEW);
        }
        for (Map.Entry entry : this.savedSwaps.colorEntries()) {
            this.swap((ColorType)((Object)entry.getKey()), (Integer)entry.getValue(), SwapMode.PREVIEW);
        }
    }

    public void undoLastSwap() {
        if (this.client.getLocalPlayer() != null) {
            this.swapDiffHistory.undoLast();
        }
    }

    public boolean canUndo() {
        return this.swapDiffHistory.undoSize() > 0;
    }

    public void redoLastSwap() {
        if (this.client.getLocalPlayer() != null) {
            this.swapDiffHistory.redoLast();
        }
    }

    public boolean canRedo() {
        return this.swapDiffHistory.redoSize() > 0;
    }

    public void doPreRefreshCheck() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        PlayerComposition playerComposition = player.getPlayerComposition();
        if (playerComposition == null) {
            return;
        }
        boolean female = playerComposition.getGender() == 1;
        this.checkRealKits(female);
        this.isFemale = female;
        if (this.isFemale.booleanValue()) {
            this.savedSwaps.removeSlot(KitType.JAW);
        }
        if (!Objects.equals(this.lastKnownPlayerName, player.getName())) {
            this.savedSwaps.loadRSProfileConfig();
            this.lastKnownPlayerName = player.getName();
        }
        for (KitType kitType : KitType.values()) {
            Integer kitId = this.kitIdFor(kitType);
            if (kitId == null || kitId < 0 || this.savedSwaps.containsSlot(kitType) && Objects.equals(this.savedSwaps.getKit(kitType), kitId)) continue;
            this.savedSwaps.putRealKit(kitType, kitId);
        }
        for (ColorType colorType : ColorType.values()) {
            Integer colorId = this.colorIdFor(colorType);
            if (colorId == null || this.savedSwaps.containsColor(colorType) && Objects.equals(this.savedSwaps.getColor(colorType), colorId)) continue;
            this.savedSwaps.putRealColor(colorType, colorId);
        }
        int n = playerComposition.getEquipmentIds()[KitType.JAW.getIndex()];
        if (n >= 512) {
            JawIcon icon = JawKit.iconFromItemId(n - 512);
            this.savedSwaps.putRealIcon(icon);
        } else {
            this.savedSwaps.putRealIcon(JawIcon.NOTHING);
        }
        int bootKitId = playerComposition.getKitId(KitType.BOOTS);
        int weaponItemId = playerComposition.getEquipmentIds()[KitType.WEAPON.getIndex()] - 512;
        if (ItemInteractions.DISABLE_BOOT_KITS.contains(bootKitId)) {
            this.disabledAnimationId = 2148;
            this.disabledSlots.put(KitType.BOOTS, bootKitId + 256);
            this.disabledSlots.put(KitType.WEAPON, 0);
            this.disabledSlots.put(KitType.SHIELD, 0);
        } else if (ItemInteractions.DISABLE_WEAPONS.contains(weaponItemId)) {
            this.disabledSlots.put(KitType.WEAPON, weaponItemId + 512);
            this.disabledSlots.put(KitType.SHIELD, 0);
        } else {
            this.disabledAnimationId = null;
            this.disabledSlots.clear();
        }
        this.refreshDisabledSlots();
    }

    private void checkRealKits(boolean female) {
        boolean containsOppositeGenderKits = this.savedSwaps.getRealKitIds().entrySet().stream().anyMatch(e -> {
            Kit kit = KIT_ID_TO_KIT.get(e.getValue());
            return kit != null && kit.getKitId(female) == null;
        });
        if (containsOppositeGenderKits) {
            this.savedSwaps.clearRealKits();
        }
    }

    private void refreshDisabledSlots() {
        if (!this.disabledSlots.isEmpty()) {
            Set<KitType> lockedItems = this.savedSwaps.getAllLockedItems();
            Set<KitType> lockedKits = this.savedSwaps.getAllLockedKits();
            boolean iconLocked = this.savedSwaps.isIconLocked();
            for (KitType slot : this.disabledSlots.keySet()) {
                this.savedSwaps.removeSlotLock(slot);
                this.savedSwaps.removeIconLock();
            }
            if (!this.disabledSlots.isEmpty()) {
                CompoundSwap.fromMap(this.disabledSlots, null).forEach(c -> this.swap((CompoundSwap)c, true, SwapMode.PREVIEW));
            }
            if (this.disabledAnimationId != null) {
                Player player = this.client.getLocalPlayer();
                if (player != null) {
                    this.setIdleAnimationId(player, this.disabledAnimationId, true);
                }
                this.disabledAnimationId = null;
            }
            this.savedSwaps.setLockedItems(lockedItems);
            this.savedSwaps.setLockedKits(lockedKits);
            this.savedSwaps.setIconLocked(iconLocked);
        }
    }

    public void onEquipmentChanged() {
        block4: for (KitType kitType : KitType.values()) {
            Integer inventoryItemId = this.inventoryItemId(kitType);
            Integer virtualItemId = this.savedSwaps.getItem(kitType);
            Integer virtualKitId = this.savedSwaps.getKit(kitType);
            if (virtualItemId != null || virtualKitId != null || inventoryItemId == null) continue;
            switch (kitType) {
                case HEAD: {
                    if (this.savedSwaps.containsSlot(KitType.HAIR) && !ItemInteractions.HAIR_HELMS.contains(inventoryItemId) || this.savedSwaps.containsSlot(KitType.JAW) && ItemInteractions.NO_JAW_HELMS.contains(inventoryItemId)) {
                        this.swap(CompoundSwap.single(KitType.HEAD, 0), SwapMode.PREVIEW);
                        continue block4;
                    }
                    if (!this.savedSwaps.containsIcon()) continue block4;
                    this.swap(CompoundSwap.single(KitType.HEAD, inventoryItemId + 512), SwapMode.PREVIEW);
                    continue block4;
                }
                case TORSO: {
                    if (!this.savedSwaps.containsSlot(KitType.ARMS) || ItemInteractions.ARMS_TORSOS.contains(inventoryItemId)) continue block4;
                    int kitId = this.savedSwaps.getRealKit(kitType, this.isFemale);
                    this.swap(CompoundSwap.single(kitType, kitId + 256), SwapMode.PREVIEW);
                    continue block4;
                }
            }
        }
    }

    public void importSwaps(Map<KitType, Integer> newItems, Map<KitType, Integer> newKits, Map<ColorType, Integer> newColors, JawIcon icon, Set<KitType> slotsToRemove) {
        this.clientThread.invokeLater(() -> {
            Map<KitType, Integer> itemEquipSwaps = newItems.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + 512));
            Map<KitType, Integer> kitEquipSwaps = newKits.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + 256));
            Map<KitType, Integer> removals = slotsToRemove.stream().collect(Collectors.toMap(v -> v, v -> 0));
            HashMap<KitType, Integer> equipSwaps = new HashMap<KitType, Integer>(kitEquipSwaps);
            equipSwaps.putAll(itemEquipSwaps);
            equipSwaps.putAll(removals);
            this.savedSwaps.removeAllLocks();
            SwapDiff iconRevert = this.doRevertIcon();
            SwapDiff kitRevert = Arrays.stream(KitType.values()).map(this::doRevert).filter(Objects::nonNull).reduce(SwapDiff::mergeOver).orElse(SwapDiff.blank());
            SwapDiff colorRevert = Arrays.stream(ColorType.values()).map(this::doRevert).reduce(SwapDiff::mergeOver).orElse(SwapDiff.blank());
            SwapDiff equips = CompoundSwap.fromMap(this.sanitize(equipSwaps), icon).stream().map(c -> this.swap((CompoundSwap)c, SwapMode.SAVE)).reduce(SwapDiff::mergeOver).orElse(SwapDiff.blank());
            Map<ColorType, Integer> colorSwaps = newColors.entrySet().stream().filter(e -> !this.savedSwaps.isColorLocked((ColorType)((Object)((Object)((Object)e.getKey()))))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<ColorType, Integer> colorEquipSwaps = colorSwaps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            SwapDiff colors = colorEquipSwaps.entrySet().stream().map(e -> this.swapColor((ColorType)((Object)((Object)((Object)e.getKey()))), (Integer)e.getValue(), true)).reduce(SwapDiff::mergeOver).orElse(SwapDiff.blank());
            SwapDiff total = iconRevert.mergeOver(kitRevert).mergeOver(colorRevert).mergeOver(equips).mergeOver(colors);
            this.swapDiffHistory.appendToUndo(total);
        });
    }

    public List<String> stringifySwaps() {
        HashSet<Map.Entry<KitType, Integer>> itemEntries = new HashSet<Map.Entry<KitType, Integer>>(this.savedSwaps.hiddenSlotEntries());
        itemEntries.addAll(this.savedSwaps.itemEntries());
        List<String> items = itemEntries.stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(e -> {
            KitType slot = (KitType)e.getKey();
            Integer itemId = (Integer)e.getValue();
            if (itemId == 0) {
                return slot.name() + ":-1 (Nothing)";
            }
            String itemName = this.itemManager.getItemComposition(itemId.intValue()).getName();
            return slot.name() + ":" + itemId + " (" + itemName + ")";
        }).collect(Collectors.toList());
        List kits = this.savedSwaps.kitEntries().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(e -> {
            KitType slot = (KitType)e.getKey();
            Integer kitId = (Integer)e.getValue();
            String kitName = KIT_ID_TO_KIT.get(kitId).getDisplayName();
            return slot.name() + "_KIT:" + kitId + " (" + kitName + ")";
        }).collect(Collectors.toList());
        List colors = this.savedSwaps.colorEntries().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(e -> {
            ColorType type = (ColorType)((Object)((Object)e.getKey()));
            Integer colorId = (Integer)e.getValue();
            return Arrays.stream(type.getColorables()).filter(c -> c.getColorId(type) == colorId.intValue()).findFirst().map(c -> type.name() + "_COLOR:" + colorId + " (" + c.getDisplayName() + ")").orElse("");
        }).collect(Collectors.toList());
        ArrayList<CallSite> icons = new ArrayList<CallSite>();
        JawIcon icon = this.savedSwaps.getSwappedIcon();
        if (this.savedSwaps.containsIcon()) {
            icons.add((CallSite)((Object)("ICON:" + icon.getId() + " (" + icon.getDisplayName() + ")")));
        }
        items.addAll(kits);
        items.addAll(colors);
        items.addAll(icons);
        return items;
    }

    @Nullable
    public Integer swappedItemIdIn(KitType slot) {
        return this.savedSwaps.getItem(slot);
    }

    @Nullable
    public JawIcon swappedIcon() {
        return this.savedSwaps.getSwappedIcon();
    }

    public boolean isHidden(KitType slot) {
        return this.savedSwaps.isHidden(slot);
    }

    @Nullable
    public Integer swappedKitIdIn(KitType slot) {
        return this.savedSwaps.getKit(slot);
    }

    @Nullable
    public Integer swappedColorIdIn(ColorType type) {
        return this.savedSwaps.getColor(type);
    }

    public Map<ColorType, Colorable> swappedColorsMap() {
        BiFunction<ColorType, Integer, Colorable> getColor = (type, id) -> {
            switch (type) {
                case HAIR: {
                    return HairColor.fromId(id);
                }
                case TORSO: {
                    return ClothingColor.fromTorsoId(id);
                }
                case LEGS: {
                    return ClothingColor.fromLegsId(id);
                }
                case BOOTS: {
                    return BootsColor.fromId(id);
                }
                case SKIN: {
                    return SkinColor.fromId(id);
                }
            }
            return null;
        };
        return Arrays.stream(ColorType.values()).filter(this.savedSwaps::containsColor).collect(Collectors.toMap(t -> t, t -> (Colorable)getColor.apply((ColorType)((Object)t), this.savedSwaps.getColor((ColorType)((Object)t)))));
    }

    public void revert(KitType slot, ColorType type) {
        SwapDiff s = SwapDiff.blank();
        if (slot != null) {
            this.savedSwaps.removeSlotLock(slot);
            s = s.mergeOver(this.doRevert(slot));
        }
        if (type != null) {
            this.savedSwaps.removeColorLock(type);
            s = s.mergeOver(this.doRevert(type));
        }
        this.swapDiffHistory.appendToUndo(s);
    }

    public void revertSlot(KitType slot) {
        this.savedSwaps.removeSlotLock(slot);
        SwapDiff s = this.doRevert(slot);
        this.swapDiffHistory.appendToUndo(s);
    }

    public void revertIcon() {
        this.savedSwaps.removeIconLock();
        SwapDiff s = this.doRevertIcon();
        this.swapDiffHistory.appendToUndo(s);
    }

    public void hoverOverItem(KitType slot, Integer itemId) {
        this.hoverOver(() -> {
            int id = itemId < 0 ? -512 : itemId;
            return this.swapItem(slot, id, false, false);
        });
    }

    public void hoverOverKit(KitType slot, int kitId) {
        this.hoverOver(() -> this.swapKit(slot, kitId, false));
    }

    public void hoverOverColor(ColorType type, Integer colorId) {
        this.hoverOver(() -> this.swapColor(type, colorId, false));
    }

    public void hoverOverIcon(JawIcon icon) {
        this.hoverOver(() -> this.swapIcon(icon, false));
    }

    private void hoverOver(Supplier<SwapDiff> diffCallable) {
        this.clientThread.invokeLater(() -> {
            SwapDiff swapDiff = (SwapDiff)diffCallable.get();
            if (this.hoverSwapDiff == null) {
                this.hoverSwapDiff = swapDiff;
            } else if (!swapDiff.isBlank()) {
                this.hoverSwapDiff = swapDiff.mergeOver(this.hoverSwapDiff);
            }
        });
    }

    public void hoverSelectItem(KitType slot, Integer itemId) {
        this.hoverSelect(() -> {
            if (this.savedSwaps.isItemLocked(slot)) {
                return SwapDiff.blank();
            }
            if (itemId < 0) {
                return this.savedSwaps.isHidden(slot) ? this.doRevert(slot) : this.swapItem(slot, -512, true, false);
            }
            return Objects.equals(this.savedSwaps.getItem(slot), itemId) ? this.doRevert(slot) : this.swapItem(slot, itemId, true, false);
        });
    }

    public void hoverSelectKit(KitType slot, int kitId) {
        this.hoverSelect(() -> {
            if (this.savedSwaps.isKitLocked(slot)) {
                return SwapDiff.blank();
            }
            return Objects.equals(this.savedSwaps.getKit(slot), kitId) ? this.doRevert(slot) : this.swapKit(slot, kitId, true);
        });
    }

    public void hoverSelectColor(ColorType type, Integer colorId) {
        this.hoverSelect(() -> {
            if (this.savedSwaps.isColorLocked(type)) {
                return SwapDiff.blank();
            }
            return Objects.equals(this.savedSwaps.getColor(type), colorId) ? this.doRevert(type) : this.swapColor(type, colorId, true);
        });
    }

    public void hoverSelectIcon(JawIcon icon) {
        this.hoverSelect(() -> {
            if (this.savedSwaps.isIconLocked()) {
                return SwapDiff.blank();
            }
            return Objects.equals((Object)this.savedSwaps.getSwappedIcon(), (Object)icon) ? this.doRevertIcon() : this.swapIcon(icon, true);
        });
    }

    private void hoverSelect(Supplier<SwapDiff> diffSupplier) {
        this.clientThread.invokeLater(() -> {
            SwapDiff swapDiff = (SwapDiff)diffSupplier.get();
            if (!swapDiff.isBlank()) {
                if (this.hoverSwapDiff != null) {
                    swapDiff = this.hoverSwapDiff.mergeOver(swapDiff);
                }
                this.swapDiffHistory.appendToUndo(swapDiff);
                this.hoverSwapDiff = null;
            }
        });
    }

    public void hoverAway() {
        this.clientThread.invokeLater(() -> {
            if (this.hoverSwapDiff != null) {
                this.restore(this.hoverSwapDiff, false);
                this.hoverSwapDiff = null;
            }
            this.refreshAllSwaps();
        });
    }

    private void revertSwaps(List<KitType> slots, boolean removeLocks, boolean preview) {
        if (removeLocks) {
            slots.forEach(slot -> this.savedSwaps.removeSlotLock((KitType)slot));
            this.savedSwaps.removeIconLock();
        }
        SwapMode mode = preview ? SwapMode.PREVIEW : SwapMode.REVERT;
        JawIcon icon = null;
        if (!this.savedSwaps.isIconLocked()) {
            icon = JawIcon.NOTHING;
        }
        Map<KitType, Integer> equipIdsToRevert = slots.stream().filter(slot -> !this.savedSwaps.isSlotLocked((KitType)slot)).collect(Collectors.toMap(slot -> slot, slot -> {
            Integer itemId = this.inventoryItemId((KitType)slot);
            if (itemId != null && itemId != 0) {
                return itemId + 512;
            }
            return this.savedSwaps.getRealKit((KitType)slot, this.isFemale) + 256;
        }));
        SwapDiff kitsDiff = CompoundSwap.fromMap(equipIdsToRevert, icon).stream().map(c -> this.swap((CompoundSwap)c, false, s -> mode, mode)).reduce(SwapDiff::mergeOver).orElse(SwapDiff.blank());
        SwapDiff colorsDiff = Arrays.stream(ColorType.values()).filter(type -> !this.savedSwaps.isColorLocked((ColorType)((Object)type))).map(type -> {
            Integer colorId = this.savedSwaps.getRealColor((ColorType)((Object)type));
            return colorId != null ? this.swap((ColorType)((Object)type), colorId, mode) : SwapDiff.blank();
        }).reduce(SwapDiff::mergeOver).orElse(SwapDiff.blank());
        SwapDiff totalDiff = kitsDiff.mergeOver(colorsDiff);
        if (mode == SwapMode.REVERT) {
            this.swapDiffHistory.appendToUndo(totalDiff);
            this.savedSwaps.clearSwapped();
        }
    }

    public void revertSwaps(boolean removeLocks, boolean preview) {
        this.revertSwaps(Arrays.asList(KitType.values()), removeLocks, preview);
    }

    @Nullable
    public Integer slotIdFor(ItemComposition itemComposition) {
        ItemEquipmentStats equipStats = this.equipmentStatsFor(itemComposition.getId());
        if (equipStats != null) {
            return equipStats.getSlot();
        }
        return null;
    }

    public void loadImports(List<String> allLines) {
        HashMap<KitType, Integer> itemImports = new HashMap<KitType, Integer>();
        HashMap<KitType, Integer> kitImports = new HashMap<KitType, Integer>();
        HashMap<ColorType, Integer> colorImports = new HashMap<ColorType, Integer>();
        JawIcon icon = null;
        HashSet<KitType> removes = new HashSet<KitType>();
        for (String line : allLines) {
            Matcher matcher;
            if (line.trim().isEmpty() || !(matcher = FashionscapePlugin.PROFILE_PATTERN.matcher(line)).matches()) continue;
            String slotStr = matcher.group(1);
            int id = Integer.parseInt(matcher.group(2));
            KitType itemSlot = this.itemSlotMatch(slotStr);
            KitType kitSlot = this.kitSlotMatch(slotStr);
            ColorType colorType = this.colorSlotMatch(slotStr);
            if (itemSlot != null) {
                if (id <= 0) {
                    removes.add(itemSlot);
                    continue;
                }
                itemImports.put(itemSlot, id);
                continue;
            }
            if (kitSlot != null) {
                kitImports.put(kitSlot, id);
                continue;
            }
            if (colorType != null) {
                colorImports.put(colorType, id);
                continue;
            }
            if (slotStr.equals(ICON_KEY)) {
                icon = JawIcon.fromId(id);
                continue;
            }
            this.sendHighlightedMessage("Could not import line: " + line);
        }
        ALLOWS_NOTHING.forEach(slot -> {
            if (!itemImports.containsKey(slot)) {
                removes.add((KitType)slot);
            }
        });
        if (!(itemImports.isEmpty() && kitImports.isEmpty() && colorImports.isEmpty())) {
            this.importSwaps(itemImports, kitImports, colorImports, icon, removes);
        }
    }

    public void exportSwaps(File selected) {
        this.clientThread.invokeLater(() -> {
            try (PrintWriter out = new PrintWriter(selected);){
                List<String> exports = this.stringifySwaps();
                for (String line : exports) {
                    out.println(line);
                }
                this.sendHighlightedMessage("Saved fashionscape to " + selected.getName());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        });
    }

    public void copyOutfit(PlayerComposition other) {
        int[] equipmentIds = other.getEquipmentIds();
        KitType[] slots = KitType.values();
        Map<KitType, Integer> equipIdImports = IntStream.range(0, equipmentIds.length).boxed().collect(Collectors.toMap(i -> slots[i], i -> equipmentIds[i]));
        Map<KitType, Integer> itemImports = equipIdImports.entrySet().stream().filter(e -> (Integer)e.getValue() >= 512).collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() - 512));
        Map<KitType, Integer> kitImports = equipIdImports.entrySet().stream().filter(e -> (Integer)e.getValue() >= 256 && (Integer)e.getValue() < 512).collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() - 256));
        Set<KitType> removals = equipIdImports.entrySet().stream().filter(e -> (Integer)e.getValue() <= 0).map(Map.Entry::getKey).collect(Collectors.toSet());
        int[] colors = other.getColors();
        ColorType[] types = ColorType.values();
        Map<ColorType, Integer> colorImports = IntStream.range(0, colors.length).boxed().collect(Collectors.toMap(i -> types[i], i -> colors[i]));
        JawIcon icon = null;
        Integer jawItemId = itemImports.get(KitType.JAW);
        if (jawItemId != null) {
            icon = JawKit.iconFromItemId(jawItemId);
            itemImports.remove(KitType.JAW);
        }
        if (!(itemImports.isEmpty() && kitImports.isEmpty() && colorImports.isEmpty() && removals.isEmpty())) {
            this.importSwaps(itemImports, kitImports, colorImports, icon, removals);
        }
    }

    private Map<KitType, Integer> sanitize(Map<KitType, Integer> equipmentIds) {
        Boolean isFemale = this.isFemale;
        if (isFemale == null) {
            return new HashMap<KitType, Integer>();
        }
        HashMap<KitType, Integer> newEquipIds = new HashMap<KitType, Integer>();
        equipmentIds.forEach((slot, equipId) -> {
            if (equipId >= 256 && equipId < 512 || equipId >= 512 && slot == KitType.JAW) {
                Integer newEquipId = this.getAnalogousEquipmentId((int)equipId);
                if (newEquipId != null) {
                    newEquipIds.put((KitType)slot, newEquipId);
                }
            } else if (equipId >= 512) {
                newEquipIds.put((KitType)slot, (Integer)equipId);
            }
        });
        Map<KitType, Integer> removals = equipmentIds.entrySet().stream().filter(e -> (Integer)e.getValue() == 0 && !this.getNonZeroSlots().contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> 0));
        newEquipIds.putAll(removals);
        return newEquipIds;
    }

    @Nullable
    private Integer getAnalogousEquipmentId(int equipId) {
        Kit kit;
        Integer result = null;
        JawIcon icon = JawIcon.NOTHING;
        if (equipId >= 512 && (kit = JawKit.fromEquipmentId(equipId)) != null) {
            icon = JawKit.iconFromItemId(equipId - 512);
            Integer jawKitId = ((JawKit)kit).getKitId(this.isFemale);
            if (jawKitId != null) {
                equipId = jawKitId + 256;
            }
        }
        if ((kit = KIT_ID_TO_KIT.get(equipId - 256)) != null) {
            Integer kitId = kit.getKitId(this.isFemale);
            if (kitId != null) {
                result = kitId + 256;
            } else {
                Integer analogKitId;
                BiMap lookup;
                BiMap biMap = lookup = this.isFemale != false ? ItemInteractions.MALE_TO_FEMALE_KITS : ItemInteractions.MALE_TO_FEMALE_KITS.inverse();
                if (lookup.containsKey((Object)kit) && (analogKitId = ((Kit)lookup.get((Object)kit)).getKitId(this.isFemale)) != null) {
                    result = analogKitId + 256;
                }
            }
            if (icon != JawIcon.NOTHING) {
                Integer itemId;
                result = result != null ? Integer.valueOf((itemId = JawKit.fromEquipmentId(result).getIconItemId(icon)) != null ? itemId + 512 : result) : Integer.valueOf(this.combineJawIcon(null, icon));
            }
        }
        return result;
    }

    private List<KitType> getNonZeroSlots() {
        if (this.isFemale != null && this.isFemale.booleanValue()) {
            return NEVER_ZERO_SLOTS_FEMALE;
        }
        return NEVER_ZERO_SLOTS_MALE;
    }

    public void shuffle() {
        Random r = new Random();
        RandomizerIntelligence intelligence = this.config.randomizerIntelligence();
        int size = intelligence.getDepth();
        if (size > 1) {
            Integer iconItemId;
            Map<KitType, Integer> lockedItems = Arrays.stream(KitType.values()).filter(s -> this.savedSwaps.isItemLocked((KitType)s) && this.savedSwaps.containsItem((KitType)s)).collect(Collectors.toMap(s -> s, this.savedSwaps::getItem));
            if (this.savedSwaps.isIconLocked() && this.savedSwaps.containsIcon() && (iconItemId = JawKit.NO_JAW.getIconItemId(this.savedSwaps.getSwappedIcon())) != null) {
                lockedItems.put(KitType.JAW, iconItemId);
            }
            Map<ColorType, Colorable> lockedColors = this.swappedColorsMap().entrySet().stream().filter(e -> this.savedSwaps.isColorLocked((ColorType)((Object)((Object)e.getKey()))) && this.savedSwaps.containsColor((ColorType)((Object)((Object)e.getKey())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.colorScorer.setPlayerInfo(lockedItems, lockedColors);
        }
        Map<KitType, Boolean> itemSlotsToRevert = Arrays.stream(KitType.values()).collect(Collectors.toMap(slot -> slot, this.savedSwaps::isItemLocked));
        Map<KitType, Integer> newSwaps = Arrays.stream(KitType.values()).filter(itemSlotsToRevert::get).collect(Collectors.toMap(s -> s, s -> -1));
        Set<Integer> skips = FashionscapePlugin.getItemIdsToExclude(this.config);
        ArrayList<Candidate> candidates = new ArrayList<Candidate>(size);
        List randomOrder = IntStream.range(0, this.client.getItemCount()).boxed().collect(Collectors.toList());
        Collections.shuffle(randomOrder);
        Iterator randomIterator = randomOrder.iterator();
        while (newSwaps.size() < KitType.values().length && randomIterator.hasNext()) {
            Candidate best;
            Integer i2 = (Integer)randomIterator.next();
            int canonical = this.itemManager.canonicalize(i2.intValue());
            if (skips.contains(canonical)) continue;
            ItemComposition itemComposition = this.itemManager.getItemComposition(canonical);
            int itemId = itemComposition.getId();
            KitType slot2 = this.slotForId(this.slotIdFor(itemComposition));
            if (slot2 != null && !newSwaps.containsKey(slot2)) {
                if (slot2 == KitType.WEAPON) {
                    ItemEquipmentStats stats = this.equipmentStatsFor(itemId);
                    if (stats != null && stats.isTwoHanded() && newSwaps.get(KitType.SHIELD) != null) {
                        continue;
                    }
                } else if (slot2 == KitType.SHIELD) {
                    ItemEquipmentStats stats;
                    Integer weaponItemId = newSwaps.get(KitType.WEAPON);
                    if (weaponItemId != null && (stats = this.equipmentStatsFor(weaponItemId)) != null && stats.isTwoHanded()) {
                        newSwaps.put(KitType.SHIELD, -1);
                        continue;
                    }
                } else if (slot2 == KitType.HEAD ? !ItemInteractions.HAIR_HELMS.contains(itemId) && this.savedSwaps.isKitLocked(KitType.HAIR) || ItemInteractions.NO_JAW_HELMS.contains(itemId) && this.savedSwaps.isKitLocked(KitType.JAW) : slot2 == KitType.TORSO && !ItemInteractions.ARMS_TORSOS.contains(itemId) && this.savedSwaps.isKitLocked(KitType.ARMS)) continue;
                candidates.add(new Candidate(itemComposition.getId(), slot2));
            }
            if (candidates.isEmpty() || candidates.size() < size) continue;
            if (size > 1) {
                best = candidates.stream().max(Comparator.comparingDouble(c -> this.colorScorer.score(c.itemId, c.slot))).get();
                this.colorScorer.addPlayerInfo(best.slot, best.itemId);
            } else {
                best = (Candidate)candidates.get(0);
            }
            newSwaps.put(best.slot, best.itemId);
            candidates.clear();
        }
        List<KitType> removes = newSwaps.entrySet().stream().filter(e -> (Integer)e.getValue() < 0).map(Map.Entry::getKey).collect(Collectors.toList());
        removes.forEach(newSwaps::remove);
        HashMap<ColorType, Integer> newColors = new HashMap<ColorType, Integer>();
        List<ColorType> allColorTypes = Arrays.asList((ColorType[])ColorType.values().clone());
        Collections.shuffle(allColorTypes);
        for (ColorType type : allColorTypes) {
            int limit;
            List<Colorable> colorables;
            if (this.savedSwaps.isColorLocked(type) || (colorables = Arrays.asList((Colorable[])type.getColorables().clone())).isEmpty()) continue;
            Collections.shuffle(colorables);
            switch (intelligence) {
                case LOW: {
                    limit = Math.max(1, colorables.size() / 4);
                    break;
                }
                case MODERATE: {
                    limit = Math.max(1, colorables.size() / 2);
                    break;
                }
                case HIGH: {
                    limit = colorables.size();
                    break;
                }
                default: {
                    limit = 1;
                }
            }
            Colorable best = colorables.stream().limit(limit).max(Comparator.comparingDouble(c -> this.colorScorer.score((Colorable)c, type))).orElse(colorables.get(0));
            this.colorScorer.addPlayerColor(type, best);
            newColors.put(type, best.getColorId(type));
        }
        SwapDiff totalDiff = SwapDiff.blank();
        Map<KitType, Integer> newEquipSwaps = newSwaps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + 512));
        SwapDiff itemsDiff = CompoundSwap.fromMap(newEquipSwaps, null).stream().map(c -> this.swap((CompoundSwap)c, SwapMode.SAVE)).reduce(SwapDiff::mergeOver).orElse(SwapDiff.blank());
        totalDiff = totalDiff.mergeOver(itemsDiff);
        if (this.isFemale != null && !this.config.excludeBaseModels()) {
            Map<KitType, Integer> kitSwaps = Arrays.stream(KitType.values()).filter(slot -> !newSwaps.containsKey(slot) && this.isOpen((KitType)slot)).map(slot -> {
                List kits = ((List)KIT_TYPE_TO_KITS.getOrDefault(slot, new ArrayList())).stream().filter(k -> k.getKitId(this.isFemale) != null).collect(Collectors.toList());
                return kits.isEmpty() ? null : (Kit)kits.get(r.nextInt(kits.size()));
            }).filter(Objects::nonNull).collect(Collectors.toMap(Kit::getKitType, k -> k.getKitId(this.isFemale)));
            Map<KitType, Integer> kitEquipSwaps = kitSwaps.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + 256));
            SwapDiff kitsDiff = CompoundSwap.fromMap(kitEquipSwaps, null).stream().map(c -> this.swap((CompoundSwap)c, SwapMode.SAVE)).reduce(SwapDiff::mergeOver).orElse(SwapDiff.blank());
            totalDiff = totalDiff.mergeOver(kitsDiff);
        }
        if (!(this.config.excludeNonStandardItems() || this.config.excludeMembersItems() || this.savedSwaps.isIconLocked())) {
            List<JawIcon> icons = Arrays.asList(JawIcon.values());
            Collections.shuffle(icons);
            int limit = icons.size();
            if (intelligence == RandomizerIntelligence.NONE) {
                limit = 1;
            }
            Map<JawIcon, Double> scores = icons.stream().limit(limit).collect(Collectors.toMap(i -> i, i -> {
                Integer itemId = JawKit.NO_JAW.getIconItemId((JawIcon)((Object)i));
                return itemId != null ? this.colorScorer.score(itemId, null) : 0.0;
            }));
            JawIcon icon = scores.entrySet().stream().filter(e -> intelligence == RandomizerIntelligence.NONE || (Double)e.getValue() > 0.75).max(Comparator.comparingDouble(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(JawIcon.NOTHING);
            SwapDiff iconDiff = this.swap(CompoundSwap.fromIcon(icon), SwapMode.PREVIEW, SwapMode.SAVE);
            totalDiff = totalDiff.mergeOver(iconDiff);
        }
        SwapDiff colorsDiff = newColors.entrySet().stream().filter(e -> (Integer)e.getValue() >= 0).map(e -> this.swap((ColorType)((Object)((Object)e.getKey())), (Integer)e.getValue(), SwapMode.SAVE)).reduce(SwapDiff::mergeOver).orElse(SwapDiff.blank());
        totalDiff = totalDiff.mergeOver(colorsDiff);
        this.swapDiffHistory.appendToUndo(totalDiff);
    }

    public SwapDiff swapItem(KitType slot, Integer itemId, boolean save, boolean saveIcon) {
        if (itemId == null) {
            return SwapDiff.blank();
        }
        int equipmentId = itemId + 512;
        SwapMode swapMode = save ? SwapMode.SAVE : SwapMode.PREVIEW;
        SwapMode iconSwapMode = saveIcon ? SwapMode.SAVE : SwapMode.PREVIEW;
        SwapDiff swapDiff = this.swap(CompoundSwap.single(slot, equipmentId), swapMode, iconSwapMode);
        if (this.hoverSwapDiff != null) {
            swapDiff = swapDiff.mergeOver(this.hoverSwapDiff);
        }
        return swapDiff;
    }

    public SwapDiff swapKit(KitType slot, Integer kitId, boolean save) {
        if (kitId == null) {
            return SwapDiff.blank();
        }
        int equipmentId = kitId + 256;
        SwapMode swapMode = save ? SwapMode.SAVE : SwapMode.PREVIEW;
        SwapDiff swapDiff = this.swap(CompoundSwap.single(slot, equipmentId), swapMode, SwapMode.PREVIEW);
        if (this.hoverSwapDiff != null) {
            swapDiff = swapDiff.mergeOver(this.hoverSwapDiff);
        }
        return swapDiff;
    }

    public SwapDiff swapIcon(JawIcon icon, boolean save) {
        if (icon == null) {
            return SwapDiff.blank();
        }
        SwapMode swapMode = save ? SwapMode.SAVE : SwapMode.PREVIEW;
        SwapDiff swapDiff = this.swap(CompoundSwap.fromIcon(icon), SwapMode.PREVIEW, swapMode);
        if (this.hoverSwapDiff != null) {
            swapDiff = swapDiff.mergeOver(this.hoverSwapDiff);
        }
        return swapDiff;
    }

    public SwapDiff swapColor(ColorType type, Integer colorId, boolean save) {
        if (colorId == null) {
            return SwapDiff.blank();
        }
        SwapMode swapMode = save ? SwapMode.SAVE : SwapMode.PREVIEW;
        SwapDiff swapDiff = this.swap(type, colorId, swapMode);
        if (this.hoverSwapDiff != null) {
            swapDiff = swapDiff.mergeOver(this.hoverSwapDiff);
        }
        return swapDiff;
    }

    private SwapDiff swap(ColorType type, Integer colorId, SwapMode swapMode) {
        if (type == null || colorId == null) {
            return SwapDiff.blank();
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return SwapDiff.blank();
        }
        PlayerComposition composition = player.getPlayerComposition();
        if (composition == null) {
            return SwapDiff.blank();
        }
        try {
            int oldColorId = this.setColorId(composition, type, colorId);
            HashMap<ColorType, SwapDiff.Change> changes = new HashMap<ColorType, SwapDiff.Change>();
            changes.put(type, new SwapDiff.Change(oldColorId, this.savedSwaps.containsColor(type)));
            switch (swapMode) {
                case SAVE: {
                    this.savedSwaps.putColor(type, colorId);
                    break;
                }
                case REVERT: {
                    this.savedSwaps.removeColor(type);
                    break;
                }
            }
            return new SwapDiff(new HashMap<KitType, SwapDiff.Change>(), changes, null, null);
        }
        catch (Exception e) {
            return SwapDiff.blank();
        }
    }

    private SwapDiff swap(CompoundSwap s, SwapMode swapMode) {
        return this.swap(s, false, swapMode);
    }

    private SwapDiff swap(CompoundSwap s, SwapMode swapMode, SwapMode iconSwapMode) {
        return this.swap(s, false, ignore -> swapMode, iconSwapMode);
    }

    private SwapDiff swap(CompoundSwap s, boolean allowDisabledSwaps, SwapMode swapMode) {
        return this.swap(s, allowDisabledSwaps, ignore -> swapMode, swapMode);
    }

    private SwapDiff swap(CompoundSwap s, boolean allowDisabledSwaps, Function<KitType, SwapMode> swapModeProvider, SwapMode iconSwapMode) {
        switch (s.getType()) {
            case HEAD: {
                Integer headEquipId = s.getEquipmentIds().get(KitType.HEAD);
                Integer hairEquipId = s.getEquipmentIds().get(KitType.HAIR);
                Integer jawEquipId = s.getEquipmentIds().get(KitType.JAW);
                JawIcon icon = s.getIcon();
                return this.swapHead(headEquipId, hairEquipId, jawEquipId, icon, allowDisabledSwaps, swapModeProvider, iconSwapMode);
            }
            case TORSO: {
                Integer torsoEquipId = s.getEquipmentIds().get(KitType.TORSO);
                Integer armsEquipId = s.getEquipmentIds().get(KitType.ARMS);
                return this.swapTorso(torsoEquipId, armsEquipId, allowDisabledSwaps, swapModeProvider);
            }
            case WEAPONS: {
                Integer weaponEquipId = s.getEquipmentIds().get(KitType.WEAPON);
                Integer shieldEquipId = s.getEquipmentIds().get(KitType.SHIELD);
                return this.swapWeapons(weaponEquipId, shieldEquipId, allowDisabledSwaps, swapModeProvider);
            }
            case SINGLE: {
                return this.swapSingle(s.getKitType(), s.getEquipmentId(), allowDisabledSwaps, swapModeProvider.apply(s.getKitType()));
            }
        }
        return SwapDiff.blank();
    }

    private SwapDiff swapSingle(KitType slot, Integer equipmentId, boolean allowDisabledSwaps, SwapMode swapMode) {
        Map<SwapDiff.Change.Type, SwapDiff.Change> results = this.swap(slot, equipmentId, swapMode, SwapMode.PREVIEW, allowDisabledSwaps);
        HashMap<KitType, SwapDiff.Change> changes = new HashMap<KitType, SwapDiff.Change>();
        SwapDiff.Change iconChange = results.get((Object)SwapDiff.Change.Type.ICON);
        if (results.containsKey((Object)SwapDiff.Change.Type.EQUIPMENT)) {
            changes.put(slot, results.get((Object)SwapDiff.Change.Type.EQUIPMENT));
        }
        return new SwapDiff(changes, new HashMap<ColorType, SwapDiff.Change>(), iconChange, null);
    }

    private SwapDiff swapHead(Integer headEquipId, Integer hairEquipId, Integer jawEquipId, JawIcon icon, boolean allowDisabledSwaps, Function<KitType, SwapMode> swapModeProvider, SwapMode iconSwapMode) {
        Integer finalJawId;
        Integer finalHairId;
        Integer adjustedHairEquipId;
        JawIcon adjustedIcon;
        Integer finalHeadId = null;
        Function<Integer, Boolean> isJawlessIcon = equipId -> equipId >= 512 && JawKit.isNoJawIcon(equipId - 512);
        Function<Integer, Boolean> headAllowsHair = equipId -> equipId < 512 || ItemInteractions.HAIR_HELMS.contains(equipId - 512);
        Function<Integer, Boolean> headAllowsJaw = equipId -> equipId < 512 || !ItemInteractions.NO_JAW_HELMS.contains(equipId - 512);
        int currentHeadEquipId = this.equipmentIdInSlot(KitType.HEAD);
        Integer adjustedJawEquipId = !this.savedSwaps.isKitLocked(KitType.JAW) ? jawEquipId : null;
        JawIcon jawIcon = adjustedIcon = !this.savedSwaps.isIconLocked() ? icon : null;
        if (adjustedJawEquipId != null || icon != null) {
            adjustedJawEquipId = this.combineJawIcon(adjustedJawEquipId, adjustedIcon);
        }
        Integer n = adjustedHairEquipId = !this.savedSwaps.isKitLocked(KitType.HAIR) ? hairEquipId : null;
        if (this.savedSwaps.isItemLocked(KitType.HEAD)) {
            if (adjustedHairEquipId != null) {
                boolean hairAllowed = headAllowsHair.apply(currentHeadEquipId) != false && adjustedHairEquipId > 0 || headAllowsHair.apply(currentHeadEquipId) == false && adjustedHairEquipId <= 0;
                finalHairId = hairAllowed ? adjustedHairEquipId : null;
            } else {
                finalHairId = null;
            }
            if (adjustedJawEquipId != null) {
                boolean jawAllowed;
                boolean bl = jawAllowed = headAllowsJaw.apply(currentHeadEquipId) != false && adjustedJawEquipId > 0 || headAllowsJaw.apply(currentHeadEquipId) == false && (adjustedJawEquipId <= 0 || isJawlessIcon.apply(adjustedJawEquipId) != false);
                finalJawId = jawAllowed ? adjustedJawEquipId : (adjustedJawEquipId >= 512 ? Integer.valueOf(this.combineJawIcon(0, adjustedIcon)) : null);
            } else {
                finalJawId = null;
            }
        } else if (headEquipId == null) {
            boolean headForbidsHair;
            finalHairId = adjustedHairEquipId;
            finalJawId = adjustedJawEquipId;
            boolean bl = headForbidsHair = finalHairId != null && finalHairId > 0 && headAllowsHair.apply(currentHeadEquipId) == false;
            if (headForbidsHair) {
                finalHeadId = 0;
            } else {
                boolean headForbidsJaw;
                boolean bl2 = headForbidsJaw = finalJawId != null && finalJawId > 0 && isJawlessIcon.apply(finalJawId) == false && headAllowsJaw.apply(currentHeadEquipId) == false;
                if (headForbidsJaw) {
                    if (jawEquipId == null) {
                        finalJawId = this.combineJawIcon(0, adjustedIcon);
                    } else {
                        finalHeadId = 0;
                    }
                }
            }
        } else {
            boolean hairDisallowed = headAllowsHair.apply(headEquipId) == false && this.savedSwaps.isKitLocked(KitType.HAIR);
            boolean jawDisallowed = headAllowsJaw.apply(headEquipId) == false && this.savedSwaps.isKitLocked(KitType.JAW);
            finalHeadId = hairDisallowed || jawDisallowed ? null : headEquipId;
            Integer headIdToCheck = hairDisallowed || jawDisallowed ? currentHeadEquipId : headEquipId;
            Integer potentialHairId = headAllowsHair.apply(headIdToCheck) != false ? adjustedHairEquipId : Integer.valueOf(0);
            finalHairId = !this.savedSwaps.isKitLocked(KitType.HAIR) ? potentialHairId : null;
            Integer potentialJawId = headAllowsJaw.apply(headIdToCheck) != false || adjustedJawEquipId != null && isJawlessIcon.apply(adjustedJawEquipId) != false ? adjustedJawEquipId : Integer.valueOf(this.combineJawIcon(0, adjustedIcon));
            finalJawId = !this.savedSwaps.isKitLocked(KitType.JAW) ? potentialJawId : null;
        }
        HashMap<KitType, SwapDiff.Change> changes = new HashMap<KitType, SwapDiff.Change>();
        SwapDiff.Change[] iconChange = new SwapDiff.Change[]{null};
        if (finalHairId == null && this.equipmentIdInSlot(KitType.HAIR) == 0 && (finalHeadId == null && headAllowsHair.apply(currentHeadEquipId).booleanValue() || finalHeadId != null && headAllowsHair.apply(finalHeadId).booleanValue())) {
            if (this.savedSwaps.isKitLocked(KitType.HAIR)) {
                finalHeadId = null;
                finalJawId = null;
            } else {
                int revertHairId = this.savedSwaps.getRealKit(KitType.HAIR, this.isFemale) + 256;
                Map<SwapDiff.Change.Type, SwapDiff.Change> result = this.swap(KitType.HAIR, revertHairId, SwapMode.REVERT, SwapMode.PREVIEW, allowDisabledSwaps);
                if (result.containsKey((Object)SwapDiff.Change.Type.EQUIPMENT)) {
                    changes.put(KitType.HAIR, result.get((Object)SwapDiff.Change.Type.EQUIPMENT));
                }
            }
        }
        int currentJawEquipId = this.equipmentIdInSlot(KitType.JAW);
        if (finalJawId == null && (currentJawEquipId == 0 || isJawlessIcon.apply(currentJawEquipId).booleanValue()) && (finalHeadId == null && headAllowsJaw.apply(currentHeadEquipId).booleanValue() || finalHeadId != null && headAllowsJaw.apply(finalHeadId).booleanValue())) {
            if (this.savedSwaps.isKitLocked(KitType.JAW)) {
                finalHeadId = null;
                finalHairId = null;
            } else {
                int realKitId = this.savedSwaps.getRealKit(KitType.JAW, this.isFemale);
                int fallbackJawId = this.combineJawIcon(realKitId + 256, adjustedIcon);
                Map<SwapDiff.Change.Type, SwapDiff.Change> result = this.swap(KitType.JAW, fallbackJawId, SwapMode.REVERT, SwapMode.PREVIEW, allowDisabledSwaps);
                if (result.containsKey((Object)SwapDiff.Change.Type.EQUIPMENT)) {
                    changes.put(KitType.JAW, result.get((Object)SwapDiff.Change.Type.EQUIPMENT));
                }
            }
        }
        BiConsumer<KitType, Integer> attemptChange = (slot, equipId) -> {
            if (equipId != null && equipId >= 0) {
                Map<SwapDiff.Change.Type, SwapDiff.Change> result = this.swap((KitType)slot, (int)equipId, (SwapMode)((Object)((Object)swapModeProvider.apply((KitType)slot))), iconSwapMode, allowDisabledSwaps);
                if (result.containsKey((Object)SwapDiff.Change.Type.EQUIPMENT)) {
                    changes.put((KitType)slot, result.get((Object)SwapDiff.Change.Type.EQUIPMENT));
                }
                if (result.containsKey((Object)SwapDiff.Change.Type.ICON)) {
                    iconChange[0] = result.get((Object)SwapDiff.Change.Type.ICON);
                }
            }
        };
        attemptChange.accept(KitType.HEAD, finalHeadId);
        attemptChange.accept(KitType.HAIR, finalHairId);
        attemptChange.accept(KitType.JAW, finalJawId);
        return new SwapDiff(changes, new HashMap<ColorType, SwapDiff.Change>(), iconChange[0], null);
    }

    private SwapDiff swapTorso(Integer torsoEquipId, Integer armsEquipId, boolean allowDisabledSwaps, Function<KitType, SwapMode> swapModeProvider) {
        Integer finalArmsId;
        Integer finalTorsoId = null;
        Function<Integer, Boolean> torsoAllowsArms = equipId -> equipId < 512 || ItemInteractions.ARMS_TORSOS.contains(equipId - 512);
        HashMap<KitType, SwapDiff.Change> changes = new HashMap<KitType, SwapDiff.Change>();
        int currentTorsoEquipId = this.equipmentIdInSlot(KitType.TORSO);
        if (this.savedSwaps.isKitLocked(KitType.TORSO) || this.savedSwaps.isItemLocked(KitType.TORSO) && torsoEquipId != null && torsoEquipId >= 512) {
            if (this.savedSwaps.isKitLocked(KitType.ARMS) && armsEquipId != null) {
                boolean armsAllowed = torsoAllowsArms.apply(currentTorsoEquipId) != false && armsEquipId > 0 || torsoAllowsArms.apply(currentTorsoEquipId) == false && armsEquipId <= 0;
                finalArmsId = armsAllowed ? armsEquipId : null;
            } else {
                finalArmsId = null;
            }
        } else if (torsoEquipId == null) {
            int revertTorsoId;
            Map<SwapDiff.Change.Type, SwapDiff.Change> result;
            boolean torsoForbidsArms;
            finalArmsId = !this.savedSwaps.isKitLocked(KitType.ARMS) ? armsEquipId : null;
            boolean bl = torsoForbidsArms = torsoAllowsArms.apply(currentTorsoEquipId) == false && finalArmsId != null && finalArmsId > 0;
            if (torsoForbidsArms && (result = this.swap(KitType.TORSO, revertTorsoId = this.savedSwaps.getRealKit(KitType.TORSO, this.isFemale) + 256, SwapMode.REVERT, SwapMode.PREVIEW, allowDisabledSwaps)).containsKey((Object)SwapDiff.Change.Type.EQUIPMENT)) {
                changes.put(KitType.TORSO, result.get((Object)SwapDiff.Change.Type.EQUIPMENT));
            }
        } else {
            boolean torsoDisallowed = torsoAllowsArms.apply(torsoEquipId) == false && this.savedSwaps.isKitLocked(KitType.ARMS);
            finalTorsoId = torsoDisallowed ? null : torsoEquipId;
            Integer torsoIdToCheck = torsoDisallowed ? currentTorsoEquipId : torsoEquipId;
            Integer potentialArmsId = torsoAllowsArms.apply(torsoIdToCheck) != false ? armsEquipId : Integer.valueOf(0);
            Integer n = finalArmsId = !this.savedSwaps.isKitLocked(KitType.ARMS) ? potentialArmsId : null;
        }
        if (finalArmsId == null && this.equipmentIdInSlot(KitType.ARMS) == 0 && (finalTorsoId == null && torsoAllowsArms.apply(currentTorsoEquipId).booleanValue() || finalTorsoId != null && torsoAllowsArms.apply(finalTorsoId).booleanValue())) {
            if (this.savedSwaps.isKitLocked(KitType.ARMS)) {
                finalTorsoId = null;
            } else {
                int revertArmsId = this.savedSwaps.getRealKit(KitType.ARMS, this.isFemale) + 256;
                Map<SwapDiff.Change.Type, SwapDiff.Change> result = this.swap(KitType.ARMS, revertArmsId, SwapMode.REVERT, SwapMode.PREVIEW, allowDisabledSwaps);
                if (result.containsKey((Object)SwapDiff.Change.Type.EQUIPMENT)) {
                    changes.put(KitType.ARMS, result.get((Object)SwapDiff.Change.Type.EQUIPMENT));
                }
            }
        }
        BiConsumer<KitType, Integer> attemptChange = (slot, equipId) -> {
            Map<SwapDiff.Change.Type, SwapDiff.Change> result;
            if (equipId != null && equipId >= 0 && (result = this.swap((KitType)slot, (int)equipId, (SwapMode)((Object)((Object)swapModeProvider.apply((KitType)slot))), SwapMode.PREVIEW, allowDisabledSwaps)).containsKey((Object)SwapDiff.Change.Type.EQUIPMENT)) {
                changes.put((KitType)slot, result.get((Object)SwapDiff.Change.Type.EQUIPMENT));
            }
        };
        attemptChange.accept(KitType.TORSO, finalTorsoId);
        attemptChange.accept(KitType.ARMS, finalArmsId);
        return new SwapDiff(changes, new HashMap<ColorType, SwapDiff.Change>(), null, null);
    }

    private SwapDiff swapWeapons(Integer weaponEquipId, Integer shieldEquipId, boolean allowDisabledSwaps, Function<KitType, SwapMode> swapModeProvider) {
        Player player;
        Integer finalShieldId;
        Integer finalWeaponId = null;
        Integer finalAnimId = null;
        Function<Integer, Boolean> weaponForbidsShields = equipId -> {
            if (equipId >= 512) {
                ItemEquipmentStats stats = this.equipmentStatsFor(equipId - 512);
                return stats != null && stats.isTwoHanded();
            }
            return false;
        };
        if (weaponEquipId == null || this.savedSwaps.isItemLocked(KitType.WEAPON)) {
            finalShieldId = shieldEquipId;
            if (shieldEquipId != null && weaponForbidsShields.apply(this.equipmentIdInSlot(KitType.WEAPON)).booleanValue()) {
                if (!this.savedSwaps.isItemLocked(KitType.WEAPON)) {
                    finalWeaponId = 0;
                    finalAnimId = 808;
                } else {
                    finalShieldId = null;
                }
            }
        } else {
            finalShieldId = weaponForbidsShields.apply(weaponEquipId) != false && !this.savedSwaps.isItemLocked(KitType.SHIELD) ? Integer.valueOf(0) : shieldEquipId;
            finalWeaponId = weaponForbidsShields.apply(weaponEquipId) != false && this.savedSwaps.isItemLocked(KitType.SHIELD) ? null : weaponEquipId;
            finalAnimId = finalWeaponId != null ? ItemInteractions.WEAPON_TO_IDLE.getOrDefault(weaponEquipId - 512, 808) : null;
        }
        HashMap<KitType, SwapDiff.Change> changes = new HashMap<KitType, SwapDiff.Change>();
        BiConsumer<KitType, Integer> attemptChange = (slot, equipId) -> {
            Map<SwapDiff.Change.Type, SwapDiff.Change> results;
            if (equipId != null && equipId >= 0 && (results = this.swap((KitType)slot, (int)equipId, (SwapMode)((Object)((Object)swapModeProvider.apply((KitType)slot))), SwapMode.PREVIEW, allowDisabledSwaps)).containsKey((Object)SwapDiff.Change.Type.EQUIPMENT)) {
                changes.put((KitType)slot, results.get((Object)SwapDiff.Change.Type.EQUIPMENT));
            }
        };
        attemptChange.accept(KitType.WEAPON, finalWeaponId);
        attemptChange.accept(KitType.SHIELD, finalShieldId);
        Integer changedAnim = null;
        if (finalAnimId != null && finalAnimId >= 0 && (player = this.client.getLocalPlayer()) != null && (changedAnim = Integer.valueOf(this.setIdleAnimationId(player, finalAnimId, allowDisabledSwaps))).equals(finalAnimId)) {
            changedAnim = null;
        }
        return new SwapDiff(changes, new HashMap<ColorType, SwapDiff.Change>(), null, changedAnim);
    }

    private Map<SwapDiff.Change.Type, SwapDiff.Change> swap(KitType slot, int equipmentId, SwapMode swapMode, SwapMode iconSwapMode, boolean allowDisabledSwaps) {
        int oldId;
        HashMap<SwapDiff.Change.Type, SwapDiff.Change> changes = new HashMap<SwapDiff.Change.Type, SwapDiff.Change>();
        if (slot == null) {
            return changes;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return changes;
        }
        PlayerComposition composition = player.getPlayerComposition();
        if (composition == null) {
            return changes;
        }
        Function<Integer, Integer> deIconJaw = equipId -> {
            Integer kitId;
            JawKit kit = JawKit.fromEquipmentId(equipId);
            if (kit != null && (kitId = kit.getKitId(this.isFemale)) != null) {
                return kitId + 256;
            }
            return equipId;
        };
        int saveId = equipmentId;
        if (slot == KitType.JAW && equipmentId >= 512) {
            saveId = deIconJaw.apply(equipmentId);
        }
        Supplier<Boolean> unnaturalCheck = () -> this.savedSwaps.containsSlot(slot) || this.savedSwaps.isHidden(slot);
        Supplier<Boolean> unnaturalIconCheck = () -> this.savedSwaps.containsIcon();
        int oldSaveId = oldId = this.setEquipmentId(composition, slot, equipmentId, allowDisabledSwaps);
        if (slot == KitType.JAW && oldId >= 512) {
            oldSaveId = deIconJaw.apply(oldId);
        }
        boolean oldUnnatural = unnaturalCheck.get();
        switch (swapMode) {
            case SAVE: {
                if (saveId <= 0) {
                    if (ALLOWS_NOTHING.contains(slot)) {
                        this.savedSwaps.putNothing(slot);
                        break;
                    }
                    this.savedSwaps.removeSlot(slot);
                    break;
                }
                if (saveId < 512) {
                    this.savedSwaps.putKit(slot, saveId - 256);
                    break;
                }
                this.savedSwaps.putItem(slot, saveId - 512);
                break;
            }
            case REVERT: {
                this.savedSwaps.removeSlot(slot);
                break;
            }
        }
        if (slot == KitType.JAW) {
            boolean oldUnnaturalIcon = unnaturalIconCheck.get();
            JawIcon oldIcon = oldId >= 512 ? JawKit.iconFromItemId(oldId - 512) : JawIcon.NOTHING;
            JawIcon icon = equipmentId >= 512 ? JawKit.iconFromItemId(equipmentId - 512) : JawIcon.NOTHING;
            switch (iconSwapMode) {
                case SAVE: {
                    if (equipmentId < 512) {
                        this.savedSwaps.removeIcon();
                        break;
                    }
                    this.savedSwaps.putIcon(icon);
                    break;
                }
                case REVERT: {
                    this.savedSwaps.removeIcon();
                    break;
                }
            }
            boolean unnaturalIcon = unnaturalIconCheck.get();
            if (!Objects.equals((Object)icon, (Object)oldIcon) || oldUnnaturalIcon != unnaturalIcon) {
                changes.put(SwapDiff.Change.Type.ICON, new SwapDiff.Change(oldIcon.getId(), oldUnnaturalIcon));
            }
        }
        boolean unnatural = unnaturalCheck.get();
        if (oldSaveId != saveId || oldUnnatural != unnatural) {
            changes.put(SwapDiff.Change.Type.EQUIPMENT, new SwapDiff.Change(oldSaveId, oldUnnatural));
        }
        return changes;
    }

    private int setEquipmentId(@Nonnull PlayerComposition composition, @Nonnull KitType slot, int equipmentId, boolean allowDisabledSwaps) {
        int previousId = composition.getEquipmentIds()[slot.getIndex()];
        if (allowDisabledSwaps || !this.disabledSlots.containsKey(slot)) {
            composition.getEquipmentIds()[slot.getIndex()] = equipmentId;
            composition.setHash();
        }
        return previousId;
    }

    private int setColorId(@Nonnull PlayerComposition composition, @Nonnull ColorType type, int colorId) {
        int[] colors = composition.getColors();
        int previousId = colors[type.ordinal()];
        colors[type.ordinal()] = colorId;
        composition.setHash();
        return previousId;
    }

    private int setIdleAnimationId(@Nonnull Player player, int animationId, boolean allowDisabledSwaps) {
        int previousId = player.getIdlePoseAnimation();
        if (allowDisabledSwaps || !this.disabledSlots.containsKey(KitType.WEAPON)) {
            player.setIdlePoseAnimation(animationId);
        }
        return previousId;
    }

    private SwapDiff doRevert(KitType slot) {
        Integer torsoItemId;
        Integer headItemId;
        if (slot == KitType.HAIR) {
            headItemId = this.inventoryItemId(KitType.HEAD);
            if (headItemId != null && headItemId >= 0 && !ItemInteractions.HAIR_HELMS.contains(headItemId)) {
                return this.swap(CompoundSwap.single(KitType.HEAD, headItemId + 512), SwapMode.REVERT, SwapMode.PREVIEW);
            }
        } else if (slot == KitType.JAW) {
            headItemId = this.inventoryItemId(KitType.HEAD);
            if (headItemId != null && headItemId >= 0 && ItemInteractions.NO_JAW_HELMS.contains(headItemId)) {
                return this.swap(CompoundSwap.single(KitType.HEAD, headItemId + 512), SwapMode.REVERT, SwapMode.PREVIEW);
            }
        } else if (slot == KitType.ARMS && (torsoItemId = this.inventoryItemId(KitType.TORSO)) != null && torsoItemId >= 0 && !ItemInteractions.ARMS_TORSOS.contains(torsoItemId)) {
            return this.swap(CompoundSwap.single(KitType.TORSO, torsoItemId + 512), SwapMode.REVERT, SwapMode.PREVIEW);
        }
        Integer originalItemId = this.inventoryItemId(slot);
        Integer originalKitId = this.savedSwaps.getRealKit(slot, this.isFemale);
        if (originalKitId == -256) {
            originalKitId = null;
        }
        int equipmentId = originalItemId != null ? (originalItemId < 0 ? 0 : originalItemId + 512) : (originalKitId != null ? (originalKitId < 0 ? 0 : originalKitId + 256) : 0);
        return this.swap(CompoundSwap.single(slot, equipmentId), SwapMode.REVERT, SwapMode.PREVIEW);
    }

    private SwapDiff doRevert(ColorType type) {
        Integer originalColorId = this.savedSwaps.getRealColor(type);
        return this.swap(type, originalColorId, SwapMode.REVERT);
    }

    private SwapDiff doRevertIcon() {
        Integer kitId;
        int jawEquipId;
        JawKit kit;
        JawIcon revertIcon = this.savedSwaps.getRealIcon();
        if (revertIcon == null) {
            revertIcon = JawIcon.NOTHING;
        }
        if ((kit = JawKit.fromEquipmentId(jawEquipId = this.combineJawIcon(null, revertIcon))) != null && (kitId = kit.getKitId(this.isFemale)) != null) {
            Map<SwapDiff.Change.Type, SwapDiff.Change> changes = this.swap(KitType.JAW, kitId + 256, SwapMode.PREVIEW, SwapMode.REVERT, false);
            SwapDiff.Change iconChange = changes.get((Object)SwapDiff.Change.Type.ICON);
            return new SwapDiff(new HashMap<KitType, SwapDiff.Change>(), new HashMap<ColorType, SwapDiff.Change>(), iconChange, null);
        }
        return SwapDiff.blank();
    }

    private int combineJawIcon(Integer jawEquipId, @Nullable JawIcon icon) {
        Integer itemId;
        JawIcon finalJawIcon;
        Integer jawKitId;
        int finalJawId = jawEquipId != null ? jawEquipId : ((jawKitId = this.savedSwaps.getKit(KitType.JAW)) != null ? jawKitId + 256 : this.savedSwaps.getRealKit(KitType.JAW, this.isFemale) + 256);
        if (icon != null) {
            finalJawIcon = icon;
        } else {
            finalJawIcon = this.savedSwaps.getSwappedIcon();
            if (finalJawIcon == null) {
                finalJawIcon = this.savedSwaps.getRealIcon();
            }
            if (finalJawIcon == null) {
                finalJawIcon = JawIcon.NOTHING;
            }
        }
        JawKit kit = JawKit.fromEquipmentId(finalJawId);
        if (kit != null && (itemId = kit.getIconItemId(finalJawIcon)) != null) {
            return itemId + 512;
        }
        return finalJawId;
    }

    @Nullable
    private KitType slotForId(Integer slotId) {
        if (slotId == null) {
            return null;
        }
        return Arrays.stream(KitType.values()).filter(type -> type.getIndex() == slotId.intValue()).findFirst().orElse(null);
    }

    private boolean isOpen(KitType slot) {
        if (slot == null || this.savedSwaps.isKitLocked(slot) || this.savedSwaps.containsItem(slot)) {
            return false;
        }
        Supplier<Boolean> fallback = () -> {
            if (this.equipmentIdInSlot(slot) > 0) {
                return true;
            }
            Integer actualEquipId = this.inventoryItemId(slot);
            return actualEquipId == null || actualEquipId < 512;
        };
        switch (slot) {
            case HAIR: 
            case JAW: {
                int headEquipId = this.equipmentIdInSlot(KitType.HEAD);
                if (headEquipId > 512) {
                    int headItemId = headEquipId - 512;
                    if (slot == KitType.HAIR) {
                        return ItemInteractions.HAIR_HELMS.contains(headItemId);
                    }
                    return !ItemInteractions.NO_JAW_HELMS.contains(headItemId);
                }
                return fallback.get();
            }
            case ARMS: {
                int torsoEquipId = this.equipmentIdInSlot(KitType.TORSO);
                if (torsoEquipId > 512) {
                    int torsoItemId = torsoEquipId - 512;
                    return ItemInteractions.ARMS_TORSOS.contains(torsoItemId);
                }
                return fallback.get();
            }
        }
        return fallback.get();
    }

    @Nullable
    private ItemEquipmentStats equipmentStatsFor(int itemId) {
        ItemStats stats = this.itemManager.getItemStats(itemId, false);
        return stats != null && stats.isEquipable() ? stats.getEquipment() : null;
    }

    private int equipmentIdInSlot(KitType kitType) {
        Integer kitId;
        if (this.savedSwaps.isHidden(kitType)) {
            return 0;
        }
        Integer virtualItemId = this.savedSwaps.getItem(kitType);
        if (virtualItemId != null && virtualItemId >= 0) {
            return virtualItemId + 512;
        }
        Integer realItemId = this.inventoryItemId(kitType);
        if (realItemId != null && realItemId >= 0) {
            boolean realItemHidden = false;
            switch (kitType) {
                case HEAD: {
                    realItemHidden = !ItemInteractions.HAIR_HELMS.contains(realItemId) && this.savedSwaps.containsSlot(KitType.HAIR) || ItemInteractions.NO_JAW_HELMS.contains(realItemId) && this.savedSwaps.containsSlot(KitType.JAW);
                    break;
                }
                case TORSO: {
                    realItemHidden = !ItemInteractions.ARMS_TORSOS.contains(realItemId) && this.savedSwaps.containsSlot(KitType.ARMS);
                    break;
                }
            }
            if (!realItemHidden) {
                return realItemId + 512;
            }
        }
        if (kitType == KitType.JAW) {
            boolean jawlessIcon;
            int jawEquipId = this.combineJawIcon(null, null);
            int headEquipId = this.equipmentIdInSlot(KitType.HEAD);
            boolean bl = jawlessIcon = jawEquipId >= 512 && JawKit.isNoJawIcon(jawEquipId - 512);
            if (!ItemInteractions.NO_JAW_HELMS.contains(headEquipId - 512) || jawEquipId <= 0 || jawlessIcon) {
                return jawEquipId;
            }
        }
        return (kitId = this.kitIdFor(kitType)) != null && kitId >= 0 ? kitId + 256 : 0;
    }

    @Nullable
    public Integer inventoryItemId(KitType kitType) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return null;
        }
        PlayerComposition composition = player.getPlayerComposition();
        if (composition == null) {
            return null;
        }
        ItemContainer inventory = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (inventory == null) {
            return null;
        }
        Item item = inventory.getItem(kitType.getIndex());
        return item != null && item.getId() >= 0 ? Integer.valueOf(item.getId()) : null;
    }

    @Nullable
    private Integer kitIdFor(KitType kitType) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return null;
        }
        PlayerComposition composition = player.getPlayerComposition();
        return composition == null ? null : Integer.valueOf(composition.getKitId(kitType));
    }

    @Nullable
    private Integer colorIdFor(ColorType colorType) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return null;
        }
        PlayerComposition composition = player.getPlayerComposition();
        if (composition == null) {
            return null;
        }
        int[] colors = composition.getColors();
        return colors[colorType.ordinal()];
    }

    private SwapDiff restore(SwapDiff swapDiff, boolean save) {
        Function<KitType, SwapMode> swapModeProvider = slot -> {
            SwapDiff.Change change = swapDiff.getSlotChanges().get(slot);
            return !save ? SwapMode.PREVIEW : (change != null && change.isUnnatural() ? SwapMode.SAVE : SwapMode.REVERT);
        };
        SwapDiff.Change iconChange = swapDiff.getIconChange();
        SwapMode iconSwapMode = !save || iconChange == null ? SwapMode.PREVIEW : (iconChange.isUnnatural() ? SwapMode.SAVE : SwapMode.REVERT);
        JawIcon icon = iconChange != null ? JawIcon.fromId(iconChange.getId()) : null;
        Map<KitType, Integer> restoreEquipIds = this.sanitize(swapDiff.getSlotChanges().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SwapDiff.Change)e.getValue()).getId())));
        SwapDiff slotRestore = CompoundSwap.fromMap(restoreEquipIds, icon).stream().map(c -> this.swap((CompoundSwap)c, false, swapModeProvider, iconSwapMode)).reduce(SwapDiff::mergeOver).orElse(SwapDiff.blank());
        SwapDiff colorRestore = swapDiff.getColorChanges().entrySet().stream().map(e -> {
            ColorType type = (ColorType)((Object)((Object)e.getKey()));
            SwapDiff.Change change = (SwapDiff.Change)e.getValue();
            int colorId = change.getId();
            SwapMode mode = save ? (change.isUnnatural() ? SwapMode.SAVE : SwapMode.REVERT) : SwapMode.PREVIEW;
            return this.swap(type, colorId, mode);
        }).reduce(SwapDiff::mergeOver).orElse(SwapDiff.blank());
        return slotRestore.mergeOver(colorRestore);
    }

    @Nullable
    private KitType itemSlotMatch(String name) {
        try {
            return KitType.valueOf((String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private KitType kitSlotMatch(String name) {
        try {
            String k = name.replace(KIT_SUFFIX, "");
            return KitType.valueOf((String)k);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private ColorType colorSlotMatch(String name) {
        try {
            String c = name.replace(COLOR_SUFFIX, "");
            return ColorType.valueOf(c);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void sendHighlightedMessage(String message) {
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(message).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
    }

    public void setIsFemale(Boolean isFemale) {
        this.isFemale = isFemale;
    }

    static {
        NEVER_ZERO_SLOTS_FEMALE = ImmutableList.of((Object)KitType.TORSO, (Object)KitType.LEGS, (Object)KitType.HAIR, (Object)KitType.HANDS, (Object)KitType.BOOTS);
        NEVER_ZERO_SLOTS_MALE = ImmutableList.of((Object)KitType.TORSO, (Object)KitType.LEGS, (Object)KitType.HAIR, (Object)KitType.HANDS, (Object)KitType.BOOTS, (Object)KitType.JAW);
        KIT_TYPE_TO_KITS = Arrays.stream(KitType.values()).collect(Collectors.toMap(s -> s, s -> Arrays.asList(Kit.allInSlot(s, true))));
        for (KitType slot : KitType.values()) {
            for (Kit value : Kit.allInSlot(slot, true)) {
                Integer femaleId;
                Integer maleId = value.getKitId(false);
                if (maleId != null) {
                    KIT_ID_TO_KIT.put(maleId, value);
                }
                if ((femaleId = value.getKitId(true)) == null) continue;
                KIT_ID_TO_KIT.put(femaleId, value);
            }
        }
    }

    private static final class Candidate {
        public final int itemId;
        public final KitType slot;

        public Candidate(int itemId, KitType slot) {
            this.itemId = itemId;
            this.slot = slot;
        }

        public int getItemId() {
            return this.itemId;
        }

        public KitType getSlot() {
            return this.slot;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Candidate)) {
                return false;
            }
            Candidate other = (Candidate)o;
            if (this.getItemId() != other.getItemId()) {
                return false;
            }
            KitType this$slot = this.getSlot();
            KitType other$slot = other.getSlot();
            return !(this$slot == null ? other$slot != null : !this$slot.equals(other$slot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getItemId();
            KitType $slot = this.getSlot();
            result = result * 59 + ($slot == null ? 43 : $slot.hashCode());
            return result;
        }

        public String toString() {
            return "SwapManager.Candidate(itemId=" + this.getItemId() + ", slot=" + this.getSlot() + ")";
        }
    }
}

