/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.swap;

import eq.uirs.fashionscape.swap.SwapDiff;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SwapDiffHistory {
    private static final Logger log = LoggerFactory.getLogger(SwapDiffHistory.class);
    private final Function<SwapDiff, SwapDiff> restoration;
    private static final int MAX_LIST_SIZE = 10;
    private final LinkedList<SwapDiff> undoSwapDiffs = new LinkedList();
    private final List<Consumer<Integer>> undoCountListeners = new LinkedList<Consumer<Integer>>();
    private final LinkedList<SwapDiff> redoSwapDiffs = new LinkedList();
    private final List<Consumer<Integer>> redoCountListeners = new LinkedList<Consumer<Integer>>();

    void addUndoQueueChangeListener(Consumer<Integer> listener) {
        this.undoCountListeners.add(listener);
    }

    void addRedoQueueChangeListener(Consumer<Integer> listener) {
        this.redoCountListeners.add(listener);
    }

    void removeListeners() {
        this.undoCountListeners.clear();
        this.redoCountListeners.clear();
    }

    void undoLast() {
        if (this.undoSwapDiffs.isEmpty()) {
            return;
        }
        SwapDiff last = this.undoSwapDiffs.removeLast();
        this.undoCountListeners.forEach(listener -> listener.accept(this.undoSwapDiffs.size()));
        SwapDiff redo = this.restoration.apply(last);
        this.addRedoDiff(redo);
    }

    void redoLast() {
        if (this.redoSwapDiffs.isEmpty()) {
            return;
        }
        SwapDiff last = this.redoSwapDiffs.removeLast();
        this.redoCountListeners.forEach(listener -> listener.accept(this.redoSwapDiffs.size()));
        SwapDiff restore = this.restoration.apply(last);
        this.addUndoDiff(restore);
    }

    void appendToUndo(SwapDiff swapDiff) {
        if (swapDiff.isBlank()) {
            return;
        }
        this.addUndoDiff(swapDiff);
        this.redoSwapDiffs.clear();
        this.redoCountListeners.forEach(listener -> listener.accept(0));
    }

    int undoSize() {
        return this.undoSwapDiffs.size();
    }

    int redoSize() {
        return this.redoSwapDiffs.size();
    }

    private void addUndoDiff(SwapDiff swapDiff) {
        if (swapDiff.isBlank()) {
            return;
        }
        SwapDiff lastUndo = this.undoSwapDiffs.peekLast();
        if (swapDiff.equals(lastUndo)) {
            return;
        }
        this.undoSwapDiffs.add(swapDiff);
        while (this.undoSwapDiffs.size() > 10) {
            this.undoSwapDiffs.removeFirst();
        }
        this.undoCountListeners.forEach(listener -> listener.accept(this.undoSwapDiffs.size()));
    }

    private void addRedoDiff(SwapDiff swapDiff) {
        if (swapDiff.isBlank()) {
            return;
        }
        SwapDiff lastRedo = this.redoSwapDiffs.peekLast();
        if (swapDiff.equals(lastRedo)) {
            return;
        }
        this.redoSwapDiffs.add(swapDiff);
        while (this.redoSwapDiffs.size() > 10) {
            this.redoSwapDiffs.removeFirst();
        }
        this.redoCountListeners.forEach(listener -> listener.accept(this.redoSwapDiffs.size()));
    }

    public SwapDiffHistory(Function<SwapDiff, SwapDiff> restoration) {
        this.restoration = restoration;
    }
}

