/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.swap;

import eq.uirs.fashionscape.data.ColorType;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.kit.KitType;

class SwapDiff {
    private final Map<KitType, Change> slotChanges;
    private final Map<ColorType, Change> colorChanges;
    private final Change iconChange;
    private final Integer changedIdleAnimationId;

    public static SwapDiff blank() {
        return new SwapDiff(new HashMap<KitType, Change>(), new HashMap<ColorType, Change>(), null, null);
    }

    boolean isBlank() {
        return this.changedIdleAnimationId == null && this.iconChange == null && this.slotChanges.isEmpty() && this.colorChanges.isEmpty();
    }

    SwapDiff mergeOver(SwapDiff other) {
        Integer idleId;
        HashMap<KitType, Change> mergedSlots = new HashMap<KitType, Change>();
        mergedSlots.putAll(other.slotChanges);
        mergedSlots.putAll(this.slotChanges);
        HashMap<ColorType, Change> mergedColors = new HashMap<ColorType, Change>();
        mergedColors.putAll(other.colorChanges);
        mergedColors.putAll(this.colorChanges);
        Change iconChange = this.iconChange;
        if (iconChange == null) {
            iconChange = other.iconChange;
        }
        if ((idleId = this.changedIdleAnimationId) == null) {
            idleId = other.changedIdleAnimationId;
        }
        return new SwapDiff(mergedSlots, mergedColors, iconChange, idleId);
    }

    public SwapDiff(Map<KitType, Change> slotChanges, Map<ColorType, Change> colorChanges, Change iconChange, Integer changedIdleAnimationId) {
        this.slotChanges = slotChanges;
        this.colorChanges = colorChanges;
        this.iconChange = iconChange;
        this.changedIdleAnimationId = changedIdleAnimationId;
    }

    public String toString() {
        return "SwapDiff(slotChanges=" + this.getSlotChanges() + ", colorChanges=" + this.getColorChanges() + ", iconChange=" + this.getIconChange() + ", changedIdleAnimationId=" + this.getChangedIdleAnimationId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwapDiff)) {
            return false;
        }
        SwapDiff other = (SwapDiff)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$changedIdleAnimationId = this.getChangedIdleAnimationId();
        Integer other$changedIdleAnimationId = other.getChangedIdleAnimationId();
        if (this$changedIdleAnimationId == null ? other$changedIdleAnimationId != null : !((Object)this$changedIdleAnimationId).equals(other$changedIdleAnimationId)) {
            return false;
        }
        Map<KitType, Change> this$slotChanges = this.getSlotChanges();
        Map<KitType, Change> other$slotChanges = other.getSlotChanges();
        if (this$slotChanges == null ? other$slotChanges != null : !((Object)this$slotChanges).equals(other$slotChanges)) {
            return false;
        }
        Map<ColorType, Change> this$colorChanges = this.getColorChanges();
        Map<ColorType, Change> other$colorChanges = other.getColorChanges();
        if (this$colorChanges == null ? other$colorChanges != null : !((Object)this$colorChanges).equals(other$colorChanges)) {
            return false;
        }
        Change this$iconChange = this.getIconChange();
        Change other$iconChange = other.getIconChange();
        return !(this$iconChange == null ? other$iconChange != null : !((Object)this$iconChange).equals(other$iconChange));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SwapDiff;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $changedIdleAnimationId = this.getChangedIdleAnimationId();
        result = result * 59 + ($changedIdleAnimationId == null ? 43 : ((Object)$changedIdleAnimationId).hashCode());
        Map<KitType, Change> $slotChanges = this.getSlotChanges();
        result = result * 59 + ($slotChanges == null ? 43 : ((Object)$slotChanges).hashCode());
        Map<ColorType, Change> $colorChanges = this.getColorChanges();
        result = result * 59 + ($colorChanges == null ? 43 : ((Object)$colorChanges).hashCode());
        Change $iconChange = this.getIconChange();
        result = result * 59 + ($iconChange == null ? 43 : ((Object)$iconChange).hashCode());
        return result;
    }

    public Map<KitType, Change> getSlotChanges() {
        return this.slotChanges;
    }

    public Map<ColorType, Change> getColorChanges() {
        return this.colorChanges;
    }

    public Change getIconChange() {
        return this.iconChange;
    }

    public Integer getChangedIdleAnimationId() {
        return this.changedIdleAnimationId;
    }

    public static final class Change {
        private final int id;
        private final boolean unnatural;

        public Change(int id, boolean unnatural) {
            this.id = id;
            this.unnatural = unnatural;
        }

        public int getId() {
            return this.id;
        }

        public boolean isUnnatural() {
            return this.unnatural;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Change)) {
                return false;
            }
            Change other = (Change)o;
            if (this.getId() != other.getId()) {
                return false;
            }
            return this.isUnnatural() == other.isUnnatural();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            result = result * 59 + (this.isUnnatural() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "SwapDiff.Change(id=" + this.getId() + ", unnatural=" + this.isUnnatural() + ")";
        }

        public static enum Type {
            EQUIPMENT,
            COLOR,
            ICON;

        }
    }
}

