/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.swap;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import eq.uirs.fashionscape.FashionscapeConfig;
import eq.uirs.fashionscape.data.ColorType;
import eq.uirs.fashionscape.data.kit.ArmsKit;
import eq.uirs.fashionscape.data.kit.BootsKit;
import eq.uirs.fashionscape.data.kit.HairKit;
import eq.uirs.fashionscape.data.kit.HandsKit;
import eq.uirs.fashionscape.data.kit.JawIcon;
import eq.uirs.fashionscape.data.kit.JawKit;
import eq.uirs.fashionscape.data.kit.LegsKit;
import eq.uirs.fashionscape.data.kit.TorsoKit;
import eq.uirs.fashionscape.swap.event.ColorChanged;
import eq.uirs.fashionscape.swap.event.ColorLockChanged;
import eq.uirs.fashionscape.swap.event.IconChanged;
import eq.uirs.fashionscape.swap.event.IconLockChanged;
import eq.uirs.fashionscape.swap.event.ItemChanged;
import eq.uirs.fashionscape.swap.event.KitChanged;
import eq.uirs.fashionscape.swap.event.KnownKitChanged;
import eq.uirs.fashionscape.swap.event.LockChanged;
import eq.uirs.fashionscape.swap.event.SwapEvent;
import eq.uirs.fashionscape.swap.event.SwapEventListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.kit.KitType;
import net.runelite.client.config.ConfigManager;
import org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class SavedSwaps {
    private static final Logger log = LoggerFactory.getLogger(SavedSwaps.class);
    private static final int DEBOUNCE_DELAY_MS = 500;
    private static final Map<KitType, Integer> FALLBACK_MALE_KITS = new HashMap<KitType, Integer>();
    private static final Map<KitType, Integer> FALLBACK_FEMALE_KITS = new HashMap<KitType, Integer>();
    @Inject
    private FashionscapeConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ScheduledExecutorService executor;
    private final HashMap<KitType, Integer> realKitIds = new HashMap();
    private final Map<ColorType, Integer> realColorIds = new HashMap<ColorType, Integer>();
    private JawIcon realIcon = JawIcon.NOTHING;
    private final HashMap<KitType, Integer> swappedItemIds = new HashMap();
    private final HashMap<KitType, Integer> swappedKitIds = new HashMap();
    private final HashMap<ColorType, Integer> swappedColorIds = new HashMap();
    private JawIcon swappedIcon = null;
    private final HashSet<KitType> hiddenSlots = new HashSet();
    private final Set<KitType> lockedKits = new HashSet<KitType>();
    private final Set<KitType> lockedItems = new HashSet<KitType>();
    private final Set<ColorType> lockedColors = new HashSet<ColorType>();
    private boolean lockedIcon = false;
    private final Map<String, List<SwapEventListener<? extends SwapEvent>>> listeners = new HashMap<String, List<SwapEventListener<? extends SwapEvent>>>();
    private boolean hasLoadedConfig = false;
    private Future<?> colorSaveFuture = null;
    private Future<?> kitsSaveFuture = null;
    private Future<?> equipSaveFuture = null;

    SavedSwaps() {
    }

    void loadFromConfig() {
        if (this.hasLoadedConfig) {
            return;
        }
        this.hasLoadedConfig = true;
        byte[] equipment = this.config.currentEquipment();
        byte[] colors = this.config.currentColors();
        Integer iconId = this.config.currentIcon();
        try {
            Map equipIds = (Map)SerializationUtils.deserialize((byte[])equipment);
            equipIds.forEach((slot, equipId) -> {
                if (equipId >= 256 && equipId < 512) {
                    this.putKit((KitType)slot, equipId - 256);
                } else if (equipId >= 512) {
                    this.putItem((KitType)slot, equipId - 512);
                }
            });
            Map colorIds = (Map)SerializationUtils.deserialize((byte[])colors);
            colorIds.forEach(this::putColor);
            JawIcon icon = JawIcon.fromId(iconId);
            if (icon != null) {
                this.putIcon(icon);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void loadRSProfileConfig() {
        byte[] realKits = (byte[])this.configManager.getRSProfileConfiguration("fashionscape", "realKitIds", byte[].class);
        try {
            this.realKitIds.putAll((Map)SerializationUtils.deserialize((byte[])realKits));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addEventListener(SwapEventListener<? extends SwapEvent> listener) {
        String key = listener.getKey();
        List list = this.listeners.getOrDefault(key, new LinkedList());
        list.add(listener);
        this.listeners.put(key, list);
    }

    void removeListeners() {
        this.listeners.clear();
    }

    Set<Map.Entry<KitType, Integer>> itemEntries() {
        return ImmutableSet.copyOf(this.swappedItemIds.entrySet());
    }

    Set<Map.Entry<KitType, Integer>> hiddenSlotEntries() {
        return ImmutableSet.copyOf(this.hiddenSlots.stream().collect(Collectors.toMap(v -> v, v -> 0)).entrySet());
    }

    Set<Map.Entry<KitType, Integer>> kitEntries() {
        return ImmutableSet.copyOf(this.swappedKitIds.entrySet());
    }

    Set<Map.Entry<ColorType, Integer>> colorEntries() {
        return ImmutableSet.copyOf(this.swappedColorIds.entrySet());
    }

    Integer getItem(KitType slot) {
        return this.swappedItemIds.get(slot);
    }

    Integer getKit(KitType slot) {
        return this.swappedKitIds.get(slot);
    }

    Integer getColor(ColorType type) {
        return this.swappedColorIds.get((Object)type);
    }

    Integer getRealColor(ColorType type) {
        return this.realColorIds.get((Object)type);
    }

    Integer getRealKit(KitType slot) {
        return this.realKitIds.get(slot);
    }

    int getRealKit(KitType slot, Boolean isFemale) {
        Integer realKit = this.getRealKit(slot);
        return realKit != null ? realKit.intValue() : this.getFallbackKit(slot, isFemale);
    }

    int getFallbackKit(KitType slot, Boolean isFemale) {
        if (isFemale == null || slot == null) {
            return -256;
        }
        Map<KitType, Integer> map = isFemale != false ? FALLBACK_FEMALE_KITS : FALLBACK_MALE_KITS;
        int result = map.getOrDefault(slot, -256);
        if (result != -256) {
            this.fireEvent(new KnownKitChanged(true, slot));
        }
        return result;
    }

    boolean containsSlot(KitType slot) {
        if (this.swappedKitIds.containsKey(slot)) {
            return true;
        }
        return this.containsItem(slot);
    }

    boolean containsItem(KitType slot) {
        return this.swappedItemIds.containsKey(slot);
    }

    boolean containsIcon() {
        return this.swappedIcon != null;
    }

    boolean isHidden(KitType slot) {
        return this.hiddenSlots.contains(slot);
    }

    boolean containsColor(ColorType type) {
        return this.swappedColorIds.containsKey((Object)type);
    }

    void putItem(KitType slot, Integer itemId) {
        if (this.isSlotLocked(slot)) {
            return;
        }
        if (slot == KitType.JAW) {
            log.warn("putting jaw {} - this should not happen", (Object)itemId);
        }
        Integer oldId = this.swappedItemIds.put(slot, itemId);
        this.hiddenSlots.remove(slot);
        if (this.swappedKitIds.containsKey(slot)) {
            this.removeKit(slot);
        }
        if (!itemId.equals(oldId)) {
            this.fireEvent(new ItemChanged(slot, itemId));
            this.saveEquipmentConfigDebounced();
        }
    }

    void putIcon(JawIcon icon) {
        Integer previousId = this.swappedIcon != null ? Integer.valueOf(this.swappedIcon.getId()) : null;
        Integer newId = icon != null ? Integer.valueOf(icon.getId()) : null;
        this.swappedIcon = icon;
        if (!Objects.equal((Object)previousId, (Object)newId)) {
            this.fireEvent(new IconChanged(icon));
            this.saveEquipmentConfigDebounced();
        }
    }

    void putNothing(KitType slot) {
        if (this.lockedItems.contains(slot)) {
            return;
        }
        Integer oldId = this.swappedItemIds.remove(slot);
        boolean wasNotHidden = this.hiddenSlots.add(slot);
        if (oldId != null || wasNotHidden) {
            this.fireEvent(new ItemChanged(slot, -1));
            this.saveEquipmentConfigDebounced();
        }
    }

    void putKit(KitType slot, Integer kitId) {
        if (this.lockedKits.contains(slot)) {
            return;
        }
        Integer oldId = this.swappedKitIds.put(slot, kitId);
        if (this.swappedItemIds.containsKey(slot)) {
            this.removeItem(slot);
        }
        if (!kitId.equals(oldId)) {
            this.fireEvent(new KitChanged(slot, kitId));
            this.saveEquipmentConfigDebounced();
        }
    }

    void putColor(ColorType type, Integer colorId) {
        Integer oldId = this.swappedColorIds.put(type, colorId);
        if (!colorId.equals(oldId)) {
            this.fireEvent(new ColorChanged(type, colorId));
            this.saveColorConfigDebounced();
        }
    }

    void putRealKit(KitType slot, Integer kitId) {
        this.fireEvent(new KnownKitChanged(false, slot));
        Integer oldKitId = this.realKitIds.put(slot, kitId);
        if (!kitId.equals(oldKitId)) {
            this.saveRealKitsDebounced();
        }
    }

    void putRealColor(ColorType type, Integer colorId) {
        this.realColorIds.put(type, colorId);
    }

    void putRealIcon(JawIcon icon) {
        this.realIcon = icon;
    }

    void removeSlot(KitType slot) {
        this.removeItem(slot);
        this.removeKit(slot);
    }

    private void removeItem(KitType slot) {
        if (this.isItemLocked(slot)) {
            return;
        }
        Integer oldId = this.swappedItemIds.remove(slot);
        boolean wasHidden = this.hiddenSlots.remove(slot);
        if (oldId != null || wasHidden) {
            this.fireEvent(new ItemChanged(slot, null));
            this.saveEquipmentConfigDebounced();
        }
    }

    private void removeKit(KitType slot) {
        if (this.isKitLocked(slot)) {
            return;
        }
        Integer oldId = this.swappedKitIds.remove(slot);
        if (oldId != null) {
            this.fireEvent(new KitChanged(slot, null));
            this.saveEquipmentConfigDebounced();
        }
    }

    void removeColor(ColorType type) {
        Integer oldId = this.swappedColorIds.remove((Object)type);
        if (oldId != null) {
            this.fireEvent(new ColorChanged(type, null));
            this.saveColorConfigDebounced();
        }
    }

    void removeIcon() {
        if (this.swappedIcon != null) {
            this.swappedIcon = null;
            this.fireEvent(new IconChanged(null));
            this.saveEquipmentConfigDebounced();
        }
    }

    void clearSwapped() {
        Sets.SetView swappedItems = Sets.union(new HashSet<KitType>(this.swappedItemIds.keySet()), new HashSet<KitType>(this.hiddenSlots));
        Sets.SetView itemSlots = Sets.difference((Set)swappedItems, this.lockedItems);
        itemSlots.forEach(this::removeItem);
        Sets.SetView kitSlots = Sets.difference(new HashSet<KitType>(this.swappedKitIds.keySet()), this.lockedKits);
        kitSlots.forEach(this::removeKit);
        Sets.SetView colorTypes = Sets.difference(new HashSet<ColorType>(this.swappedColorIds.keySet()), this.lockedColors);
        colorTypes.forEach(this::removeColor);
        this.removeIcon();
    }

    void clearRealKits() {
        boolean realKitsNeedRefresh = this.realKitIds.isEmpty();
        this.realKitIds.clear();
        if (realKitsNeedRefresh) {
            this.saveRealKitsImmediate();
        }
    }

    Set<KitType> getAllLockedKits() {
        return Arrays.stream(KitType.values()).filter(this.lockedKits::contains).collect(Collectors.toSet());
    }

    void setLockedKits(Set<KitType> kits) {
        for (KitType slot : KitType.values()) {
            if (this.lockedKits.contains(slot) && !kits.contains(slot)) {
                this.lockedKits.remove(slot);
                this.fireEvent(new LockChanged(slot, false, LockChanged.Type.KIT));
                continue;
            }
            if (this.lockedKits.contains(slot) || !kits.contains(slot)) continue;
            this.lockedKits.add(slot);
            this.fireEvent(new LockChanged(slot, true, LockChanged.Type.KIT));
        }
    }

    Set<KitType> getAllLockedItems() {
        return Arrays.stream(KitType.values()).filter(this.lockedItems::contains).collect(Collectors.toSet());
    }

    void setLockedItems(Set<KitType> items) {
        for (KitType slot : KitType.values()) {
            if (this.lockedItems.contains(slot) && !items.contains(slot)) {
                this.lockedItems.remove(slot);
                this.fireEvent(new LockChanged(slot, false, LockChanged.Type.ITEM));
                continue;
            }
            if (this.lockedItems.contains(slot) || !items.contains(slot)) continue;
            this.lockedItems.add(slot);
            this.fireEvent(new LockChanged(slot, true, LockChanged.Type.ITEM));
        }
    }

    void setIconLocked(boolean locked) {
        this.lockedIcon = locked;
    }

    boolean isSlotLocked(KitType slot) {
        return this.isKitLocked(slot) || this.isItemLocked(slot);
    }

    boolean isKitLocked(KitType slot) {
        return this.lockedKits.contains(slot);
    }

    boolean isItemLocked(KitType slot) {
        return this.lockedItems.contains(slot);
    }

    boolean isColorLocked(ColorType type) {
        return this.lockedColors.contains((Object)type);
    }

    boolean isIconLocked() {
        return this.lockedIcon;
    }

    void toggleItemLocked(KitType slot) {
        if (this.lockedItems.contains(slot)) {
            this.lockedItems.remove(slot);
            this.lockedKits.remove(slot);
            this.fireEvent(new LockChanged(slot, false, LockChanged.Type.KIT));
        } else {
            this.lockedItems.add(slot);
        }
        this.fireEvent(new LockChanged(slot, this.isItemLocked(slot), LockChanged.Type.ITEM));
    }

    void toggleKitLocked(KitType slot) {
        if (this.lockedKits.contains(slot)) {
            this.lockedKits.remove(slot);
        } else {
            this.lockedKits.add(slot);
            this.lockedItems.add(slot);
            this.fireEvent(new LockChanged(slot, true, LockChanged.Type.ITEM));
        }
        this.fireEvent(new LockChanged(slot, this.isSlotLocked(slot), LockChanged.Type.KIT));
    }

    void toggleColorLocked(ColorType type) {
        if (this.lockedColors.contains((Object)type)) {
            this.lockedColors.remove((Object)type);
        } else {
            this.lockedColors.add(type);
        }
        this.fireEvent(new ColorLockChanged(type, this.isColorLocked(type)));
    }

    void toggleIconLocked() {
        this.lockedIcon = !this.lockedIcon;
        this.fireEvent(new IconLockChanged(this.isIconLocked()));
    }

    void removeAllLocks() {
        HashSet<KitType> slotClears = new HashSet<KitType>(this.lockedKits);
        slotClears.addAll(this.lockedItems);
        HashSet<ColorType> colorClears = new HashSet<ColorType>(this.lockedColors);
        this.lockedKits.clear();
        this.lockedItems.clear();
        this.lockedColors.clear();
        this.lockedIcon = false;
        slotClears.forEach(slot -> this.fireEvent(new LockChanged((KitType)slot, false, LockChanged.Type.BOTH)));
        colorClears.forEach(type -> this.fireEvent(new ColorLockChanged((ColorType)((Object)type), false)));
        this.fireEvent(new IconLockChanged(false));
    }

    void removeSlotLock(KitType slot) {
        this.lockedKits.remove(slot);
        this.lockedItems.remove(slot);
        this.fireEvent(new LockChanged(slot, false, LockChanged.Type.BOTH));
    }

    void removeColorLock(ColorType type) {
        this.lockedColors.remove((Object)type);
        this.fireEvent(new ColorLockChanged(type, false));
    }

    void removeIconLock() {
        this.lockedIcon = false;
        this.fireEvent(new IconLockChanged(false));
    }

    private void fireEvent(SwapEvent event) {
        String key = event.getKey();
        ((List)this.listeners.getOrDefault(key, new LinkedList())).forEach(listener -> listener.onEvent(event));
    }

    void saveRealKitsImmediate() {
        byte[] bytes = SerializationUtils.serialize(this.realKitIds);
        this.configManager.setRSProfileConfiguration("fashionscape", "realKitIds", (Object)bytes);
    }

    private void saveEquipmentConfigDebounced() {
        Future<?> future = this.equipSaveFuture;
        if (future != null) {
            future.cancel(false);
        }
        this.equipSaveFuture = this.executor.schedule(() -> {
            Map<KitType, Integer> itemEquips = this.swappedItemIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + 512));
            Map<KitType, Integer> kitEquips = this.swappedKitIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() + 256));
            Map<KitType, Integer> hides = this.hiddenSlots.stream().collect(Collectors.toMap(v -> v, v -> 0));
            HashMap<KitType, Integer> equips = new HashMap<KitType, Integer>(itemEquips);
            equips.putAll(kitEquips);
            equips.putAll(hides);
            byte[] bytes = SerializationUtils.serialize(equips);
            this.config.setCurrentEquipment(bytes);
            Integer iconId = this.swappedIcon != null ? Integer.valueOf(this.swappedIcon.getId()) : null;
            this.config.setCurrentIcon(iconId);
        }, 500L, TimeUnit.MILLISECONDS);
    }

    private void saveColorConfigDebounced() {
        Future<?> future = this.colorSaveFuture;
        if (future != null) {
            future.cancel(false);
        }
        this.colorSaveFuture = this.executor.schedule(() -> {
            byte[] bytes = SerializationUtils.serialize(this.swappedColorIds);
            this.config.setCurrentColors(bytes);
        }, 500L, TimeUnit.MILLISECONDS);
    }

    private void saveRealKitsDebounced() {
        Future<?> future = this.kitsSaveFuture;
        if (future != null) {
            future.cancel(false);
        }
        this.kitsSaveFuture = this.executor.schedule(() -> {
            byte[] bytes = SerializationUtils.serialize(this.realKitIds);
            this.configManager.setRSProfileConfiguration("fashionscape", "realKitIds", (Object)bytes);
        }, 500L, TimeUnit.MILLISECONDS);
    }

    public HashMap<KitType, Integer> getRealKitIds() {
        return this.realKitIds;
    }

    public JawIcon getRealIcon() {
        return this.realIcon;
    }

    public JawIcon getSwappedIcon() {
        return this.swappedIcon;
    }

    public HashSet<KitType> getHiddenSlots() {
        return this.hiddenSlots;
    }

    static {
        FALLBACK_MALE_KITS.put(KitType.HAIR, HairKit.BALD.getKitId(false));
        FALLBACK_MALE_KITS.put(KitType.JAW, JawKit.GOATEE.getKitId(false));
        FALLBACK_MALE_KITS.put(KitType.TORSO, TorsoKit.PLAIN.getKitId(false));
        FALLBACK_MALE_KITS.put(KitType.ARMS, ArmsKit.REGULAR.getKitId(false));
        FALLBACK_MALE_KITS.put(KitType.LEGS, LegsKit.PLAIN_L.getKitId(false));
        FALLBACK_MALE_KITS.put(KitType.HANDS, HandsKit.PLAIN_H.getKitId(false));
        FALLBACK_MALE_KITS.put(KitType.BOOTS, BootsKit.SMALL.getKitId(false));
        FALLBACK_FEMALE_KITS.put(KitType.HAIR, HairKit.PIGTAILS.getKitId(true));
        FALLBACK_FEMALE_KITS.put(KitType.JAW, -256);
        FALLBACK_FEMALE_KITS.put(KitType.TORSO, TorsoKit.SIMPLE.getKitId(true));
        FALLBACK_FEMALE_KITS.put(KitType.ARMS, ArmsKit.SHORT_SLEEVES.getKitId(true));
        FALLBACK_FEMALE_KITS.put(KitType.LEGS, LegsKit.PLAIN_L.getKitId(true));
        FALLBACK_FEMALE_KITS.put(KitType.HANDS, HandsKit.PLAIN_H.getKitId(true));
        FALLBACK_FEMALE_KITS.put(KitType.BOOTS, BootsKit.SMALL.getKitId(true));
    }
}

