/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.swap;

import eq.uirs.fashionscape.data.kit.JawIcon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.runelite.api.kit.KitType;

class CompoundSwap {
    @NonNull
    private final Type type;
    @NonNull
    private final Map<KitType, Integer> equipmentIds;
    @Nullable
    private final JawIcon icon;

    public static List<CompoundSwap> fromMap(Map<KitType, Integer> equipmentIds, @Nullable JawIcon icon) {
        Map<KitType, Integer> singles;
        Map<KitType, Integer> weapons;
        Map<KitType, Integer> torsos;
        Map<Object, Object> heads;
        ArrayList<CompoundSwap> result = new ArrayList<CompoundSwap>();
        Map<Type, Map<KitType, Integer>> grouping = equipmentIds.entrySet().stream().collect(Collectors.groupingBy(e -> Type.fromSlot((KitType)e.getKey()), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        Map<Object, Object> map = heads = grouping.get((Object)Type.HEAD) != null ? grouping.get((Object)Type.HEAD) : new HashMap();
        if (!heads.isEmpty() || icon != null) {
            result.add(CompoundSwap.head((Integer)heads.get(KitType.HEAD), (Integer)heads.get(KitType.HAIR), (Integer)heads.get(KitType.JAW), icon));
        }
        if ((torsos = grouping.get((Object)Type.TORSO)) != null && !torsos.isEmpty()) {
            result.add(CompoundSwap.torso(torsos.get(KitType.TORSO), torsos.get(KitType.ARMS)));
        }
        if ((weapons = grouping.get((Object)Type.WEAPONS)) != null && !weapons.isEmpty()) {
            result.add(CompoundSwap.weapons(weapons.get(KitType.WEAPON), weapons.get(KitType.SHIELD)));
        }
        if ((singles = grouping.get((Object)Type.SINGLE)) != null && !singles.isEmpty()) {
            singles.forEach((slot, equipId) -> result.add(CompoundSwap.single(slot, equipId)));
        }
        return result;
    }

    static CompoundSwap single(KitType slot, Integer equipmentId) {
        switch (slot) {
            case HEAD: {
                return CompoundSwap.head(equipmentId, null, null, null);
            }
            case HAIR: {
                return CompoundSwap.head(null, equipmentId, null, null);
            }
            case JAW: {
                return CompoundSwap.head(null, null, equipmentId, null);
            }
            case TORSO: {
                return CompoundSwap.torso(equipmentId, null);
            }
            case ARMS: {
                return CompoundSwap.torso(null, equipmentId);
            }
            case WEAPON: {
                return CompoundSwap.weapons(equipmentId, null);
            }
            case SHIELD: {
                return CompoundSwap.weapons(null, equipmentId);
            }
        }
        HashMap<KitType, Integer> map = new HashMap<KitType, Integer>();
        map.put(slot, equipmentId);
        return new CompoundSwap(Type.SINGLE, map, null);
    }

    static CompoundSwap fromIcon(JawIcon icon) {
        return new CompoundSwap(Type.HEAD, new HashMap<KitType, Integer>(), icon);
    }

    static CompoundSwap head(Integer headEquipId, Integer hairEquipId, Integer jawEquipId, JawIcon icon) {
        HashMap<KitType, Integer> map = new HashMap<KitType, Integer>();
        map.put(KitType.HEAD, headEquipId);
        map.put(KitType.HAIR, hairEquipId);
        map.put(KitType.JAW, jawEquipId);
        return new CompoundSwap(Type.HEAD, map, icon);
    }

    static CompoundSwap torso(Integer torsoEquipId, Integer armsEquipId) {
        HashMap<KitType, Integer> map = new HashMap<KitType, Integer>();
        map.put(KitType.TORSO, torsoEquipId);
        map.put(KitType.ARMS, armsEquipId);
        return new CompoundSwap(Type.TORSO, map, null);
    }

    static CompoundSwap weapons(Integer weaponEquipId, Integer shieldEquipId) {
        HashMap<KitType, Integer> map = new HashMap<KitType, Integer>();
        map.put(KitType.WEAPON, weaponEquipId);
        map.put(KitType.SHIELD, shieldEquipId);
        return new CompoundSwap(Type.WEAPONS, map, null);
    }

    private CompoundSwap(Type type, Map<KitType, Integer> equipmentIds, JawIcon icon) {
        this.type = type;
        this.equipmentIds = equipmentIds;
        this.icon = icon;
    }

    Integer getEquipmentId() {
        return this.equipmentIds.values().stream().findAny().orElse(null);
    }

    KitType getKitType() {
        return this.equipmentIds.keySet().stream().findAny().orElse(null);
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    @NonNull
    public Map<KitType, Integer> getEquipmentIds() {
        return this.equipmentIds;
    }

    @Nullable
    public JawIcon getIcon() {
        return this.icon;
    }

    static enum Type {
        HEAD,
        TORSO,
        WEAPONS,
        SINGLE;


        private static Type fromSlot(KitType slot) {
            switch (slot) {
                case HEAD: 
                case HAIR: 
                case JAW: {
                    return HEAD;
                }
                case TORSO: 
                case ARMS: {
                    return TORSO;
                }
                case WEAPON: 
                case SHIELD: {
                    return WEAPONS;
                }
            }
            return SINGLE;
        }
    }
}

