/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.panel;

import eq.uirs.fashionscape.panel.PanelEquipSlot;
import eq.uirs.fashionscape.panel.SearchOpener;
import eq.uirs.fashionscape.panel.SwapItemPanel;
import eq.uirs.fashionscape.swap.SwapManager;
import eq.uirs.fashionscape.swap.event.KnownKitChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.ItemComposition;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SwapsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(SwapsPanel.class);
    private final SwapManager swapManager;
    private final ItemManager itemManager;
    private final ClientThread clientThread;
    private final SearchOpener searchOpener;
    private final Set<KitType> unknownSlots = new HashSet<KitType>();
    private JPanel slotsPanel;
    private JPanel warningsPanel;

    public SwapsPanel(SwapManager swapManager, ItemManager itemManager, SearchOpener searchOpener, ClientThread clientThread) {
        this.swapManager = swapManager;
        this.itemManager = itemManager;
        this.searchOpener = searchOpener;
        this.clientThread = clientThread;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(5, 10, 5, 10));
        JPanel swapsPanel = this.setUpContentPanel();
        JPanel scrollWrapper = new JPanel(new BorderLayout());
        scrollWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        scrollWrapper.add((Component)swapsPanel, "North");
        JScrollPane scrollPane = new JScrollPane(20, 31);
        scrollPane.setBackground(ColorScheme.DARK_GRAY_COLOR);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(10, 0));
        scrollPane.setViewportView(scrollWrapper);
        this.add((Component)scrollPane, "Center");
        swapManager.addEventListener(new KnownKitChangedListener(e -> {
            KitType slot = e.getSlot();
            if (e.isUnknown()) {
                this.unknownSlots.add(slot);
            } else {
                this.unknownSlots.remove(slot);
            }
            SwingUtilities.invokeLater(this::refreshWarnings);
        }));
    }

    private JPanel setUpContentPanel() {
        JPanel contentContainer = new JPanel();
        contentContainer.setLayout(new GridBagLayout());
        contentContainer.setBackground(ColorScheme.DARK_GRAY_COLOR);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(0, 1, 0, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.slotsPanel = new JPanel();
        this.slotsPanel.setLayout(new GridBagLayout());
        this.slotsPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.populateSwapSlots();
        contentContainer.add((Component)this.slotsPanel, c);
        ++c.gridy;
        this.warningsPanel = new JPanel();
        this.warningsPanel.setLayout(new GridBagLayout());
        this.warningsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.warningsPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.refreshWarnings();
        contentContainer.add((Component)this.warningsPanel, c);
        return contentContainer;
    }

    private void populateSwapSlots() {
        this.clientThread.invokeLater(() -> {
            ArrayList<SlotResult> slotResults = new ArrayList<SlotResult>();
            for (PanelEquipSlot panelSlot : PanelEquipSlot.values()) {
                BufferedImage image;
                KitType slot = panelSlot.getKitType();
                if (slot == null) continue;
                Integer itemId = this.swapManager.swappedItemIdIn(slot);
                if (itemId != null && itemId >= 0) {
                    ItemComposition itemComposition = this.itemManager.getItemComposition(itemId.intValue());
                    image = this.itemManager.getImage(itemComposition.getId());
                } else {
                    image = ImageUtil.loadImageResource(this.getClass(), (String)(slot.name().toLowerCase() + ".png"));
                }
                slotResults.add(new SlotResult(slot, itemId, image));
            }
            SwingUtilities.invokeLater(() -> this.addSlotItemPanels(slotResults));
        });
    }

    private void addSlotItemPanels(List<SlotResult> results) {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 19;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        for (SlotResult s : results) {
            SwapItemPanel itemPanel = new SwapItemPanel(s.itemId, s.image, this.itemManager, this.clientThread, this.swapManager, s.slot, this.searchOpener);
            JPanel marginWrapper = new JPanel(new BorderLayout());
            marginWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
            marginWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
            marginWrapper.add((Component)itemPanel, "North");
            this.slotsPanel.add((Component)marginWrapper, c);
            ++c.gridy;
        }
    }

    public void refreshWarnings() {
        this.warningsPanel.removeAll();
        if (!this.unknownSlots.isEmpty()) {
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 19;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            JLabel label = new JLabel("<html>Some base models can't be determined. Remove some of your in-game equipment to detect them:</html>");
            label.setPreferredSize(new Dimension(100, 60));
            label.setForeground(ColorScheme.BRAND_ORANGE);
            this.warningsPanel.add((Component)label, c);
            ++c.gridy;
            this.unknownSlots.stream().sorted(Comparator.comparing(Enum::name)).forEach(slot -> {
                JLabel slotLabel = new JLabel(Text.titleCase((Enum)slot));
                slotLabel.setForeground(ColorScheme.BRAND_ORANGE);
                this.warningsPanel.add((Component)slotLabel, c);
                ++c.gridy;
            });
        }
        this.revalidate();
    }

    private static final class SlotResult {
        private final KitType slot;
        private final Integer itemId;
        private final BufferedImage image;

        public SlotResult(KitType slot, Integer itemId, BufferedImage image) {
            this.slot = slot;
            this.itemId = itemId;
            this.image = image;
        }

        public KitType getSlot() {
            return this.slot;
        }

        public Integer getItemId() {
            return this.itemId;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SlotResult)) {
                return false;
            }
            SlotResult other = (SlotResult)o;
            Integer this$itemId = this.getItemId();
            Integer other$itemId = other.getItemId();
            if (this$itemId == null ? other$itemId != null : !((Object)this$itemId).equals(other$itemId)) {
                return false;
            }
            KitType this$slot = this.getSlot();
            KitType other$slot = other.getSlot();
            if (this$slot == null ? other$slot != null : !this$slot.equals(other$slot)) {
                return false;
            }
            BufferedImage this$image = this.getImage();
            BufferedImage other$image = other.getImage();
            return !(this$image == null ? other$image != null : !this$image.equals(other$image));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $itemId = this.getItemId();
            result = result * 59 + ($itemId == null ? 43 : ((Object)$itemId).hashCode());
            KitType $slot = this.getSlot();
            result = result * 59 + ($slot == null ? 43 : $slot.hashCode());
            BufferedImage $image = this.getImage();
            result = result * 59 + ($image == null ? 43 : $image.hashCode());
            return result;
        }

        public String toString() {
            return "SwapsPanel.SlotResult(slot=" + this.getSlot() + ", itemId=" + this.getItemId() + ", image=" + this.getImage() + ")";
        }
    }
}

