/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.panel;

import eq.uirs.fashionscape.panel.AbsItemPanel;
import eq.uirs.fashionscape.panel.SearchOpener;
import eq.uirs.fashionscape.swap.SwapManager;
import eq.uirs.fashionscape.swap.event.ItemChangedListener;
import eq.uirs.fashionscape.swap.event.LockChanged;
import eq.uirs.fashionscape.swap.event.LockChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.ItemComposition;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SwapItemPanel
extends AbsItemPanel {
    private static final Logger log = LoggerFactory.getLogger(SwapItemPanel.class);
    private static final Dimension ICON_SIZE = new Dimension(20, 20);
    private final KitType slot;
    private final SwapManager swapManager;
    private final JButton lockButton;
    private final JButton xButton;
    private final SearchOpener searchOpener;
    private Integer itemId;
    private MouseAdapter mouseAdapter = null;
    private MouseAdapter hoverAdapter = null;

    public SwapItemPanel(@Nullable Integer itemId, BufferedImage icon, ItemManager itemManager, ClientThread clientThread, SwapManager swapManager, KitType slot, SearchOpener searchOpener) {
        super(itemId, icon, itemManager, clientThread);
        this.slot = slot;
        this.itemId = itemId;
        this.swapManager = swapManager;
        this.searchOpener = searchOpener;
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setBackground(this.nonHighlightColor);
        rightPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.highlightPanels.add(rightPanel);
        rightPanel.add((Component)this.label, "Center");
        JPanel buttons = new JPanel(new GridLayout(1, 2, 2, 0));
        buttons.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.lockButton = new JButton();
        this.lockButton.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.lockButton.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.lockButton.setPreferredSize(ICON_SIZE);
        this.lockButton.setFocusPainted(false);
        this.lockButton.setBorderPainted(false);
        this.lockButton.setContentAreaFilled(false);
        this.lockButton.addActionListener(e -> {
            swapManager.toggleItemLocked(slot);
            this.updateLockButton();
            this.updateXButton();
        });
        buttons.add(this.lockButton);
        this.xButton = new JButton();
        this.xButton.setPreferredSize(ICON_SIZE);
        this.xButton.setBorder(new EmptyBorder(0, 2, 0, 2));
        this.xButton.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.xButton.setFocusPainted(false);
        this.xButton.setBorderPainted(false);
        this.xButton.setContentAreaFilled(false);
        this.xButton.setIcon(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"x.png")));
        this.xButton.addActionListener(e -> clientThread.invokeLater(() -> {
            swapManager.revertSlot(slot);
            SwingUtilities.invokeLater(() -> {
                this.updateLockButton();
                this.updateXButton();
            });
        }));
        buttons.add(this.xButton);
        this.updateLockButton();
        this.updateXButton();
        rightPanel.add((Component)buttons, "East");
        this.add((Component)rightPanel, "Center");
        swapManager.addEventListener(new ItemChangedListener(e -> {
            if (e.getSlot() == slot) {
                Integer newId;
                this.itemId = newId = e.getItemId();
                this.setItemName(newId);
                this.setItemIcon(newId);
                this.resetMouseListeners();
                this.updateXButton();
            }
        }));
        swapManager.addEventListener(new LockChangedListener(e -> {
            if (e.getSlot() == slot && e.getType() != LockChanged.Type.KIT) {
                this.updateLockButton();
            }
        }));
        this.resetMouseListeners();
    }

    private void resetMouseListeners() {
        this.icon.removeMouseListener(this.mouseAdapter);
        this.mouseAdapter = this.createOpenSearchClickListener();
        this.icon.addMouseListener(this.mouseAdapter);
        this.icon.setToolTipText("Open " + this.slot.name().toLowerCase() + " slot search");
        this.icon.removeMouseListener(this.hoverAdapter);
        this.xButton.removeMouseListener(this.hoverAdapter);
        this.lockButton.removeMouseListener(this.hoverAdapter);
        this.hoverAdapter = this.createHoverListener();
        this.icon.addMouseListener(this.hoverAdapter);
        this.xButton.addMouseListener(this.hoverAdapter);
        this.lockButton.addMouseListener(this.hoverAdapter);
    }

    void updateLockButton() {
        boolean locked = this.swapManager.isItemLocked(this.slot);
        String lockIcon = locked ? "lock" : "unlock";
        this.lockButton.setIcon(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)(lockIcon + ".png"))));
        String action = locked ? "Unlock" : "Lock";
        this.lockButton.setToolTipText(action + " " + this.slot.name().toLowerCase() + " slot");
    }

    void updateXButton() {
        this.xButton.setEnabled(this.itemId != null);
        this.xButton.setToolTipText("Clear " + this.slot.name().toLowerCase() + " slot");
    }

    private MouseAdapter createOpenSearchClickListener() {
        return new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SwapItemPanel.this.searchOpener.openSearchFor(SwapItemPanel.this.slot);
            }
        };
    }

    private MouseAdapter createHoverListener() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getComponent().isEnabled()) {
                    SwapItemPanel.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SwapItemPanel.this.setCursor(new Cursor(0));
            }
        };
    }

    private void setItemIcon(Integer itemId) {
        if (itemId != null && itemId >= 0) {
            this.clientThread.invokeLater(() -> {
                ItemComposition itemComposition = this.itemManager.getItemComposition(itemId.intValue());
                AsyncBufferedImage image = this.itemManager.getImage(itemComposition.getId());
                image.addTo(this.icon);
            });
        } else {
            BufferedImage image = ImageUtil.loadImageResource(this.getClass(), (String)(this.slot.name().toLowerCase() + ".png"));
            this.setIcon(this.icon, image);
        }
    }
}

