/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.panel;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import eq.uirs.fashionscape.FashionscapeConfig;
import eq.uirs.fashionscape.FashionscapePlugin;
import eq.uirs.fashionscape.colors.ColorScorer;
import eq.uirs.fashionscape.panel.NothingItemComposition;
import eq.uirs.fashionscape.panel.OnSelectionChangingListener;
import eq.uirs.fashionscape.panel.PanelEquipSlot;
import eq.uirs.fashionscape.panel.SearchItemPanel;
import eq.uirs.fashionscape.panel.SortBy;
import eq.uirs.fashionscape.swap.SwapManager;
import eq.uirs.fashionscape.swap.event.LockChanged;
import eq.uirs.fashionscape.swap.event.LockChangedListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;
import net.runelite.http.api.item.ItemStats;

class SearchPanel
extends JPanel {
    private static final int DEBOUNCE_DELAY_MS = 200;
    private static final String ERROR_PANEL = "ERROR_PANEL";
    private static final String RESULTS_PANEL = "RESULTS_PANEL";
    private static final Set<Integer> VALID_SLOT_IDS = Arrays.stream(PanelEquipSlot.values()).map(PanelEquipSlot::getKitType).filter(Objects::nonNull).map(KitType::getIndex).collect(Collectors.toSet());
    private final Client client;
    private final SwapManager swapManager;
    private final ItemManager itemManager;
    private final ClientThread clientThread;
    private final FashionscapeConfig config;
    private final ScheduledExecutorService executor;
    private final ColorScorer colorScorer;
    private final GridBagConstraints itemConstraints = new GridBagConstraints();
    private final CardLayout cardLayout = new CardLayout();
    private final IconTextField searchBar = new IconTextField();
    private final MaterialTabGroup slotFilter = new MaterialTabGroup();
    private final JPanel resultsPanel = new JPanel();
    private final JScrollPane resultsScrollPane;
    private final JPanel centerPanel = new JPanel(this.cardLayout);
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();
    private final Map<PanelEquipSlot, MaterialTab> tabMap;
    private final List<SearchItemPanel> searchPanels = new ArrayList<SearchItemPanel>();
    private final List<Result> results = new ArrayList<Result>();
    private final AtomicBoolean searchInProgress = new AtomicBoolean();
    private final OnSelectionChangingListener listener = new OnSelectionChangingListener(){

        @Override
        public void onSearchSelectionChanging(KitType slot) {
            for (SearchItemPanel item : SearchPanel.this.searchPanels) {
                if (!Objects.equals(item.itemId, SearchPanel.this.swapManager.swappedItemIdIn(slot)) && (item.itemId >= 0 || !SearchPanel.this.swapManager.isHidden(slot))) continue;
                item.resetBackground();
            }
        }
    };
    private Future<?> searchFuture = null;
    private Function<ItemComposition, Boolean> filter;
    private boolean allowShortQueries = false;
    private SortBy sort;
    private KitType selectedSlot = null;
    private boolean hasSearched = false;
    private final Map<Integer, Double> scores = new HashMap<Integer, Double>();
    private final Comparator<Result> itemAlphaComparator = Comparator.comparing(o -> o.getItemComposition().getName());

    @Inject
    public SearchPanel(Client client, SwapManager swapManager, ClientThread clientThread, ItemManager itemManager, ScheduledExecutorService executor, FashionscapeConfig config, ColorScorer colorScorer) {
        this.client = client;
        this.swapManager = swapManager;
        this.itemManager = itemManager;
        this.clientThread = clientThread;
        this.executor = executor;
        this.config = config;
        this.colorScorer = colorScorer;
        this.sort = config.preferredSort();
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        GridBagConstraints groupConstraints = new GridBagConstraints();
        groupConstraints.fill = 2;
        groupConstraints.weightx = 1.0;
        groupConstraints.weighty = 0.0;
        groupConstraints.gridx = 0;
        groupConstraints.gridy = 0;
        this.itemConstraints.fill = 2;
        this.itemConstraints.weightx = 1.0;
        this.itemConstraints.weighty = 0.0;
        this.itemConstraints.gridx = 0;
        this.itemConstraints.gridy = 0;
        JPanel container = new JPanel();
        container.setLayout(new GridBagLayout());
        container.setBorder(new EmptyBorder(10, 10, 10, 10));
        container.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.tabMap = this.setUpSlotFilters();
        this.setUpSearchBar();
        this.resultsPanel.setLayout(new GridBagLayout());
        this.resultsPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        wrapper.add((Component)this.resultsPanel, "North");
        this.resultsScrollPane = new JScrollPane(wrapper);
        this.resultsScrollPane.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.resultsScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(10, 0));
        this.resultsScrollPane.setVisible(false);
        JPanel infoWrapper = new JPanel(new BorderLayout());
        infoWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.errorPanel.setContent("Equipment Search", "Items you can try on will appear here.");
        infoWrapper.add((Component)this.errorPanel, "North");
        this.centerPanel.add((Component)this.resultsScrollPane, RESULTS_PANEL);
        this.centerPanel.add((Component)infoWrapper, ERROR_PANEL);
        this.cardLayout.show(this.centerPanel, ERROR_PANEL);
        JPanel sortBar = new JPanel();
        sortBar.setLayout(new GridLayout(1, 2));
        sortBar.setBorder(new EmptyBorder(5, 0, 0, 0));
        sortBar.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JLabel sortLabel = new JLabel("Sort by");
        sortLabel.setForeground(Color.WHITE);
        sortLabel.setMaximumSize(new Dimension(0, 0));
        sortLabel.setPreferredSize(new Dimension(0, 0));
        sortBar.add(sortLabel);
        JComboBox<SortBy> sortBox = new JComboBox<SortBy>(SortBy.values());
        sortBox.setSelectedItem((Object)this.sort);
        sortBox.setPreferredSize(new Dimension(sortBox.getPreferredSize().width, 25));
        sortBox.setForeground(Color.WHITE);
        sortBox.setFocusable(false);
        sortBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                SortBy selectedSort = (SortBy)((Object)((Object)sortBox.getSelectedItem()));
                config.setPreferredSort(selectedSort);
                this.sort = selectedSort;
                this.updateSearchDebounced();
            }
        });
        sortBar.add(sortBox);
        container.add((Component)this.slotFilter, groupConstraints);
        ++groupConstraints.gridy;
        container.add((Component)this.searchBar, groupConstraints);
        ++groupConstraints.gridy;
        container.add((Component)sortBar, groupConstraints);
        ++groupConstraints.gridy;
        this.add((Component)container, "North");
        this.add((Component)this.centerPanel, "Center");
        SwingUtilities.invokeLater(() -> ((IconTextField)this.searchBar).requestFocusInWindow());
        swapManager.addEventListener(new LockChangedListener(e -> {
            if (e.getType() != LockChanged.Type.KIT) {
                this.updateTabIcon((LockChanged)e);
            }
        }));
    }

    public void clearResults() {
        this.searchPanels.clear();
        SwingUtil.fastRemoveAll((Container)this.resultsPanel);
    }

    public void reloadResults() {
        this.updateSearchDebounced();
        SwingUtilities.invokeLater(() -> ((IconTextField)this.searchBar).requestFocusInWindow());
    }

    public void chooseSlot(KitType slot) {
        PanelEquipSlot panelSlot = Arrays.stream(PanelEquipSlot.values()).filter(p -> p.getKitType() == slot).findFirst().orElse(PanelEquipSlot.ALL);
        MaterialTab tab = this.tabMap.get((Object)panelSlot);
        if (tab != null) {
            this.slotFilter.select(tab);
        }
    }

    public void clearSearch() {
        if (!Strings.isNullOrEmpty((String)this.searchBar.getText())) {
            this.searchBar.setText("");
        }
        this.results.clear();
        this.searchPanels.clear();
        SwingUtilities.invokeLater(() -> {
            SwingUtil.fastRemoveAll((Container)this.resultsPanel);
            this.resultsPanel.updateUI();
            this.searchBar.requestFocusInWindow();
        });
    }

    private Map<PanelEquipSlot, MaterialTab> setUpSlotFilters() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        this.slotFilter.setLayout((LayoutManager)new GridLayout(2, 5, 5, 5));
        this.slotFilter.setBorder((Border)new EmptyBorder(0, 0, 10, 0));
        MaterialTab allTab = null;
        for (PanelEquipSlot filterSlot : PanelEquipSlot.values()) {
            MaterialTab tab = new MaterialTab(new ImageIcon(), this.slotFilter, null);
            builder.put((Object)filterSlot, (Object)tab);
            boolean isLocked = false;
            if (filterSlot.getKitType() == null) {
                allTab = tab;
            } else {
                isLocked = this.swapManager.isItemLocked(filterSlot.getKitType());
            }
            ImageIcon icon = this.iconFor(filterSlot, isLocked);
            tab.setIcon((Icon)icon);
            tab.setToolTipText(filterSlot.getDisplayName());
            tab.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    SearchPanel.this.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SearchPanel.this.setCursor(new Cursor(0));
                }
            });
            tab.setOnSelectEvent(() -> {
                this.filter = itemComposition -> {
                    KitType kitType;
                    this.selectedSlot = kitType = filterSlot.getKitType();
                    Integer slotId = this.swapManager.slotIdFor((ItemComposition)itemComposition);
                    if (kitType == null) {
                        return slotId != null && VALID_SLOT_IDS.contains(slotId);
                    }
                    return slotId != null && kitType.getIndex() == slotId.intValue();
                };
                this.allowShortQueries = filterSlot.getKitType() != null;
                this.updateSearchDebounced(() -> this.resultsScrollPane.getVerticalScrollBar().setValue(0));
                return true;
            });
            this.slotFilter.addTab(tab);
        }
        if (allTab != null) {
            this.slotFilter.select(allTab);
        }
        return builder.build();
    }

    private void setUpSearchBar() {
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(100, 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.addActionListener(e -> this.updateSearchDebounced());
        this.searchBar.addClearListener(this::clearSearch);
        this.searchBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchPanel.this.hasSearched = true;
                SearchPanel.this.updateSearchDebounced();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchPanel.this.hasSearched = true;
                SearchPanel.this.updateSearchDebounced();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchPanel.this.hasSearched = true;
                SearchPanel.this.updateSearchDebounced();
            }
        });
    }

    private void updateSearchDebounced() {
        this.updateSearchDebounced(() -> {});
    }

    private void updateSearchDebounced(Runnable postExec) {
        Future<?> future = this.searchFuture;
        if (this.searchFuture != null) {
            future.cancel(false);
        }
        this.searchFuture = this.executor.schedule(() -> this.clientThread.invokeLater(() -> {
            if (!this.updateSearch(postExec)) {
                this.updateSearchDebounced(postExec);
            }
        }), 200L, TimeUnit.MILLISECONDS);
    }

    private boolean updateSearch(Runnable postExec) {
        boolean willUpdate = this.searchInProgress.compareAndSet(false, true);
        if (willUpdate) {
            this.results.clear();
            String search = this.searchBar.getText().toLowerCase();
            if (!this.allowShortQueries && search.length() < 2) {
                this.searchPanels.clear();
                SwingUtilities.invokeLater(() -> {
                    SwingUtil.fastRemoveAll((Container)this.resultsPanel);
                    this.resultsPanel.updateUI();
                    if (this.hasSearched) {
                        this.errorPanel.setContent("Search too short", "Type a longer search for results");
                    }
                    this.cardLayout.show(this.centerPanel, ERROR_PANEL);
                    this.searchInProgress.set(false);
                });
                return true;
            }
            HashSet<Integer> ids = new HashSet<Integer>();
            Set<Integer> skips = FashionscapePlugin.getItemIdsToExclude(this.config);
            for (int i = 0; i < this.client.getItemCount(); ++i) {
                ItemComposition itemComposition = null;
                ItemStats stats = null;
                try {
                    int canonical = this.itemManager.canonicalize(i);
                    if (skips.contains(canonical)) continue;
                    itemComposition = this.itemManager.getItemComposition(canonical);
                    stats = this.itemManager.getItemStats(canonical, false);
                }
                catch (Exception canonical) {
                    // empty catch block
                }
                if (itemComposition == null || stats == null || !stats.isEquipable() || ids.contains(itemComposition.getId()) || !this.isValidSearch(itemComposition, search)) continue;
                ids.add(itemComposition.getId());
                try {
                    KitType slot = KitType.values()[stats.getEquipment().getSlot()];
                    AsyncBufferedImage image = this.itemManager.getImage(itemComposition.getId());
                    this.results.add(new Result(itemComposition, (BufferedImage)image, slot));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.selectedSlot != null && SwapManager.ALLOWS_NOTHING.contains(this.selectedSlot) && "Nothing".toLowerCase().contains(search)) {
                NothingItemComposition nothing = new NothingItemComposition();
                BufferedImage image = ImageUtil.loadImageResource(this.getClass(), (String)(this.selectedSlot.name().toLowerCase() + ".png"));
                this.results.add(0, new Result(nothing, image, this.selectedSlot));
            }
            this.searchPanels.clear();
            this.scores.clear();
            switch (this.sort) {
                case RELEASE: {
                    this.addPendingResults(postExec);
                    break;
                }
                case ALPHABETICAL: {
                    this.executor.submit(() -> {
                        this.results.sort(this.itemAlphaComparator);
                        this.addPendingResults(postExec);
                    });
                    break;
                }
                case COLOR_MATCH: {
                    this.executor.submit(() -> {
                        this.performSuggestedSort();
                        this.addPendingResults(postExec);
                    });
                }
            }
        }
        return willUpdate;
    }

    private void performSuggestedSort() {
        this.colorScorer.updatePlayerInfo();
        for (Result result : this.results) {
            int itemId = result.getItemComposition().getId();
            this.scores.put(itemId, this.colorScorer.score(itemId, this.selectedSlot));
        }
        this.results.sort(Comparator.comparing(r -> -this.scores.getOrDefault(r.getItemComposition().getId(), 0.0).doubleValue()));
    }

    private void addPendingResults(Runnable postExec) {
        SwingUtilities.invokeLater(() -> {
            SwingUtil.fastRemoveAll((Container)this.resultsPanel);
            if (this.results.isEmpty()) {
                String slotName = "any";
                if (this.selectedSlot != null) {
                    slotName = this.selectedSlot.name().toLowerCase();
                }
                this.errorPanel.setContent("No results", "No items match \"" + this.searchBar.getText() + "\" in " + slotName + " slot");
                this.cardLayout.show(this.centerPanel, ERROR_PANEL);
            } else {
                boolean firstItem = true;
                boolean showScores = true;
                for (Result result : this.results) {
                    Integer itemId = result.getItemComposition().getId();
                    Double score = this.scores.get(itemId);
                    if (firstItem) {
                        boolean bl = showScores = score != null && score != 0.0;
                    }
                    if (!showScores) {
                        score = null;
                    }
                    SearchItemPanel panel = new SearchItemPanel(itemId, result.getIcon(), result.getSlot(), this.itemManager, this.swapManager, this.clientThread, this.listener, score);
                    this.searchPanels.add(panel);
                    int topPadding = firstItem ? 0 : 5;
                    firstItem = false;
                    JPanel marginWrapper = new JPanel(new BorderLayout());
                    marginWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
                    marginWrapper.setBorder(new EmptyBorder(topPadding, 10, 0, 10));
                    marginWrapper.add((Component)panel, "North");
                    this.resultsPanel.add((Component)marginWrapper, this.itemConstraints);
                    ++this.itemConstraints.gridy;
                }
                this.cardLayout.show(this.centerPanel, RESULTS_PANEL);
                this.resultsPanel.updateUI();
            }
            this.searchInProgress.set(false);
            postExec.run();
        });
    }

    private boolean isValidSearch(ItemComposition itemComposition, String query) {
        String name = itemComposition.getName().toLowerCase();
        if (name.equals("null") || !name.contains(query)) {
            return false;
        }
        return this.filter == null || this.filter.apply(itemComposition) != false;
    }

    private void updateTabIcon(LockChanged event) {
        KitType slot = event.getSlot();
        boolean isLocked = event.isLocked();
        Arrays.stream(PanelEquipSlot.values()).filter(p -> Objects.equals(p.getKitType(), slot)).findFirst().ifPresent(panelEquipSlot -> this.updateTabIcon((PanelEquipSlot)((Object)panelEquipSlot), isLocked));
    }

    private void updateTabIcon(PanelEquipSlot panelSlot, boolean isLocked) {
        MaterialTab tab = this.tabMap.get((Object)panelSlot);
        if (tab != null) {
            tab.setIcon((Icon)this.iconFor(panelSlot, isLocked));
        }
    }

    private ImageIcon iconFor(PanelEquipSlot panelSlot, boolean isLocked) {
        String lockStr = isLocked ? "-lock" : "";
        String iconName = panelSlot.getDisplayName().toLowerCase() + lockStr + ".png";
        return new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)iconName));
    }

    private static final class Result {
        private final ItemComposition itemComposition;
        private final BufferedImage icon;
        private final KitType slot;

        public Result(ItemComposition itemComposition, BufferedImage icon, KitType slot) {
            this.itemComposition = itemComposition;
            this.icon = icon;
            this.slot = slot;
        }

        public ItemComposition getItemComposition() {
            return this.itemComposition;
        }

        public BufferedImage getIcon() {
            return this.icon;
        }

        public KitType getSlot() {
            return this.slot;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            ItemComposition this$itemComposition = this.getItemComposition();
            ItemComposition other$itemComposition = other.getItemComposition();
            if (this$itemComposition == null ? other$itemComposition != null : !this$itemComposition.equals(other$itemComposition)) {
                return false;
            }
            BufferedImage this$icon = this.getIcon();
            BufferedImage other$icon = other.getIcon();
            if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
                return false;
            }
            KitType this$slot = this.getSlot();
            KitType other$slot = other.getSlot();
            return !(this$slot == null ? other$slot != null : !this$slot.equals(other$slot));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ItemComposition $itemComposition = this.getItemComposition();
            result = result * 59 + ($itemComposition == null ? 43 : $itemComposition.hashCode());
            BufferedImage $icon = this.getIcon();
            result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
            KitType $slot = this.getSlot();
            result = result * 59 + ($slot == null ? 43 : $slot.hashCode());
            return result;
        }

        public String toString() {
            return "SearchPanel.Result(itemComposition=" + this.getItemComposition() + ", icon=" + this.getIcon() + ", slot=" + this.getSlot() + ")";
        }
    }
}

