/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.panel;

import eq.uirs.fashionscape.panel.AbsItemPanel;
import eq.uirs.fashionscape.panel.OnSelectionChangingListener;
import eq.uirs.fashionscape.swap.SwapManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchItemPanel
extends AbsItemPanel {
    private static final Logger log = LoggerFactory.getLogger(SearchItemPanel.class);
    private final SwapManager swapManager;
    private final KitType slot;

    public SearchItemPanel(final @Nullable Integer itemId, BufferedImage icon, final KitType slot, ItemManager itemManager, final SwapManager swapManager, final ClientThread clientThread, final OnSelectionChangingListener listener, Double score) {
        super(itemId, icon, itemManager, clientThread);
        this.swapManager = swapManager;
        this.slot = slot;
        MouseAdapter itemPanelMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!swapManager.isItemLocked(slot)) {
                    for (JPanel panel : SearchItemPanel.this.highlightPanels) {
                        SearchItemPanel.this.matchComponentBackground(panel, ColorScheme.DARK_GRAY_HOVER_COLOR);
                    }
                    SearchItemPanel.this.setCursor(new Cursor(12));
                }
                swapManager.hoverOverItem(slot, itemId);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                for (JPanel panel : SearchItemPanel.this.highlightPanels) {
                    SearchItemPanel.this.matchComponentBackground(panel, SearchItemPanel.this.defaultBackgroundColor());
                }
                SearchItemPanel.this.setCursor(new Cursor(0));
                swapManager.hoverAway();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean isAlreadySelected = SearchItemPanel.this.isMatch();
                Color bg = isAlreadySelected ? SearchItemPanel.this.nonHighlightColor : ColorScheme.MEDIUM_GRAY_COLOR;
                for (JPanel panel : SearchItemPanel.this.highlightPanels) {
                    SearchItemPanel.this.matchComponentBackground(panel, bg);
                }
                clientThread.invokeLater(() -> {
                    if (!swapManager.isItemLocked(slot)) {
                        listener.onSearchSelectionChanging(slot);
                        swapManager.hoverSelectItem(slot, itemId);
                    }
                });
            }
        };
        this.addMouseListener(itemPanelMouseListener);
        int rows = score == null ? 1 : 2;
        JPanel rightPanel = new JPanel(new GridLayout(rows, 1));
        rightPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.highlightPanels.add(rightPanel);
        rightPanel.add(this.label);
        if (score != null) {
            DecimalFormat format = new DecimalFormat("#.#");
            JLabel scoreLabel = new JLabel();
            scoreLabel.setForeground(Color.WHITE);
            scoreLabel.setMaximumSize(new Dimension(0, 0));
            scoreLabel.setPreferredSize(new Dimension(0, 0));
            scoreLabel.setText(format.format(score * 100.0) + "%");
            scoreLabel.setForeground(this.getScoreColor(score));
            rightPanel.add(scoreLabel);
        }
        for (JPanel panel : this.highlightPanels) {
            this.matchComponentBackground(panel, this.defaultBackgroundColor());
        }
        this.add((Component)rightPanel, "Center");
    }

    public void resetBackground() {
        for (JPanel panel : this.highlightPanels) {
            this.matchComponentBackground(panel, this.nonHighlightColor);
        }
    }

    private Color defaultBackgroundColor() {
        if (this.isMatch()) {
            return ColorScheme.MEDIUM_GRAY_COLOR;
        }
        return this.nonHighlightColor;
    }

    private boolean isMatch() {
        if (this.itemId < 0) {
            return this.swapManager.isHidden(this.slot);
        }
        return Objects.equals(this.swapManager.swappedItemIdIn(this.slot), this.itemId);
    }

    private Color getScoreColor(Double score) {
        int red = (int)(255.0 * (1.0 - Math.pow(score, 2.0)));
        int green = (int)(255.0 * Math.pow(score, 2.0));
        return new Color(red, green, 0);
    }
}

