/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.panel;

import com.google.common.base.Objects;
import eq.uirs.fashionscape.FashionscapeConfig;
import eq.uirs.fashionscape.data.ColorType;
import eq.uirs.fashionscape.data.kit.JawIcon;
import eq.uirs.fashionscape.panel.DropdownIconPanel;
import eq.uirs.fashionscape.panel.JawIconPanel;
import eq.uirs.fashionscape.panel.KitColorOpener;
import eq.uirs.fashionscape.panel.KitItemPanel;
import eq.uirs.fashionscape.panel.PanelKitSlot;
import eq.uirs.fashionscape.swap.SwapManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KitsPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(KitsPanel.class);
    private final SwapManager swapManager;
    private final ClientThread clientThread;
    private final ItemManager itemManager;
    private final Client client;
    private final FashionscapeConfig config;
    private final JPanel resultsPanel = new JPanel();
    private final JScrollPane scrollPane = new JScrollPane();
    private final List<KitItemPanel> kitPanels = new ArrayList<KitItemPanel>();
    private JawIconPanel jawIconPanel = null;
    private Boolean isFemale = null;
    private final KitColorOpener kitColorOpener = (slot, type) -> {
        this.kitPanels.forEach(panel -> {
            if (Objects.equal((Object)slot, (Object)panel.getSlot()) && Objects.equal((Object)((Object)type), (Object)((Object)panel.getType()))) {
                Boolean female = this.isFemale();
                if (female != null) {
                    panel.openOptions(female);
                }
            } else {
                panel.closeOptions();
            }
        });
        if (this.jawIconPanel != null) {
            if (slot == null && type == null) {
                this.jawIconPanel.openOptions();
            } else {
                this.jawIconPanel.closeOptions();
            }
        }
        this.updateUI();
        this.scrollPane.revalidate();
    };

    @Inject
    public KitsPanel(SwapManager swapManager, ClientThread clientThread, Client client, FashionscapeConfig config, ItemManager itemManager) {
        this.swapManager = swapManager;
        this.clientThread = clientThread;
        this.client = client;
        this.config = config;
        this.itemManager = itemManager;
        this.setLayout(new GridLayout(1, 1));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.resultsPanel.setLayout(new GridBagLayout());
        this.resultsPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.scrollPane.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(10, 0));
        JPanel resultsWrapper = new JPanel(new BorderLayout());
        resultsWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
        resultsWrapper.add((Component)this.resultsPanel, "North");
        this.scrollPane.setViewportView(resultsWrapper);
        this.add((Component)this.scrollPane, "Center");
        this.populateKitSlots();
    }

    public void collapseOptions() {
        for (KitItemPanel kitPanel : this.kitPanels) {
            kitPanel.closeOptions();
        }
        this.updateUI();
        this.scrollPane.revalidate();
    }

    void populateKitSlots() {
        this.clientThread.invokeLater(() -> {
            ArrayList<KitColorResult> results = new ArrayList<KitColorResult>();
            for (PanelKitSlot slot : PanelKitSlot.values()) {
                KitType kitType = slot.getKitType();
                ColorType colorType = slot.getColorType();
                Integer kitId = null;
                Integer colorId = null;
                if (KitType.JAW.equals((Object)kitType) && Objects.equal((Object)this.isFemale(), (Object)true)) continue;
                if (kitType == null && colorType == null) {
                    if (this.config.excludeNonStandardItems() || this.config.excludeMembersItems()) continue;
                    JawIcon jawIcon = this.swapManager.swappedIcon();
                    Integer iconId = jawIcon != null ? Integer.valueOf(jawIcon.getId()) : null;
                    results.add(new KitColorResult(null, iconId, null, null));
                    continue;
                }
                if (kitType != null) {
                    kitId = this.swapManager.swappedKitIdIn(kitType);
                }
                if (colorType != null) {
                    colorId = this.swapManager.swappedColorIdIn(colorType);
                }
                results.add(new KitColorResult(kitType, kitId, colorType, colorId));
            }
            SwingUtilities.invokeLater(() -> this.addKitSlotPanels(results));
        });
    }

    private void addKitSlotPanels(List<KitColorResult> results) {
        this.resultsPanel.removeAll();
        this.kitPanels.clear();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 19;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        for (KitColorResult result : results) {
            DropdownIconPanel panel;
            BufferedImage image = null;
            if (result.colorType == null && result.slot == null) {
                JawIconPanel jawPanel;
                image = ImageUtil.loadImageResource(this.getClass(), (String)"icon.png");
                this.jawIconPanel = jawPanel = new JawIconPanel(image, this.clientThread, this.swapManager, this.itemManager, this.kitColorOpener, result.id);
                panel = jawPanel;
            } else {
                if (result.slot != null) {
                    image = ImageUtil.loadImageResource(this.getClass(), (String)(result.slot.name().toLowerCase() + ".png"));
                }
                KitItemPanel kitPanel = new KitItemPanel(this.swapManager, result.colorType, result.colorId, result.slot, result.id, this.kitColorOpener, image, this.clientThread);
                this.kitPanels.add(kitPanel);
                panel = kitPanel;
            }
            JPanel marginWrapper = new JPanel(new BorderLayout());
            marginWrapper.setBackground(ColorScheme.DARK_GRAY_COLOR);
            marginWrapper.setBorder(new EmptyBorder(5, 0, 0, 0));
            marginWrapper.add((Component)panel, "North");
            this.resultsPanel.add((Component)marginWrapper, c);
            ++c.gridy;
        }
        this.revalidate();
        this.repaint();
    }

    public void onPlayerChanged(Player player) {
        PlayerComposition composition;
        if (player != null && (composition = player.getPlayerComposition()) != null) {
            boolean female;
            boolean bl = female = composition.getGender() == 1;
            if (this.isFemale == null || female != this.isFemale) {
                this.isFemale = female;
                this.populateKitSlots();
            }
        }
    }

    @Nullable
    private Boolean isFemale() {
        PlayerComposition composition;
        Player player = this.client.getLocalPlayer();
        if (player != null && (composition = player.getPlayerComposition()) != null) {
            return composition.getGender() == 1;
        }
        return null;
    }

    private static final class KitColorResult {
        private final KitType slot;
        private final Integer id;
        private final ColorType colorType;
        private final Integer colorId;

        public KitColorResult(KitType slot, Integer id, ColorType colorType, Integer colorId) {
            this.slot = slot;
            this.id = id;
            this.colorType = colorType;
            this.colorId = colorId;
        }

        public KitType getSlot() {
            return this.slot;
        }

        public Integer getId() {
            return this.id;
        }

        public ColorType getColorType() {
            return this.colorType;
        }

        public Integer getColorId() {
            return this.colorId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KitColorResult)) {
                return false;
            }
            KitColorResult other = (KitColorResult)o;
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Integer this$colorId = this.getColorId();
            Integer other$colorId = other.getColorId();
            if (this$colorId == null ? other$colorId != null : !((Object)this$colorId).equals(other$colorId)) {
                return false;
            }
            KitType this$slot = this.getSlot();
            KitType other$slot = other.getSlot();
            if (this$slot == null ? other$slot != null : !this$slot.equals(other$slot)) {
                return false;
            }
            ColorType this$colorType = this.getColorType();
            ColorType other$colorType = other.getColorType();
            return !(this$colorType == null ? other$colorType != null : !((Object)((Object)this$colorType)).equals((Object)other$colorType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Integer $colorId = this.getColorId();
            result = result * 59 + ($colorId == null ? 43 : ((Object)$colorId).hashCode());
            KitType $slot = this.getSlot();
            result = result * 59 + ($slot == null ? 43 : $slot.hashCode());
            ColorType $colorType = this.getColorType();
            result = result * 59 + ($colorType == null ? 43 : ((Object)((Object)$colorType)).hashCode());
            return result;
        }

        public String toString() {
            return "KitsPanel.KitColorResult(slot=" + this.getSlot() + ", id=" + this.getId() + ", colorType=" + this.getColorType() + ", colorId=" + this.getColorId() + ")";
        }
    }
}

