/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.panel;

import com.google.common.base.Objects;
import eq.uirs.fashionscape.data.ColorType;
import eq.uirs.fashionscape.data.Colorable;
import eq.uirs.fashionscape.data.kit.Kit;
import eq.uirs.fashionscape.panel.DropdownIconPanel;
import eq.uirs.fashionscape.panel.KitColorOpener;
import eq.uirs.fashionscape.panel.RoundedBorder;
import eq.uirs.fashionscape.swap.SwapManager;
import eq.uirs.fashionscape.swap.event.ColorChangedListener;
import eq.uirs.fashionscape.swap.event.ColorLockChangedListener;
import eq.uirs.fashionscape.swap.event.KitChangedListener;
import eq.uirs.fashionscape.swap.event.LockChanged;
import eq.uirs.fashionscape.swap.event.LockChangedListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KitItemPanel
extends DropdownIconPanel {
    private static final Logger log = LoggerFactory.getLogger(KitItemPanel.class);
    private static final Dimension COLOR_CHOOSER_SIZE = new Dimension(15, 15);
    private final ColorType type;
    private final KitType slot;
    private final SwapManager swapManager;
    private final KitColorOpener kitColorOpener;
    private final Map<Integer, Colorable> colorMap = new HashMap<Integer, Colorable>();
    private final JButton lockColorButton = new JButton();
    private final List<Kit> allKits = new ArrayList<Kit>();
    private Integer colorId;
    private Color color;
    private Integer kitId;

    public KitItemPanel(SwapManager swapManager, ColorType type, Integer colorId, KitType slot, Integer kitId, KitColorOpener kitColorOpener, BufferedImage image, ClientThread clientThread) {
        super(image, clientThread);
        this.swapManager = swapManager;
        this.kitColorOpener = kitColorOpener;
        this.slot = slot;
        this.type = type;
        this.colorId = colorId;
        this.kitId = kitId;
        if (type != null) {
            for (Colorable colorable : type.getColorables()) {
                this.colorMap.put(colorable.getColorId(type), colorable);
            }
        }
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setBackground(this.nonHighlightColor);
        rightPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.highlightPanels.add(rightPanel);
        rightPanel.add((Component)this.label, "Center");
        this.setIconTooltip();
        int cols = type != null && slot != null ? 3 : 2;
        JPanel buttons = new JPanel(new GridLayout(1, cols, 2, 0));
        buttons.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        if (slot != null) {
            this.allKits.clear();
            this.allKits.addAll(Arrays.asList(Kit.allInSlot(slot, false)));
            this.setKitName();
            this.setIcon(this.icon, image);
            swapManager.addEventListener(new KitChangedListener(e -> {
                if (Objects.equal((Object)slot, (Object)e.getSlot())) {
                    this.kitId = e.getKitId();
                    this.setKitName();
                    this.updateXButton();
                }
            }));
            this.configureButton(this.lockButton);
            this.lockButton.addActionListener(e -> {
                swapManager.toggleKitLocked(slot);
                this.updateLockButton();
                this.updateXButton();
            });
            buttons.add(this.lockButton);
        } else if (type != null) {
            BufferedImage colorImage = ImageUtil.loadImageResource(this.getClass(), (String)"color.png");
            this.setIcon(this.icon, colorImage);
            this.setColorName();
        }
        if (type != null) {
            this.setIconColor();
            swapManager.addEventListener(new ColorChangedListener(e -> {
                if (Objects.equal((Object)((Object)type), (Object)((Object)e.getType()))) {
                    this.colorId = e.getColorId();
                    this.setIconColor();
                    if (slot == null) {
                        this.setColorName();
                    }
                    this.setIconTooltip();
                    this.updateXButton();
                }
            }));
            this.configureButton(this.lockColorButton);
            this.lockColorButton.addActionListener(e -> {
                swapManager.toggleColorLocked(type);
                this.updateColorLockButton();
                this.updateXButton();
            });
            buttons.add(this.lockColorButton);
        } else {
            this.icon.setBorder(new RoundedBorder(ColorScheme.LIGHT_GRAY_COLOR, 15));
        }
        this.configureButton(this.xButton);
        this.xButton.setIcon(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"x.png")));
        this.xButton.addActionListener(e -> clientThread.invokeLater(() -> {
            swapManager.revert(slot, type);
            SwingUtilities.invokeLater(() -> {
                this.updateLockButton();
                this.updateColorLockButton();
                this.updateXButton();
            });
        }));
        buttons.add(this.xButton);
        this.updateLockButton();
        this.updateColorLockButton();
        this.updateXButton();
        this.optionsContainer.setLayout(new BorderLayout());
        this.optionsContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.optionsContainer.setVisible(false);
        this.add((Component)this.optionsContainer, "South");
        rightPanel.add((Component)buttons, "East");
        this.add((Component)rightPanel, "Center");
        swapManager.addEventListener(new LockChangedListener(e -> {
            if (Objects.equal((Object)e.getSlot(), (Object)slot) && e.getType() != LockChanged.Type.ITEM) {
                this.updateLockButton();
            }
        }));
        swapManager.addEventListener(new ColorLockChangedListener(e -> {
            if (Objects.equal((Object)((Object)e.getType()), (Object)((Object)type))) {
                this.updateColorLockButton();
            }
        }));
    }

    @Override
    void openDropdown() {
        this.kitColorOpener.openOptions(this.slot, this.type);
    }

    public void openOptions(boolean isFemale) {
        this.optionsContainer.removeAll();
        if (this.optionsContainer.isVisible()) {
            this.optionsContainer.setVisible(false);
            return;
        }
        this.optionsContainer.setVisible(true);
        JPanel colorsBox = new JPanel();
        colorsBox.setLayout(new GridBagLayout());
        colorsBox.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        if (this.type != null) {
            colorsBox.setBorder(new EmptyBorder(10, 0, 0, 0));
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 0;
            c.anchor = 21;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            for (final Colorable colorable : this.type.getColorables()) {
                JLabel colorLabel = new JLabel();
                colorLabel.setOpaque(true);
                colorLabel.setBackground(colorable.getColor());
                colorLabel.setPreferredSize(COLOR_CHOOSER_SIZE);
                colorLabel.setToolTipText(colorable.getDisplayName());
                colorLabel.setBorder(BorderFactory.createLineBorder(ColorScheme.LIGHT_GRAY_COLOR));
                colorLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (!KitItemPanel.this.swapManager.isColorLocked(KitItemPanel.this.type)) {
                            KitItemPanel.this.setCursor(new Cursor(12));
                        }
                        KitItemPanel.this.swapManager.hoverOverColor(KitItemPanel.this.type, colorable.getColorId(KitItemPanel.this.type));
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        KitItemPanel.this.setCursor(new Cursor(0));
                        KitItemPanel.this.swapManager.hoverAway();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        KitItemPanel.this.swapManager.hoverSelectColor(KitItemPanel.this.type, colorable.getColorId(KitItemPanel.this.type));
                    }
                });
                JPanel colorWrapper = new JPanel(new BorderLayout());
                colorWrapper.setBorder(new EmptyBorder(1, 1, 1, 1));
                colorWrapper.add((Component)colorLabel, "Center");
                colorsBox.add((Component)colorWrapper, c);
                if (c.gridx == 9) {
                    c.gridx = 0;
                    ++c.gridy;
                    continue;
                }
                ++c.gridx;
            }
        }
        this.optionsContainer.add((Component)colorsBox, "North");
        JPanel kitsList = new JPanel();
        kitsList.setLayout(new GridBagLayout());
        kitsList.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        if (this.slot != null) {
            kitsList.setBorder(new EmptyBorder(10, 0, 0, 0));
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 21;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            for (Kit kit : this.allKits) {
                final Integer kitId = kit.getKitId(isFemale);
                if (kitId == null) continue;
                JLabel kitLabel = new JLabel();
                kitLabel.setBorder(new EmptyBorder(5, 5, 0, 5));
                kitLabel.setText(kit.getDisplayName());
                kitLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (!KitItemPanel.this.swapManager.isKitLocked(KitItemPanel.this.slot)) {
                            KitItemPanel.this.setCursor(new Cursor(12));
                        }
                        KitItemPanel.this.swapManager.hoverOverKit(KitItemPanel.this.slot, kitId);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        KitItemPanel.this.setCursor(new Cursor(0));
                        KitItemPanel.this.swapManager.hoverAway();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        KitItemPanel.this.swapManager.hoverSelectKit(KitItemPanel.this.slot, kitId);
                    }
                });
                kitsList.add((Component)kitLabel, c);
                ++c.gridy;
            }
        }
        this.optionsContainer.add((Component)kitsList, "Center");
        this.optionsContainer.updateUI();
    }

    public void closeOptions() {
        this.optionsContainer.removeAll();
        this.optionsContainer.setVisible(false);
    }

    private void setKitName() {
        Kit kit;
        String kitName = "Not set";
        if (this.kitId != null && (kit = SwapManager.KIT_ID_TO_KIT.get(this.kitId)) != null) {
            kitName = kit.getDisplayName();
        }
        this.label.setText(kitName);
    }

    private void setColorName() {
        String colorName = "Not set";
        if (this.colorId != null) {
            try {
                colorName = this.colorMap.get(this.colorId).getDisplayName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.label.setText(colorName);
    }

    private void setIconColor() {
        Colorable colorable;
        this.color = ColorScheme.LIGHT_GRAY_COLOR;
        if (this.colorId != null && (colorable = this.colorMap.get(this.colorId)) != null) {
            this.color = colorable.getColor();
        }
        RoundedBorder border = new RoundedBorder(this.color, 15);
        this.icon.setBorder(border);
        this.updateColorLockButton();
    }

    private void setIconTooltip() {
        Colorable colorable;
        StringBuilder sb = new StringBuilder();
        if (this.slot != null) {
            sb.append(Text.titleCase((Enum)this.slot));
        } else if (this.type != null) {
            sb.append(Text.titleCase((Enum)this.type));
        }
        if (this.type != null && (colorable = this.colorMap.get(this.colorId)) != null) {
            if (sb.length() > 0) {
                sb.append(": ");
            }
            sb.append(colorable.getDisplayName().toLowerCase());
        }
        this.icon.setToolTipText(sb.toString());
    }

    private void updateLockButton() {
        if (this.slot != null) {
            boolean locked = this.swapManager.isKitLocked(this.slot);
            String lockIcon = locked ? "lock" : "unlock";
            this.lockButton.setIcon(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)(lockIcon + ".png"))));
            String action = locked ? "Unlock" : "Lock";
            this.lockButton.setToolTipText(action + " " + this.slot.name().toLowerCase() + " slot");
        }
    }

    private void updateColorLockButton() {
        if (this.type != null) {
            boolean locked = this.swapManager.isColorLocked(this.type);
            String lockStr = locked ? "lock" : "unlock";
            BufferedImage lockIcon = ImageUtil.loadImageResource(this.getClass(), (String)(lockStr + ".png"));
            lockIcon = this.fillImage(lockIcon, this.color, 50);
            this.lockColorButton.setIcon(new ImageIcon(lockIcon));
            String action = locked ? "Unlock" : "Lock";
            this.lockColorButton.setToolTipText(action + " " + this.type.name().toLowerCase() + " colour");
        }
    }

    private void updateXButton() {
        this.xButton.setEnabled(this.colorId != null || this.kitId != null);
        Object text = this.slot != null ? this.slot.name().toLowerCase() + " slot" : (this.type != null ? this.type.name().toLowerCase() + " colour" : "");
        this.xButton.setToolTipText("Clear " + (String)text);
    }

    public BufferedImage fillImage(BufferedImage image, Color color, int alphaThreshold) {
        BufferedImage filledImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int x = 0; x < filledImage.getWidth(); ++x) {
            for (int y = 0; y < filledImage.getHeight(); ++y) {
                int pixel = image.getRGB(x, y);
                int a = pixel >>> 24;
                if (a < alphaThreshold) continue;
                filledImage.setRGB(x, y, color.getRGB());
            }
        }
        return filledImage;
    }

    public ColorType getType() {
        return this.type;
    }

    public KitType getSlot() {
        return this.slot;
    }
}

