/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.panel;

import com.google.common.base.Objects;
import eq.uirs.fashionscape.data.kit.JawIcon;
import eq.uirs.fashionscape.panel.DropdownIconPanel;
import eq.uirs.fashionscape.panel.KitColorOpener;
import eq.uirs.fashionscape.panel.RoundedBorder;
import eq.uirs.fashionscape.swap.SwapManager;
import eq.uirs.fashionscape.swap.event.IconChangedListener;
import eq.uirs.fashionscape.swap.event.IconLockChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.ItemComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JawIconPanel
extends DropdownIconPanel {
    private static final Logger log = LoggerFactory.getLogger(JawIconPanel.class);
    private final SwapManager swapManager;
    private final ItemManager itemManager;
    private final KitColorOpener kitColorOpener;
    private JawIcon jawIcon = null;

    JawIconPanel(BufferedImage image, ClientThread clientThread, SwapManager swapManager, ItemManager itemManager, KitColorOpener kitColorOpener, Integer iconId) {
        super(image, clientThread);
        this.swapManager = swapManager;
        this.itemManager = itemManager;
        this.kitColorOpener = kitColorOpener;
        Arrays.stream(JawIcon.values()).filter(i -> Objects.equal((Object)i.getId(), (Object)iconId)).findFirst().ifPresent(i -> {
            this.jawIcon = i;
        });
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setBackground(this.nonHighlightColor);
        rightPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.highlightPanels.add(rightPanel);
        rightPanel.add((Component)this.label, "Center");
        this.setIconTooltip();
        JPanel buttons = new JPanel(new GridLayout(1, 2, 2, 0));
        buttons.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setIcon(this.icon, image);
        this.icon.setBorder(new RoundedBorder(ColorScheme.LIGHT_GRAY_COLOR, 15));
        swapManager.addEventListener(new IconChangedListener(e -> {
            if (!Objects.equal((Object)((Object)this.jawIcon), (Object)((Object)e.getIcon()))) {
                this.jawIcon = e.getIcon();
                this.setIconName();
                this.updateIconImage();
                this.updateXButton();
            }
        }));
        swapManager.addEventListener(new IconLockChangedListener(e -> this.updateLockButton()));
        this.configureButton(this.lockButton);
        this.lockButton.addActionListener(e -> {
            swapManager.toggleIconLocked();
            this.updateLockButton();
            this.updateXButton();
        });
        buttons.add(this.lockButton);
        this.configureButton(this.xButton);
        this.xButton.setIcon(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)"x.png")));
        this.xButton.addActionListener(e -> clientThread.invokeLater(() -> {
            swapManager.revertIcon();
            SwingUtilities.invokeLater(() -> {
                this.updateLockButton();
                this.updateXButton();
            });
        }));
        buttons.add(this.xButton);
        this.updateLockButton();
        this.updateXButton();
        this.optionsContainer.setLayout(new BorderLayout());
        this.optionsContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.optionsContainer.setVisible(false);
        this.add((Component)this.optionsContainer, "South");
        rightPanel.add((Component)buttons, "East");
        this.add((Component)rightPanel, "Center");
        this.setIconName();
        this.updateIconImage();
    }

    @Override
    void openDropdown() {
        this.kitColorOpener.openOptions(null, null);
    }

    public void openOptions() {
        this.optionsContainer.removeAll();
        if (this.optionsContainer.isVisible()) {
            this.optionsContainer.setVisible(false);
            return;
        }
        this.optionsContainer.setVisible(true);
        JPanel iconsList = new JPanel();
        iconsList.setLayout(new GridBagLayout());
        iconsList.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        iconsList.setBorder(new EmptyBorder(10, 0, 0, 0));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 21;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        for (final JawIcon jawIcon : JawIcon.values()) {
            if (jawIcon == JawIcon.NOTHING) continue;
            JLabel iconLabel = new JLabel();
            iconLabel.setBorder(new EmptyBorder(5, 5, 0, 5));
            iconLabel.setText(jawIcon.getDisplayName());
            iconLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!JawIconPanel.this.swapManager.isIconLocked()) {
                        JawIconPanel.this.setCursor(new Cursor(12));
                    }
                    JawIconPanel.this.swapManager.hoverOverIcon(jawIcon);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    JawIconPanel.this.setCursor(new Cursor(0));
                    JawIconPanel.this.swapManager.hoverAway();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    JawIconPanel.this.swapManager.hoverSelectIcon(jawIcon);
                }
            });
            iconsList.add((Component)iconLabel, c);
            ++c.gridy;
        }
        this.optionsContainer.add((Component)iconsList, "Center");
        this.optionsContainer.updateUI();
    }

    public void closeOptions() {
        this.optionsContainer.removeAll();
        this.optionsContainer.setVisible(false);
    }

    private void setIconName() {
        String iconName = "Not set";
        if (this.jawIcon != null) {
            iconName = this.jawIcon.getDisplayName();
        }
        this.label.setText(iconName);
    }

    private void updateIconImage() {
        if (this.jawIcon != null && this.jawIcon != JawIcon.NOTHING) {
            this.clientThread.invokeLater(() -> {
                ItemComposition itemComposition = this.itemManager.getItemComposition(this.jawIcon.getId());
                AsyncBufferedImage image = this.itemManager.getImage(itemComposition.getId());
                image.addTo(this.icon);
            });
        } else {
            BufferedImage image = ImageUtil.loadImageResource(this.getClass(), (String)"icon.png");
            this.setIcon(this.icon, image);
        }
    }

    private void updateXButton() {
        this.xButton.setEnabled(this.jawIcon != null);
        this.xButton.setToolTipText("Clear icon");
    }

    private void updateLockButton() {
        boolean locked = this.swapManager.isIconLocked();
        String lockIcon = locked ? "lock" : "unlock";
        this.lockButton.setIcon(new ImageIcon(ImageUtil.loadImageResource(this.getClass(), (String)(lockIcon + ".png"))));
        String action = locked ? "Unlock" : "Lock";
        this.lockButton.setToolTipText(action + " icon");
    }

    private void setIconTooltip() {
        StringBuilder sb = new StringBuilder();
        sb.append("Icon");
        if (this.jawIcon != null) {
            if (sb.length() > 0) {
                sb.append(": ");
            }
            sb.append(this.jawIcon.getDisplayName().toLowerCase());
        }
        this.icon.setToolTipText(sb.toString());
    }
}

