/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.panel;

import eq.uirs.fashionscape.FashionscapePlugin;
import eq.uirs.fashionscape.data.ColorType;
import eq.uirs.fashionscape.panel.KitsPanel;
import eq.uirs.fashionscape.panel.SearchOpener;
import eq.uirs.fashionscape.panel.SearchPanel;
import eq.uirs.fashionscape.panel.SwapsPanel;
import eq.uirs.fashionscape.swap.SwapManager;
import eq.uirs.fashionscape.swap.event.ColorChangedListener;
import eq.uirs.fashionscape.swap.event.ColorLockChangedListener;
import eq.uirs.fashionscape.swap.event.IconChangedListener;
import eq.uirs.fashionscape.swap.event.ItemChangedListener;
import eq.uirs.fashionscape.swap.event.KitChangedListener;
import eq.uirs.fashionscape.swap.event.LockChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.kit.KitType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;

public class FashionscapePanel
extends PluginPanel {
    private final Client client;
    private final ClientThread clientThread;
    private final SwapManager swapManager;
    private JButton undo;
    private JButton redo;
    private JButton shuffle;
    private JButton save;
    private JButton load;
    private JButton clear;
    private final SearchClearingPanel tabDisplayPanel;
    private final MaterialTabGroup tabGroup;
    private final MaterialTab searchTab;
    private final SearchPanel searchPanel;
    private final KitsPanel kitsPanel;

    @Inject
    public FashionscapePanel(final SearchPanel searchPanel, KitsPanel kitsPanel, SwapManager swapManager, ItemManager itemManager, Client client, ClientThread clientThread) {
        super(false);
        this.client = client;
        this.clientThread = clientThread;
        this.swapManager = swapManager;
        this.tabDisplayPanel = new SearchClearingPanel(searchPanel);
        this.tabGroup = new MaterialTabGroup((JPanel)this.tabDisplayPanel);
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel tabPanel = new JPanel();
        tabPanel.setLayout(new BorderLayout());
        tabPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        SearchOpener searchOpener = new SearchOpener(){

            @Override
            public void openSearchFor(KitType slot) {
                FashionscapePanel.this.tabGroup.select(FashionscapePanel.this.searchTab);
                searchPanel.chooseSlot(slot);
                searchPanel.clearSearch();
            }
        };
        SwapsPanel swapsPanel = new SwapsPanel(swapManager, itemManager, searchOpener, clientThread);
        this.searchPanel = searchPanel;
        this.kitsPanel = kitsPanel;
        MaterialTab swapsTab = new MaterialTab("Items", this.tabGroup, (JComponent)swapsPanel);
        MaterialTab kitsTab = new MaterialTab("Base", this.tabGroup, (JComponent)kitsPanel);
        this.searchTab = new MaterialTab("Search", this.tabGroup, (JComponent)searchPanel);
        this.searchTab.setOnSelectEvent(() -> {
            this.tabDisplayPanel.shouldClearSearch = false;
            searchPanel.reloadResults();
            kitsPanel.collapseOptions();
            return true;
        });
        kitsTab.setOnSelectEvent(() -> {
            this.tabDisplayPanel.shouldClearSearch = true;
            return true;
        });
        swapsTab.setOnSelectEvent(() -> {
            this.tabDisplayPanel.shouldClearSearch = true;
            kitsPanel.collapseOptions();
            return true;
        });
        this.tabGroup.setBorder((Border)new EmptyBorder(5, 0, 0, 0));
        this.tabGroup.addTab(swapsTab);
        this.tabGroup.addTab(kitsTab);
        this.tabGroup.addTab(this.searchTab);
        this.tabGroup.select(swapsTab);
        JPanel buttonPanel = this.setUpButtonPanel();
        this.add(buttonPanel, "North");
        tabPanel.add((Component)this.tabGroup, "North");
        tabPanel.add((Component)this.tabDisplayPanel, "Center");
        this.add(tabPanel, "Center");
        Runnable lockListener = () -> {
            boolean loggedIn = client.getGameState() == GameState.LOGGED_IN;
            boolean unlocked = this.hasUnlocked();
            boolean nonEmpty = this.hasNonEmpty();
            this.checkButtonEnabled(this.shuffle, loggedIn, unlocked, nonEmpty);
            this.checkButtonEnabled(this.clear, loggedIn, unlocked, nonEmpty);
        };
        swapManager.addEventListener(new LockChangedListener(e -> lockListener.run()));
        swapManager.addEventListener(new ColorLockChangedListener(e -> lockListener.run()));
        Runnable saveClearListener = () -> {
            boolean loggedIn = client.getGameState() == GameState.LOGGED_IN;
            boolean unlocked = this.hasUnlocked();
            boolean nonEmpty = this.hasNonEmpty();
            this.checkButtonEnabled(this.save, loggedIn, unlocked, nonEmpty);
            this.checkButtonEnabled(this.clear, loggedIn, unlocked, nonEmpty);
        };
        swapManager.addEventListener(new ItemChangedListener(e -> saveClearListener.run()));
        swapManager.addEventListener(new KitChangedListener(e -> saveClearListener.run()));
        swapManager.addEventListener(new ColorChangedListener(e -> saveClearListener.run()));
        swapManager.addEventListener(new IconChangedListener(e -> saveClearListener.run()));
    }

    public void onGameStateChanged(GameStateChanged event) {
        boolean loggedIn = event.getGameState() == GameState.LOGGED_IN;
        boolean hasNonEmpty = this.hasNonEmpty();
        boolean hasUnlocked = this.hasUnlocked();
        this.checkButtonEnabled(this.undo, loggedIn, hasUnlocked, hasNonEmpty);
        this.checkButtonEnabled(this.redo, loggedIn, hasUnlocked, hasNonEmpty);
        this.checkButtonEnabled(this.shuffle, loggedIn, hasUnlocked, hasNonEmpty);
        this.checkButtonEnabled(this.save, loggedIn, hasUnlocked, hasNonEmpty);
        this.checkButtonEnabled(this.load, loggedIn, hasUnlocked, hasNonEmpty);
        this.checkButtonEnabled(this.clear, loggedIn, hasUnlocked, hasNonEmpty);
    }

    public void onPlayerChanged(Player player) {
        if (this.kitsPanel != null) {
            this.kitsPanel.onPlayerChanged(player);
        }
    }

    public void reloadResults() {
        if (this.searchPanel != null) {
            this.searchPanel.reloadResults();
        }
    }

    public void refreshKitsPanel() {
        if (this.kitsPanel != null) {
            this.kitsPanel.populateKitSlots();
        }
    }

    private JPanel setUpButtonPanel() {
        JPanel buttonContainer = new JPanel();
        buttonContainer.setBorder(new EmptyBorder(5, 10, 0, 10));
        buttonContainer.setLayout(new GridBagLayout());
        buttonContainer.setBackground(ColorScheme.DARK_GRAY_COLOR);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(0, 1, 0, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        boolean isLoggedIn = this.client.getGameState() == GameState.LOGGED_IN;
        boolean hasUnlocked = this.hasUnlocked();
        boolean hasNonEmpty = this.hasNonEmpty();
        this.undo = new JButton(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"undo.png")));
        this.undo.setToolTipText("Undo");
        this.undo.addActionListener(e -> this.clientThread.invokeLater(() -> {
            this.swapManager.undoLastSwap();
            this.reloadResults();
        }));
        this.checkButtonEnabled(this.undo, isLoggedIn, hasUnlocked, hasNonEmpty);
        this.undo.addMouseListener(this.createHoverListener(this.undo));
        this.swapManager.addUndoQueueChangeListener(size -> this.checkButtonEnabled(this.undo, null, null, null));
        this.undo.setFocusPainted(false);
        buttonContainer.add((Component)this.undo, c);
        ++c.gridx;
        this.redo = new JButton(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"redo.png")));
        this.redo.setToolTipText("Redo");
        this.redo.addActionListener(e -> this.clientThread.invokeLater(() -> {
            this.swapManager.redoLastSwap();
            this.reloadResults();
        }));
        this.checkButtonEnabled(this.redo, isLoggedIn, hasUnlocked, hasNonEmpty);
        this.redo.addMouseListener(this.createHoverListener(this.redo));
        this.swapManager.addRedoQueueChangeListener(size -> this.checkButtonEnabled(this.redo, null, null, null));
        this.redo.setFocusPainted(false);
        buttonContainer.add((Component)this.redo, c);
        ++c.gridx;
        this.shuffle = new JButton(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"shuffle.png")));
        this.shuffle.setSize(12, 12);
        this.shuffle.setToolTipText("Randomize");
        this.shuffle.addActionListener(e -> this.clientThread.invokeLater(() -> {
            this.swapManager.shuffle();
            this.reloadResults();
        }));
        this.checkButtonEnabled(this.shuffle, isLoggedIn, hasUnlocked, hasNonEmpty);
        this.shuffle.setFocusPainted(false);
        this.shuffle.addMouseListener(this.createHoverListener(this.shuffle));
        buttonContainer.add((Component)this.shuffle, c);
        ++c.gridx;
        JPopupMenu openSavedFolderMenu = new JPopupMenu();
        JMenuItem openAll = new JMenuItem("Open outfits folder");
        openAll.addActionListener(e -> LinkBrowser.open((String)FashionscapePlugin.OUTFITS_DIR.toString()));
        openSavedFolderMenu.add(openAll);
        this.save = new JButton(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"save.png")));
        this.save.setToolTipText("Save");
        this.save.addActionListener(e -> this.openSaveDialog());
        this.save.setFocusPainted(false);
        this.save.addMouseListener(this.createHoverListener(this.save));
        this.save.setComponentPopupMenu(openSavedFolderMenu);
        this.checkButtonEnabled(this.save, isLoggedIn, hasUnlocked, hasNonEmpty);
        buttonContainer.add((Component)this.save, c);
        ++c.gridx;
        this.load = new JButton(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"load.png")));
        this.load.setToolTipText("Load");
        this.load.addActionListener(e -> this.openLoadDialog());
        this.load.setFocusPainted(false);
        this.load.setComponentPopupMenu(openSavedFolderMenu);
        this.checkButtonEnabled(this.load, isLoggedIn, hasUnlocked, hasNonEmpty);
        this.load.addMouseListener(this.createHoverListener(this.load));
        buttonContainer.add((Component)this.load, c);
        ++c.gridx;
        JPopupMenu softClearMenu = new JPopupMenu();
        JMenuItem softClear = new JMenuItem("Soft clear");
        softClear.addActionListener(e -> this.clientThread.invokeLater(() -> {
            this.swapManager.revertSwaps(false, false);
            this.reloadResults();
        }));
        softClearMenu.add(softClear);
        this.clear = new JButton(new ImageIcon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"clear.png")));
        this.clear.setToolTipText("Clear all");
        this.clear.addActionListener(e -> this.clientThread.invokeLater(() -> {
            this.swapManager.revertSwaps(true, false);
            this.reloadResults();
        }));
        this.clear.setFocusPainted(false);
        this.clear.addMouseListener(this.createHoverListener(this.clear));
        this.clear.setComponentPopupMenu(softClearMenu);
        this.checkButtonEnabled(this.clear, isLoggedIn, hasUnlocked, hasNonEmpty);
        buttonContainer.add((Component)this.clear, c);
        return buttonContainer;
    }

    private void openSaveDialog() {
        File outputDir = FashionscapePlugin.OUTFITS_DIR;
        outputDir.mkdirs();
        JFileChooser fileChooser = new JFileChooser(outputDir){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.getName().endsWith(".txt")) {
                    f = new File(f.getPath() + ".txt");
                }
                if (f.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, "File already exists, overwrite?", "Warning", 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case -1: 
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        fileChooser.setSelectedFile(new File("outfit.txt"));
        fileChooser.setDialogTitle("Save current outfit");
        int option = fileChooser.showSaveDialog((Component)((Object)this));
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            if (!selectedFile.getName().endsWith(".txt")) {
                selectedFile = new File(selectedFile.getPath() + ".txt");
            }
            this.swapManager.exportSwaps(selectedFile);
        }
    }

    private void openLoadDialog() {
        File outputDir = FashionscapePlugin.OUTFITS_DIR;
        outputDir.mkdirs();
        JFileChooser fileChooser = new JFileChooser(outputDir);
        fileChooser.setDialogTitle("Select an outfit to load");
        int option = fileChooser.showOpenDialog((Component)((Object)this));
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            try (BufferedReader reader = new BufferedReader(new FileReader(selectedFile));){
                List<String> lines = reader.lines().collect(Collectors.toList());
                this.swapManager.loadImports(lines);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private MouseAdapter createHoverListener(final JButton jButton) {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (jButton.isEnabled()) {
                    FashionscapePanel.this.setCursor(new Cursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FashionscapePanel.this.setCursor(new Cursor(0));
            }
        };
    }

    private boolean hasNonEmpty() {
        long numSlotSwaps = Arrays.stream(KitType.values()).filter(slot -> {
            Integer item = this.swapManager.swappedItemIdIn((KitType)slot);
            Integer kit = this.swapManager.swappedKitIdIn((KitType)slot);
            boolean containsNothing = this.swapManager.isHidden((KitType)slot);
            return item != null || kit != null || containsNothing;
        }).count();
        long numColorSwaps = Arrays.stream(ColorType.values()).map(this.swapManager::swappedColorIdIn).filter(Objects::nonNull).count();
        boolean hasIcon = this.swapManager.swappedIcon() != null;
        return numSlotSwaps + numColorSwaps > 0L || hasIcon;
    }

    private boolean hasUnlocked() {
        long numUnlockedSlots = Arrays.stream(KitType.values()).filter(Objects::nonNull).map(this.swapManager::isSlotLocked).filter(b -> b == false).count();
        long numUnlockedColors = Arrays.stream(ColorType.values()).filter(Objects::nonNull).map(this.swapManager::isColorLocked).filter(b -> b == false).count();
        long unlockedIcon = this.swapManager.isIconLocked() ? 0L : 1L;
        return numUnlockedSlots + numUnlockedColors + unlockedIcon > 0L;
    }

    private void checkButtonEnabled(JButton button, Boolean isLoggedIn, Boolean hasUnlocked, Boolean hasNonEmpty) {
        if (button == null) {
            return;
        }
        boolean loggedIn = isLoggedIn != null ? isLoggedIn : this.client.getGameState() == GameState.LOGGED_IN;
        boolean unlocked = hasUnlocked != null ? hasUnlocked.booleanValue() : this.hasUnlocked();
        boolean nonEmpty = hasNonEmpty != null ? hasNonEmpty.booleanValue() : this.hasNonEmpty();
        boolean enabled = loggedIn;
        if (button == this.undo) {
            enabled &= this.swapManager.canUndo();
        } else if (button == this.redo) {
            enabled &= this.swapManager.canRedo();
        } else if (button == this.shuffle) {
            enabled &= unlocked;
        } else if (button == this.save) {
            enabled &= nonEmpty;
        } else if (button == this.clear) {
            enabled = nonEmpty;
        }
        button.setEnabled(enabled);
    }

    static class SearchClearingPanel
    extends JPanel {
        boolean shouldClearSearch = true;
        private final SearchPanel searchPanel;

        @Override
        public void removeAll() {
            if (this.shouldClearSearch) {
                this.searchPanel.clearResults();
            }
            super.removeAll();
        }

        public SearchClearingPanel(SearchPanel searchPanel) {
            this.searchPanel = searchPanel;
        }
    }
}

