/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.data.kit;

import eq.uirs.fashionscape.data.kit.ArmsKit;
import eq.uirs.fashionscape.data.kit.BootsKit;
import eq.uirs.fashionscape.data.kit.HairKit;
import eq.uirs.fashionscape.data.kit.HandsKit;
import eq.uirs.fashionscape.data.kit.JawKit;
import eq.uirs.fashionscape.data.kit.LegsKit;
import eq.uirs.fashionscape.data.kit.TorsoKit;
import java.util.Arrays;
import java.util.function.IntFunction;
import net.runelite.api.kit.KitType;
import org.apache.commons.text.WordUtils;

public interface Kit {
    public static Kit[] allInSlot(KitType slot, boolean includeHidden) {
        IntFunction<Kit[]> creator;
        Enum[] values;
        switch (slot) {
            case HAIR: {
                values = HairKit.values();
                creator = HairKit[]::new;
                break;
            }
            case JAW: {
                values = JawKit.values();
                creator = JawKit[]::new;
                break;
            }
            case TORSO: {
                values = TorsoKit.values();
                creator = TorsoKit[]::new;
                break;
            }
            case ARMS: {
                values = ArmsKit.values();
                creator = ArmsKit[]::new;
                break;
            }
            case LEGS: {
                values = LegsKit.values();
                creator = LegsKit[]::new;
                break;
            }
            case HANDS: {
                values = HandsKit.values();
                creator = HandsKit[]::new;
                break;
            }
            case BOOTS: {
                values = BootsKit.values();
                creator = BootsKit[]::new;
                break;
            }
            default: {
                return new Kit[0];
            }
        }
        return (Kit[])Arrays.stream(values).filter(kit -> includeHidden || !kit.isHidden()).toArray(creator);
    }

    public KitType getKitType();

    public String getDisplayName();

    public boolean isHidden();

    public Integer getKitId(boolean var1);

    public static String sentenceCaseName(Enum e) {
        return WordUtils.capitalize((String)e.toString().toLowerCase()).replace("_", " ");
    }
}

