/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.data.kit;

import com.google.common.collect.ImmutableMap;
import eq.uirs.fashionscape.data.kit.JawIcon;
import eq.uirs.fashionscape.data.kit.Kit;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.runelite.api.kit.KitType;

public enum JawKit implements Kit
{
    NO_JAW(-256, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)10556).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)10558).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)10557).put((Object)((Object)JawIcon.BA_HEALER), (Object)10559).put((Object)((Object)JawIcon.SW_BLUE), (Object)25212).put((Object)((Object)JawIcon.SW_RED), (Object)25228).build()),
    GOATEE(10, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)23460).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)23466).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)22339).put((Object)((Object)JawIcon.BA_HEALER), (Object)23478).put((Object)((Object)JawIcon.SW_BLUE), (Object)25213).put((Object)((Object)JawIcon.SW_RED), (Object)25229).build()),
    LONG_J(11, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)22723).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)22345).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)23471).put((Object)((Object)JawIcon.BA_HEALER), (Object)22311).put((Object)((Object)JawIcon.SW_BLUE), (Object)25214).put((Object)((Object)JawIcon.SW_RED), (Object)25230).build()),
    MEDIUM_J(12, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)23461).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)22728).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)23472).put((Object)((Object)JawIcon.BA_HEALER), (Object)23479).put((Object)((Object)JawIcon.SW_BLUE), (Object)25215).put((Object)((Object)JawIcon.SW_RED), (Object)25231).build()),
    SMALL_MOUSTACHE(13, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)22722).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)22344).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)22338).put((Object)((Object)JawIcon.BA_HEALER), (Object)22310).put((Object)((Object)JawIcon.SW_BLUE), (Object)25216).put((Object)((Object)JawIcon.SW_RED), (Object)25232).build()),
    CLEAN_SHAVEN(14, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)23462).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)23467).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)23473).put((Object)((Object)JawIcon.BA_HEALER), (Object)23480).put((Object)((Object)JawIcon.SW_BLUE), (Object)25217).put((Object)((Object)JawIcon.SW_RED), (Object)25233).build()),
    SHORT_J(15, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)23463).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)23468).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)22337).put((Object)((Object)JawIcon.BA_HEALER), (Object)22309).put((Object)((Object)JawIcon.SW_BLUE), (Object)25218).put((Object)((Object)JawIcon.SW_RED), (Object)25234).build()),
    POINTY(16, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)22721).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)22343).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)23474).put((Object)((Object)JawIcon.BA_HEALER), (Object)23481).put((Object)((Object)JawIcon.SW_BLUE), (Object)25219).put((Object)((Object)JawIcon.SW_RED), (Object)25235).build()),
    SPLIT(17, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)23464).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)23469).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)22315).put((Object)((Object)JawIcon.BA_HEALER), (Object)23482).put((Object)((Object)JawIcon.SW_BLUE), (Object)25220).put((Object)((Object)JawIcon.SW_RED), (Object)25236).build()),
    HANDLEBAR(111, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)22349).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)22342).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)23475).put((Object)((Object)JawIcon.BA_HEALER), (Object)22308).put((Object)((Object)JawIcon.SW_BLUE), (Object)25221).put((Object)((Object)JawIcon.SW_RED), (Object)25237).build()),
    MUTTON(112, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)22730).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)23470).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)22314).put((Object)((Object)JawIcon.BA_HEALER), (Object)23483).put((Object)((Object)JawIcon.SW_BLUE), (Object)25222).put((Object)((Object)JawIcon.SW_RED), (Object)25238).build()),
    FULL_MUTTON(113, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)22348).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)22341).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)23476).put((Object)((Object)JawIcon.BA_HEALER), (Object)20802).put((Object)((Object)JawIcon.SW_BLUE), (Object)25223).put((Object)((Object)JawIcon.SW_RED), (Object)25239).build()),
    BIG_MOUSTACHE(114, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)22729).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)22727).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)22313).put((Object)((Object)JawIcon.BA_HEALER), (Object)23484).put((Object)((Object)JawIcon.SW_BLUE), (Object)25224).put((Object)((Object)JawIcon.SW_RED), (Object)25240).build()),
    WAXED_MOUSTACHE(115, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)22347).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)22340).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)22724).put((Object)((Object)JawIcon.BA_HEALER), (Object)10567).put((Object)((Object)JawIcon.SW_BLUE), (Object)25225).put((Object)((Object)JawIcon.SW_RED), (Object)25241).build()),
    DALI(116, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)23465).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)22726).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)22312).put((Object)((Object)JawIcon.BA_HEALER), (Object)23485).put((Object)((Object)JawIcon.SW_BLUE), (Object)25226).put((Object)((Object)JawIcon.SW_RED), (Object)25242).build()),
    VIZIER(117, (Map<JawIcon, Integer>)new ImmutableMap.Builder().put((Object)((Object)JawIcon.BA_ATTACKER), (Object)22346).put((Object)((Object)JawIcon.BA_DEFENDER), (Object)22725).put((Object)((Object)JawIcon.BA_COLLECTOR), (Object)23477).put((Object)((Object)JawIcon.BA_HEALER), (Object)23486).put((Object)((Object)JawIcon.SW_BLUE), (Object)25227).put((Object)((Object)JawIcon.SW_RED), (Object)25243).build());

    private static final Map<Integer, JawIcon> reverseLookupIcon;
    private static final Map<Integer, JawKit> reverseLookupKit;
    private final int kitId;
    private final Map<JawIcon, Integer> icons;

    @Nonnull
    public static JawIcon iconFromItemId(Integer itemId) {
        JawIcon icon = reverseLookupIcon.get(itemId);
        return icon != null ? icon : JawIcon.NOTHING;
    }

    public static boolean isNoJawIcon(int itemId) {
        return JawKit.NO_JAW.icons.containsValue(itemId);
    }

    public static JawKit fromEquipmentId(int equipId) {
        return reverseLookupKit.get(equipId);
    }

    @Override
    public KitType getKitType() {
        return KitType.JAW;
    }

    @Override
    public String getDisplayName() {
        switch (this) {
            case NO_JAW: {
                return "";
            }
            case CLEAN_SHAVEN: {
                return "Clean-shaven";
            }
            case LONG_J: {
                return "Long";
            }
            case MEDIUM_J: {
                return "Medium";
            }
            case SHORT_J: {
                return "Short";
            }
        }
        return Kit.sentenceCaseName(this);
    }

    @Nullable
    public Integer getIconItemId(JawIcon icon) {
        return this.icons.get((Object)icon);
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public Integer getKitId(boolean isFemale) {
        if (isFemale != (this == NO_JAW)) {
            return null;
        }
        return this.kitId;
    }

    private JawKit(int kitId, Map<JawIcon, Integer> icons) {
        this.kitId = kitId;
        this.icons = icons;
    }

    static {
        reverseLookupIcon = new HashMap<Integer, JawIcon>();
        reverseLookupKit = new HashMap<Integer, JawKit>();
        for (JawKit kit : JawKit.values()) {
            reverseLookupKit.put(kit.kitId + 256, kit);
            kit.icons.forEach((icon, itemId) -> {
                reverseLookupIcon.put((Integer)itemId, (JawIcon)((Object)icon));
                reverseLookupKit.put(itemId + 512, kit);
            });
        }
    }
}

