/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.data;

import eq.uirs.fashionscape.data.ColorType;
import eq.uirs.fashionscape.data.Colorable;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import net.runelite.client.util.Text;

public enum SkinColor implements Colorable
{
    VERY_PALE(7, new Color(213, 169, 133)),
    PALE(0, new Color(187, 143, 106)),
    DEFAULT(1, new Color(164, 127, 93)),
    SLIGHTLY_TAN(2, new Color(158, 122, 73)),
    TAN(3, new Color(131, 110, 66)),
    VERY_TAN(4, new Color(121, 88, 42)),
    DARK(5, new Color(100, 78, 36)),
    VERY_DARK(6, new Color(76, 61, 9)),
    GREEN(8, new Color(0, 127, 0)),
    BLACK(9, new Color(15, 15, 15)),
    WHITE(10, new Color(255, 255, 255)),
    CYAN(11, new Color(5, 152, 159)),
    PURPLE(12, new Color(100, 65, 164));

    private static final SkinColor[] sorted;
    private final int colorId;
    private final Color color;

    public static SkinColor fromId(int id) {
        if (id < 0 || id >= sorted.length) {
            return null;
        }
        return SkinColor.values()[id];
    }

    @Override
    public String getDisplayName() {
        return Text.titleCase((Enum)this);
    }

    @Override
    public int getColorId(ColorType type) {
        return this.colorId;
    }

    private SkinColor(int colorId, Color color) {
        this.colorId = colorId;
        this.color = color;
    }

    public int getColorId() {
        return this.colorId;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    static {
        sorted = (SkinColor[])Arrays.stream(SkinColor.values()).sorted(Comparator.comparing(SkinColor::getColorId)).toArray(SkinColor[]::new);
    }
}

