/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import eq.uirs.fashionscape.data.kit.ArmsKit;
import eq.uirs.fashionscape.data.kit.BootsKit;
import eq.uirs.fashionscape.data.kit.Kit;
import eq.uirs.fashionscape.data.kit.LegsKit;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ItemInteractions {
    public static final Set<Integer> BAD_ITEM_IDS = ImmutableSet.of((Object)286, (Object)287, (Object)288, (Object)1410, (Object)2513, (Object)4024, (Object[])new Integer[]{4025, 4026, 4027, 4028, 4029, 4030, 4031, 4284, 4285, 7957, 9054, 9055, 9056, 9057, 9058, 9059, 10595, 10596, 10888, 11165, 11167, 19525, 24265, 24619, 25155, 25582, 25584, 25958, 25959, 25960, 25961, 25969, 25971, 25983, 25987, 25989, 25973, 26217, 26237, 26239, 26376, 26378, 26380, 26526, 26567, 26686, 26687, 26688, 26689, 26690, 26691, 26692, 26693, 26694, 26695, 26698, 26699, 26700, 26701, 26702, 26703, 27965, 27968, 27971, 27974, 27977, 27980, 27983, 27986, 27989, 27992, 27995});
    public static final Set<String> BAD_ITEM_NAMES = ImmutableSet.of((Object)"attacker icon", (Object)"defender icon", (Object)"collector icon", (Object)"healer icon", (Object)"red icon", (Object)"blue icon", (Object[])new String[0]);
    public static final Set<Integer> NON_STANDARD_ITEMS = ImmutableSet.of((Object)945, (Object)1235, (Object)3839, (Object)3841, (Object)3843, (Object)4041, (Object[])new Integer[]{4042, 4083, 4084, 4181, 4692, 4860, 4866, 4868, 4872, 4878, 4884, 4890, 4896, 4902, 4908, 4914, 4920, 4926, 4932, 4938, 4944, 4950, 4956, 4962, 4968, 4974, 4980, 4986, 4992, 4998, 5607, 5608, 5609, 5732, 6122, 6123, 7414, 7671, 7673, 7675, 7679, 7682, 7684, 7686, 7756, 7804, 7806, 7807, 7808, 7809, 8856, 8860, 8861, 8862, 8863, 8864, 8871, 9660, 9702, 10023, 10024, 10500, 10556, 10557, 10558, 10559, 10567, 10840, 10841, 12607, 12609, 12611, 13080, 13195, 20802, 21433, 21539, 22308, 22309, 22310, 22311, 22312, 22313, 22314, 22315, 22331, 22333, 22335, 22337, 22338, 22339, 22340, 22341, 22342, 22343, 22344, 22345, 22346, 22347, 22348, 22349, 22516, 22610, 22613, 22616, 22619, 22622, 22625, 22628, 22631, 22634, 22636, 22638, 22641, 22644, 22647, 22650, 22653, 22656, 22721, 22722, 22723, 22724, 22725, 22726, 22727, 22728, 22729, 22730, 22816, 22817, 23460, 23461, 23462, 23463, 23464, 23465, 23466, 23467, 23468, 23469, 23470, 23471, 23472, 23473, 23474, 23475, 23476, 23477, 23478, 23479, 23480, 23481, 23482, 23483, 23484, 23485, 23486, 23820, 23821, 23822, 23823, 23840, 23841, 23842, 23843, 23844, 23845, 23846, 23847, 23848, 23849, 23850, 23851, 23852, 23853, 23854, 23855, 23856, 23857, 23861, 23886, 23887, 23888, 23889, 23890, 23891, 23892, 23893, 23894, 23895, 23896, 23897, 23898, 23899, 23900, 23901, 23902, 23903, 23907, 25106, 25108, 25282, 26695, 26696, 26708, 26710, 26712, 26714, 26715, 26716, 26718, 26719, 26720, 26721, 26722, 26723, 26724, 26725, 26726, 26879, 27010, 27100, 27115, 27117, 27119, 27123, 27125, 27127, 28363});
    public static final Set<Integer> HAIR_HELMS = ImmutableSet.of((Object)579, (Object)656, (Object)658, (Object)660, (Object)662, (Object)664, (Object[])new Integer[]{1017, 1025, 1037, 1038, 1040, 1042, 1044, 1046, 1048, 1050, 1949, 2581, 2631, 2633, 2635, 2637, 2639, 2641, 2643, 2645, 2647, 2649, 2651, 2900, 2910, 2920, 2930, 2940, 2978, 2979, 2980, 2981, 2982, 2983, 2984, 2985, 2986, 2987, 2988, 2989, 2990, 2991, 2992, 2993, 2994, 2995, 3057, 3327, 3329, 3331, 3333, 3335, 3337, 3339, 3341, 3343, 3385, 3797, 4089, 4099, 4109, 4164, 4166, 4168, 4284, 4285, 5013, 5014, 5525, 5527, 5529, 5531, 5533, 5535, 5537, 5539, 5541, 5543, 5545, 5547, 5549, 6182, 6335, 6337, 6339, 6345, 6355, 6365, 6375, 6382, 6547, 6548, 6656, 6665, 6856, 6858, 6860, 6862, 6918, 7319, 7321, 7323, 7325, 7327, 7394, 7396, 7917, 8860, 8861, 8862, 8863, 8864, 8901, 8903, 8905, 8907, 8909, 8911, 8913, 8915, 8917, 8919, 8921, 8928, 8950, 8959, 8960, 8961, 8962, 8963, 8964, 8965, 9068, 9106, 9472, 9660, 9729, 9733, 10172, 10556, 10557, 10558, 10559, 10567, 10836, 10862, 11280, 11282, 11774, 11775, 11776, 11777, 11778, 11779, 11780, 11781, 11782, 11783, 11784, 11862, 11863, 11898, 11990, 12013, 12247, 12299, 12301, 12303, 12305, 12307, 12309, 12311, 12313, 12319, 12321, 12323, 12325, 12337, 12351, 12353, 12355, 12359, 12397, 12399, 12412, 12419, 12432, 12434, 12453, 12455, 12457, 12516, 12540, 12600, 12637, 12638, 12639, 12855, 12856, 13137, 13203, 13258, 13343, 13344, 13385, 13646, 13647, 13655, 19724, 19727, 19988, 20008, 20053, 20205, 20246, 20562, 20568, 20802, 21211, 21859, 22121, 22308, 22309, 22310, 22311, 22312, 22313, 22314, 22315, 22337, 22338, 22339, 22340, 22341, 22342, 22343, 22344, 22345, 22346, 22347, 22348, 22349, 22664, 22665, 22666, 22721, 22722, 22723, 22724, 22725, 22726, 22727, 22728, 22729, 22730, 23047, 23255, 23312, 23460, 23461, 23462, 23463, 23464, 23465, 23466, 23467, 23468, 23469, 23470, 23471, 23472, 23473, 23474, 23475, 23476, 23477, 23478, 23479, 23480, 23481, 23482, 23483, 23484, 23485, 23486, 23522, 23911, 23913, 23915, 23917, 23919, 23921, 23923, 23925, 24165, 24169, 24170, 24171, 24192, 24194, 24195, 24197, 24198, 24200, 24201, 24203, 24204, 24206, 24288, 24338, 24340, 24342, 24344, 24346, 24348, 24387, 24397, 24405, 24525, 24527, 24872, 24942, 25212, 25213, 25214, 25215, 25216, 25217, 25218, 25219, 25220, 25221, 25222, 25223, 25224, 25225, 25226, 25227, 25228, 25229, 25230, 25231, 25232, 25233, 25234, 25235, 25236, 25237, 25238, 25239, 25240, 25241, 25242, 25243, 25398, 25413, 25438, 25549, 25592, 25840, 26254, 26312, 26531, 26788, 26801, 26804, 26937, 26963, 26967, 27035, 27123, 27141, 27143, 27145, 27147, 27149, 27151, 27153, 27155, 27576, 27584, 27588, 27804, 27828, 27875, 27877, 28603, 28605, 28607, 28609, 28611, 28620, 28655});
    public static final Set<Integer> NO_JAW_HELMS = ImmutableSet.of((Object)1053, (Object)1055, (Object)1057, (Object)1153, (Object)1155, (Object)1157, (Object[])new Integer[]{1159, 1161, 1163, 1165, 1506, 2587, 2595, 2605, 2613, 2619, 2627, 2657, 2665, 2673, 3057, 3486, 4164, 4551, 4611, 4724, 4732, 4745, 4753, 4904, 4905, 4906, 4907, 4908, 4928, 4929, 4930, 4931, 4932, 4952, 4953, 4954, 4955, 4956, 4976, 4977, 4978, 4979, 4980, 5554, 5574, 6188, 6623, 7534, 7594, 8464, 8466, 8468, 8470, 8472, 8474, 8476, 8478, 8480, 8482, 8484, 8486, 8488, 8490, 8492, 8494, 8682, 8684, 8686, 8688, 8690, 8692, 8694, 8696, 8698, 8700, 8702, 8704, 8706, 8708, 8710, 8712, 9096, 9629, 9672, 9920, 10567, 11282, 11335, 11847, 11850, 11864, 11865, 11919, 12211, 12221, 12231, 12241, 12249, 12251, 12283, 12293, 12363, 12365, 12367, 12369, 12371, 12417, 12466, 12476, 12486, 12518, 12520, 12522, 12524, 12810, 12813, 12845, 12887, 12892, 12929, 12931, 13140, 13196, 13197, 13198, 13199, 13283, 13359, 13364, 13369, 13374, 13379, 13579, 13591, 13603, 13615, 13627, 13667, 19639, 19641, 19643, 19645, 19647, 19649, 19915, 19988, 20020, 20023, 20026, 20029, 20032, 20035, 20080, 20095, 20178, 20193, 20266, 20269, 20561, 20563, 20595, 20708, 20773, 20792, 20802, 20838, 21061, 21264, 21266, 21298, 21720, 21847, 21888, 21890, 22159, 22161, 22163, 22165, 22167, 22169, 22171, 22173, 22175, 22177, 22179, 22181, 22183, 22185, 22187, 22189, 22308, 22309, 22310, 22311, 22312, 22313, 22314, 22315, 22326, 22337, 22338, 22339, 22340, 22341, 22342, 22343, 22344, 22345, 22346, 22347, 22348, 22349, 22689, 22713, 22721, 22722, 22723, 22724, 22725, 22726, 22727, 22728, 22729, 22730, 23073, 23075, 23101, 23252, 23270, 23273, 23448, 23460, 23461, 23462, 23463, 23464, 23465, 23466, 23467, 23468, 23469, 23470, 23471, 23472, 23473, 23474, 23475, 23476, 23477, 23478, 23479, 23480, 23481, 23482, 23483, 23484, 23485, 23486, 23785, 23840, 23841, 23842, 23886, 23887, 23888, 23971, 23973, 24034, 24271, 24305, 24315, 24342, 24344, 24346, 24348, 24370, 24419, 24444, 24743, 24975, 25069, 25165, 25169, 25174, 25176, 25212, 25213, 25214, 25215, 25216, 25217, 25218, 25219, 25220, 25221, 25222, 25223, 25224, 25225, 25226, 25227, 25228, 25229, 25230, 25231, 25232, 25233, 25234, 25235, 25236, 25237, 25238, 25239, 25240, 25241, 25242, 25243, 25336, 25898, 25900, 25902, 25904, 25906, 25908, 25910, 25912, 25914, 26225, 26241, 26382, 26427, 26439, 26451, 26731, 26733, 26735, 26741, 26745, 26747, 27119, 27226, 27235, 27705, 27707, 27717, 27719, 27729, 27731, 27741, 27743, 27753, 27755, 27765, 27767, 27777, 27779, 28254});
    public static final Set<Integer> ARMS_TORSOS = ImmutableSet.of((Object)1005, (Object)1101, (Object)1103, (Object)1105, (Object)1107, (Object)1109, (Object[])new Integer[]{1111, 1113, 1129, 1131, 1133, 1135, 1757, 2499, 2501, 2503, 2513, 6615, 7110, 7122, 7128, 7134, 7362, 7364, 7370, 7372, 7374, 7376, 7592, 7957, 12327, 12331, 12381, 12385, 20149, 20208, 20417, 20423, 20566, 23264, 23381});
    public static final Set<Integer> DISABLE_BOOT_KITS = ImmutableSet.of((Object)BootsKit.MINECART.getKitId(true), (Object)BootsKit.MINECART.getKitId(false));
    public static final Set<Integer> DISABLE_WEAPONS = ImmutableSet.of((Object)5614);
    public static final BiMap<Kit, Kit> MALE_TO_FEMALE_KITS;
    public static final Map<Integer, Integer> WEAPON_TO_IDLE;

    static {
        HashMap<Enum, Enum> mToF = new HashMap<Enum, Enum>();
        mToF.put(ArmsKit.REGULAR, ArmsKit.SHORT_SLEEVES);
        mToF.put(ArmsKit.MUSCLEBOUND, ArmsKit.MUSCLEY);
        mToF.put(ArmsKit.LOOSE_SLEEVED, ArmsKit.FRILLY_A);
        mToF.put(ArmsKit.LARGE_CUFFED, ArmsKit.LARGE_CUFFS);
        mToF.put(ArmsKit.THIN, ArmsKit.LONG_SLEEVED);
        mToF.put(ArmsKit.SHOULDER_PADS, ArmsKit.BARE_ARMS);
        mToF.put(ArmsKit.THICK_STRIPE, ArmsKit.SWEATER_A);
        mToF.put(ArmsKit.RIPPED, ArmsKit.BARE_SHOULDERS);
        mToF.put(LegsKit.SHORTS, LegsKit.SHORT_SKIRT);
        mToF.put(LegsKit.RIPPED_L, LegsKit.TORN_SKIRT);
        mToF.put(LegsKit.PATCHED, LegsKit.PATCHED_SKIRT);
        MALE_TO_FEMALE_KITS = new ImmutableBiMap.Builder().putAll(mToF).build();
        WEAPON_TO_IDLE = new HashMap<Integer, Integer>();
        WEAPON_TO_IDLE.put(667, 809);
        WEAPON_TO_IDLE.put(767, 4591);
        WEAPON_TO_IDLE.put(772, 813);
        WEAPON_TO_IDLE.put(837, 4591);
        WEAPON_TO_IDLE.put(1235, 813);
        WEAPON_TO_IDLE.put(1237, 813);
        WEAPON_TO_IDLE.put(1239, 813);
        WEAPON_TO_IDLE.put(1241, 813);
        WEAPON_TO_IDLE.put(1243, 813);
        WEAPON_TO_IDLE.put(1245, 813);
        WEAPON_TO_IDLE.put(1247, 813);
        WEAPON_TO_IDLE.put(1249, 813);
        WEAPON_TO_IDLE.put(1251, 813);
        WEAPON_TO_IDLE.put(1253, 813);
        WEAPON_TO_IDLE.put(1255, 813);
        WEAPON_TO_IDLE.put(1257, 813);
        WEAPON_TO_IDLE.put(1259, 813);
        WEAPON_TO_IDLE.put(1261, 813);
        WEAPON_TO_IDLE.put(1263, 813);
        WEAPON_TO_IDLE.put(1305, 809);
        WEAPON_TO_IDLE.put(1307, 2561);
        WEAPON_TO_IDLE.put(1309, 2561);
        WEAPON_TO_IDLE.put(1311, 2561);
        WEAPON_TO_IDLE.put(1313, 2561);
        WEAPON_TO_IDLE.put(1317, 2561);
        WEAPON_TO_IDLE.put(1319, 2561);
        WEAPON_TO_IDLE.put(1379, 813);
        WEAPON_TO_IDLE.put(1381, 813);
        WEAPON_TO_IDLE.put(1383, 813);
        WEAPON_TO_IDLE.put(1385, 813);
        WEAPON_TO_IDLE.put(1387, 813);
        WEAPON_TO_IDLE.put(1389, 813);
        WEAPON_TO_IDLE.put(1391, 813);
        WEAPON_TO_IDLE.put(1393, 813);
        WEAPON_TO_IDLE.put(1395, 813);
        WEAPON_TO_IDLE.put(1397, 813);
        WEAPON_TO_IDLE.put(1399, 813);
        WEAPON_TO_IDLE.put(1401, 813);
        WEAPON_TO_IDLE.put(1403, 813);
        WEAPON_TO_IDLE.put(1405, 813);
        WEAPON_TO_IDLE.put(1407, 813);
        WEAPON_TO_IDLE.put(1409, 813);
        WEAPON_TO_IDLE.put(1410, 813);
        WEAPON_TO_IDLE.put(1419, 847);
        WEAPON_TO_IDLE.put(3053, 813);
        WEAPON_TO_IDLE.put(3054, 813);
        WEAPON_TO_IDLE.put(3170, 813);
        WEAPON_TO_IDLE.put(3171, 813);
        WEAPON_TO_IDLE.put(3172, 813);
        WEAPON_TO_IDLE.put(3173, 813);
        WEAPON_TO_IDLE.put(3174, 813);
        WEAPON_TO_IDLE.put(3175, 813);
        WEAPON_TO_IDLE.put(3176, 813);
        WEAPON_TO_IDLE.put(3190, 813);
        WEAPON_TO_IDLE.put(3192, 813);
        WEAPON_TO_IDLE.put(3194, 813);
        WEAPON_TO_IDLE.put(3196, 813);
        WEAPON_TO_IDLE.put(3198, 813);
        WEAPON_TO_IDLE.put(3200, 813);
        WEAPON_TO_IDLE.put(3202, 813);
        WEAPON_TO_IDLE.put(3204, 813);
        WEAPON_TO_IDLE.put(3695, 6657);
        WEAPON_TO_IDLE.put(4037, 1421);
        WEAPON_TO_IDLE.put(4039, 1421);
        WEAPON_TO_IDLE.put(4083, 1461);
        WEAPON_TO_IDLE.put(4084, 1461);
        WEAPON_TO_IDLE.put(4153, 1662);
        WEAPON_TO_IDLE.put(4158, 813);
        WEAPON_TO_IDLE.put(4170, 813);
        WEAPON_TO_IDLE.put(4565, 1837);
        WEAPON_TO_IDLE.put(4566, 1832);
        WEAPON_TO_IDLE.put(4580, 813);
        WEAPON_TO_IDLE.put(4582, 813);
        WEAPON_TO_IDLE.put(4584, 813);
        WEAPON_TO_IDLE.put(4675, 813);
        WEAPON_TO_IDLE.put(4710, 813);
        WEAPON_TO_IDLE.put(4718, 2065);
        WEAPON_TO_IDLE.put(4726, 813);
        WEAPON_TO_IDLE.put(4734, 2074);
        WEAPON_TO_IDLE.put(4755, 2061);
        WEAPON_TO_IDLE.put(4862, 813);
        WEAPON_TO_IDLE.put(4863, 813);
        WEAPON_TO_IDLE.put(4864, 813);
        WEAPON_TO_IDLE.put(4865, 813);
        WEAPON_TO_IDLE.put(4866, 813);
        WEAPON_TO_IDLE.put(4886, 2065);
        WEAPON_TO_IDLE.put(4887, 2065);
        WEAPON_TO_IDLE.put(4888, 2065);
        WEAPON_TO_IDLE.put(4889, 2065);
        WEAPON_TO_IDLE.put(4890, 2065);
        WEAPON_TO_IDLE.put(4910, 813);
        WEAPON_TO_IDLE.put(4911, 813);
        WEAPON_TO_IDLE.put(4912, 813);
        WEAPON_TO_IDLE.put(4913, 813);
        WEAPON_TO_IDLE.put(4914, 813);
        WEAPON_TO_IDLE.put(4934, 2074);
        WEAPON_TO_IDLE.put(4938, 2074);
        WEAPON_TO_IDLE.put(4982, 2061);
        WEAPON_TO_IDLE.put(4983, 2061);
        WEAPON_TO_IDLE.put(4984, 2061);
        WEAPON_TO_IDLE.put(4985, 2061);
        WEAPON_TO_IDLE.put(4986, 2061);
        WEAPON_TO_IDLE.put(5016, 813);
        WEAPON_TO_IDLE.put(5614, 6936);
        WEAPON_TO_IDLE.put(5704, 813);
        WEAPON_TO_IDLE.put(5706, 813);
        WEAPON_TO_IDLE.put(5708, 813);
        WEAPON_TO_IDLE.put(5710, 813);
        WEAPON_TO_IDLE.put(5712, 813);
        WEAPON_TO_IDLE.put(5714, 813);
        WEAPON_TO_IDLE.put(5716, 813);
        WEAPON_TO_IDLE.put(5718, 813);
        WEAPON_TO_IDLE.put(5720, 813);
        WEAPON_TO_IDLE.put(5722, 813);
        WEAPON_TO_IDLE.put(5724, 813);
        WEAPON_TO_IDLE.put(5726, 813);
        WEAPON_TO_IDLE.put(5728, 813);
        WEAPON_TO_IDLE.put(5730, 813);
        WEAPON_TO_IDLE.put(5734, 813);
        WEAPON_TO_IDLE.put(5736, 813);
        WEAPON_TO_IDLE.put(6082, 2316);
        WEAPON_TO_IDLE.put(6526, 813);
        WEAPON_TO_IDLE.put(6528, 2065);
        WEAPON_TO_IDLE.put(6562, 813);
        WEAPON_TO_IDLE.put(6563, 813);
        WEAPON_TO_IDLE.put(6599, 813);
        WEAPON_TO_IDLE.put(6603, 813);
        WEAPON_TO_IDLE.put(6609, 2561);
        WEAPON_TO_IDLE.put(6760, 813);
        WEAPON_TO_IDLE.put(6762, 813);
        WEAPON_TO_IDLE.put(6764, 813);
        WEAPON_TO_IDLE.put(6773, 1421);
        WEAPON_TO_IDLE.put(6774, 1421);
        WEAPON_TO_IDLE.put(6775, 1421);
        WEAPON_TO_IDLE.put(6776, 1421);
        WEAPON_TO_IDLE.put(6777, 1421);
        WEAPON_TO_IDLE.put(6778, 1421);
        WEAPON_TO_IDLE.put(6779, 1421);
        WEAPON_TO_IDLE.put(6908, 813);
        WEAPON_TO_IDLE.put(6910, 813);
        WEAPON_TO_IDLE.put(6912, 813);
        WEAPON_TO_IDLE.put(6914, 813);
        WEAPON_TO_IDLE.put(7158, 2561);
        WEAPON_TO_IDLE.put(7170, 3175);
        WEAPON_TO_IDLE.put(7439, 2561);
        WEAPON_TO_IDLE.put(7449, 2065);
        WEAPON_TO_IDLE.put(7639, 813);
        WEAPON_TO_IDLE.put(7640, 813);
        WEAPON_TO_IDLE.put(7641, 813);
        WEAPON_TO_IDLE.put(7642, 813);
        WEAPON_TO_IDLE.put(7643, 813);
        WEAPON_TO_IDLE.put(7644, 813);
        WEAPON_TO_IDLE.put(7645, 813);
        WEAPON_TO_IDLE.put(7646, 813);
        WEAPON_TO_IDLE.put(7647, 813);
        WEAPON_TO_IDLE.put(7648, 813);
        WEAPON_TO_IDLE.put(7668, 1662);
        WEAPON_TO_IDLE.put(7671, 3677);
        WEAPON_TO_IDLE.put(7673, 3677);
        WEAPON_TO_IDLE.put(7809, 813);
        WEAPON_TO_IDLE.put(8650, 1421);
        WEAPON_TO_IDLE.put(8652, 1421);
        WEAPON_TO_IDLE.put(8654, 1421);
        WEAPON_TO_IDLE.put(8656, 1421);
        WEAPON_TO_IDLE.put(8658, 1421);
        WEAPON_TO_IDLE.put(8660, 1421);
        WEAPON_TO_IDLE.put(8662, 1421);
        WEAPON_TO_IDLE.put(8664, 1421);
        WEAPON_TO_IDLE.put(8666, 1421);
        WEAPON_TO_IDLE.put(8668, 1421);
        WEAPON_TO_IDLE.put(8670, 1421);
        WEAPON_TO_IDLE.put(8672, 1421);
        WEAPON_TO_IDLE.put(8674, 1421);
        WEAPON_TO_IDLE.put(8676, 1421);
        WEAPON_TO_IDLE.put(8678, 1421);
        WEAPON_TO_IDLE.put(8680, 1421);
        WEAPON_TO_IDLE.put(8871, 4193);
        WEAPON_TO_IDLE.put(8880, 4591);
        WEAPON_TO_IDLE.put(8966, 1421);
        WEAPON_TO_IDLE.put(8967, 1421);
        WEAPON_TO_IDLE.put(8968, 1421);
        WEAPON_TO_IDLE.put(8969, 1421);
        WEAPON_TO_IDLE.put(8970, 1421);
        WEAPON_TO_IDLE.put(8971, 1421);
        WEAPON_TO_IDLE.put(9013, 813);
        WEAPON_TO_IDLE.put(9044, 813);
        WEAPON_TO_IDLE.put(9084, 813);
        WEAPON_TO_IDLE.put(9091, 813);
        WEAPON_TO_IDLE.put(9092, 813);
        WEAPON_TO_IDLE.put(9093, 813);
        WEAPON_TO_IDLE.put(9174, 4591);
        WEAPON_TO_IDLE.put(9176, 4591);
        WEAPON_TO_IDLE.put(9177, 4591);
        WEAPON_TO_IDLE.put(9179, 4591);
        WEAPON_TO_IDLE.put(9181, 4591);
        WEAPON_TO_IDLE.put(9183, 4591);
        WEAPON_TO_IDLE.put(9185, 4591);
        WEAPON_TO_IDLE.put(10010, 813);
        WEAPON_TO_IDLE.put(10024, 5160);
        WEAPON_TO_IDLE.put(10033, 3175);
        WEAPON_TO_IDLE.put(10034, 3175);
        WEAPON_TO_IDLE.put(10146, 5246);
        WEAPON_TO_IDLE.put(10147, 5246);
        WEAPON_TO_IDLE.put(10148, 5246);
        WEAPON_TO_IDLE.put(10149, 5246);
        WEAPON_TO_IDLE.put(10150, 5254);
        WEAPON_TO_IDLE.put(10156, 4591);
        WEAPON_TO_IDLE.put(10280, 813);
        WEAPON_TO_IDLE.put(10282, 813);
        WEAPON_TO_IDLE.put(10284, 813);
        WEAPON_TO_IDLE.put(10440, 813);
        WEAPON_TO_IDLE.put(10442, 813);
        WEAPON_TO_IDLE.put(10444, 813);
        WEAPON_TO_IDLE.put(10487, 5363);
        WEAPON_TO_IDLE.put(10858, 2561);
        WEAPON_TO_IDLE.put(10887, 5869);
        WEAPON_TO_IDLE.put(10888, 5869);
        WEAPON_TO_IDLE.put(11259, 6604);
        WEAPON_TO_IDLE.put(11367, 813);
        WEAPON_TO_IDLE.put(11369, 813);
        WEAPON_TO_IDLE.put(11371, 813);
        WEAPON_TO_IDLE.put(11373, 813);
        WEAPON_TO_IDLE.put(11375, 813);
        WEAPON_TO_IDLE.put(11377, 813);
        WEAPON_TO_IDLE.put(11379, 813);
        WEAPON_TO_IDLE.put(11381, 813);
        WEAPON_TO_IDLE.put(11382, 813);
        WEAPON_TO_IDLE.put(11384, 813);
        WEAPON_TO_IDLE.put(11386, 813);
        WEAPON_TO_IDLE.put(11388, 813);
        WEAPON_TO_IDLE.put(11389, 813);
        WEAPON_TO_IDLE.put(11391, 813);
        WEAPON_TO_IDLE.put(11393, 813);
        WEAPON_TO_IDLE.put(11395, 813);
        WEAPON_TO_IDLE.put(11396, 813);
        WEAPON_TO_IDLE.put(11398, 813);
        WEAPON_TO_IDLE.put(11400, 813);
        WEAPON_TO_IDLE.put(11402, 813);
        WEAPON_TO_IDLE.put(11403, 813);
        WEAPON_TO_IDLE.put(11405, 813);
        WEAPON_TO_IDLE.put(11407, 813);
        WEAPON_TO_IDLE.put(11409, 813);
        WEAPON_TO_IDLE.put(11410, 813);
        WEAPON_TO_IDLE.put(11412, 813);
        WEAPON_TO_IDLE.put(11414, 813);
        WEAPON_TO_IDLE.put(11416, 813);
        WEAPON_TO_IDLE.put(11417, 813);
        WEAPON_TO_IDLE.put(11419, 813);
        WEAPON_TO_IDLE.put(11705, 3677);
        WEAPON_TO_IDLE.put(11706, 3677);
        WEAPON_TO_IDLE.put(11709, 813);
        WEAPON_TO_IDLE.put(11785, 4591);
        WEAPON_TO_IDLE.put(11787, 813);
        WEAPON_TO_IDLE.put(11789, 813);
        WEAPON_TO_IDLE.put(11791, 813);
        WEAPON_TO_IDLE.put(11802, 7053);
        WEAPON_TO_IDLE.put(11804, 7053);
        WEAPON_TO_IDLE.put(11806, 7053);
        WEAPON_TO_IDLE.put(11808, 7053);
        WEAPON_TO_IDLE.put(11824, 1713);
        WEAPON_TO_IDLE.put(11838, 7053);
        WEAPON_TO_IDLE.put(11889, 813);
        WEAPON_TO_IDLE.put(11905, 813);
        WEAPON_TO_IDLE.put(11907, 813);
        WEAPON_TO_IDLE.put(11908, 813);
        WEAPON_TO_IDLE.put(11959, 3175);
        WEAPON_TO_IDLE.put(11998, 813);
        WEAPON_TO_IDLE.put(12000, 813);
        WEAPON_TO_IDLE.put(12199, 813);
        WEAPON_TO_IDLE.put(12263, 813);
        WEAPON_TO_IDLE.put(12275, 813);
        WEAPON_TO_IDLE.put(12373, 813);
        WEAPON_TO_IDLE.put(12422, 813);
        WEAPON_TO_IDLE.put(12439, 813);
        WEAPON_TO_IDLE.put(12658, 813);
        WEAPON_TO_IDLE.put(12727, 2316);
        WEAPON_TO_IDLE.put(12795, 813);
        WEAPON_TO_IDLE.put(12796, 813);
        WEAPON_TO_IDLE.put(12808, 7053);
        WEAPON_TO_IDLE.put(12809, 7053);
        WEAPON_TO_IDLE.put(12848, 1662);
        WEAPON_TO_IDLE.put(12899, 813);
        WEAPON_TO_IDLE.put(12900, 813);
        WEAPON_TO_IDLE.put(12902, 813);
        WEAPON_TO_IDLE.put(12904, 813);
        WEAPON_TO_IDLE.put(12924, 813);
        WEAPON_TO_IDLE.put(12926, 813);
        WEAPON_TO_IDLE.put(13080, 813);
        WEAPON_TO_IDLE.put(13081, 813);
        WEAPON_TO_IDLE.put(13082, 813);
        WEAPON_TO_IDLE.put(13083, 813);
        WEAPON_TO_IDLE.put(13084, 813);
        WEAPON_TO_IDLE.put(13085, 813);
        WEAPON_TO_IDLE.put(13086, 813);
        WEAPON_TO_IDLE.put(13087, 813);
        WEAPON_TO_IDLE.put(13088, 813);
        WEAPON_TO_IDLE.put(13089, 813);
        WEAPON_TO_IDLE.put(13090, 813);
        WEAPON_TO_IDLE.put(13141, 1421);
        WEAPON_TO_IDLE.put(13142, 1421);
        WEAPON_TO_IDLE.put(13143, 1421);
        WEAPON_TO_IDLE.put(13144, 1421);
        WEAPON_TO_IDLE.put(13195, 1824);
        WEAPON_TO_IDLE.put(13263, 1652);
        WEAPON_TO_IDLE.put(13265, 3296);
        WEAPON_TO_IDLE.put(13267, 3296);
        WEAPON_TO_IDLE.put(13269, 3296);
        WEAPON_TO_IDLE.put(13271, 3296);
        WEAPON_TO_IDLE.put(13328, 1421);
        WEAPON_TO_IDLE.put(19478, 7220);
        WEAPON_TO_IDLE.put(19481, 7220);
        WEAPON_TO_IDLE.put(19941, 4193);
        WEAPON_TO_IDLE.put(20056, 3040);
        WEAPON_TO_IDLE.put(20155, 2561);
        WEAPON_TO_IDLE.put(20158, 813);
        WEAPON_TO_IDLE.put(20161, 813);
        WEAPON_TO_IDLE.put(20164, 7053);
        WEAPON_TO_IDLE.put(20249, 7271);
        WEAPON_TO_IDLE.put(20251, 1421);
        WEAPON_TO_IDLE.put(20254, 1421);
        WEAPON_TO_IDLE.put(20257, 1421);
        WEAPON_TO_IDLE.put(20260, 1421);
        WEAPON_TO_IDLE.put(20263, 1421);
        WEAPON_TO_IDLE.put(20368, 7053);
        WEAPON_TO_IDLE.put(20370, 7053);
        WEAPON_TO_IDLE.put(20372, 7053);
        WEAPON_TO_IDLE.put(20374, 7053);
        WEAPON_TO_IDLE.put(20431, 813);
        WEAPON_TO_IDLE.put(20553, 813);
        WEAPON_TO_IDLE.put(20555, 2561);
        WEAPON_TO_IDLE.put(20556, 813);
        WEAPON_TO_IDLE.put(20559, 2561);
        WEAPON_TO_IDLE.put(20560, 813);
        WEAPON_TO_IDLE.put(20590, 1832);
        WEAPON_TO_IDLE.put(20593, 7053);
        WEAPON_TO_IDLE.put(20730, 813);
        WEAPON_TO_IDLE.put(20733, 813);
        WEAPON_TO_IDLE.put(20736, 813);
        WEAPON_TO_IDLE.put(20739, 813);
        WEAPON_TO_IDLE.put(20756, 2065);
        WEAPON_TO_IDLE.put(20779, 2911);
        WEAPON_TO_IDLE.put(20836, 4193);
        WEAPON_TO_IDLE.put(21003, 7518);
        WEAPON_TO_IDLE.put(21006, 813);
        WEAPON_TO_IDLE.put(21012, 4591);
        WEAPON_TO_IDLE.put(21015, 7508);
        WEAPON_TO_IDLE.put(21059, 2911);
        WEAPON_TO_IDLE.put(21198, 813);
        WEAPON_TO_IDLE.put(21200, 813);
        WEAPON_TO_IDLE.put(21205, 7518);
        WEAPON_TO_IDLE.put(21209, 7538);
        WEAPON_TO_IDLE.put(21255, 813);
        WEAPON_TO_IDLE.put(21276, 813);
        WEAPON_TO_IDLE.put(21354, 6297);
        WEAPON_TO_IDLE.put(21649, 813);
        WEAPON_TO_IDLE.put(21902, 4591);
        WEAPON_TO_IDLE.put(22288, 813);
        WEAPON_TO_IDLE.put(22290, 813);
        WEAPON_TO_IDLE.put(22292, 813);
        WEAPON_TO_IDLE.put(22294, 813);
        WEAPON_TO_IDLE.put(22296, 813);
        WEAPON_TO_IDLE.put(22316, 2911);
        WEAPON_TO_IDLE.put(22323, 813);
        WEAPON_TO_IDLE.put(22324, 809);
        WEAPON_TO_IDLE.put(22325, 8057);
        WEAPON_TO_IDLE.put(22335, 813);
        WEAPON_TO_IDLE.put(22368, 813);
        WEAPON_TO_IDLE.put(22370, 813);
        WEAPON_TO_IDLE.put(22398, 8009);
        WEAPON_TO_IDLE.put(22481, 813);
        WEAPON_TO_IDLE.put(22486, 8057);
        WEAPON_TO_IDLE.put(22542, 244);
        WEAPON_TO_IDLE.put(22545, 244);
        WEAPON_TO_IDLE.put(22552, 813);
        WEAPON_TO_IDLE.put(22555, 813);
        WEAPON_TO_IDLE.put(22613, 809);
        WEAPON_TO_IDLE.put(22719, 2911);
        WEAPON_TO_IDLE.put(22731, 813);
        WEAPON_TO_IDLE.put(22734, 813);
        WEAPON_TO_IDLE.put(22737, 813);
        WEAPON_TO_IDLE.put(22740, 813);
        WEAPON_TO_IDLE.put(22743, 813);
        WEAPON_TO_IDLE.put(22817, 5160);
        WEAPON_TO_IDLE.put(22840, 8208);
        WEAPON_TO_IDLE.put(22978, 813);
        WEAPON_TO_IDLE.put(23108, 4193);
        WEAPON_TO_IDLE.put(23235, 2065);
        WEAPON_TO_IDLE.put(23282, 2561);
        WEAPON_TO_IDLE.put(23342, 813);
        WEAPON_TO_IDLE.put(23363, 813);
        WEAPON_TO_IDLE.put(23446, 4193);
        WEAPON_TO_IDLE.put(23528, 809);
        WEAPON_TO_IDLE.put(23611, 4591);
        WEAPON_TO_IDLE.put(23849, 813);
        WEAPON_TO_IDLE.put(23850, 813);
        WEAPON_TO_IDLE.put(23851, 813);
        WEAPON_TO_IDLE.put(23852, 813);
        WEAPON_TO_IDLE.put(23853, 813);
        WEAPON_TO_IDLE.put(23854, 813);
        WEAPON_TO_IDLE.put(23895, 813);
        WEAPON_TO_IDLE.put(23896, 813);
        WEAPON_TO_IDLE.put(23897, 813);
        WEAPON_TO_IDLE.put(23898, 813);
        WEAPON_TO_IDLE.put(23899, 813);
        WEAPON_TO_IDLE.put(23900, 813);
        WEAPON_TO_IDLE.put(23987, 813);
        WEAPON_TO_IDLE.put(23995, 809);
        WEAPON_TO_IDLE.put(23997, 809);
        WEAPON_TO_IDLE.put(24000, 3040);
        WEAPON_TO_IDLE.put(24144, 813);
        WEAPON_TO_IDLE.put(24157, 809);
        WEAPON_TO_IDLE.put(24225, 1662);
        WEAPON_TO_IDLE.put(24227, 1662);
        WEAPON_TO_IDLE.put(24327, 8521);
        WEAPON_TO_IDLE.put(24372, 4193);
        WEAPON_TO_IDLE.put(24374, 4193);
        WEAPON_TO_IDLE.put(24376, 4193);
        WEAPON_TO_IDLE.put(24413, 1421);
        WEAPON_TO_IDLE.put(24422, 4504);
        WEAPON_TO_IDLE.put(24423, 4504);
        WEAPON_TO_IDLE.put(24424, 4504);
        WEAPON_TO_IDLE.put(24425, 4504);
        WEAPON_TO_IDLE.put(24537, 809);
        WEAPON_TO_IDLE.put(24539, 809);
        WEAPON_TO_IDLE.put(24551, 809);
        WEAPON_TO_IDLE.put(24617, 809);
        WEAPON_TO_IDLE.put(24619, 809);
        WEAPON_TO_IDLE.put(24699, 8009);
        WEAPON_TO_IDLE.put(25042, 4193);
        WEAPON_TO_IDLE.put(25044, 4193);
        WEAPON_TO_IDLE.put(25046, 4193);
        WEAPON_TO_IDLE.put(25056, 1421);
        WEAPON_TO_IDLE.put(25282, 1461);
        WEAPON_TO_IDLE.put(25314, 4193);
        WEAPON_TO_IDLE.put(25500, 4646);
        WEAPON_TO_IDLE.put(25604, 7508);
        WEAPON_TO_IDLE.put(25721, 9018);
        WEAPON_TO_IDLE.put(25723, 9018);
        WEAPON_TO_IDLE.put(25724, 9018);
        WEAPON_TO_IDLE.put(25725, 9018);
        WEAPON_TO_IDLE.put(25726, 9018);
        WEAPON_TO_IDLE.put(25727, 9018);
        WEAPON_TO_IDLE.put(25728, 9018);
        WEAPON_TO_IDLE.put(25729, 9018);
        WEAPON_TO_IDLE.put(25731, 813);
        WEAPON_TO_IDLE.put(25733, 813);
        WEAPON_TO_IDLE.put(25734, 809);
        WEAPON_TO_IDLE.put(25736, 8057);
        WEAPON_TO_IDLE.put(25738, 8057);
        WEAPON_TO_IDLE.put(25739, 8057);
        WEAPON_TO_IDLE.put(25741, 8057);
        WEAPON_TO_IDLE.put(25822, 9018);
        WEAPON_TO_IDLE.put(24553, 809);
        WEAPON_TO_IDLE.put(25870, 809);
        WEAPON_TO_IDLE.put(25872, 809);
        WEAPON_TO_IDLE.put(25874, 809);
        WEAPON_TO_IDLE.put(25876, 809);
        WEAPON_TO_IDLE.put(25878, 809);
        WEAPON_TO_IDLE.put(25880, 809);
        WEAPON_TO_IDLE.put(25882, 809);
        WEAPON_TO_IDLE.put(25916, 4591);
        WEAPON_TO_IDLE.put(25918, 4591);
        WEAPON_TO_IDLE.put(25979, 813);
        WEAPON_TO_IDLE.put(26219, 809);
        WEAPON_TO_IDLE.put(26233, 7053);
        WEAPON_TO_IDLE.put(26374, 4591);
        WEAPON_TO_IDLE.put(26424, 1421);
        WEAPON_TO_IDLE.put(26486, 4591);
        WEAPON_TO_IDLE.put(26511, 4193);
        WEAPON_TO_IDLE.put(26513, 4193);
        WEAPON_TO_IDLE.put(26515, 4193);
        WEAPON_TO_IDLE.put(26517, 813);
        WEAPON_TO_IDLE.put(26649, 9341);
        WEAPON_TO_IDLE.put(26712, 7220);
        WEAPON_TO_IDLE.put(27010, 7518);
        WEAPON_TO_IDLE.put(27021, 9460);
        WEAPON_TO_IDLE.put(27100, 7518);
        WEAPON_TO_IDLE.put(27246, 809);
        WEAPON_TO_IDLE.put(27275, 9494);
        WEAPON_TO_IDLE.put(27277, 9494);
        WEAPON_TO_IDLE.put(25981, 813);
        WEAPON_TO_IDLE.put(27287, 813);
        WEAPON_TO_IDLE.put(27291, 813);
        WEAPON_TO_IDLE.put(27414, 9814);
        WEAPON_TO_IDLE.put(27422, 4193);
        WEAPON_TO_IDLE.put(27424, 4193);
        WEAPON_TO_IDLE.put(27580, 1421);
        WEAPON_TO_IDLE.put(27586, 1421);
        WEAPON_TO_IDLE.put(27610, 9857);
        WEAPON_TO_IDLE.put(27612, 9857);
        WEAPON_TO_IDLE.put(27624, 813);
        WEAPON_TO_IDLE.put(27645, 9847);
        WEAPON_TO_IDLE.put(27660, 244);
        WEAPON_TO_IDLE.put(27657, 244);
        WEAPON_TO_IDLE.put(27665, 813);
        WEAPON_TO_IDLE.put(27662, 813);
        WEAPON_TO_IDLE.put(27676, 813);
        WEAPON_TO_IDLE.put(27679, 813);
        WEAPON_TO_IDLE.put(27783, 4193);
        WEAPON_TO_IDLE.put(27785, 813);
        WEAPON_TO_IDLE.put(27788, 813);
        WEAPON_TO_IDLE.put(27820, 10032);
        WEAPON_TO_IDLE.put(27855, 5869);
        WEAPON_TO_IDLE.put(27859, 809);
        WEAPON_TO_IDLE.put(27861, 3296);
        WEAPON_TO_IDLE.put(27863, 3296);
        WEAPON_TO_IDLE.put(27871, 9460);
        WEAPON_TO_IDLE.put(28033, 809);
        WEAPON_TO_IDLE.put(28041, 813);
        WEAPON_TO_IDLE.put(28043, 813);
        WEAPON_TO_IDLE.put(28049, 813);
        WEAPON_TO_IDLE.put(28051, 2561);
        WEAPON_TO_IDLE.put(28053, 4591);
        WEAPON_TO_IDLE.put(28128, 4591);
        WEAPON_TO_IDLE.put(28338, 10169);
        WEAPON_TO_IDLE.put(25489, 813);
        WEAPON_TO_IDLE.put(25490, 813);
        WEAPON_TO_IDLE.put(25491, 813);
        WEAPON_TO_IDLE.put(25492, 813);
        WEAPON_TO_IDLE.put(28260, 813);
        WEAPON_TO_IDLE.put(28262, 813);
        WEAPON_TO_IDLE.put(28264, 813);
        WEAPON_TO_IDLE.put(28266, 813);
        WEAPON_TO_IDLE.put(28196, 10075);
        WEAPON_TO_IDLE.put(28199, 10075);
        WEAPON_TO_IDLE.put(28202, 10075);
        WEAPON_TO_IDLE.put(28205, 10075);
        WEAPON_TO_IDLE.put(28208, 10075);
        WEAPON_TO_IDLE.put(28211, 10075);
        WEAPON_TO_IDLE.put(28214, 10075);
        WEAPON_TO_IDLE.put(28217, 10075);
        WEAPON_TO_IDLE.put(28226, 10075);
        WEAPON_TO_IDLE.put(28220, 10075);
        WEAPON_TO_IDLE.put(28223, 10075);
        WEAPON_TO_IDLE.put(28537, 7053);
        WEAPON_TO_IDLE.put(28543, 8057);
        WEAPON_TO_IDLE.put(28545, 8057);
        WEAPON_TO_IDLE.put(28547, 9494);
        WEAPON_TO_IDLE.put(28583, 813);
        WEAPON_TO_IDLE.put(28585, 813);
    }
}

