/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.data;

import eq.uirs.fashionscape.data.ColorType;
import eq.uirs.fashionscape.data.Colorable;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import net.runelite.client.util.Text;

public enum BootsColor implements Colorable
{
    BROWN(0, new Color(111, 89, 61)),
    KHAKI(1, new Color(88, 88, 8)),
    ASHEN(2, new Color(121, 113, 96)),
    DARK(3, new Color(65, 60, 60)),
    TERRACOTTA(4, new Color(129, 98, 58)),
    GREY(5, new Color(115, 114, 106));

    private static final BootsColor[] sorted;
    private final int colorId;
    private final Color color;

    public static BootsColor fromId(int id) {
        if (id < 0 || id >= sorted.length) {
            return null;
        }
        return BootsColor.values()[id];
    }

    @Override
    public String getDisplayName() {
        return Text.titleCase((Enum)this);
    }

    @Override
    public int getColorId(ColorType type) {
        return this.colorId;
    }

    private BootsColor(int colorId, Color color) {
        this.colorId = colorId;
        this.color = color;
    }

    public int getColorId() {
        return this.colorId;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    static {
        sorted = (BootsColor[])Arrays.stream(BootsColor.values()).sorted(Comparator.comparing(BootsColor::getColorId)).toArray(BootsColor[]::new);
    }
}

