/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape.colors;

import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import eq.uirs.fashionscape.colors.GenderItemColors;
import eq.uirs.fashionscape.colors.ItemColorInfo;
import eq.uirs.fashionscape.colors.ItemColors;
import eq.uirs.fashionscape.data.ColorType;
import eq.uirs.fashionscape.data.Colorable;
import eq.uirs.fashionscape.data.kit.JawIcon;
import eq.uirs.fashionscape.data.kit.JawKit;
import eq.uirs.fashionscape.swap.SwapManager;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.kit.KitType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ColorScorer {
    private static final Logger log = LoggerFactory.getLogger(ColorScorer.class);
    private final Client client;
    private final SwapManager swapManager;
    private final Map<Integer, GenderItemColors> allColors;
    private final Map<KitType, List<ItemColorInfo>> kitColors = new ConcurrentHashMap<KitType, List<ItemColorInfo>>();
    private final Map<ColorType, Colorable> playerColors = new ConcurrentHashMap<ColorType, Colorable>();
    private boolean isFemale;

    @Inject
    ColorScorer(Client client, SwapManager swapManager, Gson baseGson) {
        this.client = client;
        this.swapManager = swapManager;
        GsonBuilder builder = baseGson.newBuilder().registerTypeAdapter(ItemColors.class, (Object)new ItemColors.Deserializer());
        Gson gson = builder.create();
        InputStream stream = this.getClass().getResourceAsStream("colors.json");
        if (stream != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            Type type = new TypeToken<Map<Integer, GenderItemColors>>(){}.getType();
            this.allColors = new ConcurrentHashMap<Integer, GenderItemColors>((Map)gson.fromJson((Reader)reader, type));
        } else {
            this.allColors = new ConcurrentHashMap<Integer, GenderItemColors>();
        }
    }

    public void updatePlayerInfo() {
        Integer iconItemId;
        this.kitColors.clear();
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        PlayerComposition composition = player.getPlayerComposition();
        if (composition == null) {
            return;
        }
        this.playerColors.clear();
        this.playerColors.putAll(this.swapManager.swappedColorsMap());
        this.isFemale = composition.isFemale();
        for (KitType slot : KitType.values()) {
            Integer itemId = this.swapManager.swappedItemIdIn(slot);
            if (itemId == null) continue;
            this.kitColors.put(slot, this.colorsFor(itemId));
        }
        JawIcon icon = this.swapManager.swappedIcon();
        if (icon != null && (iconItemId = JawKit.NO_JAW.getIconItemId(icon)) != null) {
            this.kitColors.put(KitType.JAW, this.colorsFor(iconItemId));
        }
    }

    public void setPlayerInfo(Map<KitType, Integer> itemIds, Map<ColorType, Colorable> colors) {
        this.kitColors.clear();
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        this.playerColors.clear();
        this.playerColors.putAll(colors);
        PlayerComposition composition = player.getPlayerComposition();
        this.isFemale = composition.isFemale();
        for (Map.Entry<KitType, Integer> entry : itemIds.entrySet()) {
            this.kitColors.put(entry.getKey(), this.colorsFor(entry.getValue()));
        }
    }

    public void addPlayerInfo(KitType slot, Integer itemId) {
        if (itemId != null) {
            this.kitColors.put(slot, this.colorsFor(itemId));
        }
    }

    public void addPlayerColor(ColorType type, Colorable colorable) {
        if (colorable != null) {
            this.playerColors.put(type, colorable);
        }
    }

    public double score(int itemId, KitType exclude) {
        List<ItemColorInfo> colors = this.colorsFor(itemId);
        return this.score(colors, exclude, null);
    }

    public double score(Colorable colorable, ColorType exclude) {
        int rgb = colorable.getColor().getRGB();
        List<ItemColorInfo> colors = Collections.singletonList(new ItemColorInfo(rgb, 1.0));
        return this.score(colors, null, exclude);
    }

    private double score(List<ItemColorInfo> colors, KitType excludeKit, ColorType excludeColor) {
        if (colors.isEmpty()) {
            return 0.0;
        }
        Map<Integer, Double> playerInfo = this.getPlayerRgbInfo(excludeKit, excludeColor);
        if (playerInfo.isEmpty()) {
            return 0.0;
        }
        ArrayList scoresTarget = new ArrayList();
        for (ItemColorInfo c2 : colors) {
            playerInfo.entrySet().stream().min(Comparator.comparingDouble(e -> this.colorDistance(c.rgb, (Integer)e.getKey()))).map(e -> new Score(1.0 - this.colorDistance(c.rgb, (Integer)e.getKey()), c.pct)).ifPresent(scoresTarget::add);
        }
        double targetScore = scoresTarget.stream().mapToDouble(s -> Math.pow(s.match, 2.0) * s.percentage).sum();
        ArrayList scoresPlayer = new ArrayList();
        for (Map.Entry<Integer, Double> e2 : playerInfo.entrySet()) {
            colors.stream().min(Comparator.comparingDouble(c -> this.colorDistance(c.rgb, (Integer)e2.getKey()))).map(c -> new Score(1.0 - this.colorDistance(c.rgb, (Integer)e2.getKey()), (Double)e2.getValue())).ifPresent(scoresPlayer::add);
        }
        double playerScore = scoresPlayer.stream().mapToDouble(s -> Math.pow(s.match, 2.0) * s.percentage).sum();
        return (3.0 * targetScore + playerScore) / 4.0;
    }

    private double colorDistance(int c1, int c2) {
        Color color1 = new Color(c1);
        Color color2 = new Color(c2);
        double deltaR = (float)Math.abs(color1.getRed() - color2.getRed()) / 255.0f;
        double deltaG = (float)Math.abs(color1.getGreen() - color2.getGreen()) / 255.0f;
        double deltaB = (float)Math.abs(color1.getBlue() - color2.getBlue()) / 255.0f;
        return Math.sqrt((Math.pow(deltaR, 2.0) + Math.pow(deltaG, 2.0) + Math.pow(deltaB, 2.0)) / 3.0);
    }

    private List<ItemColorInfo> colorsFor(int itemId) {
        GenderItemColors genderColors = this.allColors.get(itemId);
        if (genderColors != null) {
            if (genderColors.any != null) {
                return genderColors.any.itemColorInfo;
            }
            if (this.isFemale) {
                return genderColors.female.itemColorInfo;
            }
            return genderColors.male.itemColorInfo;
        }
        return new ArrayList<ItemColorInfo>();
    }

    private Map<Integer, Double> getPlayerRgbInfo(KitType excludeKit, ColorType excludeColor) {
        Map<Integer, Double> unscaled = this.kitColors.entrySet().stream().filter(e -> !Objects.equal(e.getKey(), (Object)excludeKit)).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toMap(ItemColorInfo::getRgb, ItemColorInfo::getPct, Double::sum));
        Map<Integer, Double> unscaledColors = this.playerColors.entrySet().stream().filter(e -> !Objects.equal(e.getKey(), (Object)((Object)excludeColor))).map(Map.Entry::getValue).collect(Collectors.toMap(c -> c.getColor().getRGB(), c -> 1.0, Double::sum));
        unscaledColors.forEach((rgb, score) -> unscaled.merge((Integer)rgb, (Double)score, Double::sum));
        Double scale = unscaled.values().stream().mapToDouble(d -> d).sum();
        return unscaled.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Double)e.getValue() / scale));
    }

    private static final class Score {
        private final double match;
        private final double percentage;

        public Score(double match, double percentage) {
            this.match = match;
            this.percentage = percentage;
        }

        public double getMatch() {
            return this.match;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Score)) {
                return false;
            }
            Score other = (Score)o;
            if (Double.compare(this.getMatch(), other.getMatch()) != 0) {
                return false;
            }
            return Double.compare(this.getPercentage(), other.getPercentage()) == 0;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $match = Double.doubleToLongBits(this.getMatch());
            result = result * 59 + (int)($match >>> 32 ^ $match);
            long $percentage = Double.doubleToLongBits(this.getPercentage());
            result = result * 59 + (int)($percentage >>> 32 ^ $percentage);
            return result;
        }

        public String toString() {
            return "ColorScorer.Score(match=" + this.getMatch() + ", percentage=" + this.getPercentage() + ")";
        }
    }
}

