/*
 * Decompiled with CFR 0.152.
 */
package eq.uirs.fashionscape;

import com.google.inject.Provides;
import eq.uirs.fashionscape.FashionscapeConfig;
import eq.uirs.fashionscape.data.ItemInteractions;
import eq.uirs.fashionscape.panel.FashionscapePanel;
import eq.uirs.fashionscape.swap.SwapManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.PlayerChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Fashionscape", description="Previews combinations of equipment by changing the player's local appearance")
public class FashionscapePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FashionscapePlugin.class);
    public static final File OUTFITS_DIR = new File(RuneLite.RUNELITE_DIR, "outfits");
    public static final Pattern PROFILE_PATTERN = Pattern.compile("^(\\w+):(-?\\d+).*");
    private static final Pattern PAREN_REPLACE = Pattern.compile("\\(.*\\)");
    private static final String COPY_PLAYER = "Copy-outfit";
    private static final Set<Integer> ITEM_ID_DUPES = new HashSet<Integer>();
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SwapManager swapManager;
    @Inject
    private FashionscapeConfig config;
    @Inject
    private Provider<MenuManager> menuManager;
    private FashionscapePanel panel;
    private NavigationButton navButton;

    public static Set<Integer> getItemIdsToExclude(FashionscapeConfig config) {
        Set<Integer> result = ITEM_ID_DUPES;
        result.addAll(ItemInteractions.BAD_ITEM_IDS);
        if (config.excludeNonStandardItems()) {
            result.addAll(ItemInteractions.NON_STANDARD_ITEMS);
        }
        return result;
    }

    private static String stripName(String name) {
        String noParens = PAREN_REPLACE.matcher(name).replaceAll("");
        return noParens.replaceAll("[^A-Za-z]+", "");
    }

    @Provides
    FashionscapeConfig getConfig(ConfigManager configManager) {
        return (FashionscapeConfig)configManager.getConfig(FashionscapeConfig.class);
    }

    protected void startUp() {
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"panelicon.png");
        this.panel = (FashionscapePanel)((Object)this.injector.getInstance(FashionscapePanel.class));
        this.navButton = NavigationButton.builder().tooltip("Fashionscape").icon(icon).panel((PluginPanel)this.panel).priority(8).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.refreshMenuEntries();
        this.clientThread.invokeLater(() -> {
            this.populateDupes();
            this.swapManager.startUp();
        });
    }

    protected void shutDown() {
        ((MenuManager)this.menuManager.get()).removePlayerMenuItem(COPY_PLAYER);
        this.clientThread.invokeLater(() -> this.swapManager.shutDown());
        this.clientToolbar.removeNavigation(this.navButton);
        ITEM_ID_DUPES.clear();
    }

    @Subscribe
    public void onPlayerChanged(PlayerChanged event) {
        Player player = event.getPlayer();
        if (player != null && player == this.client.getLocalPlayer()) {
            this.swapManager.onPlayerChanged();
            if (this.panel != null) {
                this.panel.onPlayerChanged(player);
            }
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.EQUIPMENT.getId()) {
            this.swapManager.onEquipmentChanged();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("fashionscape")) {
            if (event.getKey().equals("excludeNonStandardItems") || event.getKey().equals("excludeMembersItems")) {
                this.clientThread.invokeLater(() -> {
                    this.populateDupes();
                    this.panel.reloadResults();
                    this.panel.refreshKitsPanel();
                });
            } else if (event.getKey().equals("copyMenuEntry")) {
                this.refreshMenuEntries();
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.populateDupes();
            this.swapManager.onEquipmentChanged();
        } else if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.swapManager.setIsFemale(null);
        }
        if (this.panel != null) {
            this.panel.onGameStateChanged(event);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.RUNELITE_PLAYER && event.getMenuOption().equals(COPY_PLAYER)) {
            SwingUtilities.invokeLater(() -> {
                Runnable onSelect;
                if (!this.navButton.isSelected() && (onSelect = this.navButton.getOnSelect()) != null) {
                    onSelect.run();
                }
            });
            Player p = this.client.getCachedPlayers()[event.getId()];
            if (p == null) {
                return;
            }
            this.swapManager.copyOutfit(p.getPlayerComposition());
            this.panel.reloadResults();
        }
    }

    private void populateDupes() {
        ITEM_ID_DUPES.clear();
        HashSet<Integer> ids = new HashSet<Integer>();
        HashSet<ItemDupeData> itemUniques = new HashSet<ItemDupeData>();
        Set<Integer> skips = FashionscapePlugin.getItemIdsToExclude(this.config);
        for (int i = 0; i < this.client.getItemCount(); ++i) {
            boolean membersObject;
            int canonical = this.itemManager.canonicalize(i);
            if (skips.contains(canonical)) continue;
            ItemComposition itemComposition = this.itemManager.getItemComposition(canonical);
            String itemName = itemComposition.getName().toLowerCase();
            boolean badItemName = ItemInteractions.BAD_ITEM_NAMES.contains(itemName);
            boolean bl = membersObject = this.config.excludeMembersItems() && itemComposition.isMembers();
            if (badItemName || membersObject) {
                ITEM_ID_DUPES.add(canonical);
                continue;
            }
            ItemStats itemStats = this.itemManager.getItemStats(canonical, false);
            if (ids.contains(itemComposition.getId()) || itemStats == null || !itemStats.isEquipable()) continue;
            ItemDupeData itemDupeData = new ItemDupeData(itemComposition.getInventoryModel(), itemComposition.getColorToReplaceWith(), itemComposition.getTextureToReplaceWith(), FashionscapePlugin.stripName(itemName));
            if (itemUniques.contains(itemDupeData)) {
                ITEM_ID_DUPES.add(canonical);
                continue;
            }
            itemUniques.add(itemDupeData);
            ids.add(itemComposition.getId());
        }
    }

    private void refreshMenuEntries() {
        if (this.config.copyMenuEntry()) {
            ((MenuManager)this.menuManager.get()).addPlayerMenuItem(COPY_PLAYER);
        } else {
            ((MenuManager)this.menuManager.get()).removePlayerMenuItem(COPY_PLAYER);
        }
    }

    private static final class ItemDupeData {
        private final int modelId;
        private final short[] colorsToReplace;
        private final short[] texturesToReplace;
        private final String strippedName;

        public ItemDupeData(int modelId, short[] colorsToReplace, short[] texturesToReplace, String strippedName) {
            this.modelId = modelId;
            this.colorsToReplace = colorsToReplace;
            this.texturesToReplace = texturesToReplace;
            this.strippedName = strippedName;
        }

        public int getModelId() {
            return this.modelId;
        }

        public short[] getColorsToReplace() {
            return this.colorsToReplace;
        }

        public short[] getTexturesToReplace() {
            return this.texturesToReplace;
        }

        public String getStrippedName() {
            return this.strippedName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemDupeData)) {
                return false;
            }
            ItemDupeData other = (ItemDupeData)o;
            if (this.getModelId() != other.getModelId()) {
                return false;
            }
            if (!Arrays.equals(this.getColorsToReplace(), other.getColorsToReplace())) {
                return false;
            }
            if (!Arrays.equals(this.getTexturesToReplace(), other.getTexturesToReplace())) {
                return false;
            }
            String this$strippedName = this.getStrippedName();
            String other$strippedName = other.getStrippedName();
            return !(this$strippedName == null ? other$strippedName != null : !this$strippedName.equals(other$strippedName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getModelId();
            result = result * 59 + Arrays.hashCode(this.getColorsToReplace());
            result = result * 59 + Arrays.hashCode(this.getTexturesToReplace());
            String $strippedName = this.getStrippedName();
            result = result * 59 + ($strippedName == null ? 43 : $strippedName.hashCode());
            return result;
        }

        public String toString() {
            return "FashionscapePlugin.ItemDupeData(modelId=" + this.getModelId() + ", colorsToReplace=" + Arrays.toString(this.getColorsToReplace()) + ", texturesToReplace=" + Arrays.toString(this.getTexturesToReplace()) + ", strippedName=" + this.getStrippedName() + ")";
        }
    }
}

