/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.util;

import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.duckblade.osrs.toa.util.RaidStateChanged;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class RaidStateTracker
implements PluginLifecycleComponent {
    private static final int REGION_LOBBY = 13454;
    private static final int WIDGET_PARENT_ID = 481;
    private static final int WIDGET_CHILD_ID = 40;
    private static final RaidState DEFAULT_STATE = new RaidState(false, false, null, 0);
    private final Client client;
    private final EventBus eventBus;
    private RaidState currentState = DEFAULT_STATE;
    private int raidLeaveTicks = 0;

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe(priority=5.0f)
    public void onGameTick(GameTick e) {
        LocalPoint lp = this.client.getLocalPlayer().getLocalLocation();
        int region = lp == null ? -1 : WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)lp).getRegionID();
        Widget w = this.client.getWidget(481, 40);
        boolean inLobby = region == 13454;
        RaidRoom currentRoom = RaidRoom.forRegionId(region);
        boolean inRaidRaw = currentRoom != null || w != null && !w.isHidden();
        this.raidLeaveTicks = inRaidRaw ? 3 : this.raidLeaveTicks - 1;
        boolean inRaid = this.raidLeaveTicks > 0;
        this.setRaidState(new RaidState(inLobby, inRaid, currentRoom, this.countPlayers()), false);
    }

    public int getPlayerCount() {
        return this.currentState.getPlayerCount();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged e) {
        switch (e.getGameState()) {
            case LOGGING_IN: 
            case HOPPING: {
                this.raidLeaveTicks = 0;
                this.setRaidState(DEFAULT_STATE, true);
            }
        }
    }

    private void setRaidState(RaidState newValue, boolean forceEvent) {
        RaidState previous = this.currentState;
        this.currentState = newValue;
        if (forceEvent || !this.currentState.equals(previous)) {
            this.eventBus.post((Object)new RaidStateChanged(previous, this.currentState));
        }
    }

    private int countPlayers() {
        return 1 + (this.client.getVarbitValue(14347) != 0 ? 1 : 0) + (this.client.getVarbitValue(14348) != 0 ? 1 : 0) + (this.client.getVarbitValue(14349) != 0 ? 1 : 0) + (this.client.getVarbitValue(14350) != 0 ? 1 : 0) + (this.client.getVarbitValue(14351) != 0 ? 1 : 0) + (this.client.getVarbitValue(14352) != 0 ? 1 : 0) + (this.client.getVarbitValue(14353) != 0 ? 1 : 0);
    }

    @Inject
    public RaidStateTracker(Client client, EventBus eventBus) {
        this.client = client;
        this.eventBus = eventBus;
    }

    public RaidState getCurrentState() {
        return this.currentState;
    }
}

