/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.module;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidState;
import com.duckblade.osrs.toa.util.RaidStateChanged;
import com.duckblade.osrs.toa.util.RaidStateTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.util.GameEventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ComponentManager {
    private static final Logger log = LoggerFactory.getLogger(ComponentManager.class);
    private final EventBus eventBus;
    private final GameEventManager gameEventManager;
    private final TombsOfAmascutConfig config;
    private final RaidStateTracker raidStateTracker;
    private final Set<PluginLifecycleComponent> components;
    private final Map<PluginLifecycleComponent, Boolean> states = new HashMap<PluginLifecycleComponent, Boolean>();

    public void onPluginStart() {
        this.eventBus.register((Object)this);
        this.components.forEach(c -> this.states.put((PluginLifecycleComponent)c, false));
        this.revalidateComponentStates();
    }

    public void onPluginStop() {
        this.eventBus.unregister((Object)this);
        this.components.stream().filter(this.states::get).forEach(this::tryShutDown);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (!"tombsofamascut".equals(e.getGroup())) {
            return;
        }
        this.revalidateComponentStates();
    }

    @Subscribe
    public void onRaidStateChanged(RaidStateChanged e) {
        this.revalidateComponentStates();
    }

    private void revalidateComponentStates() {
        RaidState raidState = this.raidStateTracker.getCurrentState();
        this.components.forEach(c -> {
            boolean isEnabled;
            boolean shouldBeEnabled = c.isEnabled(this.config, raidState);
            if (shouldBeEnabled == (isEnabled = this.states.get(c).booleanValue())) {
                return;
            }
            if (shouldBeEnabled) {
                this.tryStartUp((PluginLifecycleComponent)c);
            } else {
                this.tryShutDown((PluginLifecycleComponent)c);
            }
        });
    }

    private void tryStartUp(PluginLifecycleComponent component) {
        if (this.states.get(component).booleanValue()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Enabling ToA plugin component [{}]", (Object)component.getClass().getName());
        }
        try {
            component.startUp();
            this.gameEventManager.simulateGameEvents((Object)component);
            this.states.put(component, true);
        }
        catch (Exception e) {
            log.error("Failed to start ToA plugin component [{}]", (Object)component.getClass().getName(), (Object)e);
        }
    }

    private void tryShutDown(PluginLifecycleComponent component) {
        if (!this.states.get(component).booleanValue()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Disabling ToA plugin component [{}]", (Object)component.getClass().getName());
        }
        try {
            component.shutDown();
        }
        catch (Exception e) {
            log.error("Failed to cleanly shut down ToA plugin component [{}]", (Object)component.getClass().getName());
        }
        finally {
            this.states.put(component, false);
        }
    }

    @Inject
    public ComponentManager(EventBus eventBus, GameEventManager gameEventManager, TombsOfAmascutConfig config, RaidStateTracker raidStateTracker, Set<PluginLifecycleComponent> components) {
        this.eventBus = eventBus;
        this.gameEventManager = gameEventManager;
        this.config = config;
        this.raidStateTracker = raidStateTracker;
        this.components = components;
    }
}

