/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.tomb;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.WallObject;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SarcophagusRecolorer
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(SarcophagusRecolorer.class);
    private static final Set<String> CONFIG_KEYS = ImmutableSet.of((Object)"sarcophagusRecolorWhite", (Object)"sarcophagusWhiteRecolor", (Object)"sarcophagusRecolorMyPurple", (Object)"sarcophagusMyPurpleRecolor", (Object)"sarcophagusRecolorOtherPurple", (Object)"sarcophagusOtherPurpleRecolor", (Object[])new String[0]);
    private static final int[] VARBIT_MULTILOC_IDS_CHEST = new int[]{14356, 14357, 14358, 14359, 14360, 14370, 14371, 14372};
    private static final int VARBIT_VALUE_CHEST_KEY = 2;
    private static final int VARBIT_ID_SARCOPHAGUS = 14373;
    private static final int WALL_OBJECT_ID_SARCOPHAGUS = 46221;
    @Inject
    private EventBus eventBus;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TombsOfAmascutConfig config;
    private final List<WallObject> wallObjects = new ArrayList<WallObject>();
    private int[] defaultFaceColors1;
    private boolean sarcophagusIsPurple;
    private boolean purpleIsMine = true;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return raidState.getCurrentRoom() == RaidRoom.TOMB;
    }

    @Override
    public void startUp() {
        this.clientThread.invokeLater(() -> {
            this.parseVarbits();
            this.recolor(this.wallObjects);
        });
        this.eventBus.register((Object)this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
        this.wallObjects.clear();
        this.sarcophagusIsPurple = false;
        this.purpleIsMine = true;
        this.defaultFaceColors1 = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("tombsofamascut") || this.wallObjects.isEmpty()) {
            return;
        }
        String key = event.getKey();
        if (CONFIG_KEYS.contains(key)) {
            this.clientThread.invokeLater(() -> this.recolor(this.wallObjects));
        }
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        WallObject wallObject = event.getWallObject();
        if (wallObject.getId() != 46221) {
            return;
        }
        if (this.defaultFaceColors1 == null) {
            this.initDefaultFaceColors1(wallObject);
        }
        this.recolor(wallObject);
        this.wallObjects.add(wallObject);
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        WallObject wallObject = event.getWallObject();
        if (wallObject.getId() == 46221) {
            this.wallObjects.remove(wallObject);
        }
    }

    private void parseVarbits() {
        this.sarcophagusIsPurple = this.client.getVarbitValue(14373) % 2 != 0;
        this.purpleIsMine = true;
        for (int varbitId : VARBIT_MULTILOC_IDS_CHEST) {
            if (this.client.getVarbitValue(varbitId) != 2) continue;
            this.purpleIsMine = false;
            break;
        }
    }

    private void initDefaultFaceColors1(WallObject wallObject) {
        Model model = wallObject.getRenderable1().getModel();
        if (model == null) {
            return;
        }
        this.defaultFaceColors1 = (int[])model.getFaceColors1().clone();
    }

    private void recolor(Collection<WallObject> wallObjects) {
        for (WallObject wallObject : wallObjects) {
            this.recolor(wallObject);
        }
    }

    private void recolor(WallObject wallObject) {
        Color color;
        Model model = wallObject.getRenderable1().getModel();
        if (model == null) {
            return;
        }
        int[] faceColors1 = model.getFaceColors1();
        if (this.sarcophagusIsPurple) {
            if (this.purpleIsMine) {
                if (!this.config.sarcophagusRecolorMyPurple()) {
                    this.resetFaceColors1(faceColors1);
                    return;
                }
                color = this.config.sarcophagusMyPurpleRecolor();
            } else {
                if (!this.config.sarcophagusRecolorOtherPurple()) {
                    this.resetFaceColors1(faceColors1);
                    return;
                }
                color = this.config.sarcophagusOtherPurpleRecolor();
            }
        } else {
            if (!this.config.sarcophagusRecolorWhite()) {
                this.resetFaceColors1(faceColors1);
                return;
            }
            color = this.config.sarcophagusWhiteRecolor();
        }
        Arrays.fill(faceColors1, SarcophagusRecolorer.colorToRs2hsb(color));
    }

    private void resetFaceColors1(int[] faceColors1) {
        if (this.defaultFaceColors1 == null) {
            log.error("defaultFaceColors1 was not initialized. Failed to reset faceColors1.");
            return;
        }
        System.arraycopy(this.defaultFaceColors1, 0, faceColors1, 0, faceColors1.length);
    }

    private static int colorToRs2hsb(Color color) {
        float[] hsbVals = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hsbVals[2] = hsbVals[2] - Math.min(hsbVals[1], hsbVals[2] / 2.0f);
        int encode_hue = (int)(hsbVals[0] * 63.0f);
        int encode_saturation = (int)(hsbVals[1] * 7.0f);
        int encode_brightness = (int)(hsbVals[2] * 127.0f);
        return (encode_hue << 10) + (encode_saturation << 7) + encode_brightness;
    }
}

