/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.tomb;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.TombsOfAmascutPlugin;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidState;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SarcophagusOpeningSoundPlayer
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(SarcophagusOpeningSoundPlayer.class);
    private static final int SARCOPHAGUS_ID = 44934;
    private final EventBus eventBus;
    private final TombsOfAmascutConfig config;
    private Clip clip = null;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return config.chestAudioEnable();
    }

    @Override
    public void startUp() {
        this.clip = null;
        this.eventBus.register((Object)this);
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
        if (this.clip != null) {
            this.clip.close();
        }
        this.clip = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged c) {
        if (!c.getGroup().equals("tombsofamascut")) {
            return;
        }
        if (c.getKey().equals("chestAudioVolume")) {
            this.playClip();
        }
    }

    @Subscribe
    private void onGameObjectSpawned(GameObjectSpawned e) {
        if (e.getGameObject().getId() != 44934) {
            return;
        }
        this.playClip();
    }

    private boolean loadClip() {
        boolean bl;
        block10: {
            File f = new File(TombsOfAmascutPlugin.TOA_FOLDER, "toa-chest.wav");
            if (!f.exists()) {
                log.warn("ToA chest opening sound file does not exist, expected " + f.getAbsolutePath());
                return false;
            }
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(f);
            try {
                this.clip = AudioSystem.getClip();
                this.clip.open(audioInputStream);
                bl = true;
                if (audioInputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (audioInputStream != null) {
                        try {
                            audioInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                    if (this.clip.isOpen()) {
                        this.clip.close();
                    }
                    this.clip = null;
                    log.warn("Failed to load toa chest audio");
                    return false;
                }
            }
            audioInputStream.close();
        }
        return bl;
    }

    public void playClip() {
        if (!(this.clip != null && this.clip.isOpen() || this.loadClip())) {
            log.warn("Unable to play audio clip");
            return;
        }
        FloatControl volume = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float gain = 20.0f * (float)Math.log10((float)this.config.chestAudioVolume() / 100.0f);
        gain = Math.max(Math.min(gain, volume.getMaximum()), volume.getMinimum());
        volume.setValue(gain);
        this.clip.setFramePosition(0);
        this.clip.loop(0);
    }

    @Inject
    public SarcophagusOpeningSoundPlayer(EventBus eventBus, TombsOfAmascutConfig config) {
        this.eventBus = eventBus;
        this.config = config;
    }
}

