/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.timetracking;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.timetracking.Split;
import com.duckblade.osrs.toa.features.timetracking.SplitsMode;
import com.duckblade.osrs.toa.features.timetracking.SplitsTracker;
import com.duckblade.osrs.toa.features.timetracking.TargetTimeManager;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import com.duckblade.osrs.toa.util.RaidStateTracker;
import com.duckblade.osrs.toa.util.TimerMode;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SplitsOverlay
extends OverlayPanel
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(SplitsOverlay.class);
    private final OverlayManager overlayManager;
    private final TargetTimeManager targetTimeManager;
    private final SplitsTracker splitsTracker;
    private final RaidStateTracker raidStateTracker;
    private final Client client;
    private SplitsMode splitsMode;

    @Inject
    public SplitsOverlay(OverlayManager overlayManager, TargetTimeManager targetTimeManager, SplitsTracker splitsTracker, RaidStateTracker raidStateTracker, Client client) {
        this.overlayManager = overlayManager;
        this.targetTimeManager = targetTimeManager;
        this.splitsTracker = splitsTracker;
        this.raidStateTracker = raidStateTracker;
        this.client = client;
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
    }

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        this.splitsMode = config.splitsOverlay();
        return this.splitsMode != SplitsMode.OFF && raidState.isInRaid();
    }

    @Override
    public void startUp() {
        this.overlayManager.add((Overlay)this);
    }

    @Override
    public void shutDown() {
        this.overlayManager.removeIf(o -> o instanceof SplitsOverlay);
    }

    public Dimension render(Graphics2D graphics) {
        String targetTime;
        String currentName;
        this.getPanelComponent().getChildren().add(TitleComponent.builder().text("ToA Splits").build());
        RaidRoom currentRoom = this.raidStateTracker.getCurrentState().getCurrentRoom();
        boolean hasCurrentTime = false;
        for (Split s : this.splitsTracker.getSplits()) {
            if (!this.splitsMode.includesRoom(s.getRoom())) continue;
            hasCurrentTime = hasCurrentTime || currentRoom == s.getRoom();
            this.addLine(s.getRoom().toString(), s.getSplit());
        }
        if (!hasCurrentTime && (currentName = this.splitsMode.nextSplit(currentRoom)) != null) {
            this.addLine(currentName, this.currentTimerValue());
        }
        if ((targetTime = this.targetTimeManager.getTargetTime()) != null) {
            this.addLine("Target", targetTime);
        }
        return super.render(graphics);
    }

    private void addLine(String left, String right) {
        this.getPanelComponent().getChildren().add(LineComponent.builder().left(left).right(right).build());
    }

    private String currentTimerValue() {
        String text;
        Widget w = this.client.getWidget(TargetTimeManager.WIDGET_TIMER);
        if (w == null || (text = w.getText()) == null) {
            return TimerMode.fromClient(this.client) == TimerMode.PRECISE ? "--:--.--" : "--:--";
        }
        return text.split("/")[0].trim();
    }
}

