/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.scabaras.overlay;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.scabaras.ScabarasHelperMode;
import com.duckblade.osrs.toa.features.scabaras.overlay.ScabarasOverlay;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@Singleton
public class ScabarasOverlayManager
implements PluginLifecycleComponent {
    private final EventBus eventBus;
    private final OverlayManager overlayManager;
    private final ScabarasOverlay scabarasOverlay;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState currentState) {
        return config.scabarasHelperMode() == ScabarasHelperMode.OVERLAY && currentState.getCurrentRoom() == RaidRoom.SCABARAS;
    }

    @Override
    public void startUp() {
        this.eventBus.register((Object)this);
        this.installOverlay();
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister((Object)this);
        this.removeOverlay();
    }

    private void installOverlay() {
        this.overlayManager.add((Overlay)this.scabarasOverlay);
    }

    private void removeOverlay() {
        this.overlayManager.remove((Overlay)this.scabarasOverlay);
    }

    @Inject
    public ScabarasOverlayManager(EventBus eventBus, OverlayManager overlayManager, ScabarasOverlay scabarasOverlay) {
        this.eventBus = eventBus;
        this.overlayManager = overlayManager;
        this.scabarasOverlay = scabarasOverlay;
    }
}

